/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.AFDDomainHttpsParameters;
import com.microsoft.azure.management.cdn.AFDDomainUpdateParameters;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.ResourceReference;
import com.microsoft.azure.management.cdn.implementation.AFDDomainInner;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.cdn.implementation.ValidationTokenInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AFDCustomDomainsInner {
    private AFDCustomDomainsService service;
    private CdnManagementClientImpl client;

    public AFDCustomDomainsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (AFDCustomDomainsService)retrofit.create(AFDCustomDomainsService.class);
        this.client = client;
    }

    public PagedList<AFDDomainInner> listByProfile(String resourceGroupName, String profileName) {
        ServiceResponse response = (ServiceResponse)this.listByProfileSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<AFDDomainInner>((Page)response.body()){

            public Page<AFDDomainInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AFDCustomDomainsInner.this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AFDDomainInner>> listByProfileAsync(String resourceGroupName, String profileName, ListOperationCallback<AFDDomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByProfileSinglePageAsync(resourceGroupName, profileName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AFDDomainInner>>>>(){

            public Observable<ServiceResponse<Page<AFDDomainInner>>> call(String nextPageLink) {
                return AFDCustomDomainsInner.this.listByProfileNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AFDDomainInner>> listByProfileAsync(String resourceGroupName, String profileName) {
        return this.listByProfileWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<Page<AFDDomainInner>>, Page<AFDDomainInner>>(){

            public Page<AFDDomainInner> call(ServiceResponse<Page<AFDDomainInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDDomainInner>>> listByProfileWithServiceResponseAsync(String resourceGroupName, String profileName) {
        return this.listByProfileSinglePageAsync(resourceGroupName, profileName).concatMap((Func1)new Func1<ServiceResponse<Page<AFDDomainInner>>, Observable<ServiceResponse<Page<AFDDomainInner>>>>(){

            public Observable<ServiceResponse<Page<AFDDomainInner>>> call(ServiceResponse<Page<AFDDomainInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AFDCustomDomainsInner.this.listByProfileNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDDomainInner>>> listByProfileSinglePageAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByProfile(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AFDDomainInner>>>>(){

            public Observable<ServiceResponse<Page<AFDDomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AFDCustomDomainsInner.this.listByProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AFDDomainInner>> listByProfileDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AFDDomainInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public AFDDomainInner get(String resourceGroupName, String profileName, String customDomainName) {
        return (AFDDomainInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().single()).body());
    }

    public ServiceFuture<AFDDomainInner> getAsync(String resourceGroupName, String profileName, String customDomainName, ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    public Observable<AFDDomainInner> getAsync(String resourceGroupName, String profileName, String customDomainName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map((Func1)new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>(){

            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return (AFDDomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDDomainInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDDomainInner>>>(){

            public Observable<ServiceResponse<AFDDomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDCustomDomainsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AFDDomainInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AFDDomainInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public AFDDomainInner create(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        return (AFDDomainInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain).toBlocking().last()).body());
    }

    public ServiceFuture<AFDDomainInner> createAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain, ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain), serviceCallback);
    }

    public Observable<AFDDomainInner> createAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain).map((Func1)new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>(){

            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return (AFDDomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDDomainInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (customDomain == null) {
            throw new IllegalArgumentException("Parameter customDomain is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)customDomain));
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), customDomain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDDomainInner>(){}.getType());
    }

    public AFDDomainInner beginCreate(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        return (AFDDomainInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain).toBlocking().single()).body());
    }

    public ServiceFuture<AFDDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain, ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain), serviceCallback);
    }

    public Observable<AFDDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain).map((Func1)new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>(){

            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return (AFDDomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDDomainInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (customDomain == null) {
            throw new IllegalArgumentException("Parameter customDomain is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)customDomain));
        return this.service.beginCreate(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), customDomain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDDomainInner>>>(){

            public Observable<ServiceResponse<AFDDomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDCustomDomainsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AFDDomainInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AFDDomainInner>(){}.getType()).register(201, new TypeToken<AFDDomainInner>(){}.getType()).register(202, new TypeToken<AFDDomainInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public AFDDomainInner update(String resourceGroupName, String profileName, String customDomainName) {
        return (AFDDomainInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().last()).body());
    }

    public ServiceFuture<AFDDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName, ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    public Observable<AFDDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map((Func1)new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>(){

            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return (AFDDomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDDomainInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object tlsSettings = null;
        Object azureDnsZone = null;
        AFDDomainUpdateParameters customDomainUpdateProperties = new AFDDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(null);
        customDomainUpdateProperties.withAzureDnsZone(null);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainUpdateProperties, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDDomainInner>(){}.getType());
    }

    public AFDDomainInner update(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return (AFDDomainInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).toBlocking().last()).body());
    }

    public ServiceFuture<AFDDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone, ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone), serviceCallback);
    }

    public Observable<AFDDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).map((Func1)new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>(){

            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return (AFDDomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDDomainInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)tlsSettings);
        Validator.validate((Object)azureDnsZone);
        AFDDomainUpdateParameters customDomainUpdateProperties = new AFDDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(tlsSettings);
        customDomainUpdateProperties.withAzureDnsZone(azureDnsZone);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainUpdateProperties, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDDomainInner>(){}.getType());
    }

    public AFDDomainInner beginUpdate(String resourceGroupName, String profileName, String customDomainName) {
        return (AFDDomainInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().single()).body());
    }

    public ServiceFuture<AFDDomainInner> beginUpdateAsync(String resourceGroupName, String profileName, String customDomainName, ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    public Observable<AFDDomainInner> beginUpdateAsync(String resourceGroupName, String profileName, String customDomainName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map((Func1)new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>(){

            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return (AFDDomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDDomainInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object tlsSettings = null;
        Object azureDnsZone = null;
        AFDDomainUpdateParameters customDomainUpdateProperties = new AFDDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(null);
        customDomainUpdateProperties.withAzureDnsZone(null);
        return this.service.beginUpdate(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainUpdateProperties, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDDomainInner>>>(){

            public Observable<ServiceResponse<AFDDomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDCustomDomainsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public AFDDomainInner beginUpdate(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return (AFDDomainInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).toBlocking().single()).body());
    }

    public ServiceFuture<AFDDomainInner> beginUpdateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone, ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone), serviceCallback);
    }

    public Observable<AFDDomainInner> beginUpdateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).map((Func1)new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>(){

            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return (AFDDomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDDomainInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)tlsSettings);
        Validator.validate((Object)azureDnsZone);
        AFDDomainUpdateParameters customDomainUpdateProperties = new AFDDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(tlsSettings);
        customDomainUpdateProperties.withAzureDnsZone(azureDnsZone);
        return this.service.beginUpdate(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainUpdateProperties, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDDomainInner>>>(){

            public Observable<ServiceResponse<AFDDomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDCustomDomainsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AFDDomainInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AFDDomainInner>(){}.getType()).register(202, new TypeToken<AFDDomainInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName, String customDomainName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String customDomainName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String customDomainName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String profileName, String customDomainName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String customDomainName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String customDomainName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDCustomDomainsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public ValidationTokenInner refreshValidationToken(String resourceGroupName, String profileName, String customDomainName) {
        return (ValidationTokenInner)((ServiceResponse)this.refreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().last()).body();
    }

    public ServiceFuture<ValidationTokenInner> refreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName, ServiceCallback<ValidationTokenInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.refreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    public Observable<ValidationTokenInner> refreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName) {
        return this.refreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map((Func1)new Func1<ServiceResponse<ValidationTokenInner>, ValidationTokenInner>(){

            public ValidationTokenInner call(ServiceResponse<ValidationTokenInner> response) {
                return (ValidationTokenInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ValidationTokenInner>> refreshValidationTokenWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.refreshValidationToken(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.AZURE_ASYNC_OPERATION), new TypeToken<ValidationTokenInner>(){}.getType());
    }

    public ValidationTokenInner beginRefreshValidationToken(String resourceGroupName, String profileName, String customDomainName) {
        return (ValidationTokenInner)((ServiceResponse)this.beginRefreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().single()).body();
    }

    public ServiceFuture<ValidationTokenInner> beginRefreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName, ServiceCallback<ValidationTokenInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRefreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    public Observable<ValidationTokenInner> beginRefreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName) {
        return this.beginRefreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map((Func1)new Func1<ServiceResponse<ValidationTokenInner>, ValidationTokenInner>(){

            public ValidationTokenInner call(ServiceResponse<ValidationTokenInner> response) {
                return (ValidationTokenInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ValidationTokenInner>> beginRefreshValidationTokenWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginRefreshValidationToken(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ValidationTokenInner>>>(){

            public Observable<ServiceResponse<ValidationTokenInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDCustomDomainsInner.this.beginRefreshValidationTokenDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ValidationTokenInner> beginRefreshValidationTokenDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ValidationTokenInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public PagedList<AFDDomainInner> listByProfileNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AFDDomainInner>((Page)response.body()){

            public Page<AFDDomainInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AFDCustomDomainsInner.this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AFDDomainInner>> listByProfileNextAsync(String nextPageLink, ServiceFuture<List<AFDDomainInner>> serviceFuture, ListOperationCallback<AFDDomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByProfileNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AFDDomainInner>>>>(){

            public Observable<ServiceResponse<Page<AFDDomainInner>>> call(String nextPageLink) {
                return AFDCustomDomainsInner.this.listByProfileNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AFDDomainInner>> listByProfileNextAsync(String nextPageLink) {
        return this.listByProfileNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AFDDomainInner>>, Page<AFDDomainInner>>(){

            public Page<AFDDomainInner> call(ServiceResponse<Page<AFDDomainInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDDomainInner>>> listByProfileNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByProfileNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AFDDomainInner>>, Observable<ServiceResponse<Page<AFDDomainInner>>>>(){

            public Observable<ServiceResponse<Page<AFDDomainInner>>> call(ServiceResponse<Page<AFDDomainInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AFDCustomDomainsInner.this.listByProfileNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDDomainInner>>> listByProfileNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByProfileNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AFDDomainInner>>>>(){

            public Observable<ServiceResponse<Page<AFDDomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AFDCustomDomainsInner.this.listByProfileNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AFDDomainInner>> listByProfileNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AFDDomainInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    static interface AFDCustomDomainsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains listByProfile"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains")
        public Observable<Response<ResponseBody>> listByProfile(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="customDomainName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="customDomainName") String var3, @Path(value="subscriptionId") String var4, @Body AFDDomainInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="customDomainName") String var3, @Path(value="subscriptionId") String var4, @Body AFDDomainInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="customDomainName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body AFDDomainUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="customDomainName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body AFDDomainUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="customDomainName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="customDomainName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains refreshValidationToken"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}/refreshValidationToken")
        public Observable<Response<ResponseBody>> refreshValidationToken(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="customDomainName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains beginRefreshValidationToken"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}/refreshValidationToken")
        public Observable<Response<ResponseBody>> beginRefreshValidationToken(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="customDomainName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains listByProfileNext"})
        @GET
        public Observable<Response<ResponseBody>> listByProfileNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

