/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.SecurityPolicyParameters;
import com.microsoft.azure.management.cdn.SecurityPolicyProperties;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.cdn.implementation.SecurityPolicyInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SecurityPoliciesInner {
    private SecurityPoliciesService service;
    private CdnManagementClientImpl client;

    public SecurityPoliciesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (SecurityPoliciesService)retrofit.create(SecurityPoliciesService.class);
        this.client = client;
    }

    public PagedList<SecurityPolicyInner> listByProfile(String resourceGroupName, String profileName) {
        ServiceResponse response = (ServiceResponse)this.listByProfileSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<SecurityPolicyInner>((Page)response.body()){

            public Page<SecurityPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SecurityPoliciesInner.this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SecurityPolicyInner>> listByProfileAsync(String resourceGroupName, String profileName, ListOperationCallback<SecurityPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByProfileSinglePageAsync(resourceGroupName, profileName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(String nextPageLink) {
                return SecurityPoliciesInner.this.listByProfileNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SecurityPolicyInner>> listByProfileAsync(String resourceGroupName, String profileName) {
        return this.listByProfileWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<Page<SecurityPolicyInner>>, Page<SecurityPolicyInner>>(){

            public Page<SecurityPolicyInner> call(ServiceResponse<Page<SecurityPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SecurityPolicyInner>>> listByProfileWithServiceResponseAsync(String resourceGroupName, String profileName) {
        return this.listByProfileSinglePageAsync(resourceGroupName, profileName).concatMap((Func1)new Func1<ServiceResponse<Page<SecurityPolicyInner>>, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(ServiceResponse<Page<SecurityPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SecurityPoliciesInner.this.listByProfileNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecurityPolicyInner>>> listByProfileSinglePageAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByProfile(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SecurityPoliciesInner.this.listByProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecurityPolicyInner>> listByProfileDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SecurityPolicyInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public SecurityPolicyInner get(String resourceGroupName, String profileName, String securityPolicyName) {
        return (SecurityPolicyInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().single()).body());
    }

    public ServiceFuture<SecurityPolicyInner> getAsync(String resourceGroupName, String profileName, String securityPolicyName, ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    public Observable<SecurityPolicyInner> getAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map((Func1)new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>(){

            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return (SecurityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecurityPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityPolicyInner>>>(){

            public Observable<ServiceResponse<SecurityPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecurityPoliciesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecurityPolicyInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SecurityPolicyInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public SecurityPolicyInner create(String resourceGroupName, String profileName, String securityPolicyName) {
        return (SecurityPolicyInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().last()).body());
    }

    public ServiceFuture<SecurityPolicyInner> createAsync(String resourceGroupName, String profileName, String securityPolicyName, ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    public Observable<SecurityPolicyInner> createAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map((Func1)new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>(){

            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return (SecurityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecurityPolicyInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object parameters = null;
        SecurityPolicyInner securityPolicy = new SecurityPolicyInner();
        securityPolicy.withParameters(null);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicy, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecurityPolicyInner>(){}.getType());
    }

    public SecurityPolicyInner create(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return (SecurityPolicyInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<SecurityPolicyInner> createAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters, ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters), serviceCallback);
    }

    public Observable<SecurityPolicyInner> createAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).map((Func1)new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>(){

            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return (SecurityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecurityPolicyInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        SecurityPolicyInner securityPolicy = new SecurityPolicyInner();
        securityPolicy.withParameters(parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicy, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecurityPolicyInner>(){}.getType());
    }

    public SecurityPolicyInner beginCreate(String resourceGroupName, String profileName, String securityPolicyName) {
        return (SecurityPolicyInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().single()).body());
    }

    public ServiceFuture<SecurityPolicyInner> beginCreateAsync(String resourceGroupName, String profileName, String securityPolicyName, ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    public Observable<SecurityPolicyInner> beginCreateAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map((Func1)new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>(){

            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return (SecurityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecurityPolicyInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object parameters = null;
        SecurityPolicyInner securityPolicy = new SecurityPolicyInner();
        securityPolicy.withParameters(null);
        return this.service.beginCreate(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicy, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityPolicyInner>>>(){

            public Observable<ServiceResponse<SecurityPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecurityPoliciesInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public SecurityPolicyInner beginCreate(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return (SecurityPolicyInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<SecurityPolicyInner> beginCreateAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters, ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters), serviceCallback);
    }

    public Observable<SecurityPolicyInner> beginCreateAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).map((Func1)new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>(){

            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return (SecurityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecurityPolicyInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        SecurityPolicyInner securityPolicy = new SecurityPolicyInner();
        securityPolicy.withParameters(parameters);
        return this.service.beginCreate(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicy, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityPolicyInner>>>(){

            public Observable<ServiceResponse<SecurityPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecurityPoliciesInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecurityPolicyInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SecurityPolicyInner>(){}.getType()).register(201, new TypeToken<SecurityPolicyInner>(){}.getType()).register(202, new TypeToken<SecurityPolicyInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public SecurityPolicyInner patch(String resourceGroupName, String profileName, String securityPolicyName) {
        return (SecurityPolicyInner)((Object)((ServiceResponse)this.patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().last()).body());
    }

    public ServiceFuture<SecurityPolicyInner> patchAsync(String resourceGroupName, String profileName, String securityPolicyName, ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    public Observable<SecurityPolicyInner> patchAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return this.patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map((Func1)new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>(){

            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return (SecurityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecurityPolicyInner>> patchWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object parameters = null;
        SecurityPolicyProperties securityPolicyProperties = new SecurityPolicyProperties();
        securityPolicyProperties.withParameters(null);
        Observable<Response<ResponseBody>> observable = this.service.patch(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicyProperties, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecurityPolicyInner>(){}.getType());
    }

    public SecurityPolicyInner patch(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return (SecurityPolicyInner)((Object)((ServiceResponse)this.patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<SecurityPolicyInner> patchAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters, ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters), serviceCallback);
    }

    public Observable<SecurityPolicyInner> patchAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return this.patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).map((Func1)new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>(){

            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return (SecurityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecurityPolicyInner>> patchWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        SecurityPolicyProperties securityPolicyProperties = new SecurityPolicyProperties();
        securityPolicyProperties.withParameters(parameters);
        Observable<Response<ResponseBody>> observable = this.service.patch(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicyProperties, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecurityPolicyInner>(){}.getType());
    }

    public SecurityPolicyInner beginPatch(String resourceGroupName, String profileName, String securityPolicyName) {
        return (SecurityPolicyInner)((Object)((ServiceResponse)this.beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().single()).body());
    }

    public ServiceFuture<SecurityPolicyInner> beginPatchAsync(String resourceGroupName, String profileName, String securityPolicyName, ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    public Observable<SecurityPolicyInner> beginPatchAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return this.beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map((Func1)new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>(){

            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return (SecurityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecurityPolicyInner>> beginPatchWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object parameters = null;
        SecurityPolicyProperties securityPolicyProperties = new SecurityPolicyProperties();
        securityPolicyProperties.withParameters(null);
        return this.service.beginPatch(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicyProperties, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityPolicyInner>>>(){

            public Observable<ServiceResponse<SecurityPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecurityPoliciesInner.this.beginPatchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public SecurityPolicyInner beginPatch(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return (SecurityPolicyInner)((Object)((ServiceResponse)this.beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<SecurityPolicyInner> beginPatchAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters, ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters), serviceCallback);
    }

    public Observable<SecurityPolicyInner> beginPatchAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return this.beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).map((Func1)new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>(){

            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return (SecurityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecurityPolicyInner>> beginPatchWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        SecurityPolicyProperties securityPolicyProperties = new SecurityPolicyProperties();
        securityPolicyProperties.withParameters(parameters);
        return this.service.beginPatch(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicyProperties, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityPolicyInner>>>(){

            public Observable<ServiceResponse<SecurityPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecurityPoliciesInner.this.beginPatchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecurityPolicyInner> beginPatchDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SecurityPolicyInner>(){}.getType()).register(202, new TypeToken<SecurityPolicyInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName, String securityPolicyName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String securityPolicyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String profileName, String securityPolicyName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String securityPolicyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecurityPoliciesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public PagedList<SecurityPolicyInner> listByProfileNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SecurityPolicyInner>((Page)response.body()){

            public Page<SecurityPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SecurityPoliciesInner.this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SecurityPolicyInner>> listByProfileNextAsync(String nextPageLink, ServiceFuture<List<SecurityPolicyInner>> serviceFuture, ListOperationCallback<SecurityPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByProfileNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(String nextPageLink) {
                return SecurityPoliciesInner.this.listByProfileNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SecurityPolicyInner>> listByProfileNextAsync(String nextPageLink) {
        return this.listByProfileNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SecurityPolicyInner>>, Page<SecurityPolicyInner>>(){

            public Page<SecurityPolicyInner> call(ServiceResponse<Page<SecurityPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SecurityPolicyInner>>> listByProfileNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByProfileNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SecurityPolicyInner>>, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(ServiceResponse<Page<SecurityPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SecurityPoliciesInner.this.listByProfileNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecurityPolicyInner>>> listByProfileNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByProfileNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SecurityPoliciesInner.this.listByProfileNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecurityPolicyInner>> listByProfileNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SecurityPolicyInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    static interface SecurityPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies listByProfile"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies")
        public Observable<Response<ResponseBody>> listByProfile(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="securityPolicyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="securityPolicyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body SecurityPolicyInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="securityPolicyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body SecurityPolicyInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies patch"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}")
        public Observable<Response<ResponseBody>> patch(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="securityPolicyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body SecurityPolicyProperties var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies beginPatch"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}")
        public Observable<Response<ResponseBody>> beginPatch(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="securityPolicyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body SecurityPolicyProperties var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="securityPolicyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="securityPolicyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies listByProfileNext"})
        @GET
        public Observable<Response<ResponseBody>> listByProfileNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

