/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.AvailabilitySetOperations;
import com.microsoft.azure.management.compute.AvailabilitySetOperationsImpl;
import com.microsoft.azure.management.compute.ComputeManagementClient;
import com.microsoft.azure.management.compute.UsageOperations;
import com.microsoft.azure.management.compute.UsageOperationsImpl;
import com.microsoft.azure.management.compute.VirtualMachineExtensionImageOperations;
import com.microsoft.azure.management.compute.VirtualMachineExtensionImageOperationsImpl;
import com.microsoft.azure.management.compute.VirtualMachineExtensionOperations;
import com.microsoft.azure.management.compute.VirtualMachineExtensionOperationsImpl;
import com.microsoft.azure.management.compute.VirtualMachineImageOperations;
import com.microsoft.azure.management.compute.VirtualMachineImageOperationsImpl;
import com.microsoft.azure.management.compute.VirtualMachineOperations;
import com.microsoft.azure.management.compute.VirtualMachineOperationsImpl;
import com.microsoft.azure.management.compute.VirtualMachineSizeOperations;
import com.microsoft.azure.management.compute.VirtualMachineSizeOperationsImpl;
import com.microsoft.azure.management.compute.models.ApiError;
import com.microsoft.azure.management.compute.models.ApiErrorBase;
import com.microsoft.azure.management.compute.models.ComputeLongRunningOperationResponse;
import com.microsoft.azure.management.compute.models.ComputeOperationStatus;
import com.microsoft.azure.management.compute.models.DeleteOperationResponse;
import com.microsoft.azure.management.compute.models.InnerError;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class ComputeManagementClientImpl
extends ServiceClient<ComputeManagementClient>
implements ComputeManagementClient {
    private String apiVersion = "2015-06-15";
    private URI baseUri;
    private SubscriptionCloudCredentials credentials;
    private int longRunningOperationInitialTimeout = -1;
    private int longRunningOperationRetryTimeout = -1;
    private AvailabilitySetOperations availabilitySets = new AvailabilitySetOperationsImpl(this);
    private UsageOperations usage = new UsageOperationsImpl(this);
    private VirtualMachineExtensionImageOperations virtualMachineExtensionImages = new VirtualMachineExtensionImageOperationsImpl(this);
    private VirtualMachineExtensionOperations virtualMachineExtensions = new VirtualMachineExtensionOperationsImpl(this);
    private VirtualMachineImageOperations virtualMachineImages = new VirtualMachineImageOperationsImpl(this);
    private VirtualMachineOperations virtualMachines = new VirtualMachineOperationsImpl(this);
    private VirtualMachineSizeOperations virtualMachineSizes = new VirtualMachineSizeOperationsImpl(this);

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public SubscriptionCloudCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public int getLongRunningOperationInitialTimeout() {
        return this.longRunningOperationInitialTimeout;
    }

    @Override
    public void setLongRunningOperationInitialTimeout(int longRunningOperationInitialTimeoutValue) {
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }

    @Override
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeoutValue) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }

    @Override
    public AvailabilitySetOperations getAvailabilitySetsOperations() {
        return this.availabilitySets;
    }

    @Override
    public UsageOperations getUsageOperations() {
        return this.usage;
    }

    @Override
    public VirtualMachineExtensionImageOperations getVirtualMachineExtensionImagesOperations() {
        return this.virtualMachineExtensionImages;
    }

    @Override
    public VirtualMachineExtensionOperations getVirtualMachineExtensionsOperations() {
        return this.virtualMachineExtensions;
    }

    @Override
    public VirtualMachineImageOperations getVirtualMachineImagesOperations() {
        return this.virtualMachineImages;
    }

    @Override
    public VirtualMachineOperations getVirtualMachinesOperations() {
        return this.virtualMachines;
    }

    @Override
    public VirtualMachineSizeOperations getVirtualMachineSizesOperations() {
        return this.virtualMachineSizes;
    }

    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
    }

    @Inject
    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(value="com.microsoft.windowsazure.Configuration.credentials") SubscriptionCloudCredentials credentials, @Named(value="management.uri") URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        if (baseUri == null) {
            try {
                this.baseUri = new URI("https://management.azure.com");
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.baseUri = baseUri;
        }
    }

    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials) throws URISyntaxException {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = new URI("https://management.azure.com");
    }

    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    protected ComputeManagementClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new ComputeManagementClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri(), this.getApiVersion(), this.getLongRunningOperationInitialTimeout(), this.getLongRunningOperationRetryTimeout());
    }

    @Override
    public Future<DeleteOperationResponse> getDeleteOperationStatusAsync(final String operationStatusLink) {
        return this.getExecutorService().submit(new Callable<DeleteOperationResponse>(){

            @Override
            public DeleteOperationResponse call() throws Exception {
                return ComputeManagementClientImpl.this.getDeleteOperationStatus(operationStatusLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOperationResponse getDeleteOperationStatus(String operationStatusLink) throws IOException, ServiceException {
        if (operationStatusLink == null) {
            throw new NullPointerException("operationStatusLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("operationStatusLink", operationStatusLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getDeleteOperationStatusAsync", tracingParameters);
        }
        String url = "";
        url = url + operationStatusLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeleteOperationResponse result = null;
            if (statusCode == 200 || statusCode == 202) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeleteOperationResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode endTimeValue;
                    JsonNode startTimeValue;
                    JsonNode statusValue;
                    JsonNode operationIdValue = responseDoc.get("operationId");
                    if (operationIdValue != null && !(operationIdValue instanceof NullNode)) {
                        String operationIdInstance = operationIdValue.getTextValue();
                        result.setTrackingOperationId(operationIdInstance);
                    }
                    if ((statusValue = responseDoc.get("status")) != null && !(statusValue instanceof NullNode)) {
                        OperationStatus statusInstance = Enum.valueOf(OperationStatus.class, statusValue.getTextValue());
                        result.setStatus(statusInstance);
                    }
                    if ((startTimeValue = responseDoc.get("startTime")) != null && !(startTimeValue instanceof NullNode)) {
                        Calendar startTimeInstance = DatatypeConverter.parseDateTime((String)startTimeValue.getTextValue());
                        result.setStartTime(startTimeInstance);
                    }
                    if ((endTimeValue = responseDoc.get("endTime")) != null && !(endTimeValue instanceof NullNode)) {
                        Calendar endTimeInstance = DatatypeConverter.parseDateTime((String)endTimeValue.getTextValue());
                        result.setEndTime(endTimeInstance);
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode messageValue2;
                        JsonNode targetValue2;
                        JsonNode codeValue2;
                        JsonNode innererrorValue;
                        ApiError errorInstance = new ApiError();
                        result.setError(errorInstance);
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue;
                                JsonNode targetValue;
                                ApiErrorBase apiErrorBaseInstance = new ApiErrorBase();
                                errorInstance.getDetails().add(apiErrorBaseInstance);
                                JsonNode codeValue = detailsValue.get("code");
                                if (codeValue != null && !(codeValue instanceof NullNode)) {
                                    String codeInstance = codeValue.getTextValue();
                                    apiErrorBaseInstance.setCode(codeInstance);
                                }
                                if ((targetValue = detailsValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                                    String targetInstance = targetValue.getTextValue();
                                    apiErrorBaseInstance.setTarget(targetInstance);
                                }
                                if ((messageValue = detailsValue.get("message")) == null || messageValue instanceof NullNode) continue;
                                String messageInstance = messageValue.getTextValue();
                                apiErrorBaseInstance.setMessage(messageInstance);
                            }
                        }
                        if ((innererrorValue = errorValue.get("innererror")) != null && !(innererrorValue instanceof NullNode)) {
                            JsonNode errordetailValue;
                            InnerError innererrorInstance = new InnerError();
                            errorInstance.setInnerError(innererrorInstance);
                            JsonNode exceptiontypeValue = innererrorValue.get("exceptiontype");
                            if (exceptiontypeValue != null && !(exceptiontypeValue instanceof NullNode)) {
                                String exceptiontypeInstance = exceptiontypeValue.getTextValue();
                                innererrorInstance.setExceptionType(exceptiontypeInstance);
                            }
                            if ((errordetailValue = innererrorValue.get("errordetail")) != null && !(errordetailValue instanceof NullNode)) {
                                String errordetailInstance = errordetailValue.getTextValue();
                                innererrorInstance.setErrorDetail(errordetailInstance);
                            }
                        }
                        if ((codeValue2 = errorValue.get("code")) != null && !(codeValue2 instanceof NullNode)) {
                            String codeInstance2 = codeValue2.getTextValue();
                            errorInstance.setCode(codeInstance2);
                        }
                        if ((targetValue2 = errorValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                            String targetInstance2 = targetValue2.getTextValue();
                            errorInstance.setTarget(targetInstance2);
                        }
                        if ((messageValue2 = errorValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                            String messageInstance2 = messageValue2.getTextValue();
                            errorInstance.setMessage(messageInstance2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeleteOperationResponse deleteOperationResponse = result;
            return deleteOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ComputeLongRunningOperationResponse> getLongRunningOperationStatusAsync(final String operationStatusLink) {
        return this.getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>(){

            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return ComputeManagementClientImpl.this.getLongRunningOperationStatus(operationStatusLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeLongRunningOperationResponse getLongRunningOperationStatus(String operationStatusLink) throws IOException, ServiceException {
        if (operationStatusLink == null) {
            throw new NullPointerException("operationStatusLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("operationStatusLink", operationStatusLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getLongRunningOperationStatusAsync", tracingParameters);
        }
        String url = "";
        url = url + operationStatusLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ComputeLongRunningOperationResponse result = null;
            if (statusCode == 200 || statusCode == 202) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ComputeLongRunningOperationResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode outputValue;
                    JsonNode propertiesValue;
                    JsonNode endTimeValue;
                    JsonNode startTimeValue;
                    JsonNode statusValue;
                    JsonNode operationIdValue = responseDoc.get("operationId");
                    if (operationIdValue != null && !(operationIdValue instanceof NullNode)) {
                        String operationIdInstance = operationIdValue.getTextValue();
                        result.setTrackingOperationId(operationIdInstance);
                    }
                    if ((statusValue = responseDoc.get("status")) != null && !(statusValue instanceof NullNode)) {
                        ComputeOperationStatus statusInstance = Enum.valueOf(ComputeOperationStatus.class, statusValue.getTextValue());
                        result.setStatus(statusInstance);
                    }
                    if ((startTimeValue = responseDoc.get("startTime")) != null && !(startTimeValue instanceof NullNode)) {
                        Calendar startTimeInstance = DatatypeConverter.parseDateTime((String)startTimeValue.getTextValue());
                        result.setStartTime(startTimeInstance);
                    }
                    if ((endTimeValue = responseDoc.get("endTime")) != null && !(endTimeValue instanceof NullNode)) {
                        Calendar endTimeInstance = DatatypeConverter.parseDateTime((String)endTimeValue.getTextValue());
                        result.setEndTime(endTimeInstance);
                    }
                    if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode) && (outputValue = propertiesValue.get("output")) != null && !(outputValue instanceof NullNode)) {
                        String outputInstance = outputValue.getTextValue();
                        result.setOutput(outputInstance);
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode messageValue2;
                        JsonNode targetValue2;
                        JsonNode codeValue2;
                        JsonNode innererrorValue;
                        ApiError errorInstance = new ApiError();
                        result.setError(errorInstance);
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue;
                                JsonNode targetValue;
                                ApiErrorBase apiErrorBaseInstance = new ApiErrorBase();
                                errorInstance.getDetails().add(apiErrorBaseInstance);
                                JsonNode codeValue = detailsValue.get("code");
                                if (codeValue != null && !(codeValue instanceof NullNode)) {
                                    String codeInstance = codeValue.getTextValue();
                                    apiErrorBaseInstance.setCode(codeInstance);
                                }
                                if ((targetValue = detailsValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                                    String targetInstance = targetValue.getTextValue();
                                    apiErrorBaseInstance.setTarget(targetInstance);
                                }
                                if ((messageValue = detailsValue.get("message")) == null || messageValue instanceof NullNode) continue;
                                String messageInstance = messageValue.getTextValue();
                                apiErrorBaseInstance.setMessage(messageInstance);
                            }
                        }
                        if ((innererrorValue = errorValue.get("innererror")) != null && !(innererrorValue instanceof NullNode)) {
                            JsonNode errordetailValue;
                            InnerError innererrorInstance = new InnerError();
                            errorInstance.setInnerError(innererrorInstance);
                            JsonNode exceptiontypeValue = innererrorValue.get("exceptiontype");
                            if (exceptiontypeValue != null && !(exceptiontypeValue instanceof NullNode)) {
                                String exceptiontypeInstance = exceptiontypeValue.getTextValue();
                                innererrorInstance.setExceptionType(exceptiontypeInstance);
                            }
                            if ((errordetailValue = innererrorValue.get("errordetail")) != null && !(errordetailValue instanceof NullNode)) {
                                String errordetailInstance = errordetailValue.getTextValue();
                                innererrorInstance.setErrorDetail(errordetailInstance);
                            }
                        }
                        if ((codeValue2 = errorValue.get("code")) != null && !(codeValue2 instanceof NullNode)) {
                            String codeInstance2 = codeValue2.getTextValue();
                            errorInstance.setCode(codeInstance2);
                        }
                        if ((targetValue2 = errorValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                            String targetInstance2 = targetValue2.getTextValue();
                            errorInstance.setTarget(targetInstance2);
                        }
                        if ((messageValue2 = errorValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                            String messageInstance2 = messageValue2.getTextValue();
                            errorInstance.setMessage(messageInstance2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeLongRunningOperationResponse computeLongRunningOperationResponse = result;
            return computeLongRunningOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

