/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.ComputeManagementClient;
import com.microsoft.azure.management.compute.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.VirtualMachineExtensionOperations;
import com.microsoft.azure.management.compute.models.ComputeLongRunningOperationResponse;
import com.microsoft.azure.management.compute.models.ComputeOperationStatus;
import com.microsoft.azure.management.compute.models.DeleteOperationResponse;
import com.microsoft.azure.management.compute.models.InstanceViewStatus;
import com.microsoft.azure.management.compute.models.VirtualMachineExtension;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionCreateOrUpdateResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionGetResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionInstanceView;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class VirtualMachineExtensionOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineExtensionOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineExtensionOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<VirtualMachineExtensionCreateOrUpdateResponse> beginCreatingOrUpdatingAsync(final String resourceGroupName, final String vmName, final VirtualMachineExtension extensionParameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineExtensionCreateOrUpdateResponse>(){

            @Override
            public VirtualMachineExtensionCreateOrUpdateResponse call() throws Exception {
                return VirtualMachineExtensionOperationsImpl.this.beginCreatingOrUpdating(resourceGroupName, vmName, extensionParameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineExtensionCreateOrUpdateResponse beginCreatingOrUpdating(String resourceGroupName, String vmName, VirtualMachineExtension extensionParameters) throws IOException, ServiceException, URISyntaxException {
        ObjectNode virtualMachineExtensionJsonValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        if (extensionParameters == null) {
            throw new NullPointerException("extensionParameters");
        }
        if (extensionParameters.getLocation() == null) {
            throw new NullPointerException("extensionParameters.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("extensionParameters", (Object)extensionParameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreatingOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/extensions/";
        if (extensionParameters.getName() != null) {
            url = url + URLEncoder.encode(extensionParameters.getName(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = virtualMachineExtensionJsonValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        virtualMachineExtensionJsonValue.put("properties", (JsonNode)propertiesValue);
        if (extensionParameters.getPublisher() != null) {
            propertiesValue.put("publisher", extensionParameters.getPublisher());
        }
        if (extensionParameters.getExtensionType() != null) {
            propertiesValue.put("type", extensionParameters.getExtensionType());
        }
        if (extensionParameters.getTypeHandlerVersion() != null) {
            propertiesValue.put("typeHandlerVersion", extensionParameters.getTypeHandlerVersion());
        }
        propertiesValue.put("autoUpgradeMinorVersion", extensionParameters.isAutoUpgradeMinorVersion());
        if (extensionParameters.getSettings() != null) {
            propertiesValue.put("settings", objectMapper.readTree(extensionParameters.getSettings()));
        }
        if (extensionParameters.getProtectedSettings() != null) {
            propertiesValue.put("protectedSettings", objectMapper.readTree(extensionParameters.getProtectedSettings()));
        }
        if (extensionParameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", extensionParameters.getProvisioningState());
        }
        if (extensionParameters.getInstanceView() != null) {
            ObjectNode instanceViewValue = objectMapper.createObjectNode();
            propertiesValue.put("instanceView", (JsonNode)instanceViewValue);
            if (extensionParameters.getInstanceView().getName() != null) {
                instanceViewValue.put("name", extensionParameters.getInstanceView().getName());
            }
            if (extensionParameters.getInstanceView().getExtensionType() != null) {
                instanceViewValue.put("type", extensionParameters.getInstanceView().getExtensionType());
            }
            if (extensionParameters.getInstanceView().getTypeHandlerVersion() != null) {
                instanceViewValue.put("typeHandlerVersion", extensionParameters.getInstanceView().getTypeHandlerVersion());
            }
            if (extensionParameters.getInstanceView().getSubStatuses() != null && (!(extensionParameters.getInstanceView().getSubStatuses() instanceof LazyCollection) || ((LazyCollection)extensionParameters.getInstanceView().getSubStatuses()).isInitialized())) {
                ArrayNode substatusesArray = objectMapper.createArrayNode();
                for (InstanceViewStatus substatusesItem : extensionParameters.getInstanceView().getSubStatuses()) {
                    ObjectNode instanceViewStatusValue = objectMapper.createObjectNode();
                    substatusesArray.add((JsonNode)instanceViewStatusValue);
                    if (substatusesItem.getCode() != null) {
                        instanceViewStatusValue.put("code", substatusesItem.getCode());
                    }
                    if (substatusesItem.getLevel() != null) {
                        instanceViewStatusValue.put("level", substatusesItem.getLevel());
                    }
                    if (substatusesItem.getDisplayStatus() != null) {
                        instanceViewStatusValue.put("displayStatus", substatusesItem.getDisplayStatus());
                    }
                    if (substatusesItem.getMessage() != null) {
                        instanceViewStatusValue.put("message", substatusesItem.getMessage());
                    }
                    if (substatusesItem.getTime() == null) continue;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    instanceViewStatusValue.put("time", simpleDateFormat.format(substatusesItem.getTime().getTime()));
                }
                instanceViewValue.put("substatuses", (JsonNode)substatusesArray);
            }
            if (extensionParameters.getInstanceView().getStatuses() != null) {
                ArrayNode statusesArray = objectMapper.createArrayNode();
                for (InstanceViewStatus statusesItem : extensionParameters.getInstanceView().getStatuses()) {
                    ObjectNode instanceViewStatusValue2 = objectMapper.createObjectNode();
                    statusesArray.add((JsonNode)instanceViewStatusValue2);
                    if (statusesItem.getCode() != null) {
                        instanceViewStatusValue2.put("code", statusesItem.getCode());
                    }
                    if (statusesItem.getLevel() != null) {
                        instanceViewStatusValue2.put("level", statusesItem.getLevel());
                    }
                    if (statusesItem.getDisplayStatus() != null) {
                        instanceViewStatusValue2.put("displayStatus", statusesItem.getDisplayStatus());
                    }
                    if (statusesItem.getMessage() != null) {
                        instanceViewStatusValue2.put("message", statusesItem.getMessage());
                    }
                    if (statusesItem.getTime() == null) continue;
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                    instanceViewStatusValue2.put("time", simpleDateFormat2.format(statusesItem.getTime().getTime()));
                }
                instanceViewValue.put("statuses", (JsonNode)statusesArray);
            }
        }
        if (extensionParameters.getId() != null) {
            virtualMachineExtensionJsonValue.put("id", extensionParameters.getId());
        }
        if (extensionParameters.getName() != null) {
            virtualMachineExtensionJsonValue.put("name", extensionParameters.getName());
        }
        if (extensionParameters.getType() != null) {
            virtualMachineExtensionJsonValue.put("type", extensionParameters.getType());
        }
        virtualMachineExtensionJsonValue.put("location", extensionParameters.getLocation());
        if (extensionParameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : extensionParameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            virtualMachineExtensionJsonValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineExtensionCreateOrUpdateResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineExtensionCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue3;
                    JsonNode nameValue2;
                    JsonNode idValue;
                    VirtualMachineExtension virtualMachineExtensionInstance = new VirtualMachineExtension();
                    result.setVirtualMachineExtension(virtualMachineExtensionInstance);
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                        JsonNode instanceViewValue2;
                        JsonNode provisioningStateValue;
                        JsonNode protectedSettingsValue;
                        JsonNode settingsValue;
                        JsonNode autoUpgradeMinorVersionValue;
                        JsonNode typeHandlerVersionValue;
                        JsonNode typeValue;
                        JsonNode publisherValue = propertiesValue2.get("publisher");
                        if (publisherValue != null && !(publisherValue instanceof NullNode)) {
                            String publisherInstance = publisherValue.getTextValue();
                            virtualMachineExtensionInstance.setPublisher(publisherInstance);
                        }
                        if ((typeValue = propertiesValue2.get("type")) != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            virtualMachineExtensionInstance.setExtensionType(typeInstance);
                        }
                        if ((typeHandlerVersionValue = propertiesValue2.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue instanceof NullNode)) {
                            String typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                            virtualMachineExtensionInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                        }
                        if ((autoUpgradeMinorVersionValue = propertiesValue2.get("autoUpgradeMinorVersion")) != null && !(autoUpgradeMinorVersionValue instanceof NullNode)) {
                            boolean autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                            virtualMachineExtensionInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                        }
                        if ((settingsValue = propertiesValue2.get("settings")) != null && !(settingsValue instanceof NullNode)) {
                            String settingsInstance = settingsValue.getTextValue();
                            virtualMachineExtensionInstance.setSettings(settingsInstance);
                        }
                        if ((protectedSettingsValue = propertiesValue2.get("protectedSettings")) != null && !(protectedSettingsValue instanceof NullNode)) {
                            String protectedSettingsInstance = protectedSettingsValue.getTextValue();
                            virtualMachineExtensionInstance.setProtectedSettings(protectedSettingsInstance);
                        }
                        if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineExtensionInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((instanceViewValue2 = propertiesValue2.get("instanceView")) != null && !(instanceViewValue2 instanceof NullNode)) {
                            JsonNode statusesArray2;
                            JsonNode substatusesArray2;
                            JsonNode typeHandlerVersionValue2;
                            JsonNode typeValue2;
                            VirtualMachineExtensionInstanceView instanceViewInstance = new VirtualMachineExtensionInstanceView();
                            virtualMachineExtensionInstance.setInstanceView(instanceViewInstance);
                            JsonNode nameValue = instanceViewValue2.get("name");
                            if (nameValue != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                instanceViewInstance.setName(nameInstance);
                            }
                            if ((typeValue2 = instanceViewValue2.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                String typeInstance2 = typeValue2.getTextValue();
                                instanceViewInstance.setExtensionType(typeInstance2);
                            }
                            if ((typeHandlerVersionValue2 = instanceViewValue2.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue2 instanceof NullNode)) {
                                String typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                instanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                            }
                            if ((substatusesArray2 = instanceViewValue2.get("substatuses")) != null && !(substatusesArray2 instanceof NullNode)) {
                                for (JsonNode substatusesValue : (ArrayNode)substatusesArray2) {
                                    JsonNode timeValue;
                                    JsonNode messageValue;
                                    JsonNode displayStatusValue;
                                    JsonNode levelValue;
                                    InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                    instanceViewInstance.getSubStatuses().add(instanceViewStatusInstance);
                                    JsonNode codeValue = substatusesValue.get("code");
                                    if (codeValue != null && !(codeValue instanceof NullNode)) {
                                        String codeInstance = codeValue.getTextValue();
                                        instanceViewStatusInstance.setCode(codeInstance);
                                    }
                                    if ((levelValue = substatusesValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                        String levelInstance = levelValue.getTextValue();
                                        instanceViewStatusInstance.setLevel(levelInstance);
                                    }
                                    if ((displayStatusValue = substatusesValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                        String displayStatusInstance = displayStatusValue.getTextValue();
                                        instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                    }
                                    if ((messageValue = substatusesValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                        String messageInstance = messageValue.getTextValue();
                                        instanceViewStatusInstance.setMessage(messageInstance);
                                    }
                                    if ((timeValue = substatusesValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                    Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                    instanceViewStatusInstance.setTime(timeInstance);
                                }
                            }
                            if ((statusesArray2 = instanceViewValue2.get("statuses")) != null && !(statusesArray2 instanceof NullNode)) {
                                for (JsonNode statusesValue : (ArrayNode)statusesArray2) {
                                    JsonNode timeValue2;
                                    JsonNode messageValue2;
                                    JsonNode displayStatusValue2;
                                    JsonNode levelValue2;
                                    InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                    JsonNode codeValue2 = statusesValue.get("code");
                                    if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                        String codeInstance2 = codeValue2.getTextValue();
                                        instanceViewStatusInstance2.setCode(codeInstance2);
                                    }
                                    if ((levelValue2 = statusesValue.get("level")) != null && !(levelValue2 instanceof NullNode)) {
                                        String levelInstance2 = levelValue2.getTextValue();
                                        instanceViewStatusInstance2.setLevel(levelInstance2);
                                    }
                                    if ((displayStatusValue2 = statusesValue.get("displayStatus")) != null && !(displayStatusValue2 instanceof NullNode)) {
                                        String displayStatusInstance2 = displayStatusValue2.getTextValue();
                                        instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance2);
                                    }
                                    if ((messageValue2 = statusesValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                                        String messageInstance2 = messageValue2.getTextValue();
                                        instanceViewStatusInstance2.setMessage(messageInstance2);
                                    }
                                    if ((timeValue2 = statusesValue.get("time")) == null || timeValue2 instanceof NullNode) continue;
                                    Calendar timeInstance2 = DatatypeConverter.parseDateTime((String)timeValue2.getTextValue());
                                    instanceViewStatusInstance2.setTime(timeInstance2);
                                }
                            }
                        }
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        virtualMachineExtensionInstance.setId(idInstance);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        virtualMachineExtensionInstance.setName(nameInstance2);
                    }
                    if ((typeValue3 = responseDoc.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                        String typeInstance3 = typeValue3.getTextValue();
                        virtualMachineExtensionInstance.setType(typeInstance3);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineExtensionInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            virtualMachineExtensionInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineExtensionCreateOrUpdateResponse virtualMachineExtensionCreateOrUpdateResponse = result;
            return virtualMachineExtensionCreateOrUpdateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeleteOperationResponse> beginDeletingAsync(final String resourceGroupName, final String vmName, final String vmExtensionName) {
        return this.getClient().getExecutorService().submit(new Callable<DeleteOperationResponse>(){

            @Override
            public DeleteOperationResponse call() throws Exception {
                return VirtualMachineExtensionOperationsImpl.this.beginDeleting(resourceGroupName, vmName, vmExtensionName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOperationResponse beginDeleting(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        if (vmExtensionName == null) {
            throw new NullPointerException("vmExtensionName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("vmExtensionName", vmExtensionName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/extensions/";
        url = url + URLEncoder.encode(vmExtensionName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeleteOperationResponse result = null;
            result = new DeleteOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == 409) {
                result.setStatus(OperationStatus.Failed);
            }
            if (statusCode == 200) {
                result.setStatus(OperationStatus.Succeeded);
            }
            if (statusCode == 204) {
                result.setStatus(OperationStatus.Succeeded);
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeleteOperationResponse deleteOperationResponse = result;
            return deleteOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ComputeLongRunningOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String vmName, final VirtualMachineExtension extensionParameters) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>(){

            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return VirtualMachineExtensionOperationsImpl.this.createOrUpdate(resourceGroupName, vmName, extensionParameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeLongRunningOperationResponse createOrUpdate(String resourceGroupName, String vmName, VirtualMachineExtension extensionParameters) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("extensionParameters", (Object)extensionParameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            VirtualMachineExtensionCreateOrUpdateResponse response = client2.getVirtualMachineExtensionsOperations().beginCreatingOrUpdatingAsync(resourceGroupName, vmName, extensionParameters).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeLongRunningOperationResponse computeLongRunningOperationResponse = result;
            return computeLongRunningOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<DeleteOperationResponse> deleteAsync(final String resourceGroupName, final String vmName, final String vmExtensionName) {
        return this.getClient().getExecutorService().submit(new Callable<DeleteOperationResponse>(){

            @Override
            public DeleteOperationResponse call() throws Exception {
                return VirtualMachineExtensionOperationsImpl.this.delete(resourceGroupName, vmName, vmExtensionName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOperationResponse delete(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("vmExtensionName", vmExtensionName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            DeleteOperationResponse response;
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            if ((response = client2.getVirtualMachineExtensionsOperations().beginDeletingAsync(resourceGroupName, vmName, vmExtensionName).get()).getStatus() == OperationStatus.Succeeded) {
                DeleteOperationResponse deleteOperationResponse = response;
                return deleteOperationResponse;
            }
            DeleteOperationResponse result = client2.getDeleteOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getDeleteOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeleteOperationResponse deleteOperationResponse = result;
            return deleteOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<VirtualMachineExtensionGetResponse> getAsync(final String resourceGroupName, final String vmName, final String vmExtensionName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineExtensionGetResponse>(){

            @Override
            public VirtualMachineExtensionGetResponse call() throws Exception {
                return VirtualMachineExtensionOperationsImpl.this.get(resourceGroupName, vmName, vmExtensionName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineExtensionGetResponse get(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        if (vmExtensionName == null) {
            throw new NullPointerException("vmExtensionName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("vmExtensionName", vmExtensionName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/extensions/";
        url = url + URLEncoder.encode(vmExtensionName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineExtensionGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineExtensionGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue3;
                    JsonNode nameValue2;
                    JsonNode idValue;
                    VirtualMachineExtension virtualMachineExtensionInstance = new VirtualMachineExtension();
                    result.setVirtualMachineExtension(virtualMachineExtensionInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode instanceViewValue;
                        JsonNode provisioningStateValue;
                        JsonNode protectedSettingsValue;
                        JsonNode settingsValue;
                        JsonNode autoUpgradeMinorVersionValue;
                        JsonNode typeHandlerVersionValue;
                        JsonNode typeValue;
                        JsonNode publisherValue = propertiesValue.get("publisher");
                        if (publisherValue != null && !(publisherValue instanceof NullNode)) {
                            String publisherInstance = publisherValue.getTextValue();
                            virtualMachineExtensionInstance.setPublisher(publisherInstance);
                        }
                        if ((typeValue = propertiesValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            virtualMachineExtensionInstance.setExtensionType(typeInstance);
                        }
                        if ((typeHandlerVersionValue = propertiesValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue instanceof NullNode)) {
                            String typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                            virtualMachineExtensionInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                        }
                        if ((autoUpgradeMinorVersionValue = propertiesValue.get("autoUpgradeMinorVersion")) != null && !(autoUpgradeMinorVersionValue instanceof NullNode)) {
                            boolean autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                            virtualMachineExtensionInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                        }
                        if ((settingsValue = propertiesValue.get("settings")) != null && !(settingsValue instanceof NullNode)) {
                            String settingsInstance = settingsValue.getTextValue();
                            virtualMachineExtensionInstance.setSettings(settingsInstance);
                        }
                        if ((protectedSettingsValue = propertiesValue.get("protectedSettings")) != null && !(protectedSettingsValue instanceof NullNode)) {
                            String protectedSettingsInstance = protectedSettingsValue.getTextValue();
                            virtualMachineExtensionInstance.setProtectedSettings(protectedSettingsInstance);
                        }
                        if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineExtensionInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((instanceViewValue = propertiesValue.get("instanceView")) != null && !(instanceViewValue instanceof NullNode)) {
                            JsonNode statusesArray;
                            JsonNode substatusesArray;
                            JsonNode typeHandlerVersionValue2;
                            JsonNode typeValue2;
                            VirtualMachineExtensionInstanceView instanceViewInstance = new VirtualMachineExtensionInstanceView();
                            virtualMachineExtensionInstance.setInstanceView(instanceViewInstance);
                            JsonNode nameValue = instanceViewValue.get("name");
                            if (nameValue != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                instanceViewInstance.setName(nameInstance);
                            }
                            if ((typeValue2 = instanceViewValue.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                String typeInstance2 = typeValue2.getTextValue();
                                instanceViewInstance.setExtensionType(typeInstance2);
                            }
                            if ((typeHandlerVersionValue2 = instanceViewValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue2 instanceof NullNode)) {
                                String typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                instanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                            }
                            if ((substatusesArray = instanceViewValue.get("substatuses")) != null && !(substatusesArray instanceof NullNode)) {
                                for (JsonNode substatusesValue : (ArrayNode)substatusesArray) {
                                    JsonNode timeValue;
                                    JsonNode messageValue;
                                    JsonNode displayStatusValue;
                                    JsonNode levelValue;
                                    InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                    instanceViewInstance.getSubStatuses().add(instanceViewStatusInstance);
                                    JsonNode codeValue = substatusesValue.get("code");
                                    if (codeValue != null && !(codeValue instanceof NullNode)) {
                                        String codeInstance = codeValue.getTextValue();
                                        instanceViewStatusInstance.setCode(codeInstance);
                                    }
                                    if ((levelValue = substatusesValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                        String levelInstance = levelValue.getTextValue();
                                        instanceViewStatusInstance.setLevel(levelInstance);
                                    }
                                    if ((displayStatusValue = substatusesValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                        String displayStatusInstance = displayStatusValue.getTextValue();
                                        instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                    }
                                    if ((messageValue = substatusesValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                        String messageInstance = messageValue.getTextValue();
                                        instanceViewStatusInstance.setMessage(messageInstance);
                                    }
                                    if ((timeValue = substatusesValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                    Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                    instanceViewStatusInstance.setTime(timeInstance);
                                }
                            }
                            if ((statusesArray = instanceViewValue.get("statuses")) != null && !(statusesArray instanceof NullNode)) {
                                for (JsonNode statusesValue : (ArrayNode)statusesArray) {
                                    JsonNode timeValue2;
                                    JsonNode messageValue2;
                                    JsonNode displayStatusValue2;
                                    JsonNode levelValue2;
                                    InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                    JsonNode codeValue2 = statusesValue.get("code");
                                    if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                        String codeInstance2 = codeValue2.getTextValue();
                                        instanceViewStatusInstance2.setCode(codeInstance2);
                                    }
                                    if ((levelValue2 = statusesValue.get("level")) != null && !(levelValue2 instanceof NullNode)) {
                                        String levelInstance2 = levelValue2.getTextValue();
                                        instanceViewStatusInstance2.setLevel(levelInstance2);
                                    }
                                    if ((displayStatusValue2 = statusesValue.get("displayStatus")) != null && !(displayStatusValue2 instanceof NullNode)) {
                                        String displayStatusInstance2 = displayStatusValue2.getTextValue();
                                        instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance2);
                                    }
                                    if ((messageValue2 = statusesValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                                        String messageInstance2 = messageValue2.getTextValue();
                                        instanceViewStatusInstance2.setMessage(messageInstance2);
                                    }
                                    if ((timeValue2 = statusesValue.get("time")) == null || timeValue2 instanceof NullNode) continue;
                                    Calendar timeInstance2 = DatatypeConverter.parseDateTime((String)timeValue2.getTextValue());
                                    instanceViewStatusInstance2.setTime(timeInstance2);
                                }
                            }
                        }
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        virtualMachineExtensionInstance.setId(idInstance);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        virtualMachineExtensionInstance.setName(nameInstance2);
                    }
                    if ((typeValue3 = responseDoc.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                        String typeInstance3 = typeValue3.getTextValue();
                        virtualMachineExtensionInstance.setType(typeInstance3);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineExtensionInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            virtualMachineExtensionInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineExtensionGetResponse virtualMachineExtensionGetResponse = result;
            return virtualMachineExtensionGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineExtensionGetResponse> getWithInstanceViewAsync(final String resourceGroupName, final String vmName, final String vmExtensionName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineExtensionGetResponse>(){

            @Override
            public VirtualMachineExtensionGetResponse call() throws Exception {
                return VirtualMachineExtensionOperationsImpl.this.getWithInstanceView(resourceGroupName, vmName, vmExtensionName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineExtensionGetResponse getWithInstanceView(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        if (vmExtensionName == null) {
            throw new NullPointerException("vmExtensionName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("vmExtensionName", vmExtensionName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getWithInstanceViewAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/extensions/";
        url = url + URLEncoder.encode(vmExtensionName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("$expand=instanceView");
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineExtensionGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineExtensionGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue3;
                    JsonNode nameValue2;
                    JsonNode idValue;
                    VirtualMachineExtension virtualMachineExtensionInstance = new VirtualMachineExtension();
                    result.setVirtualMachineExtension(virtualMachineExtensionInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode instanceViewValue;
                        JsonNode provisioningStateValue;
                        JsonNode protectedSettingsValue;
                        JsonNode settingsValue;
                        JsonNode autoUpgradeMinorVersionValue;
                        JsonNode typeHandlerVersionValue;
                        JsonNode typeValue;
                        JsonNode publisherValue = propertiesValue.get("publisher");
                        if (publisherValue != null && !(publisherValue instanceof NullNode)) {
                            String publisherInstance = publisherValue.getTextValue();
                            virtualMachineExtensionInstance.setPublisher(publisherInstance);
                        }
                        if ((typeValue = propertiesValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            virtualMachineExtensionInstance.setExtensionType(typeInstance);
                        }
                        if ((typeHandlerVersionValue = propertiesValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue instanceof NullNode)) {
                            String typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                            virtualMachineExtensionInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                        }
                        if ((autoUpgradeMinorVersionValue = propertiesValue.get("autoUpgradeMinorVersion")) != null && !(autoUpgradeMinorVersionValue instanceof NullNode)) {
                            boolean autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                            virtualMachineExtensionInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                        }
                        if ((settingsValue = propertiesValue.get("settings")) != null && !(settingsValue instanceof NullNode)) {
                            String settingsInstance = settingsValue.getTextValue();
                            virtualMachineExtensionInstance.setSettings(settingsInstance);
                        }
                        if ((protectedSettingsValue = propertiesValue.get("protectedSettings")) != null && !(protectedSettingsValue instanceof NullNode)) {
                            String protectedSettingsInstance = protectedSettingsValue.getTextValue();
                            virtualMachineExtensionInstance.setProtectedSettings(protectedSettingsInstance);
                        }
                        if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineExtensionInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((instanceViewValue = propertiesValue.get("instanceView")) != null && !(instanceViewValue instanceof NullNode)) {
                            JsonNode statusesArray;
                            JsonNode substatusesArray;
                            JsonNode typeHandlerVersionValue2;
                            JsonNode typeValue2;
                            VirtualMachineExtensionInstanceView instanceViewInstance = new VirtualMachineExtensionInstanceView();
                            virtualMachineExtensionInstance.setInstanceView(instanceViewInstance);
                            JsonNode nameValue = instanceViewValue.get("name");
                            if (nameValue != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                instanceViewInstance.setName(nameInstance);
                            }
                            if ((typeValue2 = instanceViewValue.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                String typeInstance2 = typeValue2.getTextValue();
                                instanceViewInstance.setExtensionType(typeInstance2);
                            }
                            if ((typeHandlerVersionValue2 = instanceViewValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue2 instanceof NullNode)) {
                                String typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                instanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                            }
                            if ((substatusesArray = instanceViewValue.get("substatuses")) != null && !(substatusesArray instanceof NullNode)) {
                                for (JsonNode substatusesValue : (ArrayNode)substatusesArray) {
                                    JsonNode timeValue;
                                    JsonNode messageValue;
                                    JsonNode displayStatusValue;
                                    JsonNode levelValue;
                                    InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                    instanceViewInstance.getSubStatuses().add(instanceViewStatusInstance);
                                    JsonNode codeValue = substatusesValue.get("code");
                                    if (codeValue != null && !(codeValue instanceof NullNode)) {
                                        String codeInstance = codeValue.getTextValue();
                                        instanceViewStatusInstance.setCode(codeInstance);
                                    }
                                    if ((levelValue = substatusesValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                        String levelInstance = levelValue.getTextValue();
                                        instanceViewStatusInstance.setLevel(levelInstance);
                                    }
                                    if ((displayStatusValue = substatusesValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                        String displayStatusInstance = displayStatusValue.getTextValue();
                                        instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                    }
                                    if ((messageValue = substatusesValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                        String messageInstance = messageValue.getTextValue();
                                        instanceViewStatusInstance.setMessage(messageInstance);
                                    }
                                    if ((timeValue = substatusesValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                    Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                    instanceViewStatusInstance.setTime(timeInstance);
                                }
                            }
                            if ((statusesArray = instanceViewValue.get("statuses")) != null && !(statusesArray instanceof NullNode)) {
                                for (JsonNode statusesValue : (ArrayNode)statusesArray) {
                                    JsonNode timeValue2;
                                    JsonNode messageValue2;
                                    JsonNode displayStatusValue2;
                                    JsonNode levelValue2;
                                    InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                    JsonNode codeValue2 = statusesValue.get("code");
                                    if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                        String codeInstance2 = codeValue2.getTextValue();
                                        instanceViewStatusInstance2.setCode(codeInstance2);
                                    }
                                    if ((levelValue2 = statusesValue.get("level")) != null && !(levelValue2 instanceof NullNode)) {
                                        String levelInstance2 = levelValue2.getTextValue();
                                        instanceViewStatusInstance2.setLevel(levelInstance2);
                                    }
                                    if ((displayStatusValue2 = statusesValue.get("displayStatus")) != null && !(displayStatusValue2 instanceof NullNode)) {
                                        String displayStatusInstance2 = displayStatusValue2.getTextValue();
                                        instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance2);
                                    }
                                    if ((messageValue2 = statusesValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                                        String messageInstance2 = messageValue2.getTextValue();
                                        instanceViewStatusInstance2.setMessage(messageInstance2);
                                    }
                                    if ((timeValue2 = statusesValue.get("time")) == null || timeValue2 instanceof NullNode) continue;
                                    Calendar timeInstance2 = DatatypeConverter.parseDateTime((String)timeValue2.getTextValue());
                                    instanceViewStatusInstance2.setTime(timeInstance2);
                                }
                            }
                        }
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        virtualMachineExtensionInstance.setId(idInstance);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        virtualMachineExtensionInstance.setName(nameInstance2);
                    }
                    if ((typeValue3 = responseDoc.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                        String typeInstance3 = typeValue3.getTextValue();
                        virtualMachineExtensionInstance.setType(typeInstance3);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineExtensionInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            virtualMachineExtensionInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineExtensionGetResponse virtualMachineExtensionGetResponse = result;
            return virtualMachineExtensionGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

