package com.microsoft.azure.management.compute;

/**
 * Scale set virtual machine sku types.
 */
public class VirtualMachineScaleSetSkuTypes {
    /** Static value Standard_A0 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A0 = new VirtualMachineScaleSetSkuTypes("Standard_A0", "Standard");

    /** Static value Standard_A1 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A1 = new VirtualMachineScaleSetSkuTypes("Standard_A1", "Standard");

    /** Static value Standard_A2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A2 = new VirtualMachineScaleSetSkuTypes("Standard_A2", "Standard");

    /** Static value Standard_A3 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A3 = new VirtualMachineScaleSetSkuTypes("Standard_A3", "Standard");

    /** Static value Standard_A4 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A4 = new VirtualMachineScaleSetSkuTypes("Standard_A4", "Standard");

    /** Static value Standard_A5 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A5 = new VirtualMachineScaleSetSkuTypes("Standard_A5", "Standard");

    /** Static value Standard_A6 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A6 = new VirtualMachineScaleSetSkuTypes("Standard_A6", "Standard");

    /** Static value Standard_A7 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A7 = new VirtualMachineScaleSetSkuTypes("Standard_A7", "Standard");

    /** Static value Standard_A8 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A8 = new VirtualMachineScaleSetSkuTypes("Standard_A8", "Standard");

    /** Static value Standard_A9 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A9 = new VirtualMachineScaleSetSkuTypes("Standard_A9", "Standard");

    /** Static value Standard_A10 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A10 = new VirtualMachineScaleSetSkuTypes("Standard_A10", "Standard");

    /** Static value Standard_A11 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A11 = new VirtualMachineScaleSetSkuTypes("Standard_A11", "Standard");

    /** Static value Standard_D1 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D1 = new VirtualMachineScaleSetSkuTypes("Standard_D1", "Standard");

    /** Static value Standard_D2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D2 = new VirtualMachineScaleSetSkuTypes("Standard_D2", "Standard");

    /** Static value Standard_D3 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D3 = new VirtualMachineScaleSetSkuTypes("Standard_D3", "Standard");

    /** Static value Standard_D4 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D4 = new VirtualMachineScaleSetSkuTypes("Standard_D4", "Standard");

    /** Static value Standard_D11 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D11 = new VirtualMachineScaleSetSkuTypes("Standard_D11", "Standard");

    /** Static value Standard_D12 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D12 = new VirtualMachineScaleSetSkuTypes("Standard_D12", "Standard");

    /** Static value Standard_D13 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D13 = new VirtualMachineScaleSetSkuTypes("Standard_D13", "Standard");

    /** Static value Standard_D14 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D14 = new VirtualMachineScaleSetSkuTypes("Standard_D14", "Standard");

    /** Static value Standard_D1_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D1_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D1_v2", "Standard");

    /** Static value Standard_D2_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D2_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D2_v2", "Standard");

    /** Static value Standard_D3_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D3_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D3_v2", "Standard");

    /** Static value Standard_D4_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D4_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D4_v2", "Standard");

    /** Static value Standard_D5_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D5_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D5_v2", "Standard");

    /** Static value Standard_D11_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D11_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D11_v2", "Standard");

    /** Static value Standard_D12_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D12_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D12_v2", "Standard");

    /** Static value Standard_D13_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D13_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D13_v2", "Standard");

    /** Static value Standard_D14_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D14_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D14_v2", "Standard");

    /** Static value Standard_D15_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D15_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D15_v2", "Standard");

    /** Static value Standard_DS1 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS1 = new VirtualMachineScaleSetSkuTypes("Standard_DS1", "Standard");

    /** Static value Standard_DS2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS2 = new VirtualMachineScaleSetSkuTypes("Standard_DS2", "Standard");

    /** Static value Standard_DS3 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS3 = new VirtualMachineScaleSetSkuTypes("Standard_DS3", "Standard");

    /** Static value Standard_DS4 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS4 = new VirtualMachineScaleSetSkuTypes("Standard_DS4", "Standard");

    /** Static value Standard_DS11 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS11 = new VirtualMachineScaleSetSkuTypes("Standard_DS11", "Standard");

    /** Static value Standard_DS12 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS12 = new VirtualMachineScaleSetSkuTypes("Standard_DS12", "Standard");

    /** Static value Standard_DS13 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS13 = new VirtualMachineScaleSetSkuTypes("Standard_DS13", "Standard");

    /** Static value Standard_DS14 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS14 = new VirtualMachineScaleSetSkuTypes("Standard_DS14", "Standard");

    /** Static value Standard_DS1_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS1_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS1_v2", "Standard");

    /** Static value Standard_DS2_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS2_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS2_v2", "Standard");

    /** Static value Standard_DS3_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS3_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS3_v2", "Standard");

    /** Static value Standard_DS4_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS4_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS4_v2", "Standard");

    /** Static value Standard_DS5_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS5_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS5_v2", "Standard");

    /** Static value Standard_DS11_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS11_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS11_v2", "Standard");

    /** Static value Standard_DS12_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS12_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS12_v2", "Standard");

    /** Static value Standard_DS13_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS13_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS13_v2", "Standard");

    /** Static value Standard_DS14_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS14_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS14_v2", "Standard");

    /** Static value Standard_DS15_v2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS15_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS15_v2", "Standard");

    /** Static value STANDARD_F1S for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F1S = new VirtualMachineScaleSetSkuTypes("STANDARD_F1S", "Standard");

    /** Static value STANDARD_F2S for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F2S = new VirtualMachineScaleSetSkuTypes("STANDARD_F2S", "Standard");

    /** Static value STANDARD_F4S for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F4S = new VirtualMachineScaleSetSkuTypes("STANDARD_F4S", "Standard");

    /** Static value STANDARD_F8S for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F8S = new VirtualMachineScaleSetSkuTypes("STANDARD_F8S", "Standard");

    /** Static value STANDARD_F16S for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F16S = new VirtualMachineScaleSetSkuTypes("STANDARD_F16S", "Standard");

    /** Static value STANDARD_F1 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F1 = new VirtualMachineScaleSetSkuTypes("STANDARD_F1", "Standard");

    /** Static value STANDARD_F2 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F2 = new VirtualMachineScaleSetSkuTypes("STANDARD_F2", "Standard");

    /** Static value STANDARD_F4 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F4 = new VirtualMachineScaleSetSkuTypes("STANDARD_F4", "Standard");

    /** Static value STANDARD_F8 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F8 = new VirtualMachineScaleSetSkuTypes("STANDARD_F8", "Standard");

    /** Static value STANDARD_F16 for VirtualMachineScaleSetSkuTypes. */
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F16 = new VirtualMachineScaleSetSkuTypes("STANDARD_F16", "Standard");

    /**
     * the sku corresponding to this size.
     */
    private Sku sku;

    /**
     * The string value of the sku.
     */
    private String value;
    /**
     * Creates a custom value for VirtualMachineSizeTypes.
     * @param skuName the sku name
     * @param skuTier thr sku tier
     */
    public VirtualMachineScaleSetSkuTypes(String skuName, String skuTier) {
        this(new Sku().withName(skuName).withTier(skuTier));
    }

    /**
     * Creates a custom value for VirtualMachineSizeTypes.
     * @param sku the sku
     */
    public VirtualMachineScaleSetSkuTypes(Sku sku) {
        this.sku = sku;
        this.value = this.sku.name();
        if (this.sku.tier() != null) {
            this.value = this.value + "_" + this.sku.tier();
        }
    }

    /**
     * @return the sku
     */
    public Sku sku() {
        return this.sku;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        String value = this.toString();
        if (!(obj instanceof VirtualMachineScaleSetSkuTypes)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        VirtualMachineScaleSetSkuTypes rhs = (VirtualMachineScaleSetSkuTypes) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
