/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.compute.AvailabilitySet;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.DiagnosticsProfile;
import com.microsoft.azure.management.compute.DiskEncryptionSettings;
import com.microsoft.azure.management.compute.ImageReference;
import com.microsoft.azure.management.compute.KnownLinuxVirtualMachineImage;
import com.microsoft.azure.management.compute.KnownWindowsVirtualMachineImage;
import com.microsoft.azure.management.compute.OSProfile;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.Plan;
import com.microsoft.azure.management.compute.PowerState;
import com.microsoft.azure.management.compute.StorageProfile;
import com.microsoft.azure.management.compute.VirtualMachineDataDisk;
import com.microsoft.azure.management.compute.VirtualMachineExtension;
import com.microsoft.azure.management.compute.VirtualMachineInstanceView;
import com.microsoft.azure.management.compute.VirtualMachineSize;
import com.microsoft.azure.management.compute.VirtualMachineSizeTypes;
import com.microsoft.azure.management.compute.WinRMListener;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.PublicIpAddress;
import com.microsoft.azure.management.network.model.HasNetworkInterfaces;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.resources.fluentcore.model.Wrapper;
import com.microsoft.azure.management.storage.StorageAccount;
import java.util.List;
import java.util.Map;

@Fluent
public interface VirtualMachine
extends GroupableResource,
Refreshable<VirtualMachine>,
Wrapper<VirtualMachineInner>,
Updatable<Update>,
HasNetworkInterfaces {
    public void deallocate();

    public void generalize();

    public void powerOff();

    public void restart();

    public void start();

    public void redeploy();

    @Method
    public PagedList<VirtualMachineSize> availableSizes();

    public String capture(String var1, boolean var2);

    @Method
    public VirtualMachineInstanceView refreshInstanceView();

    public String computerName();

    public VirtualMachineSizeTypes size();

    public OperatingSystemTypes osType();

    public String osDiskVhdUri();

    public CachingTypes osDiskCachingType();

    public int osDiskSize();

    public List<VirtualMachineDataDisk> dataDisks();

    public PublicIpAddress getPrimaryPublicIpAddress();

    public String getPrimaryPublicIpAddressId();

    public String availabilitySetId();

    public String provisioningState();

    public String licenseType();

    public Map<String, VirtualMachineExtension> extensions();

    public Plan plan();

    public StorageProfile storageProfile();

    public OSProfile osProfile();

    public DiagnosticsProfile diagnosticsProfile();

    public String vmId();

    public PowerState powerState();

    public VirtualMachineInstanceView instanceView();

    public static interface Update
    extends Appliable<VirtualMachine>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithDataDisk,
    UpdateStages.WithSecondaryNetworkInterface,
    UpdateStages.WithExtension {
        public Update withOsDiskCaching(CachingTypes var1);

        public Update withOsDiskSizeInGb(Integer var1);

        public Update withSize(String var1);

        public Update withSize(VirtualMachineSizeTypes var1);
    }

    public static interface UpdateStages {

        public static interface WithExtension {
            public VirtualMachineExtension.UpdateDefinitionStages.Blank<Update> defineNewExtension(String var1);

            public VirtualMachineExtension.Update updateExtension(String var1);

            public Update withoutExtension(String var1);
        }

        public static interface WithSecondaryNetworkInterface {
            public Update withNewSecondaryNetworkInterface(Creatable<NetworkInterface> var1);

            public Update withExistingSecondaryNetworkInterface(NetworkInterface var1);

            public Update withoutSecondaryNetworkInterface(String var1);
        }

        public static interface WithDataDisk {
            public Update withNewDataDisk(Integer var1);

            public Update withExistingDataDisk(String var1, String var2, String var3);

            public VirtualMachineDataDisk.UpdateDefinitionStages.AttachNewDataDisk<Update> defineNewDataDisk(String var1);

            public VirtualMachineDataDisk.UpdateDefinitionStages.AttachExistingDataDisk<Update> defineExistingDataDisk(String var1);

            public VirtualMachineDataDisk.Update updateDataDisk(String var1);

            public Update withoutDataDisk(String var1);

            public Update withoutDataDisk(int var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<VirtualMachine>,
        Resource.DefinitionWithTags<WithCreate>,
        WithPassword,
        WithOsDiskSettings,
        WithVMSize,
        WithStorageAccount,
        WithDataDisk,
        WithAvailabilitySet,
        WithSecondaryNetworkInterface,
        WithExtension {
        }

        public static interface WithExtension {
            public VirtualMachineExtension.DefinitionStages.Blank<WithCreate> defineNewExtension(String var1);
        }

        public static interface WithSecondaryNetworkInterface {
            public WithCreate withNewSecondaryNetworkInterface(Creatable<NetworkInterface> var1);

            public WithCreate withExistingSecondaryNetworkInterface(NetworkInterface var1);
        }

        public static interface WithStorageAccount {
            public WithCreate withNewStorageAccount(String var1);

            public WithCreate withNewStorageAccount(Creatable<StorageAccount> var1);

            public WithCreate withExistingStorageAccount(StorageAccount var1);
        }

        public static interface WithAvailabilitySet {
            public WithCreate withNewAvailabilitySet(String var1);

            public WithCreate withNewAvailabilitySet(Creatable<AvailabilitySet> var1);

            public WithCreate withExistingAvailabilitySet(AvailabilitySet var1);
        }

        public static interface WithDataDisk {
            public WithCreate withNewDataDisk(Integer var1);

            public WithCreate withExistingDataDisk(String var1, String var2, String var3);

            public VirtualMachineDataDisk.DefinitionStages.AttachNewDataDisk<WithCreate> defineNewDataDisk(String var1);

            public VirtualMachineDataDisk.DefinitionStages.AttachExistingDataDisk<WithCreate> defineExistingDataDisk(String var1);
        }

        public static interface WithVMSize {
            public WithCreate withSize(String var1);

            public WithCreate withSize(VirtualMachineSizeTypes var1);
        }

        public static interface WithOsDiskSettings {
            public WithCreate withOsDiskCaching(CachingTypes var1);

            public WithCreate withOsDiskVhdLocation(String var1, String var2);

            public WithCreate withOsDiskEncryptionSettings(DiskEncryptionSettings var1);

            public WithCreate withOsDiskSizeInGb(Integer var1);

            public WithCreate withOsDiskName(String var1);
        }

        public static interface WithPassword {
            public WithCreate withPassword(String var1);
        }

        public static interface WithWindowsCreate
        extends WithCreate {
            @Method
            public WithWindowsCreate disableVmAgent();

            @Method
            public WithWindowsCreate disableAutoUpdate();

            public WithWindowsCreate withTimeZone(String var1);

            public WithWindowsCreate withWinRm(WinRMListener var1);
        }

        public static interface WithLinuxCreate
        extends WithCreate {
            public WithLinuxCreate withSsh(String var1);
        }

        public static interface WithAdminUserName {
            public WithWindowsCreate withAdminUserName(String var1);
        }

        public static interface WithRootUserName {
            public WithLinuxCreate withRootUserName(String var1);
        }

        public static interface WithOS {
            public WithAdminUserName withPopularWindowsImage(KnownWindowsVirtualMachineImage var1);

            public WithAdminUserName withLatestWindowsImage(String var1, String var2, String var3);

            public WithAdminUserName withSpecificWindowsImageVersion(ImageReference var1);

            public WithAdminUserName withStoredWindowsImage(String var1);

            public WithRootUserName withPopularLinuxImage(KnownLinuxVirtualMachineImage var1);

            public WithRootUserName withLatestLinuxImage(String var1, String var2, String var3);

            public WithRootUserName withSpecificLinuxImageVersion(ImageReference var1);

            public WithRootUserName withStoredLinuxImage(String var1);

            public WithCreate withOsDisk(String var1, OperatingSystemTypes var2);
        }

        public static interface WithPrimaryNetworkInterface {
            public WithOS withNewPrimaryNetworkInterface(Creatable<NetworkInterface> var1);

            public WithOS withExistingPrimaryNetworkInterface(NetworkInterface var1);
        }

        public static interface WithPublicIpAddress {
            public WithOS withNewPrimaryPublicIpAddress(Creatable<PublicIpAddress> var1);

            public WithOS withNewPrimaryPublicIpAddress(String var1);

            public WithOS withExistingPrimaryPublicIpAddress(PublicIpAddress var1);

            public WithOS withoutPrimaryPublicIpAddress();
        }

        public static interface WithPrivateIp {
            public WithPublicIpAddress withPrimaryPrivateIpAddressDynamic();

            public WithPublicIpAddress withPrimaryPrivateIpAddressStatic(String var1);
        }

        public static interface WithSubnet {
            public WithPrivateIp withSubnet(String var1);
        }

        public static interface WithNetwork
        extends WithPrimaryNetworkInterface {
            public WithPrivateIp withNewPrimaryNetwork(Creatable<Network> var1);

            public WithPrivateIp withNewPrimaryNetwork(String var1);

            public WithSubnet withExistingPrimaryNetwork(Network var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithNetwork> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithNetwork,
    DefinitionStages.WithSubnet,
    DefinitionStages.WithPrivateIp,
    DefinitionStages.WithPublicIpAddress,
    DefinitionStages.WithPrimaryNetworkInterface,
    DefinitionStages.WithOS,
    DefinitionStages.WithRootUserName,
    DefinitionStages.WithAdminUserName,
    DefinitionStages.WithLinuxCreate,
    DefinitionStages.WithWindowsCreate,
    DefinitionStages.WithCreate {
    }
}

