/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.ImageReference;
import com.microsoft.azure.management.compute.KnownLinuxVirtualMachineImage;
import com.microsoft.azure.management.compute.KnownWindowsVirtualMachineImage;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.UpgradeMode;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetExtension;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetNetworkProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetSku;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetSkuTypes;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetStorageProfile;
import com.microsoft.azure.management.compute.WinRMListener;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetInner;
import com.microsoft.azure.management.network.Backend;
import com.microsoft.azure.management.network.InboundNatPool;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.resources.fluentcore.model.Wrapper;
import com.microsoft.azure.management.storage.StorageAccount;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@Fluent
public interface VirtualMachineScaleSet
extends GroupableResource,
Refreshable<VirtualMachineScaleSet>,
Wrapper<VirtualMachineScaleSetInner>,
Updatable<UpdateStages.WithPrimaryLoadBalancer> {
    public PagedList<VirtualMachineScaleSetSku> listAvailableSkus() throws CloudException, IOException;

    public void deallocate() throws CloudException, IOException, InterruptedException;

    public void powerOff() throws CloudException, IOException, InterruptedException;

    public void restart() throws CloudException, IOException, InterruptedException;

    public void start() throws CloudException, IOException, InterruptedException;

    public void reimage() throws CloudException, IOException, InterruptedException;

    public String computerNamePrefix();

    public OperatingSystemTypes osType();

    public CachingTypes osDiskCachingType();

    public String osDiskName();

    public UpgradeMode upgradeModel();

    public boolean overProvisionEnabled();

    public VirtualMachineScaleSetSkuTypes sku();

    public int capacity();

    public Network getPrimaryNetwork() throws IOException;

    public LoadBalancer getPrimaryInternetFacingLoadBalancer() throws IOException;

    public Map<String, Backend> listPrimaryInternetFacingLoadBalancerBackends() throws IOException;

    public Map<String, InboundNatPool> listPrimaryInternetFacingLoadBalancerInboundNatPools() throws IOException;

    public LoadBalancer getPrimaryInternalLoadBalancer() throws IOException;

    public Map<String, Backend> listPrimaryInternalLoadBalancerBackends() throws IOException;

    public Map<String, InboundNatPool> listPrimaryInternalLoadBalancerInboundNatPools() throws IOException;

    public List<String> primaryPublicIpAddressIds() throws IOException;

    public List<String> vhdContainers();

    public VirtualMachineScaleSetStorageProfile storageProfile();

    public VirtualMachineScaleSetNetworkProfile networkProfile();

    public Map<String, VirtualMachineScaleSetExtension> extensions();

    public static interface Update
    extends UpdateStages.WithPrimaryLoadBalancer,
    UpdateStages.WithPrimaryInternetFacingLoadBalancerBackendOrNatPool,
    UpdateStages.WithPrimaryInternalLoadBalancerBackendOrNatPool {
    }

    public static interface UpdateStages {

        public static interface WithApply
        extends Appliable<VirtualMachineScaleSet>,
        Resource.UpdateWithTags<WithApply>,
        WithSku,
        WithCapacity,
        WithExtension,
        WithoutPrimaryLoadBalancer,
        WithoutPrimaryLoadBalancerBackend,
        WithoutPrimaryLoadBalancerNatPool {
        }

        public static interface WithoutPrimaryLoadBalancerNatPool {
            public WithApply withoutPrimaryInternetFacingLoadBalancerNatPools(String ... var1);

            public WithApply withoutPrimaryInternalLoadBalancerNatPools(String ... var1);
        }

        public static interface WithoutPrimaryLoadBalancerBackend {
            public WithApply withoutPrimaryInternetFacingLoadBalancerBackends(String ... var1);

            public WithApply withoutPrimaryInternalLoadBalancerBackends(String ... var1);
        }

        public static interface WithoutPrimaryLoadBalancer {
            public WithApply withoutPrimaryInternetFacingLoadBalancer();

            public WithApply withoutPrimaryInternalLoadBalancer();
        }

        public static interface WithExtension {
            public VirtualMachineScaleSetExtension.UpdateDefinitionStages.Blank<WithApply> defineNewExtension(String var1);

            public VirtualMachineScaleSetExtension.Update updateExtension(String var1);

            public WithApply withoutExtension(String var1);
        }

        public static interface WithCapacity {
            public WithApply withCapacity(int var1);
        }

        public static interface WithSku {
            public WithApply withSku(VirtualMachineScaleSetSkuTypes var1);

            public WithApply withSku(VirtualMachineScaleSetSku var1);
        }

        public static interface WithPrimaryInternalLoadBalancerNatPool
        extends WithApply {
            public WithApply withPrimaryInternalLoadBalancerInboundNatPools(String ... var1);
        }

        public static interface WithPrimaryInternalLoadBalancerBackendOrNatPool
        extends WithPrimaryInternalLoadBalancerNatPool {
            public WithPrimaryInternalLoadBalancerNatPool withPrimaryInternalLoadBalancerBackends(String ... var1);
        }

        public static interface WithPrimaryInternalLoadBalancer
        extends WithApply {
            public WithPrimaryInternalLoadBalancerBackendOrNatPool withPrimaryInternalLoadBalancer(LoadBalancer var1);
        }

        public static interface WithPrimaryInternetFacingLoadBalancerNatPool
        extends WithPrimaryInternalLoadBalancer {
            public WithPrimaryInternalLoadBalancer withPrimaryInternetFacingLoadBalancerInboundNatPools(String ... var1);
        }

        public static interface WithPrimaryInternetFacingLoadBalancerBackendOrNatPool
        extends WithPrimaryInternetFacingLoadBalancerNatPool {
            public WithPrimaryInternetFacingLoadBalancerNatPool withPrimaryInternetFacingLoadBalancerBackends(String ... var1);
        }

        public static interface WithPrimaryLoadBalancer
        extends WithPrimaryInternalLoadBalancer {
            public WithPrimaryInternetFacingLoadBalancerBackendOrNatPool withPrimaryInternetFacingLoadBalancer(LoadBalancer var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<VirtualMachineScaleSet>,
        WithPassword,
        WithOsDiskSettings,
        WithComputerNamePrefix,
        WithCapacity,
        WithUpgradePolicy,
        WithOverProvision,
        WithStorageAccount,
        WithExtension,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithExtension {
            public VirtualMachineScaleSetExtension.DefinitionStages.Blank<WithCreate> defineNewExtension(String var1);
        }

        public static interface WithStorageAccount {
            public WithCreate withNewStorageAccount(String var1);

            public WithCreate withNewStorageAccount(Creatable<StorageAccount> var1);

            public WithCreate withExistingStorageAccount(StorageAccount var1);
        }

        public static interface WithOsDiskSettings {
            public WithCreate withOsDiskCaching(CachingTypes var1);

            public WithCreate withOsDiskName(String var1);
        }

        public static interface WithOverProvision {
            public WithCreate withOverProvision(boolean var1);

            public WithCreate withOverProvisioning();

            public WithCreate withoutOverProvisioning();
        }

        public static interface WithUpgradePolicy {
            public WithCreate withUpgradeMode(UpgradeMode var1);
        }

        public static interface WithCapacity {
            public WithCreate withCapacity(int var1);
        }

        public static interface WithComputerNamePrefix {
            public WithCreate withComputerNamePrefix(String var1);
        }

        public static interface WithPassword {
            public WithCreate withPassword(String var1);
        }

        public static interface WithWindowsCreate
        extends WithCreate {
            public WithWindowsCreate withVmAgent();

            public WithWindowsCreate withoutVmAgent();

            public WithWindowsCreate withAutoUpdate();

            public WithWindowsCreate withoutAutoUpdate();

            public WithWindowsCreate withTimeZone(String var1);

            public WithWindowsCreate withWinRm(WinRMListener var1);
        }

        public static interface WithLinuxCreate
        extends WithCreate {
            public WithLinuxCreate withSsh(String var1);
        }

        public static interface WithAdminUserName {
            public WithWindowsCreate withAdminUserName(String var1);
        }

        public static interface WithRootUserName {
            public WithLinuxCreate withRootUserName(String var1);
        }

        public static interface WithOS {
            public WithAdminUserName withPopularWindowsImage(KnownWindowsVirtualMachineImage var1);

            public WithAdminUserName withLatestWindowsImage(String var1, String var2, String var3);

            public WithAdminUserName withSpecificWindowsImageVersion(ImageReference var1);

            public WithAdminUserName withStoredWindowsImage(String var1);

            public WithRootUserName withPopularLinuxImage(KnownLinuxVirtualMachineImage var1);

            public WithRootUserName withLatestLinuxImage(String var1, String var2, String var3);

            public WithRootUserName withSpecificLinuxImageVersion(ImageReference var1);

            public WithRootUserName withStoredLinuxImage(String var1);
        }

        public static interface WithInternalInternalLoadBalancerNatPool
        extends WithOS {
            public WithOS withPrimaryInternalLoadBalancerInboundNatPools(String ... var1);
        }

        public static interface WithInternalLoadBalancerBackendOrNatPool
        extends WithCreate {
            public WithInternalInternalLoadBalancerNatPool withPrimaryInternalLoadBalancerBackends(String ... var1);
        }

        public static interface WithPrimaryInternetFacingLoadBalancerNatPool
        extends WithPrimaryInternalLoadBalancer {
            public WithPrimaryInternalLoadBalancer withPrimaryInternetFacingLoadBalancerInboundNatPools(String ... var1);
        }

        public static interface WithPrimaryInternetFacingLoadBalancerBackendOrNatPool
        extends WithPrimaryInternetFacingLoadBalancerNatPool {
            public WithPrimaryInternetFacingLoadBalancerNatPool withPrimaryInternetFacingLoadBalancerBackends(String ... var1);
        }

        public static interface WithPrimaryInternalLoadBalancer {
            public WithInternalLoadBalancerBackendOrNatPool withPrimaryInternalLoadBalancer(LoadBalancer var1);

            public WithOS withoutPrimaryInternalLoadBalancer();
        }

        public static interface WithPrimaryInternetFacingLoadBalancer {
            public WithPrimaryInternetFacingLoadBalancerBackendOrNatPool withPrimaryInternetFacingLoadBalancer(LoadBalancer var1);

            public WithPrimaryInternalLoadBalancer withoutPrimaryInternetFacingLoadBalancer();
        }

        public static interface WithNetworkSubnet {
            public WithPrimaryInternetFacingLoadBalancer withExistingPrimaryNetworkSubnet(Network var1, String var2);
        }

        public static interface WithSku {
            public WithNetworkSubnet withSku(VirtualMachineScaleSetSkuTypes var1);

            public WithNetworkSubnet withSku(VirtualMachineScaleSetSku var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSku> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithNetworkSubnet,
    DefinitionStages.WithPrimaryInternetFacingLoadBalancer,
    DefinitionStages.WithPrimaryInternalLoadBalancer,
    DefinitionStages.WithPrimaryInternetFacingLoadBalancerBackendOrNatPool,
    DefinitionStages.WithInternalLoadBalancerBackendOrNatPool,
    DefinitionStages.WithPrimaryInternetFacingLoadBalancerNatPool,
    DefinitionStages.WithInternalInternalLoadBalancerNatPool,
    DefinitionStages.WithOS,
    DefinitionStages.WithAdminUserName,
    DefinitionStages.WithRootUserName,
    DefinitionStages.WithLinuxCreate,
    DefinitionStages.WithWindowsCreate,
    DefinitionStages.WithCreate {
    }
}

