/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.AvailabilitySet;
import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.implementation.AvailabilitySetInner;
import com.microsoft.azure.management.compute.implementation.AvailabilitySetsInner;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class AvailabilitySetImpl
extends GroupableResourceImpl<AvailabilitySet, AvailabilitySetInner, AvailabilitySetImpl, ComputeManager>
implements AvailabilitySet,
AvailabilitySet.Definition,
AvailabilitySet.Update {
    private List<String> idOfVMsInSet;
    private final AvailabilitySetsInner client;

    AvailabilitySetImpl(String name, AvailabilitySetInner innerModel, AvailabilitySetsInner client, ComputeManager computeManager) {
        super(name, (Resource)innerModel, (ManagerBase)computeManager);
        this.client = client;
    }

    @Override
    public int updateDomainCount() {
        return ((AvailabilitySetInner)((Object)this.inner())).platformUpdateDomainCount();
    }

    @Override
    public int faultDomainCount() {
        return ((AvailabilitySetInner)((Object)this.inner())).platformFaultDomainCount();
    }

    @Override
    public List<String> virtualMachineIds() {
        if (this.idOfVMsInSet == null) {
            this.idOfVMsInSet = new ArrayList<String>();
            for (SubResource resource : ((AvailabilitySetInner)((Object)this.inner())).virtualMachines()) {
                this.idOfVMsInSet.add(resource.id());
            }
        }
        return Collections.unmodifiableList(this.idOfVMsInSet);
    }

    @Override
    public List<InstanceViewStatus> statuses() {
        return Collections.unmodifiableList(((AvailabilitySetInner)((Object)this.inner())).statuses());
    }

    public AvailabilitySet refresh() {
        AvailabilitySetInner response = this.client.get(this.resourceGroupName(), this.name());
        this.setInner((Object)response);
        this.idOfVMsInSet = null;
        return this;
    }

    @Override
    public AvailabilitySetImpl withUpdateDomainCount(int updateDomainCount) {
        ((AvailabilitySetInner)((Object)this.inner())).withPlatformUpdateDomainCount(updateDomainCount);
        return this;
    }

    @Override
    public AvailabilitySetImpl withFaultDomainCount(int faultDomainCount) {
        ((AvailabilitySetInner)((Object)this.inner())).withPlatformFaultDomainCount(faultDomainCount);
        return this;
    }

    public Observable<AvailabilitySet> createResourceAsync() {
        final AvailabilitySetImpl self = this;
        return this.client.createOrUpdateAsync(this.resourceGroupName(), this.name(), (AvailabilitySetInner)((Object)this.inner())).map((Func1)new Func1<AvailabilitySetInner, AvailabilitySet>(){

            public AvailabilitySet call(AvailabilitySetInner availabilitySetInner) {
                self.setInner((Object)availabilitySetInner);
                AvailabilitySetImpl.this.idOfVMsInSet = null;
                return self;
            }
        });
    }
}

