/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.RestException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

final class ChildListFlattener<ParentT, ChildT> {
    private final String switchToCousin = "switchToCousin";
    private Iterator<ParentT> parentItr;
    private PagedList<ChildT> currentChildList;
    private final ChildListLoader<ParentT, ChildT> childListLoader;

    ChildListFlattener(PagedList<ParentT> parentList, ChildListLoader<ParentT, ChildT> childListLoader) {
        this.parentItr = parentList.iterator();
        this.childListLoader = childListLoader;
    }

    public PagedList<ChildT> flatten() {
        this.currentChildList = this.nextChildList();
        if (this.currentChildList == null) {
            return this.emptyPagedList();
        }
        return new PagedList<ChildT>(this.childListPage(this.currentChildList.currentPage())){

            public Page<ChildT> nextPage(String nextPageLink) throws RestException, IOException {
                if (nextPageLink.equalsIgnoreCase("switchToCousin")) {
                    ChildListFlattener.this.currentChildList = ChildListFlattener.this.nextChildList();
                    return ChildListFlattener.this.childListPage(ChildListFlattener.this.currentChildList.currentPage());
                }
                ChildListFlattener.this.currentChildList.loadNextPage();
                return ChildListFlattener.this.childListPage(ChildListFlattener.this.currentChildList.currentPage());
            }
        };
    }

    private PagedList<ChildT> nextChildList() {
        while (this.parentItr.hasNext()) {
            PagedList<ChildT> nextChildList = this.childListLoader.loadList(this.parentItr.next());
            if (!nextChildList.iterator().hasNext()) continue;
            return nextChildList;
        }
        return null;
    }

    private Page<ChildT> childListPage(final Page<ChildT> page) {
        return new Page<ChildT>(){

            public String getNextPageLink() {
                if (page.getNextPageLink() != null) {
                    return page.getNextPageLink();
                }
                if (ChildListFlattener.this.parentItr.hasNext()) {
                    return "switchToCousin";
                }
                return null;
            }

            public List<ChildT> getItems() {
                return page.getItems();
            }
        };
    }

    private PagedList<ChildT> emptyPagedList() {
        return new PagedList<ChildT>(){

            public Page<ChildT> nextPage(String nextPageLink) throws RestException, IOException {
                return null;
            }
        };
    }

    static interface ChildListLoader<T, U> {
        public PagedList<U> loadList(T var1);
    }
}

