/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.RestClient;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.compute.AvailabilitySets;
import com.microsoft.azure.management.compute.VirtualMachineExtensionImages;
import com.microsoft.azure.management.compute.VirtualMachineImages;
import com.microsoft.azure.management.compute.VirtualMachineScaleSets;
import com.microsoft.azure.management.compute.VirtualMachines;
import com.microsoft.azure.management.compute.implementation.AvailabilitySetsImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionImagesImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImagesImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachinePublishersImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetsImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachinesImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public final class ComputeManager
extends Manager<ComputeManager, ComputeManagementClientImpl> {
    private StorageManager storageManager;
    private NetworkManager networkManager;
    private AvailabilitySets availabilitySets;
    private VirtualMachines virtualMachines;
    private VirtualMachineImages virtualMachineImages;
    private VirtualMachineExtensionImages virtualMachineExtensionImages;
    private VirtualMachineScaleSets virtualMachineScaleSets;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ComputeManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new ComputeManager(credentials.getEnvironment().newRestClientBuilder().withCredentials((ServiceClientCredentials)credentials).build(), subscriptionId);
    }

    public static ComputeManager authenticate(RestClient restClient, String subscriptionId) {
        return new ComputeManager(restClient, subscriptionId);
    }

    private ComputeManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new ComputeManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
        this.storageManager = StorageManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.networkManager = NetworkManager.authenticate((RestClient)restClient, (String)subscriptionId);
    }

    public AvailabilitySets availabilitySets() {
        if (this.availabilitySets == null) {
            this.availabilitySets = new AvailabilitySetsImpl(((ComputeManagementClientImpl)((Object)this.innerManagementClient)).availabilitySets(), this);
        }
        return this.availabilitySets;
    }

    public VirtualMachines virtualMachines() {
        if (this.virtualMachines == null) {
            this.virtualMachines = new VirtualMachinesImpl(((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachines(), ((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineExtensions(), ((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineSizes(), this, this.storageManager, this.networkManager);
        }
        return this.virtualMachines;
    }

    public VirtualMachineImages virtualMachineImages() {
        if (this.virtualMachineImages == null) {
            this.virtualMachineImages = new VirtualMachineImagesImpl(new VirtualMachinePublishersImpl(((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineImages(), ((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineExtensionImages()));
        }
        return this.virtualMachineImages;
    }

    public VirtualMachineExtensionImages virtualMachineExtensionImages() {
        if (this.virtualMachineExtensionImages == null) {
            this.virtualMachineExtensionImages = new VirtualMachineExtensionImagesImpl(new VirtualMachinePublishersImpl(((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineImages(), ((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineExtensionImages()));
        }
        return this.virtualMachineExtensionImages;
    }

    public VirtualMachineScaleSets virtualMachineScaleSets() {
        if (this.virtualMachineScaleSets == null) {
            this.virtualMachineScaleSets = new VirtualMachineScaleSetsImpl(((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineScaleSets(), this, this.storageManager, this.networkManager);
        }
        return this.virtualMachineScaleSets;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ComputeManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return ComputeManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ComputeManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

