/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.DataDisk;
import com.microsoft.azure.management.compute.DiskCreateOptionTypes;
import com.microsoft.azure.management.compute.VirtualHardDisk;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineDataDisk;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.storage.StorageAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@LangDefinition
class DataDiskImpl
extends ChildResourceImpl<DataDisk, VirtualMachineImpl, VirtualMachine>
implements VirtualMachineDataDisk,
VirtualMachineDataDisk.Definition<VirtualMachine.DefinitionStages.WithCreate>,
VirtualMachineDataDisk.UpdateDefinition<VirtualMachine.Update>,
VirtualMachineDataDisk.Update {
    protected DataDiskImpl(DataDisk inner, VirtualMachineImpl parent) {
        super((Object)inner, (Object)parent);
    }

    protected static DataDiskImpl prepareDataDisk(String name, DiskCreateOptionTypes createOption, VirtualMachineImpl parent) {
        DataDisk dataDiskInner = new DataDisk();
        dataDiskInner.withLun(-1);
        dataDiskInner.withName(name);
        dataDiskInner.withCreateOption(createOption);
        dataDiskInner.withVhd(null);
        return new DataDiskImpl(dataDiskInner, parent);
    }

    protected static DataDiskImpl createNewDataDisk(int sizeInGB, VirtualMachineImpl parent) {
        DataDiskImpl dataDiskImpl = DataDiskImpl.prepareDataDisk(null, DiskCreateOptionTypes.EMPTY, parent);
        ((DataDisk)dataDiskImpl.inner()).withDiskSizeGB(sizeInGB);
        return dataDiskImpl;
    }

    protected static DataDiskImpl createFromExistingDisk(String storageAccountName, String containerName, String vhdName, VirtualMachineImpl parent) {
        DataDiskImpl dataDiskImpl = DataDiskImpl.prepareDataDisk(null, DiskCreateOptionTypes.ATTACH, parent);
        VirtualHardDisk diskVhd = new VirtualHardDisk();
        diskVhd.withUri(DataDiskImpl.blobUrl(storageAccountName, containerName, vhdName));
        ((DataDisk)dataDiskImpl.inner()).withVhd(diskVhd);
        return dataDiskImpl;
    }

    public String name() {
        return ((DataDisk)this.inner()).name();
    }

    @Override
    public int size() {
        return ((DataDisk)this.inner()).diskSizeGB();
    }

    @Override
    public int lun() {
        return ((DataDisk)this.inner()).lun();
    }

    @Override
    public String vhdUri() {
        return ((DataDisk)this.inner()).vhd().uri();
    }

    @Override
    public CachingTypes cachingType() {
        return ((DataDisk)this.inner()).caching();
    }

    @Override
    public String sourceImageUri() {
        if (((DataDisk)this.inner()).image() != null) {
            return ((DataDisk)this.inner()).image().uri();
        }
        return null;
    }

    @Override
    public DiskCreateOptionTypes creationMethod() {
        return ((DataDisk)this.inner()).createOption();
    }

    public DataDiskImpl from(String storageAccountName, String containerName, String vhdName) {
        ((DataDisk)this.inner()).withVhd(new VirtualHardDisk());
        ((DataDisk)this.inner()).vhd().withUri(DataDiskImpl.blobUrl(storageAccountName, containerName, vhdName));
        return this;
    }

    @Override
    public DataDiskImpl withSizeInGB(Integer sizeInGB) {
        ((DataDisk)this.inner()).withDiskSizeGB(sizeInGB);
        return this;
    }

    public DataDiskImpl storeAt(String storageAccountName, String containerName, String vhdName) {
        ((DataDisk)this.inner()).withVhd(new VirtualHardDisk());
        ((DataDisk)this.inner()).vhd().withUri(DataDiskImpl.blobUrl(storageAccountName, containerName, vhdName));
        return this;
    }

    @Override
    public DataDiskImpl withLun(Integer lun) {
        ((DataDisk)this.inner()).withLun(lun);
        return this;
    }

    @Override
    public DataDiskImpl withCaching(CachingTypes cachingType) {
        ((DataDisk)this.inner()).withCaching(cachingType);
        return this;
    }

    public VirtualMachineImpl attach() {
        return ((VirtualMachineImpl)this.parent()).withDataDisk(this);
    }

    protected static void setDataDisksDefaults(List<VirtualMachineDataDisk> dataDisks, String namePrefix) {
        ArrayList<Integer> usedLuns = new ArrayList<Integer>();
        for (VirtualMachineDataDisk dataDisk : dataDisks) {
            if (dataDisk.lun() == -1) continue;
            usedLuns.add(dataDisk.lun());
        }
        for (VirtualMachineDataDisk dataDisk : dataDisks) {
            if (dataDisk.lun() == -1) {
                Integer i = 0;
                while (usedLuns.contains(i)) {
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                ((DataDisk)dataDisk.inner()).withLun(i);
                usedLuns.add(i);
            }
            if (dataDisk.name() == null) {
                ((DataDisk)dataDisk.inner()).withName(namePrefix + "-data-disk-" + dataDisk.lun());
            }
            if (((DataDisk)dataDisk.inner()).caching() != null) continue;
            ((DataDisk)dataDisk.inner()).withCaching(CachingTypes.READ_WRITE);
        }
    }

    protected static void ensureDisksVhdUri(List<VirtualMachineDataDisk> dataDisks, StorageAccount storageAccount, String namePrefix) {
        for (VirtualMachineDataDisk dataDisk : dataDisks) {
            if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY || ((DataDisk)dataDisk.inner()).vhd() != null) continue;
            ((DataDisk)dataDisk.inner()).withVhd(new VirtualHardDisk());
            ((DataDisk)dataDisk.inner()).vhd().withUri(storageAccount.endPoints().primary().blob() + "vhds/" + namePrefix + "-data-disk-" + dataDisk.lun() + "-" + UUID.randomUUID().toString() + ".vhd");
        }
    }

    protected static void ensureDisksVhdUri(List<VirtualMachineDataDisk> dataDisks, String namePrefix) {
        String containerUrl = null;
        for (VirtualMachineDataDisk dataDisk : dataDisks) {
            if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY || ((DataDisk)dataDisk.inner()).vhd() == null) continue;
            int idx = ((DataDisk)dataDisk.inner()).vhd().uri().lastIndexOf(47);
            containerUrl = ((DataDisk)dataDisk.inner()).vhd().uri().substring(0, idx);
            break;
        }
        if (containerUrl != null) {
            for (VirtualMachineDataDisk dataDisk : dataDisks) {
                if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY || ((DataDisk)dataDisk.inner()).vhd() != null) continue;
                ((DataDisk)dataDisk.inner()).withVhd(new VirtualHardDisk());
                ((DataDisk)dataDisk.inner()).vhd().withUri(containerUrl + namePrefix + "-data-disk-" + dataDisk.lun() + "-" + UUID.randomUUID().toString() + ".vhd");
            }
        }
    }

    private static String blobUrl(String storageAccountName, String containerName, String blobName) {
        return "https://" + storageAccountName + ".blob.core.windows.net" + "/" + containerName + "/" + blobName;
    }
}

