/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineExtension;
import com.microsoft.azure.management.compute.VirtualMachineExtensionImage;
import com.microsoft.azure.management.compute.VirtualMachineExtensionInstanceView;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class VirtualMachineExtensionImpl
extends ExternalChildResourceImpl<VirtualMachineExtension, VirtualMachineExtensionInner, VirtualMachineImpl, VirtualMachine>
implements VirtualMachineExtension,
VirtualMachineExtension.Definition<VirtualMachine.DefinitionStages.WithCreate>,
VirtualMachineExtension.UpdateDefinition<VirtualMachine.Update>,
VirtualMachineExtension.Update {
    private final VirtualMachineExtensionsInner client;
    private HashMap<String, Object> publicSettings;
    private HashMap<String, Object> protectedSettings;

    VirtualMachineExtensionImpl(String name, VirtualMachineImpl parent, VirtualMachineExtensionInner inner, VirtualMachineExtensionsInner client) {
        super(name, (Object)parent, (Object)inner);
        this.client = client;
        this.initializeSettings();
    }

    protected static VirtualMachineExtensionImpl newVirtualMachineExtension(String name, VirtualMachineImpl parent, VirtualMachineExtensionsInner client) {
        VirtualMachineExtensionInner inner = new VirtualMachineExtensionInner();
        inner.withLocation(parent.regionName());
        VirtualMachineExtensionImpl extension = new VirtualMachineExtensionImpl(name, parent, inner, client);
        return extension;
    }

    public String id() {
        return ((VirtualMachineExtensionInner)((Object)this.inner())).id();
    }

    @Override
    public String publisherName() {
        return ((VirtualMachineExtensionInner)((Object)this.inner())).publisher();
    }

    @Override
    public String typeName() {
        return ((VirtualMachineExtensionInner)((Object)this.inner())).virtualMachineExtensionType();
    }

    @Override
    public String versionName() {
        return ((VirtualMachineExtensionInner)((Object)this.inner())).typeHandlerVersion();
    }

    @Override
    public boolean autoUpgradeMinorVersionEnabled() {
        return ((VirtualMachineExtensionInner)((Object)this.inner())).autoUpgradeMinorVersion();
    }

    @Override
    public Map<String, Object> publicSettings() {
        return Collections.unmodifiableMap(this.publicSettings);
    }

    @Override
    public String publicSettingsAsJsonString() {
        return null;
    }

    @Override
    public VirtualMachineExtensionInstanceView instanceView() {
        return ((VirtualMachineExtensionInner)((Object)this.inner())).instanceView();
    }

    @Override
    public Map<String, String> tags() {
        TreeMap tags = ((VirtualMachineExtensionInner)((Object)this.inner())).getTags();
        if (tags == null) {
            tags = new TreeMap();
        }
        return Collections.unmodifiableMap(tags);
    }

    @Override
    public String provisioningState() {
        return ((VirtualMachineExtensionInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public VirtualMachineExtensionImpl withAutoUpgradeMinorVersionEnabled() {
        ((VirtualMachineExtensionInner)((Object)this.inner())).withAutoUpgradeMinorVersion(true);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withAutoUpgradeMinorVersionDisabled() {
        ((VirtualMachineExtensionInner)((Object)this.inner())).withAutoUpgradeMinorVersion(false);
        return this;
    }

    public VirtualMachineExtensionImpl withImage(VirtualMachineExtensionImage image) {
        ((VirtualMachineExtensionInner)((Object)this.inner())).withPublisher(image.publisherName()).withVirtualMachineExtensionType(image.typeName()).withTypeHandlerVersion(image.versionName());
        return this;
    }

    public VirtualMachineExtensionImpl withPublisher(String extensionImagePublisherName) {
        ((VirtualMachineExtensionInner)((Object)this.inner())).withPublisher(extensionImagePublisherName);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withPublicSetting(String key, Object value) {
        this.publicSettings.put(key, value);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withProtectedSetting(String key, Object value) {
        this.protectedSettings.put(key, value);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withPublicSettings(HashMap<String, Object> settings) {
        this.publicSettings.clear();
        this.publicSettings.putAll(settings);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withProtectedSettings(HashMap<String, Object> settings) {
        this.protectedSettings.clear();
        this.protectedSettings.putAll(settings);
        return this;
    }

    public VirtualMachineExtensionImpl withType(String extensionImageTypeName) {
        ((VirtualMachineExtensionInner)((Object)this.inner())).withVirtualMachineExtensionType(extensionImageTypeName);
        return this;
    }

    public VirtualMachineExtensionImpl withVersion(String extensionImageVersionName) {
        ((VirtualMachineExtensionInner)((Object)this.inner())).withTypeHandlerVersion(extensionImageVersionName);
        return this;
    }

    @Override
    public final VirtualMachineExtensionImpl withTags(Map<String, String> tags) {
        ((VirtualMachineExtensionInner)((Object)this.inner())).withTags(new HashMap<String, String>(tags));
        return this;
    }

    @Override
    public final VirtualMachineExtensionImpl withTag(String key, String value) {
        ((VirtualMachineExtensionInner)((Object)this.inner())).getTags().put(key, value);
        return this;
    }

    @Override
    public final VirtualMachineExtensionImpl withoutTag(String key) {
        ((VirtualMachineExtensionInner)((Object)this.inner())).getTags().remove(key);
        return this;
    }

    public VirtualMachineImpl attach() {
        this.nullifySettingsIfEmpty();
        return ((VirtualMachineImpl)this.parent()).withExtension(this);
    }

    public VirtualMachineExtensionImpl refresh() {
        String name = this.isReference() ? ResourceUtils.nameFromResourceId((String)((VirtualMachineExtensionInner)((Object)this.inner())).id()) : ((VirtualMachineExtensionInner)((Object)this.inner())).name();
        VirtualMachineExtensionInner inner = this.client.get(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), name);
        this.setInner((Object)inner);
        return this;
    }

    public Observable<VirtualMachineExtension> createAsync() {
        final VirtualMachineExtensionImpl self = this;
        return this.client.createOrUpdateAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), this.name(), (VirtualMachineExtensionInner)((Object)this.inner())).map((Func1)new Func1<VirtualMachineExtensionInner, VirtualMachineExtension>(){

            public VirtualMachineExtension call(VirtualMachineExtensionInner inner) {
                self.setInner((Object)inner);
                self.initializeSettings();
                return self;
            }
        });
    }

    public Observable<VirtualMachineExtension> updateAsync() {
        this.nullifySettingsIfEmpty();
        if (this.isReference()) {
            String extensionName = ResourceUtils.nameFromResourceId((String)((VirtualMachineExtensionInner)((Object)this.inner())).id());
            return this.client.getAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), extensionName).flatMap((Func1)new Func1<VirtualMachineExtensionInner, Observable<VirtualMachineExtension>>(){

                public Observable<VirtualMachineExtension> call(VirtualMachineExtensionInner resource) {
                    LinkedHashMap publicSettings;
                    ((VirtualMachineExtensionInner)((Object)VirtualMachineExtensionImpl.this.inner())).withPublisher(resource.publisher()).withVirtualMachineExtensionType(resource.virtualMachineExtensionType()).withTypeHandlerVersion(resource.typeHandlerVersion());
                    if (((VirtualMachineExtensionInner)((Object)VirtualMachineExtensionImpl.this.inner())).autoUpgradeMinorVersion() == null) {
                        ((VirtualMachineExtensionInner)((Object)VirtualMachineExtensionImpl.this.inner())).withAutoUpgradeMinorVersion(resource.autoUpgradeMinorVersion());
                    }
                    if ((publicSettings = (LinkedHashMap)resource.settings()) != null && publicSettings.size() > 0) {
                        LinkedHashMap innerPublicSettings = (LinkedHashMap)((VirtualMachineExtensionInner)((Object)VirtualMachineExtensionImpl.this.inner())).settings();
                        if (innerPublicSettings == null) {
                            ((VirtualMachineExtensionInner)((Object)VirtualMachineExtensionImpl.this.inner())).withSettings(new LinkedHashMap());
                            innerPublicSettings = (LinkedHashMap)((VirtualMachineExtensionInner)((Object)VirtualMachineExtensionImpl.this.inner())).settings();
                        }
                        for (Map.Entry entry : publicSettings.entrySet()) {
                            if (innerPublicSettings.containsKey(entry.getKey())) continue;
                            innerPublicSettings.put(entry.getKey(), entry.getValue());
                        }
                    }
                    return VirtualMachineExtensionImpl.this.createAsync();
                }
            });
        }
        return this.createAsync();
    }

    public Observable<Void> deleteAsync() {
        return this.client.deleteAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), this.name()).map((Func1)new Func1<Void, Void>(){

            public Void call(Void result) {
                return result;
            }
        });
    }

    public boolean isReference() {
        return ((VirtualMachineExtensionInner)((Object)this.inner())).name() == null;
    }

    private void nullifySettingsIfEmpty() {
        if (this.publicSettings.size() == 0) {
            ((VirtualMachineExtensionInner)((Object)this.inner())).withSettings(null);
        }
        if (this.protectedSettings.size() == 0) {
            ((VirtualMachineExtensionInner)((Object)this.inner())).withProtectedSettings(null);
        }
    }

    private void initializeSettings() {
        if (((VirtualMachineExtensionInner)((Object)this.inner())).settings() == null) {
            this.publicSettings = new LinkedHashMap<String, Object>();
            ((VirtualMachineExtensionInner)((Object)this.inner())).withSettings(this.publicSettings);
        } else {
            this.publicSettings = (LinkedHashMap)((VirtualMachineExtensionInner)((Object)this.inner())).settings();
        }
        if (((VirtualMachineExtensionInner)((Object)this.inner())).protectedSettings() == null) {
            this.protectedSettings = new LinkedHashMap<String, Object>();
            ((VirtualMachineExtensionInner)((Object)this.inner())).withProtectedSettings(this.protectedSettings);
        } else {
            this.protectedSettings = (LinkedHashMap)((VirtualMachineExtensionInner)((Object)this.inner())).protectedSettings();
        }
    }
}

