/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.AvailabilitySet;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.DataDisk;
import com.microsoft.azure.management.compute.DiagnosticsProfile;
import com.microsoft.azure.management.compute.DiskCreateOptionTypes;
import com.microsoft.azure.management.compute.DiskEncryptionSettings;
import com.microsoft.azure.management.compute.HardwareProfile;
import com.microsoft.azure.management.compute.ImageReference;
import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.InstanceViewTypes;
import com.microsoft.azure.management.compute.KnownLinuxVirtualMachineImage;
import com.microsoft.azure.management.compute.KnownWindowsVirtualMachineImage;
import com.microsoft.azure.management.compute.LinuxConfiguration;
import com.microsoft.azure.management.compute.OSDisk;
import com.microsoft.azure.management.compute.OSProfile;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.Plan;
import com.microsoft.azure.management.compute.PowerState;
import com.microsoft.azure.management.compute.SshConfiguration;
import com.microsoft.azure.management.compute.SshPublicKey;
import com.microsoft.azure.management.compute.StorageProfile;
import com.microsoft.azure.management.compute.VirtualHardDisk;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineDataDisk;
import com.microsoft.azure.management.compute.VirtualMachineExtension;
import com.microsoft.azure.management.compute.VirtualMachineInstanceView;
import com.microsoft.azure.management.compute.VirtualMachineSize;
import com.microsoft.azure.management.compute.VirtualMachineSizeTypes;
import com.microsoft.azure.management.compute.WinRMConfiguration;
import com.microsoft.azure.management.compute.WinRMListener;
import com.microsoft.azure.management.compute.WindowsConfiguration;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.DataDiskImpl;
import com.microsoft.azure.management.compute.implementation.NetworkInterfaceReferenceInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineCaptureParametersInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineCaptureResultInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionsImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizeImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizeInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachinesInner;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.PublicIpAddress;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceNamer;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

@LangDefinition
class VirtualMachineImpl
extends GroupableResourceImpl<VirtualMachine, VirtualMachineInner, VirtualMachineImpl, ComputeManager>
implements VirtualMachine,
VirtualMachine.Definition,
VirtualMachine.Update {
    private final VirtualMachinesInner client;
    private final StorageManager storageManager;
    private final NetworkManager networkManager;
    private final String vmName;
    private final ResourceNamer namer;
    private String creatableStorageAccountKey;
    private String creatableAvailabilitySetKey;
    private String creatablePrimaryNetworkInterfaceKey;
    private List<String> creatableSecondaryNetworkInterfaceKeys;
    private StorageAccount existingStorageAccountToAssociate;
    private AvailabilitySet existingAvailabilitySetToAssociate;
    private NetworkInterface existingPrimaryNetworkInterfaceToAssociate;
    private List<NetworkInterface> existingSecondaryNetworkInterfacesToAssociate;
    private VirtualMachineInstanceView virtualMachineInstanceView;
    private boolean isMarketplaceLinuxImage;
    private List<VirtualMachineDataDisk> dataDisks;
    private NetworkInterface.DefinitionStages.WithPrimaryPrivateIp nicDefinitionWithPrivateIp;
    private NetworkInterface.DefinitionStages.WithPrimaryNetworkSubnet nicDefinitionWithSubnet;
    private NetworkInterface.DefinitionStages.WithCreate nicDefinitionWithCreate;
    private final PagedListConverter<VirtualMachineSizeInner, VirtualMachineSize> virtualMachineSizeConverter;
    private VirtualMachineExtensionsImpl virtualMachineExtensions;

    VirtualMachineImpl(String name, VirtualMachineInner innerModel, VirtualMachinesInner client, VirtualMachineExtensionsInner extensionsClient, ComputeManager computeManager, StorageManager storageManager, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)computeManager);
        this.client = client;
        this.storageManager = storageManager;
        this.networkManager = networkManager;
        this.vmName = name;
        this.isMarketplaceLinuxImage = false;
        this.namer = new ResourceNamer(this.vmName);
        this.creatableSecondaryNetworkInterfaceKeys = new ArrayList<String>();
        this.existingSecondaryNetworkInterfacesToAssociate = new ArrayList<NetworkInterface>();
        this.virtualMachineSizeConverter = new PagedListConverter<VirtualMachineSizeInner, VirtualMachineSize>(){

            public VirtualMachineSize typeConvert(VirtualMachineSizeInner inner) {
                return new VirtualMachineSizeImpl(inner);
            }
        };
        this.virtualMachineExtensions = new VirtualMachineExtensionsImpl(extensionsClient, this);
        this.initializeDataDisks();
    }

    public VirtualMachine refresh() {
        VirtualMachineInner response = this.client.get(this.resourceGroupName(), this.name());
        this.setInner((Object)response);
        this.clearCachedRelatedResources();
        this.initializeDataDisks();
        this.virtualMachineExtensions.refresh();
        return this;
    }

    @Override
    public void deallocate() {
        this.client.deallocate(this.resourceGroupName(), this.name());
    }

    @Override
    public void generalize() {
        this.client.generalize(this.resourceGroupName(), this.name());
    }

    @Override
    public void powerOff() {
        this.client.powerOff(this.resourceGroupName(), this.name());
    }

    @Override
    public void restart() {
        this.client.restart(this.resourceGroupName(), this.name());
    }

    @Override
    public void start() {
        this.client.start(this.resourceGroupName(), this.name());
    }

    @Override
    public void redeploy() {
        this.client.redeploy(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedList<VirtualMachineSize> availableSizes() {
        PageImpl page = new PageImpl();
        page.setItems(this.client.listAvailableSizes(this.resourceGroupName(), this.name()));
        page.setNextPageLink(null);
        return this.virtualMachineSizeConverter.convert((PagedList)new PagedList<VirtualMachineSizeInner>((Page)page){

            public Page<VirtualMachineSizeInner> nextPage(String nextPageLink) {
                return null;
            }
        });
    }

    @Override
    public String capture(String containerName, boolean overwriteVhd) {
        VirtualMachineCaptureParametersInner parameters = new VirtualMachineCaptureParametersInner();
        parameters.withDestinationContainerName(containerName);
        parameters.withOverwriteVhds(overwriteVhd);
        VirtualMachineCaptureResultInner captureResult = this.client.capture(this.resourceGroupName(), this.name(), parameters);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(captureResult.output());
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public VirtualMachineInstanceView refreshInstanceView() {
        this.virtualMachineInstanceView = this.client.get(this.resourceGroupName(), this.name(), InstanceViewTypes.INSTANCE_VIEW).instanceView();
        return this.virtualMachineInstanceView;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryNetwork(Creatable<Network> creatable) {
        this.nicDefinitionWithPrivateIp = this.preparePrimaryNetworkInterface(this.namer.randomName("nic", 20)).withNewPrimaryNetwork(creatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryNetwork(String addressSpace) {
        this.nicDefinitionWithPrivateIp = this.preparePrimaryNetworkInterface(this.namer.randomName("nic", 20)).withNewPrimaryNetwork(addressSpace);
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingPrimaryNetwork(Network network) {
        this.nicDefinitionWithSubnet = this.preparePrimaryNetworkInterface(this.namer.randomName("nic", 20)).withExistingPrimaryNetwork(network);
        return this;
    }

    @Override
    public VirtualMachineImpl withSubnet(String name) {
        this.nicDefinitionWithPrivateIp = this.nicDefinitionWithSubnet.withSubnet(name);
        return this;
    }

    @Override
    public VirtualMachineImpl withPrimaryPrivateIpAddressDynamic() {
        this.nicDefinitionWithCreate = this.nicDefinitionWithPrivateIp.withPrimaryPrivateIpAddressDynamic();
        return this;
    }

    @Override
    public VirtualMachineImpl withPrimaryPrivateIpAddressStatic(String staticPrivateIpAddress) {
        this.nicDefinitionWithCreate = this.nicDefinitionWithPrivateIp.withPrimaryPrivateIpAddressStatic(staticPrivateIpAddress);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryPublicIpAddress(Creatable<PublicIpAddress> creatable) {
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate.withNewPrimaryPublicIpAddress(creatable);
        this.addCreatableDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryPublicIpAddress(String leafDnsLabel) {
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate.withNewPrimaryPublicIpAddress(leafDnsLabel);
        this.creatablePrimaryNetworkInterfaceKey = nicCreatable.key();
        this.addCreatableDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingPrimaryPublicIpAddress(PublicIpAddress publicIpAddress) {
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate.withExistingPrimaryPublicIpAddress(publicIpAddress);
        this.creatablePrimaryNetworkInterfaceKey = nicCreatable.key();
        this.addCreatableDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutPrimaryPublicIpAddress() {
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate;
        this.creatablePrimaryNetworkInterfaceKey = nicCreatable.key();
        this.addCreatableDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryNetworkInterface(Creatable<NetworkInterface> creatable) {
        this.creatablePrimaryNetworkInterfaceKey = creatable.key();
        this.addCreatableDependency(creatable);
        return this;
    }

    public VirtualMachineImpl withNewPrimaryNetworkInterface(String name, String publicDnsNameLabel) {
        NetworkInterface.DefinitionStages.WithCreate definitionCreatable = this.prepareNetworkInterface(name).withNewPrimaryPublicIpAddress(publicDnsNameLabel);
        return this.withNewPrimaryNetworkInterface((Creatable)definitionCreatable);
    }

    @Override
    public VirtualMachineImpl withExistingPrimaryNetworkInterface(NetworkInterface networkInterface) {
        this.existingPrimaryNetworkInterfaceToAssociate = networkInterface;
        return this;
    }

    @Override
    public VirtualMachineImpl withStoredWindowsImage(String imageUrl) {
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withOsType(OperatingSystemTypes.WINDOWS);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withStoredLinuxImage(String imageUrl) {
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withOsType(OperatingSystemTypes.LINUX);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withLinuxConfiguration(new LinuxConfiguration());
        return this;
    }

    @Override
    public VirtualMachineImpl withPopularWindowsImage(KnownWindowsVirtualMachineImage knownImage) {
        return this.withSpecificWindowsImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineImpl withPopularLinuxImage(KnownLinuxVirtualMachineImage knownImage) {
        return this.withSpecificLinuxImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineImpl withSpecificWindowsImageVersion(ImageReference imageReference) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().withImageReference(imageReference);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpecificLinuxImageVersion(ImageReference imageReference) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().withImageReference(imageReference);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withLinuxConfiguration(new LinuxConfiguration());
        this.isMarketplaceLinuxImage = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withLatestWindowsImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference();
        imageReference.withPublisher(publisher);
        imageReference.withOffer(offer);
        imageReference.withSku(sku);
        imageReference.withVersion("latest");
        return this.withSpecificWindowsImageVersion(imageReference);
    }

    @Override
    public VirtualMachineImpl withLatestLinuxImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference();
        imageReference.withPublisher(publisher);
        imageReference.withOffer(offer);
        imageReference.withSku(sku);
        imageReference.withVersion("latest");
        return this.withSpecificLinuxImageVersion(imageReference);
    }

    @Override
    public VirtualMachineImpl withOsDisk(String osDiskUrl, OperatingSystemTypes osType) {
        VirtualHardDisk osDisk = new VirtualHardDisk();
        osDisk.withUri(osDiskUrl);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.ATTACH);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withVhd(osDisk);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withOsType(osType);
        return this;
    }

    @Override
    public VirtualMachineImpl withRootUserName(String rootUserName) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withAdminUsername(rootUserName);
        return this;
    }

    @Override
    public VirtualMachineImpl withAdminUserName(String adminUserName) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withAdminUsername(adminUserName);
        return this;
    }

    @Override
    public VirtualMachineImpl withSsh(String publicKeyData) {
        OSProfile osProfile = ((VirtualMachineInner)((Object)this.inner())).osProfile();
        if (osProfile.linuxConfiguration().ssh() == null) {
            SshConfiguration sshConfiguration = new SshConfiguration();
            sshConfiguration.withPublicKeys(new ArrayList<SshPublicKey>());
            osProfile.linuxConfiguration().withSsh(sshConfiguration);
        }
        SshPublicKey sshPublicKey = new SshPublicKey();
        sshPublicKey.withKeyData(publicKeyData);
        sshPublicKey.withPath("/home/" + osProfile.adminUsername() + "/.ssh/authorized_keys");
        osProfile.linuxConfiguration().ssh().publicKeys().add(sshPublicKey);
        return this;
    }

    @Override
    public VirtualMachineImpl disableVmAgent() {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withProvisionVMAgent(false);
        return this;
    }

    @Override
    public VirtualMachineImpl disableAutoUpdate() {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(false);
        return this;
    }

    @Override
    public VirtualMachineImpl withTimeZone(String timeZone) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withTimeZone(timeZone);
        return this;
    }

    @Override
    public VirtualMachineImpl withWinRm(WinRMListener listener) {
        if (((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().winRM() == null) {
            WinRMConfiguration winRMConfiguration = new WinRMConfiguration();
            ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withWinRM(winRMConfiguration);
        }
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().winRM().listeners().add(listener);
        return this;
    }

    @Override
    public VirtualMachineImpl withPassword(String password) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withAdminPassword(password);
        return this;
    }

    @Override
    public VirtualMachineImpl withSize(String sizeName) {
        ((VirtualMachineInner)((Object)this.inner())).hardwareProfile().withVmSize(new VirtualMachineSizeTypes(sizeName));
        return this;
    }

    @Override
    public VirtualMachineImpl withSize(VirtualMachineSizeTypes size) {
        ((VirtualMachineInner)((Object)this.inner())).hardwareProfile().withVmSize(size);
        return this;
    }

    @Override
    public VirtualMachineImpl withOsDiskCaching(CachingTypes cachingType) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCaching(cachingType);
        return this;
    }

    @Override
    public VirtualMachineImpl withOsDiskVhdLocation(String containerName, String vhdName) {
        VirtualHardDisk osVhd = new VirtualHardDisk();
        osVhd.withUri(this.temporaryBlobUrl(containerName, vhdName));
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withVhd(osVhd);
        return this;
    }

    @Override
    public VirtualMachineImpl withOsDiskEncryptionSettings(DiskEncryptionSettings settings) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withEncryptionSettings(settings);
        return this;
    }

    @Override
    public VirtualMachineImpl withOsDiskSizeInGb(Integer size) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withDiskSizeGB(size);
        return this;
    }

    @Override
    public VirtualMachineImpl withOsDiskName(String name) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withName(name);
        return this;
    }

    public DataDiskImpl defineNewDataDisk(String name) {
        return DataDiskImpl.prepareDataDisk(name, DiskCreateOptionTypes.EMPTY, this);
    }

    public DataDiskImpl defineExistingDataDisk(String name) {
        return DataDiskImpl.prepareDataDisk(name, DiskCreateOptionTypes.ATTACH, this);
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(Integer sizeInGB) {
        return this.withDataDisk(DataDiskImpl.createNewDataDisk(sizeInGB, this));
    }

    @Override
    public VirtualMachineImpl withExistingDataDisk(String storageAccountName, String containerName, String vhdName) {
        return this.withDataDisk(DataDiskImpl.createFromExistingDisk(storageAccountName, containerName, vhdName, this));
    }

    @Override
    public VirtualMachineImpl withNewStorageAccount(Creatable<StorageAccount> creatable) {
        if (this.creatableStorageAccountKey == null) {
            this.creatableStorageAccountKey = creatable.key();
            this.addCreatableDependency(creatable);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withNewStorageAccount(String name) {
        StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(name)).withRegion(this.regionName());
        Creatable definitionAfterGroup = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return this.withNewStorageAccount(definitionAfterGroup);
    }

    @Override
    public VirtualMachineImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.existingStorageAccountToAssociate = storageAccount;
        return this;
    }

    @Override
    public VirtualMachineImpl withNewAvailabilitySet(Creatable<AvailabilitySet> creatable) {
        if (this.creatableAvailabilitySetKey == null) {
            this.creatableAvailabilitySetKey = creatable.key();
            this.addCreatableDependency(creatable);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withNewAvailabilitySet(String name) {
        return this.withNewAvailabilitySet((Creatable)((AvailabilitySet.DefinitionStages.WithGroup)((AvailabilitySet.DefinitionStages.Blank)((ComputeManager)this.myManager).availabilitySets().define(name)).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName()));
    }

    @Override
    public VirtualMachineImpl withExistingAvailabilitySet(AvailabilitySet availabilitySet) {
        this.existingAvailabilitySetToAssociate = availabilitySet;
        return this;
    }

    @Override
    public VirtualMachineImpl withNewSecondaryNetworkInterface(Creatable<NetworkInterface> creatable) {
        this.creatableSecondaryNetworkInterfaceKeys.add(creatable.key());
        this.addCreatableDependency(creatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingSecondaryNetworkInterface(NetworkInterface networkInterface) {
        this.existingSecondaryNetworkInterfacesToAssociate.add(networkInterface);
        return this;
    }

    public VirtualMachineExtensionImpl defineNewExtension(String name) {
        return this.virtualMachineExtensions.define(name);
    }

    @Override
    public VirtualMachineImpl withoutDataDisk(String name) {
        int idx = -1;
        for (VirtualMachineDataDisk dataDisk : this.dataDisks) {
            ++idx;
            if (!dataDisk.name().equalsIgnoreCase(name)) continue;
            this.dataDisks.remove(idx);
            ((VirtualMachineInner)((Object)this.inner())).storageProfile().dataDisks().remove(idx);
            break;
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withoutDataDisk(int lun) {
        int idx = -1;
        for (VirtualMachineDataDisk dataDisk : this.dataDisks) {
            ++idx;
            if (dataDisk.lun() != lun) continue;
            this.dataDisks.remove(idx);
            ((VirtualMachineInner)((Object)this.inner())).storageProfile().dataDisks().remove(idx);
            break;
        }
        return this;
    }

    @Override
    public DataDiskImpl updateDataDisk(String name) {
        for (VirtualMachineDataDisk dataDisk : this.dataDisks) {
            if (!dataDisk.name().equalsIgnoreCase(name)) continue;
            return (DataDiskImpl)dataDisk;
        }
        throw new RuntimeException("A data disk with name  '" + name + "' not found");
    }

    @Override
    public VirtualMachineImpl withoutSecondaryNetworkInterface(String name) {
        if (((VirtualMachineInner)((Object)this.inner())).networkProfile() != null && ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces() != null) {
            int idx = -1;
            for (NetworkInterfaceReferenceInner nicReference : ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces()) {
                ++idx;
                if (nicReference.primary().booleanValue() || !name.equalsIgnoreCase(ResourceUtils.nameFromResourceId((String)nicReference.id()))) continue;
                ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces().remove(idx);
                break;
            }
        }
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl updateExtension(String name) {
        return this.virtualMachineExtensions.update(name);
    }

    @Override
    public VirtualMachineImpl withoutExtension(String name) {
        this.virtualMachineExtensions.remove(name);
        return this;
    }

    @Override
    public String computerName() {
        return ((VirtualMachineInner)((Object)this.inner())).osProfile().computerName();
    }

    @Override
    public VirtualMachineSizeTypes size() {
        return ((VirtualMachineInner)((Object)this.inner())).hardwareProfile().vmSize();
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().osType();
    }

    @Override
    public String osDiskVhdUri() {
        return ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().vhd().uri();
    }

    @Override
    public CachingTypes osDiskCachingType() {
        return ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().caching();
    }

    @Override
    public int osDiskSize() {
        if (((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().diskSizeGB() == null) {
            return 0;
        }
        return ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().diskSizeGB();
    }

    @Override
    public List<VirtualMachineDataDisk> dataDisks() {
        return this.dataDisks;
    }

    public NetworkInterface getPrimaryNetworkInterface() {
        return (NetworkInterface)this.networkManager.networkInterfaces().getById(this.primaryNetworkInterfaceId());
    }

    @Override
    public PublicIpAddress getPrimaryPublicIpAddress() {
        return this.getPrimaryNetworkInterface().primaryIpConfiguration().getPublicIpAddress();
    }

    @Override
    public String getPrimaryPublicIpAddressId() {
        return this.getPrimaryNetworkInterface().primaryIpConfiguration().publicIpAddressId();
    }

    public List<String> networkInterfaceIds() {
        ArrayList<String> nicIds = new ArrayList<String>();
        for (NetworkInterfaceReferenceInner nicRef : ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces()) {
            nicIds.add(nicRef.id());
        }
        return nicIds;
    }

    public String primaryNetworkInterfaceId() {
        List<NetworkInterfaceReferenceInner> nicRefs = ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces();
        String primaryNicRefId = null;
        if (nicRefs.size() == 1) {
            primaryNicRefId = nicRefs.get(0).id();
        } else if (nicRefs.size() == 0) {
            primaryNicRefId = null;
        } else {
            for (NetworkInterfaceReferenceInner nicRef : ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces()) {
                if (nicRef.primary() == null || !nicRef.primary().booleanValue()) continue;
                primaryNicRefId = nicRef.id();
                break;
            }
            if (primaryNicRefId == null) {
                primaryNicRefId = nicRefs.get(0).id();
            }
        }
        return primaryNicRefId;
    }

    @Override
    public String availabilitySetId() {
        if (((VirtualMachineInner)((Object)this.inner())).availabilitySet() != null) {
            return ((VirtualMachineInner)((Object)this.inner())).availabilitySet().id();
        }
        return null;
    }

    @Override
    public String provisioningState() {
        return ((VirtualMachineInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public String licenseType() {
        return ((VirtualMachineInner)((Object)this.inner())).licenseType();
    }

    @Override
    public Map<String, VirtualMachineExtension> extensions() {
        return this.virtualMachineExtensions.asMap();
    }

    @Override
    public Plan plan() {
        return ((VirtualMachineInner)((Object)this.inner())).plan();
    }

    @Override
    public StorageProfile storageProfile() {
        return ((VirtualMachineInner)((Object)this.inner())).storageProfile();
    }

    @Override
    public OSProfile osProfile() {
        return ((VirtualMachineInner)((Object)this.inner())).osProfile();
    }

    @Override
    public DiagnosticsProfile diagnosticsProfile() {
        return ((VirtualMachineInner)((Object)this.inner())).diagnosticsProfile();
    }

    @Override
    public String vmId() {
        return ((VirtualMachineInner)((Object)this.inner())).vmId();
    }

    @Override
    public VirtualMachineInstanceView instanceView() {
        if (this.virtualMachineInstanceView == null) {
            this.refreshInstanceView();
        }
        return this.virtualMachineInstanceView;
    }

    @Override
    public PowerState powerState() {
        String powerStateCode = this.getStatusCodeFromInstanceView("PowerState");
        if (powerStateCode != null) {
            return PowerState.fromValue(powerStateCode);
        }
        return null;
    }

    public Observable<VirtualMachine> createResourceAsync() {
        if (this.isInCreateMode()) {
            this.setOSDiskAndOSProfileDefaults();
            this.setHardwareProfileDefaults();
        }
        DataDiskImpl.setDataDisksDefaults(this.dataDisks, this.vmName);
        final VirtualMachineImpl self = this;
        return this.handleStorageSettingsAsync().flatMap((Func1)new Func1<StorageAccount, Observable<? extends VirtualMachine>>(){

            public Observable<? extends VirtualMachine> call(StorageAccount storageAccount) {
                VirtualMachineImpl.this.handleNetworkSettings();
                VirtualMachineImpl.this.handleAvailabilitySettings();
                return VirtualMachineImpl.this.client.createOrUpdateAsync(VirtualMachineImpl.this.resourceGroupName(), VirtualMachineImpl.this.vmName, (VirtualMachineInner)((Object)VirtualMachineImpl.this.inner())).map((Func1)new Func1<VirtualMachineInner, VirtualMachine>(){

                    public VirtualMachine call(VirtualMachineInner virtualMachineInner) {
                        self.setInner((Object)virtualMachineInner);
                        VirtualMachineImpl.this.clearCachedRelatedResources();
                        VirtualMachineImpl.this.initializeDataDisks();
                        return self;
                    }
                });
            }
        }).flatMap((Func1)new Func1<VirtualMachine, Observable<? extends VirtualMachine>>(){

            public Observable<? extends VirtualMachine> call(VirtualMachine virtualMachine) {
                return self.virtualMachineExtensions.commitAndGetAllAsync().map((Func1)new Func1<List<VirtualMachineExtensionImpl>, VirtualMachine>(){

                    public VirtualMachine call(List<VirtualMachineExtensionImpl> virtualMachineExtensions) {
                        return self;
                    }
                });
            }
        });
    }

    VirtualMachineImpl withExtension(VirtualMachineExtensionImpl extension) {
        this.virtualMachineExtensions.addExtension(extension);
        return this;
    }

    VirtualMachineImpl withDataDisk(DataDiskImpl dataDisk) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().dataDisks().add((DataDisk)dataDisk.inner());
        this.dataDisks.add(dataDisk);
        return this;
    }

    private void setOSDiskAndOSProfileDefaults() {
        if (!this.isInCreateMode()) {
            return;
        }
        OSDisk osDisk = ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk();
        if (this.isOSDiskFromImage(osDisk)) {
            if (osDisk.vhd() == null) {
                this.withOsDiskVhdLocation("vhds", this.vmName + "-os-disk-" + UUID.randomUUID().toString() + ".vhd");
            }
            OSProfile osProfile = ((VirtualMachineInner)((Object)this.inner())).osProfile();
            if (osDisk.osType() == OperatingSystemTypes.LINUX || this.isMarketplaceLinuxImage) {
                if (osProfile.linuxConfiguration() == null) {
                    osProfile.withLinuxConfiguration(new LinuxConfiguration());
                }
                ((VirtualMachineInner)((Object)this.inner())).osProfile().linuxConfiguration().withDisablePasswordAuthentication(osProfile.adminPassword() == null);
            }
        }
        if (osDisk.caching() == null) {
            this.withOsDiskCaching(CachingTypes.READ_WRITE);
        }
        if (osDisk.name() == null) {
            this.withOsDiskName(this.vmName + "-os-disk");
        }
        if (((VirtualMachineInner)((Object)this.inner())).osProfile().computerName() == null) {
            if (this.vmName.matches("[0-9]+")) {
                ((VirtualMachineInner)((Object)this.inner())).osProfile().withComputerName(ResourceNamer.randomResourceName((String)"vm", (int)15));
            } else if (this.vmName.length() <= 15) {
                ((VirtualMachineInner)((Object)this.inner())).osProfile().withComputerName(this.vmName);
            } else {
                ((VirtualMachineInner)((Object)this.inner())).osProfile().withComputerName(ResourceNamer.randomResourceName((String)"vm", (int)15));
            }
        }
    }

    private void setHardwareProfileDefaults() {
        if (!this.isInCreateMode()) {
            return;
        }
        HardwareProfile hardwareProfile = ((VirtualMachineInner)((Object)this.inner())).hardwareProfile();
        if (hardwareProfile.vmSize() == null) {
            hardwareProfile.withVmSize(VirtualMachineSizeTypes.BASIC_A0);
        }
    }

    private Observable<StorageAccount> handleStorageSettingsAsync() {
        Func1<StorageAccount, StorageAccount> storageAccountFunc = new Func1<StorageAccount, StorageAccount>(){

            public StorageAccount call(StorageAccount storageAccount) {
                if (VirtualMachineImpl.this.isInCreateMode()) {
                    if (VirtualMachineImpl.this.isOSDiskFromImage(((VirtualMachineInner)((Object)VirtualMachineImpl.this.inner())).storageProfile().osDisk())) {
                        String uri = ((VirtualMachineInner)((Object)VirtualMachineImpl.this.inner())).storageProfile().osDisk().vhd().uri().replaceFirst("\\{storage-base-url}", storageAccount.endPoints().primary().blob());
                        ((VirtualMachineInner)((Object)VirtualMachineImpl.this.inner())).storageProfile().osDisk().vhd().withUri(uri);
                    }
                    DataDiskImpl.ensureDisksVhdUri(VirtualMachineImpl.this.dataDisks, storageAccount, VirtualMachineImpl.this.vmName);
                } else if (storageAccount != null) {
                    DataDiskImpl.ensureDisksVhdUri(VirtualMachineImpl.this.dataDisks, storageAccount, VirtualMachineImpl.this.vmName);
                } else {
                    DataDiskImpl.ensureDisksVhdUri(VirtualMachineImpl.this.dataDisks, VirtualMachineImpl.this.vmName);
                }
                return storageAccount;
            }
        };
        if (this.creatableStorageAccountKey != null) {
            return Observable.just((Object)((StorageAccount)this.createdResource(this.creatableStorageAccountKey))).map((Func1)storageAccountFunc);
        }
        if (this.existingStorageAccountToAssociate != null) {
            return Observable.just((Object)this.existingStorageAccountToAssociate).map((Func1)storageAccountFunc);
        }
        if (this.osDiskRequiresImplicitStorageAccountCreation() || this.dataDisksRequiresImplicitStorageAccountCreation()) {
            return ((StorageAccount.DefinitionStages.WithCreate)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(this.namer.randomName("stg", 24))).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName())).createAsync().map((Func1)storageAccountFunc);
        }
        return Observable.just(null);
    }

    private void handleNetworkSettings() {
        if (this.isInCreateMode()) {
            NetworkInterface primaryNetworkInterface = null;
            if (this.creatablePrimaryNetworkInterfaceKey != null) {
                primaryNetworkInterface = (NetworkInterface)this.createdResource(this.creatablePrimaryNetworkInterfaceKey);
            } else if (this.existingPrimaryNetworkInterfaceToAssociate != null) {
                primaryNetworkInterface = this.existingPrimaryNetworkInterfaceToAssociate;
            }
            if (primaryNetworkInterface != null) {
                NetworkInterfaceReferenceInner nicReference = new NetworkInterfaceReferenceInner();
                nicReference.withPrimary(true);
                nicReference.withId(primaryNetworkInterface.id());
                ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces().add(nicReference);
            }
        }
        for (String creatableSecondaryNetworkInterfaceKey : this.creatableSecondaryNetworkInterfaceKeys) {
            NetworkInterface secondaryNetworkInterface = (NetworkInterface)this.createdResource(creatableSecondaryNetworkInterfaceKey);
            NetworkInterfaceReferenceInner nicReference = new NetworkInterfaceReferenceInner();
            nicReference.withPrimary(false);
            nicReference.withId(secondaryNetworkInterface.id());
            ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces().add(nicReference);
        }
        for (NetworkInterface secondaryNetworkInterface : this.existingSecondaryNetworkInterfacesToAssociate) {
            NetworkInterfaceReferenceInner nicReference = new NetworkInterfaceReferenceInner();
            nicReference.withPrimary(false);
            nicReference.withId(secondaryNetworkInterface.id());
            ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces().add(nicReference);
        }
    }

    private void handleAvailabilitySettings() {
        if (!this.isInCreateMode()) {
            return;
        }
        AvailabilitySet availabilitySet = null;
        if (this.creatableAvailabilitySetKey != null) {
            availabilitySet = (AvailabilitySet)this.createdResource(this.creatableAvailabilitySetKey);
        } else if (this.existingAvailabilitySetToAssociate != null) {
            availabilitySet = this.existingAvailabilitySetToAssociate;
        }
        if (availabilitySet != null) {
            if (((VirtualMachineInner)((Object)this.inner())).availabilitySet() == null) {
                ((VirtualMachineInner)((Object)this.inner())).withAvailabilitySet(new SubResource());
            }
            ((VirtualMachineInner)((Object)this.inner())).availabilitySet().withId(availabilitySet.id());
        }
    }

    private boolean osDiskRequiresImplicitStorageAccountCreation() {
        if (this.creatableStorageAccountKey != null || this.existingStorageAccountToAssociate != null || !this.isInCreateMode()) {
            return false;
        }
        return this.isOSDiskFromImage(((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk());
    }

    private boolean dataDisksRequiresImplicitStorageAccountCreation() {
        if (this.creatableStorageAccountKey != null || this.existingStorageAccountToAssociate != null || this.dataDisks.size() == 0) {
            return false;
        }
        boolean hasEmptyVhd = false;
        for (VirtualMachineDataDisk dataDisk : this.dataDisks) {
            if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY || ((DataDisk)dataDisk.inner()).vhd() != null) continue;
            hasEmptyVhd = true;
            break;
        }
        if (this.isInCreateMode()) {
            return hasEmptyVhd;
        }
        if (hasEmptyVhd) {
            for (VirtualMachineDataDisk dataDisk : this.dataDisks) {
                if (dataDisk.creationMethod() != DiskCreateOptionTypes.ATTACH || ((DataDisk)dataDisk.inner()).vhd() == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isOSDiskAttached(OSDisk osDisk) {
        return osDisk.createOption() == DiskCreateOptionTypes.ATTACH;
    }

    private boolean isOSDiskFromImage(OSDisk osDisk) {
        return !this.isOSDiskAttached(osDisk);
    }

    private String temporaryBlobUrl(String containerName, String blobName) {
        return "{storage-base-url}" + containerName + "/" + blobName;
    }

    private NetworkInterface.DefinitionStages.WithPrimaryPublicIpAddress prepareNetworkInterface(String name) {
        NetworkInterface.DefinitionStages.WithGroup definitionWithGroup = (NetworkInterface.DefinitionStages.WithGroup)((NetworkInterface.DefinitionStages.Blank)this.networkManager.networkInterfaces().define(name)).withRegion(this.regionName());
        NetworkInterface.DefinitionStages.WithPrimaryNetwork definitionWithNetwork = this.creatableGroup != null ? (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return definitionWithNetwork.withNewPrimaryNetwork("vnet" + name).withPrimaryPrivateIpAddressDynamic();
    }

    private void initializeDataDisks() {
        if (((VirtualMachineInner)((Object)this.inner())).storageProfile().dataDisks() == null) {
            ((VirtualMachineInner)((Object)this.inner())).storageProfile().withDataDisks(new ArrayList<DataDisk>());
        }
        this.dataDisks = new ArrayList<VirtualMachineDataDisk>();
        for (DataDisk dataDiskInner : this.storageProfile().dataDisks()) {
            this.dataDisks().add(new DataDiskImpl(dataDiskInner, this));
        }
    }

    private NetworkInterface.DefinitionStages.WithPrimaryNetwork preparePrimaryNetworkInterface(String name) {
        NetworkInterface.DefinitionStages.WithGroup definitionWithGroup = (NetworkInterface.DefinitionStages.WithGroup)((NetworkInterface.DefinitionStages.Blank)this.networkManager.networkInterfaces().define(name)).withRegion(this.regionName());
        NetworkInterface.DefinitionStages.WithPrimaryNetwork definitionAfterGroup = this.creatableGroup != null ? (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return definitionAfterGroup;
    }

    private String getStatusCodeFromInstanceView(String codePrefix) {
        try {
            for (InstanceViewStatus status : this.instanceView().statuses()) {
                if (status.code() == null || !status.code().startsWith(codePrefix)) continue;
                return status.code();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    private void clearCachedRelatedResources() {
        this.virtualMachineInstanceView = null;
    }
}

