/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.ApiEntityReference;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.DiskCreateOptionTypes;
import com.microsoft.azure.management.compute.ImageReference;
import com.microsoft.azure.management.compute.KnownLinuxVirtualMachineImage;
import com.microsoft.azure.management.compute.KnownWindowsVirtualMachineImage;
import com.microsoft.azure.management.compute.LinuxConfiguration;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.SshConfiguration;
import com.microsoft.azure.management.compute.SshPublicKey;
import com.microsoft.azure.management.compute.UpgradeMode;
import com.microsoft.azure.management.compute.UpgradePolicy;
import com.microsoft.azure.management.compute.VirtualHardDisk;
import com.microsoft.azure.management.compute.VirtualMachineScaleSet;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetExtension;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetExtensionProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetNetworkProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetOSProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetSku;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetSkuTypes;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetStorageProfile;
import com.microsoft.azure.management.compute.WinRMConfiguration;
import com.microsoft.azure.management.compute.WinRMListener;
import com.microsoft.azure.management.compute.WindowsConfiguration;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetExtensionImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetIPConfigurationInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetNetworkConfigurationInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetSkuImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetSkuInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetsInner;
import com.microsoft.azure.management.network.Backend;
import com.microsoft.azure.management.network.Frontend;
import com.microsoft.azure.management.network.InboundNatPool;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.implementation.FrontendIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceNamer;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class VirtualMachineScaleSetImpl
extends GroupableParentResourceImpl<VirtualMachineScaleSet, VirtualMachineScaleSetInner, VirtualMachineScaleSetImpl, ComputeManager>
implements VirtualMachineScaleSet,
VirtualMachineScaleSet.Definition,
VirtualMachineScaleSet.Update {
    private final VirtualMachineScaleSetsInner client;
    private final StorageManager storageManager;
    private final NetworkManager networkManager;
    private final ResourceNamer namer;
    private boolean isMarketplaceLinuxImage = false;
    private String existingPrimaryNetworkSubnetNameToAssociate;
    private List<String> creatableStorageAccountKeys = new ArrayList<String>();
    private List<StorageAccount> existingStorageAccountsToAssociate = new ArrayList<StorageAccount>();
    private String vhdContainerName;
    private Map<String, VirtualMachineScaleSetExtension> extensions;
    private LoadBalancer primaryInternetFacingLoadBalancer;
    private LoadBalancer primaryInternalLoadBalancer;
    private boolean removePrimaryInternetFacingLoadBalancerOnUpdate;
    private boolean removePrimaryInternalLoadBalancerOnUpdate;
    private LoadBalancer primaryInternetFacingLoadBalancerToAttachOnUpdate;
    private LoadBalancer primaryInternalLoadBalancerToAttachOnUpdate;
    private List<String> primaryInternetFacingLBBackendsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBBackendsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBInboundNatPoolsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternetFacingLBBackendsToAddOnUpdate = new ArrayList<String>();
    private List<String> primaryInternetFacingLBInboundNatPoolsToAddOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBBackendsToAddOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBInboundNatPoolsToAddOnUpdate = new ArrayList<String>();
    private PagedListConverter<VirtualMachineScaleSetSkuInner, VirtualMachineScaleSetSku> skuConverter;

    VirtualMachineScaleSetImpl(String name, VirtualMachineScaleSetInner innerModel, VirtualMachineScaleSetsInner client, ComputeManager computeManager, StorageManager storageManager, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)computeManager);
        this.client = client;
        this.storageManager = storageManager;
        this.networkManager = networkManager;
        this.namer = new ResourceNamer(this.name());
        this.skuConverter = new PagedListConverter<VirtualMachineScaleSetSkuInner, VirtualMachineScaleSetSku>(){

            public VirtualMachineScaleSetSku typeConvert(VirtualMachineScaleSetSkuInner inner) {
                return new VirtualMachineScaleSetSkuImpl(inner);
            }
        };
    }

    protected void initializeChildrenFromInner() {
        this.extensions = new HashMap<String, VirtualMachineScaleSetExtension>();
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().extensionProfile() != null && ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().extensionProfile().extensions() != null) {
            for (VirtualMachineScaleSetExtensionInner inner : ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().extensionProfile().extensions()) {
                this.extensions.put(inner.name(), new VirtualMachineScaleSetExtensionImpl(inner, this));
            }
        }
    }

    @Override
    public PagedList<VirtualMachineScaleSetSku> listAvailableSkus() throws CloudException, IOException {
        return this.skuConverter.convert(this.client.listSkus(this.resourceGroupName(), this.name()));
    }

    @Override
    public void deallocate() throws CloudException, IOException, InterruptedException {
        this.client.deallocate(this.resourceGroupName(), this.name());
    }

    @Override
    public void powerOff() throws CloudException, IOException, InterruptedException {
        this.client.powerOff(this.resourceGroupName(), this.name());
    }

    @Override
    public void restart() throws CloudException, IOException, InterruptedException {
        this.client.restart(this.resourceGroupName(), this.name());
    }

    @Override
    public void start() throws CloudException, IOException, InterruptedException {
        this.client.start(this.resourceGroupName(), this.name());
    }

    @Override
    public void reimage() throws CloudException, IOException, InterruptedException {
        this.client.reimage(this.resourceGroupName(), this.name());
    }

    @Override
    public String computerNamePrefix() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().computerNamePrefix();
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().osType();
    }

    @Override
    public CachingTypes osDiskCachingType() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().caching();
    }

    @Override
    public String osDiskName() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().name();
    }

    @Override
    public UpgradeMode upgradeModel() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).upgradePolicy().mode();
    }

    @Override
    public boolean overProvisionEnabled() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).overProvision();
    }

    @Override
    public VirtualMachineScaleSetSkuTypes sku() {
        return new VirtualMachineScaleSetSkuTypes(((VirtualMachineScaleSetInner)((Object)this.inner())).sku());
    }

    @Override
    public int capacity() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).sku().capacity().intValue();
    }

    @Override
    public Network getPrimaryNetwork() throws IOException {
        String subnetId = this.primaryNicDefaultIPConfiguration().subnet().id();
        String virtualNetworkId = ResourceUtils.parentResourcePathFromResourceId((String)subnetId);
        return (Network)this.networkManager.networks().getById(virtualNetworkId);
    }

    @Override
    public LoadBalancer getPrimaryInternetFacingLoadBalancer() throws IOException {
        if (this.primaryInternetFacingLoadBalancer == null) {
            this.loadCurrentPrimaryLoadBalancersIfAvailable();
        }
        return this.primaryInternetFacingLoadBalancer;
    }

    @Override
    public Map<String, Backend> listPrimaryInternetFacingLoadBalancerBackends() throws IOException {
        if (this.getPrimaryInternetFacingLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getBackendsAssociatedWithIpConfiguration(this.primaryInternetFacingLoadBalancer, this.primaryNicDefaultIPConfiguration());
        }
        return new HashMap<String, Backend>();
    }

    @Override
    public Map<String, InboundNatPool> listPrimaryInternetFacingLoadBalancerInboundNatPools() throws IOException {
        if (this.getPrimaryInternetFacingLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getInboundNatPoolsAssociatedWithIpConfiguration(this.primaryInternetFacingLoadBalancer, this.primaryNicDefaultIPConfiguration());
        }
        return new HashMap<String, InboundNatPool>();
    }

    @Override
    public LoadBalancer getPrimaryInternalLoadBalancer() throws IOException {
        if (this.primaryInternalLoadBalancer == null) {
            this.loadCurrentPrimaryLoadBalancersIfAvailable();
        }
        return this.primaryInternalLoadBalancer;
    }

    @Override
    public Map<String, Backend> listPrimaryInternalLoadBalancerBackends() throws IOException {
        if (this.getPrimaryInternalLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getBackendsAssociatedWithIpConfiguration(this.primaryInternalLoadBalancer, this.primaryNicDefaultIPConfiguration());
        }
        return new HashMap<String, Backend>();
    }

    @Override
    public Map<String, InboundNatPool> listPrimaryInternalLoadBalancerInboundNatPools() throws IOException {
        if (this.getPrimaryInternalLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getInboundNatPoolsAssociatedWithIpConfiguration(this.primaryInternalLoadBalancer, this.primaryNicDefaultIPConfiguration());
        }
        return new HashMap<String, InboundNatPool>();
    }

    @Override
    public List<String> primaryPublicIpAddressIds() throws IOException {
        LoadBalancer loadBalancer = this.getPrimaryInternetFacingLoadBalancer();
        if (loadBalancer != null) {
            return loadBalancer.publicIpAddressIds();
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> vhdContainers() {
        if (this.storageProfile() != null && this.storageProfile().osDisk() != null && this.storageProfile().osDisk().vhdContainers() != null) {
            return this.storageProfile().osDisk().vhdContainers();
        }
        return new ArrayList<String>();
    }

    @Override
    public VirtualMachineScaleSetStorageProfile storageProfile() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile();
    }

    @Override
    public VirtualMachineScaleSetNetworkProfile networkProfile() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().networkProfile();
    }

    @Override
    public Map<String, VirtualMachineScaleSetExtension> extensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    @Override
    public VirtualMachineScaleSetImpl withSku(VirtualMachineScaleSetSkuTypes skuType) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).withSku(skuType.sku());
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSku(VirtualMachineScaleSetSku sku) {
        return this.withSku(sku.skuType());
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingPrimaryNetworkSubnet(Network network, String subnetName) {
        this.existingPrimaryNetworkSubnetNameToAssociate = VirtualMachineScaleSetImpl.mergePath(network.id(), "subnets", subnetName);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternetFacingLoadBalancer(LoadBalancer loadBalancer) {
        if (loadBalancer.publicIpAddressIds().isEmpty()) {
            throw new IllegalArgumentException("Parameter loadBalancer must be an internet facing load balancer");
        }
        if (this.isInCreateMode()) {
            this.primaryInternetFacingLoadBalancer = loadBalancer;
            VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternetFacingLoadBalancer, this.primaryNicDefaultIPConfiguration());
        } else {
            this.primaryInternetFacingLoadBalancerToAttachOnUpdate = loadBalancer;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternetFacingLoadBalancerBackends(String ... backendNames) {
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIPConfigurationInner defaultPrimaryIpConfig = this.primaryNicDefaultIPConfiguration();
            VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), defaultPrimaryIpConfig, backendNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBBackendsToAddOnUpdate, backendNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternetFacingLoadBalancerInboundNatPools(String ... natPoolNames) {
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIPConfigurationInner defaultPrimaryIpConfig = this.primaryNicDefaultIPConfiguration();
            VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), defaultPrimaryIpConfig, natPoolNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate, natPoolNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternalLoadBalancer(LoadBalancer loadBalancer) {
        if (!loadBalancer.publicIpAddressIds().isEmpty()) {
            throw new IllegalArgumentException("Parameter loadBalancer must be an internal load balancer");
        }
        String lbNetworkId = null;
        for (Frontend frontEnd : loadBalancer.frontends().values()) {
            if (((FrontendIPConfigurationInner)frontEnd.inner()).subnet().id() == null) continue;
            lbNetworkId = ResourceUtils.parentResourcePathFromResourceId((String)((FrontendIPConfigurationInner)frontEnd.inner()).subnet().id());
        }
        if (this.isInCreateMode()) {
            String vmNICNetworkId = ResourceUtils.parentResourcePathFromResourceId((String)this.existingPrimaryNetworkSubnetNameToAssociate);
            if (!vmNICNetworkId.equalsIgnoreCase(lbNetworkId)) {
                throw new IllegalArgumentException("Virtual network associated with scale set virtual machines and internal load balancer must be same. '" + vmNICNetworkId + "'" + "'" + lbNetworkId);
            }
            this.primaryInternalLoadBalancer = loadBalancer;
            VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternalLoadBalancer, this.primaryNicDefaultIPConfiguration());
        } else {
            String vmNicVnetId = ResourceUtils.parentResourcePathFromResourceId((String)this.primaryNicDefaultIPConfiguration().subnet().id());
            if (!vmNicVnetId.equalsIgnoreCase(lbNetworkId)) {
                throw new IllegalArgumentException("Virtual network associated with scale set virtual machines and internal load balancer must be same. '" + vmNicVnetId + "'" + "'" + lbNetworkId);
            }
            this.primaryInternalLoadBalancerToAttachOnUpdate = loadBalancer;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternalLoadBalancerBackends(String ... backendNames) {
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIPConfigurationInner defaultPrimaryIpConfig = this.primaryNicDefaultIPConfiguration();
            VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternalLoadBalancer.id(), defaultPrimaryIpConfig, backendNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBBackendsToAddOnUpdate, backendNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternalLoadBalancerInboundNatPools(String ... natPoolNames) {
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIPConfigurationInner defaultPrimaryIpConfig = this.primaryNicDefaultIPConfiguration();
            VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternalLoadBalancer.id(), defaultPrimaryIpConfig, natPoolNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBInboundNatPoolsToAddOnUpdate, natPoolNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternalLoadBalancer() {
        if (this.isInUpdateMode()) {
            this.removePrimaryInternalLoadBalancerOnUpdate = true;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternetFacingLoadBalancer() {
        if (this.isInUpdateMode()) {
            this.removePrimaryInternetFacingLoadBalancerOnUpdate = true;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternetFacingLoadBalancerBackends(String ... backendNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBBackendsToRemoveOnUpdate, backendNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternalLoadBalancerBackends(String ... backendNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBBackendsToRemoveOnUpdate, backendNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternetFacingLoadBalancerNatPools(String ... natPoolNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBInboundNatPoolsToRemoveOnUpdate, natPoolNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternalLoadBalancerNatPools(String ... natPoolNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate, natPoolNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPopularWindowsImage(KnownWindowsVirtualMachineImage knownImage) {
        return this.withSpecificWindowsImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineScaleSetImpl withLatestWindowsImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference().withPublisher(publisher).withOffer(offer).withSku(sku).withVersion("latest");
        return this.withSpecificWindowsImageVersion(imageReference);
    }

    @Override
    public VirtualMachineScaleSetImpl withSpecificWindowsImageVersion(ImageReference imageReference) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().withImageReference(imageReference);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withStoredWindowsImage(String imageUrl) {
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withOsType(OperatingSystemTypes.WINDOWS);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPopularLinuxImage(KnownLinuxVirtualMachineImage knownImage) {
        return this.withSpecificLinuxImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineScaleSetImpl withLatestLinuxImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference().withPublisher(publisher).withOffer(offer).withSku(sku).withVersion("latest");
        return this.withSpecificLinuxImageVersion(imageReference);
    }

    @Override
    public VirtualMachineScaleSetImpl withSpecificLinuxImageVersion(ImageReference imageReference) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().withImageReference(imageReference);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withLinuxConfiguration(new LinuxConfiguration());
        this.isMarketplaceLinuxImage = true;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withStoredLinuxImage(String imageUrl) {
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withOsType(OperatingSystemTypes.LINUX);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withLinuxConfiguration(new LinuxConfiguration());
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAdminUserName(String adminUserName) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withAdminUsername(adminUserName);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withRootUserName(String rootUserName) {
        return this.withAdminUserName(rootUserName);
    }

    @Override
    public VirtualMachineScaleSetImpl withPassword(String password) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withAdminPassword(password);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSsh(String publicKeyData) {
        VirtualMachineScaleSetOSProfile osProfile = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile();
        if (osProfile.linuxConfiguration().ssh() == null) {
            SshConfiguration sshConfiguration = new SshConfiguration();
            sshConfiguration.withPublicKeys(new ArrayList<SshPublicKey>());
            osProfile.linuxConfiguration().withSsh(sshConfiguration);
        }
        SshPublicKey sshPublicKey = new SshPublicKey();
        sshPublicKey.withKeyData(publicKeyData);
        sshPublicKey.withPath("/home/" + osProfile.adminUsername() + "/.ssh/authorized_keys");
        osProfile.linuxConfiguration().ssh().publicKeys().add(sshPublicKey);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVmAgent() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutVmAgent() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAutoUpdate() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutAutoUpdate() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withTimeZone(String timeZone) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withTimeZone(timeZone);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withWinRm(WinRMListener listener) {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().winRM() == null) {
            WinRMConfiguration winRMConfiguration = new WinRMConfiguration();
            ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withWinRM(winRMConfiguration);
        }
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().winRM().listeners().add(listener);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOsDiskCaching(CachingTypes cachingType) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCaching(cachingType);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOsDiskName(String name) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withName(name);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withComputerNamePrefix(String namePrefix) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withComputerNamePrefix(namePrefix);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withUpgradeMode(UpgradeMode upgradeMode) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).upgradePolicy().withMode(upgradeMode);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOverProvision(boolean enabled) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).withOverProvision(enabled);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOverProvisioning() {
        return this.withOverProvision(true);
    }

    @Override
    public VirtualMachineScaleSetImpl withoutOverProvisioning() {
        return this.withOverProvision(false);
    }

    @Override
    public VirtualMachineScaleSetImpl withCapacity(int capacity) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).sku().withCapacity(new Long(capacity));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewStorageAccount(String name) {
        StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(name)).withRegion(this.regionName());
        Creatable definitionAfterGroup = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return this.withNewStorageAccount(definitionAfterGroup);
    }

    @Override
    public VirtualMachineScaleSetImpl withNewStorageAccount(Creatable<StorageAccount> creatable) {
        this.creatableStorageAccountKeys.add(creatable.key());
        this.addCreatableDependency(creatable);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.existingStorageAccountsToAssociate.add(storageAccount);
        return this;
    }

    public VirtualMachineScaleSetExtensionImpl defineNewExtension(String name) {
        return new VirtualMachineScaleSetExtensionImpl(new VirtualMachineScaleSetExtensionInner().withName(name), this);
    }

    protected VirtualMachineScaleSetImpl withExtension(VirtualMachineScaleSetExtensionImpl extension) {
        this.extensions.put(extension.name(), extension);
        return this;
    }

    @Override
    public VirtualMachineScaleSetExtensionImpl updateExtension(String name) {
        return (VirtualMachineScaleSetExtensionImpl)this.extensions.get(name);
    }

    @Override
    public VirtualMachineScaleSetImpl withoutExtension(String name) {
        if (this.extensions.containsKey(name)) {
            this.extensions.remove(name);
        }
        return this;
    }

    protected void beforeCreating() {
        if (this.extensions.size() > 0) {
            ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().withExtensionProfile(new VirtualMachineScaleSetExtensionProfile()).extensionProfile().withExtensions(this.innersFromWrappers(this.extensions.values()));
        }
    }

    protected Observable<VirtualMachineScaleSetInner> createInner() {
        this.setOSDiskAndOSProfileDefaults();
        this.setPrimaryIpConfigurationSubnet();
        this.setPrimaryIpConfigurationBackendsAndInboundNatPools();
        return this.handleOSDiskContainersAsync().flatMap((Func1)new Func1<Void, Observable<VirtualMachineScaleSetInner>>(){

            public Observable<VirtualMachineScaleSetInner> call(Void aVoid) {
                return VirtualMachineScaleSetImpl.this.client.createOrUpdateAsync(VirtualMachineScaleSetImpl.this.resourceGroupName(), VirtualMachineScaleSetImpl.this.name(), (VirtualMachineScaleSetInner)((Object)VirtualMachineScaleSetImpl.this.inner()));
            }
        });
    }

    protected void afterCreating() {
        this.clearCachedProperties();
        this.initializeChildrenFromInner();
    }

    public VirtualMachineScaleSetImpl refresh() {
        VirtualMachineScaleSetInner inner = this.client.get(this.resourceGroupName(), this.name());
        this.setInner((Object)inner);
        this.clearCachedProperties();
        this.initializeChildrenFromInner();
        return this;
    }

    private boolean isInUpdateMode() {
        return !this.isInCreateMode();
    }

    private void setOSDiskAndOSProfileDefaults() {
        if (this.isInUpdateMode()) {
            return;
        }
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).sku().capacity() == null) {
            this.withCapacity(2);
        }
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).upgradePolicy() == null || ((VirtualMachineScaleSetInner)((Object)this.inner())).upgradePolicy().mode() == null) {
            ((VirtualMachineScaleSetInner)((Object)this.inner())).withUpgradePolicy(new UpgradePolicy().withMode(UpgradeMode.AUTOMATIC));
        }
        VirtualMachineScaleSetOSProfile osProfile = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile();
        if (this.osType() == OperatingSystemTypes.LINUX || this.isMarketplaceLinuxImage) {
            if (osProfile.linuxConfiguration() == null) {
                osProfile.withLinuxConfiguration(new LinuxConfiguration());
            }
            osProfile.linuxConfiguration().withDisablePasswordAuthentication(osProfile.adminPassword() == null);
        }
        if (this.osDiskCachingType() == null) {
            this.withOsDiskCaching(CachingTypes.READ_WRITE);
        }
        if (this.osDiskName() == null) {
            this.withOsDiskName(this.name() + "-os-disk");
        }
        if (this.computerNamePrefix() == null) {
            if (this.name().matches("[0-9]+")) {
                this.withComputerNamePrefix(ResourceNamer.randomResourceName((String)"vmss-vm", (int)12));
            } else if (this.name().length() <= 12) {
                this.withComputerNamePrefix(this.name() + "-vm");
            } else {
                this.withComputerNamePrefix(ResourceNamer.randomResourceName((String)"vmss-vm", (int)12));
            }
        }
    }

    private boolean isCustomImage(VirtualMachineScaleSetStorageProfile storageProfile) {
        return storageProfile.osDisk().image() != null && storageProfile.osDisk().image().uri() != null;
    }

    private Observable<Void> handleOSDiskContainersAsync() {
        Iterator<String> i$;
        final VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile();
        if (this.isCustomImage(storageProfile)) {
            storageProfile.osDisk().vhdContainers().clear();
            return Observable.just(null);
        }
        if (this.isInCreateMode() && this.creatableStorageAccountKeys.isEmpty() && this.existingStorageAccountsToAssociate.isEmpty()) {
            return ((StorageAccount.DefinitionStages.WithCreate)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(this.namer.randomName("stg", 24))).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName())).createAsync().map((Func1)new Func1<StorageAccount, Void>(){

                public Void call(StorageAccount storageAccount) {
                    String containerName = VirtualMachineScaleSetImpl.this.vhdContainerName;
                    if (containerName == null) {
                        containerName = "vhds";
                    }
                    storageProfile.osDisk().vhdContainers().add(VirtualMachineScaleSetImpl.mergePath(new String[]{storageAccount.endPoints().primary().blob(), containerName}));
                    VirtualMachineScaleSetImpl.this.vhdContainerName = null;
                    VirtualMachineScaleSetImpl.this.creatableStorageAccountKeys.clear();
                    VirtualMachineScaleSetImpl.this.existingStorageAccountsToAssociate.clear();
                    return null;
                }
            });
        }
        String containerName = this.vhdContainerName;
        if (containerName == null && (i$ = storageProfile.osDisk().vhdContainers().iterator()).hasNext()) {
            String containerUrl = i$.next();
            containerName = containerUrl.substring(containerUrl.lastIndexOf("/") + 1);
        }
        if (containerName == null) {
            containerName = "vhds";
        }
        for (String storageAccountKey : this.creatableStorageAccountKeys) {
            StorageAccount storageAccount = (StorageAccount)this.createdResource(storageAccountKey);
            storageProfile.osDisk().vhdContainers().add(VirtualMachineScaleSetImpl.mergePath(storageAccount.endPoints().primary().blob(), containerName));
        }
        for (StorageAccount storageAccount : this.existingStorageAccountsToAssociate) {
            storageProfile.osDisk().vhdContainers().add(VirtualMachineScaleSetImpl.mergePath(storageAccount.endPoints().primary().blob(), containerName));
        }
        this.vhdContainerName = null;
        this.creatableStorageAccountKeys.clear();
        this.existingStorageAccountsToAssociate.clear();
        return Observable.just(null);
    }

    private void setPrimaryIpConfigurationSubnet() {
        if (this.isInUpdateMode()) {
            return;
        }
        VirtualMachineScaleSetIPConfigurationInner ipConfig = this.primaryNicDefaultIPConfiguration();
        ipConfig.withSubnet(new ApiEntityReference().withId(this.existingPrimaryNetworkSubnetNameToAssociate));
        this.existingPrimaryNetworkSubnetNameToAssociate = null;
    }

    private void setPrimaryIpConfigurationBackendsAndInboundNatPools() {
        if (this.isInCreateMode()) {
            return;
        }
        try {
            this.loadCurrentPrimaryLoadBalancersIfAvailable();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        VirtualMachineScaleSetIPConfigurationInner primaryIpConfig = this.primaryNicDefaultIPConfiguration();
        if (this.primaryInternetFacingLoadBalancer != null) {
            VirtualMachineScaleSetImpl.removeBackendsFromIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBBackendsToRemoveOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBBackendsToAddOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.removeInboundNatPoolsFromIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
        }
        if (this.primaryInternalLoadBalancer != null) {
            VirtualMachineScaleSetImpl.removeBackendsFromIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBBackendsToRemoveOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBBackendsToAddOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.removeInboundNatPoolsFromIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBInboundNatPoolsToRemoveOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
        }
        if (this.removePrimaryInternetFacingLoadBalancerOnUpdate && this.primaryInternetFacingLoadBalancer != null) {
            VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, primaryIpConfig);
        }
        if (this.removePrimaryInternalLoadBalancerOnUpdate && this.primaryInternalLoadBalancer != null) {
            VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, primaryIpConfig);
        }
        if (this.primaryInternetFacingLoadBalancerToAttachOnUpdate != null) {
            if (this.primaryInternetFacingLoadBalancer != null) {
                VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, primaryIpConfig);
            }
            VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate, primaryIpConfig);
            if (!this.primaryInternetFacingLBBackendsToAddOnUpdate.isEmpty()) {
                VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate, primaryIpConfig);
                VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternetFacingLBBackendsToAddOnUpdate.toArray(new String[0]));
            }
            if (!this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.isEmpty()) {
                VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate, primaryIpConfig);
                VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
            }
        }
        if (this.primaryInternalLoadBalancerToAttachOnUpdate != null) {
            if (this.primaryInternalLoadBalancer != null) {
                VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, primaryIpConfig);
            }
            VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate, primaryIpConfig);
            if (!this.primaryInternalLBBackendsToAddOnUpdate.isEmpty()) {
                VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate, primaryIpConfig);
                VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternalLBBackendsToAddOnUpdate.toArray(new String[0]));
            }
            if (!this.primaryInternalLBInboundNatPoolsToAddOnUpdate.isEmpty()) {
                VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate, primaryIpConfig);
                VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternalLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
            }
        }
        this.removePrimaryInternetFacingLoadBalancerOnUpdate = false;
        this.removePrimaryInternalLoadBalancerOnUpdate = false;
        this.primaryInternetFacingLoadBalancerToAttachOnUpdate = null;
        this.primaryInternalLoadBalancerToAttachOnUpdate = null;
        this.primaryInternetFacingLBBackendsToRemoveOnUpdate.clear();
        this.primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate.clear();
        this.primaryInternalLBBackendsToRemoveOnUpdate.clear();
        this.primaryInternalLBInboundNatPoolsToRemoveOnUpdate.clear();
        this.primaryInternetFacingLBBackendsToAddOnUpdate.clear();
        this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.clear();
        this.primaryInternalLBBackendsToAddOnUpdate.clear();
        this.primaryInternalLBInboundNatPoolsToAddOnUpdate.clear();
    }

    private void clearCachedProperties() {
        this.primaryInternetFacingLoadBalancer = null;
        this.primaryInternalLoadBalancer = null;
    }

    private void loadCurrentPrimaryLoadBalancersIfAvailable() throws IOException {
        if (this.primaryInternetFacingLoadBalancer != null && this.primaryInternalLoadBalancer != null) {
            return;
        }
        String firstLoadBalancerId = null;
        VirtualMachineScaleSetIPConfigurationInner ipConfig = this.primaryNicDefaultIPConfiguration();
        if (!ipConfig.loadBalancerBackendAddressPools().isEmpty()) {
            firstLoadBalancerId = ResourceUtils.parentResourcePathFromResourceId((String)ipConfig.loadBalancerBackendAddressPools().get(0).id());
        }
        if (firstLoadBalancerId == null && !ipConfig.loadBalancerInboundNatPools().isEmpty()) {
            firstLoadBalancerId = ResourceUtils.parentResourcePathFromResourceId((String)ipConfig.loadBalancerInboundNatPools().get(0).id());
        }
        if (firstLoadBalancerId == null) {
            return;
        }
        LoadBalancer loadBalancer1 = (LoadBalancer)this.networkManager.loadBalancers().getById(firstLoadBalancerId);
        if (loadBalancer1.publicIpAddressIds() != null && loadBalancer1.publicIpAddressIds().size() > 0) {
            this.primaryInternetFacingLoadBalancer = loadBalancer1;
        } else {
            this.primaryInternalLoadBalancer = loadBalancer1;
        }
        String secondLoadBalancerId = null;
        for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
            if (subResource.id().toLowerCase().startsWith(firstLoadBalancerId.toLowerCase())) continue;
            secondLoadBalancerId = ResourceUtils.parentResourcePathFromResourceId((String)subResource.id());
            break;
        }
        if (secondLoadBalancerId == null) {
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (subResource.id().toLowerCase().startsWith(firstLoadBalancerId.toLowerCase())) continue;
                secondLoadBalancerId = ResourceUtils.parentResourcePathFromResourceId((String)subResource.id());
                break;
            }
        }
        if (secondLoadBalancerId == null) {
            return;
        }
        LoadBalancer loadBalancer2 = (LoadBalancer)this.networkManager.loadBalancers().getById(secondLoadBalancerId);
        if (loadBalancer2.publicIpAddressIds() != null && loadBalancer2.publicIpAddressIds().size() > 0) {
            this.primaryInternetFacingLoadBalancer = loadBalancer2;
        } else {
            this.primaryInternalLoadBalancer = loadBalancer2;
        }
    }

    private VirtualMachineScaleSetIPConfigurationInner primaryNicDefaultIPConfiguration() {
        List<VirtualMachineScaleSetNetworkConfigurationInner> nicConfigurations = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().networkProfile().networkInterfaceConfigurations();
        for (VirtualMachineScaleSetNetworkConfigurationInner nicConfiguration : nicConfigurations) {
            if (!nicConfiguration.primary().booleanValue() || nicConfiguration.ipConfigurations().size() <= 0) continue;
            VirtualMachineScaleSetIPConfigurationInner ipConfig = nicConfiguration.ipConfigurations().get(0);
            if (ipConfig.loadBalancerBackendAddressPools() == null) {
                ipConfig.withLoadBalancerBackendAddressPools(new ArrayList<SubResource>());
            }
            if (ipConfig.loadBalancerInboundNatPools() == null) {
                ipConfig.withLoadBalancerInboundNatPools(new ArrayList<SubResource>());
            }
            return ipConfig;
        }
        throw new RuntimeException("Could not find the primary nic configuration or an IP configuration in it");
    }

    private static void associateBackEndsToIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIPConfigurationInner ipConfig, String ... backendNames) {
        ArrayList<SubResource> backendSubResourcesToAssociate = new ArrayList<SubResource>();
        for (String backendName : backendNames) {
            String backendPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "backendAddressPools", backendName);
            boolean found = false;
            for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
                if (!subResource.id().equalsIgnoreCase(backendPoolId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            backendSubResourcesToAssociate.add(new SubResource().withId(backendPoolId));
        }
        for (SubResource backendSubResource : backendSubResourcesToAssociate) {
            ipConfig.loadBalancerBackendAddressPools().add(backendSubResource);
        }
    }

    private static void associateInboundNATPoolsToIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIPConfigurationInner ipConfig, String ... inboundNatPools) {
        ArrayList<SubResource> inboundNatPoolSubResourcesToAssociate = new ArrayList<SubResource>();
        for (String inboundNatPool : inboundNatPools) {
            String inboundNatPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "inboundNatPools", inboundNatPool);
            boolean found = false;
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (!subResource.id().equalsIgnoreCase(inboundNatPoolId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            inboundNatPoolSubResourcesToAssociate.add(new SubResource().withId(inboundNatPoolId));
        }
        for (SubResource backendSubResource : inboundNatPoolSubResourcesToAssociate) {
            ipConfig.loadBalancerInboundNatPools().add(backendSubResource);
        }
    }

    private static Map<String, Backend> getBackendsAssociatedWithIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfigurationInner ipConfig) {
        String loadBalancerId = loadBalancer.id();
        HashMap<String, Backend> attachedBackends = new HashMap<String, Backend>();
        Map lbBackends = loadBalancer.backends();
        for (Backend lbBackend : lbBackends.values()) {
            String backendId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "backendAddressPools", lbBackend.name());
            for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
                if (!subResource.id().equalsIgnoreCase(backendId)) continue;
                attachedBackends.put(lbBackend.name(), lbBackend);
            }
        }
        return attachedBackends;
    }

    private static Map<String, InboundNatPool> getInboundNatPoolsAssociatedWithIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfigurationInner ipConfig) {
        String loadBalancerId = loadBalancer.id();
        HashMap<String, InboundNatPool> attachedInboundNatPools = new HashMap<String, InboundNatPool>();
        Map lbInboundNatPools = loadBalancer.inboundNatPools();
        for (InboundNatPool lbInboundNatPool : lbInboundNatPools.values()) {
            String inboundNatPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "inboundNatPools", lbInboundNatPool.name());
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (!subResource.id().equalsIgnoreCase(inboundNatPoolId)) continue;
                attachedInboundNatPools.put(lbInboundNatPool.name(), lbInboundNatPool);
            }
        }
        return attachedInboundNatPools;
    }

    private static void associateLoadBalancerToIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfigurationInner ipConfig) {
        Collection backends = loadBalancer.backends().values();
        String[] backendNames = new String[backends.size()];
        int i = 0;
        for (Backend backend : backends) {
            backendNames[i] = backend.name();
            ++i;
        }
        VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(loadBalancer.id(), ipConfig, backendNames);
        Collection inboundNatPools = loadBalancer.inboundNatPools().values();
        String[] natPoolNames = new String[inboundNatPools.size()];
        i = 0;
        for (InboundNatPool inboundNatPool : inboundNatPools) {
            natPoolNames[i] = inboundNatPool.name();
            ++i;
        }
        VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(loadBalancer.id(), ipConfig, natPoolNames);
    }

    private static void removeLoadBalancerAssociationFromIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfigurationInner ipConfig) {
        VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(loadBalancer, ipConfig);
        VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(loadBalancer, ipConfig);
    }

    private static void removeAllBackendAssociationFromIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfigurationInner ipConfig) {
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
            if (!subResource.id().toLowerCase().startsWith(loadBalancer.id().toLowerCase() + "/")) continue;
            toRemove.add(subResource);
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerBackendAddressPools().remove(subResource);
        }
    }

    private static void removeAllInboundNatPoolAssociationFromIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfigurationInner ipConfig) {
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
            if (!subResource.id().toLowerCase().startsWith(loadBalancer.id().toLowerCase() + "/")) continue;
            toRemove.add(subResource);
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerInboundNatPools().remove(subResource);
        }
    }

    private static void removeBackendsFromIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIPConfigurationInner ipConfig, String ... backendNames) {
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        block0: for (String backendName : backendNames) {
            String backendPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "backendAddressPools", backendName);
            for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
                if (!subResource.id().equalsIgnoreCase(backendPoolId)) continue;
                toRemove.add(subResource);
                continue block0;
            }
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerBackendAddressPools().remove(subResource);
        }
    }

    private static void removeInboundNatPoolsFromIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIPConfigurationInner ipConfig, String ... inboundNatPoolNames) {
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        block0: for (String natPoolName : inboundNatPoolNames) {
            String inboundNatPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "inboundNatPools", natPoolName);
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (!subResource.id().equalsIgnoreCase(inboundNatPoolId)) continue;
                toRemove.add(subResource);
                continue block0;
            }
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerInboundNatPools().remove(subResource);
        }
    }

    private static <T> void addToList(List<T> list, T ... items) {
        for (T item : items) {
            list.add(item);
        }
    }

    private static String mergePath(String ... segments) {
        StringBuilder builder = new StringBuilder();
        for (String segment : segments) {
            while (segment.length() > 1 && segment.endsWith("/")) {
                segment = segment.substring(0, segment.length() - 1);
            }
            if (segment.length() <= 0) continue;
            builder.append(segment);
            builder.append("/");
        }
        String merged = builder.toString();
        if (merged.endsWith("/")) {
            merged = merged.substring(0, merged.length() - 1);
        }
        return merged;
    }
}

