/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.VirtualMachineScaleSet;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetNetworkProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetOSDisk;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetOSProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetStorageProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetVMProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSets;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetIPConfigurationInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetNetworkConfigurationInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetsInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.ArrayList;
import rx.Observable;

@LangDefinition
public class VirtualMachineScaleSetsImpl
extends GroupableResourcesImpl<VirtualMachineScaleSet, VirtualMachineScaleSetImpl, VirtualMachineScaleSetInner, VirtualMachineScaleSetsInner, ComputeManager>
implements VirtualMachineScaleSets {
    private final StorageManager storageManager;
    private final NetworkManager networkManager;

    VirtualMachineScaleSetsImpl(VirtualMachineScaleSetsInner client, ComputeManager computeManager, StorageManager storageManager, NetworkManager networkManager) {
        super((Object)client, (ManagerBase)computeManager);
        this.storageManager = storageManager;
        this.networkManager = networkManager;
    }

    public VirtualMachineScaleSet getByGroup(String groupName, String name) {
        return this.wrapModel(((VirtualMachineScaleSetsInner)this.innerCollection).get(groupName, name));
    }

    public PagedList<VirtualMachineScaleSet> listByGroup(String groupName) {
        return this.wrapList(((VirtualMachineScaleSetsInner)this.innerCollection).list(groupName));
    }

    public PagedList<VirtualMachineScaleSet> list() {
        return this.wrapList(((VirtualMachineScaleSetsInner)this.innerCollection).listAll());
    }

    public Observable<Void> deleteAsync(String groupName, String name) {
        return ((VirtualMachineScaleSetsInner)this.innerCollection).deleteAsync(groupName, name);
    }

    @Override
    public void deallocate(String groupName, String name) {
        ((VirtualMachineScaleSetsInner)this.innerCollection).deallocate(groupName, name);
    }

    @Override
    public void powerOff(String groupName, String name) {
        ((VirtualMachineScaleSetsInner)this.innerCollection).powerOff(groupName, name);
    }

    @Override
    public void restart(String groupName, String name) {
        ((VirtualMachineScaleSetsInner)this.innerCollection).restart(groupName, name);
    }

    @Override
    public void start(String groupName, String name) {
        ((VirtualMachineScaleSetsInner)this.innerCollection).start(groupName, name);
    }

    @Override
    public void reimage(String groupName, String name) {
        ((VirtualMachineScaleSetsInner)this.innerCollection).reimage(groupName, name);
    }

    public VirtualMachineScaleSetImpl define(String name) {
        return this.wrapModel(name);
    }

    protected VirtualMachineScaleSetImpl wrapModel(String name) {
        VirtualMachineScaleSetInner inner = new VirtualMachineScaleSetInner();
        inner.withVirtualMachineProfile(new VirtualMachineScaleSetVMProfile());
        inner.virtualMachineProfile().withStorageProfile(new VirtualMachineScaleSetStorageProfile().withOsDisk(new VirtualMachineScaleSetOSDisk().withVhdContainers(new ArrayList<String>())));
        inner.virtualMachineProfile().withOsProfile(new VirtualMachineScaleSetOSProfile());
        inner.virtualMachineProfile().withNetworkProfile(new VirtualMachineScaleSetNetworkProfile());
        inner.virtualMachineProfile().networkProfile().withNetworkInterfaceConfigurations(new ArrayList<VirtualMachineScaleSetNetworkConfigurationInner>());
        VirtualMachineScaleSetNetworkConfigurationInner primaryNetworkInterfaceConfiguration = new VirtualMachineScaleSetNetworkConfigurationInner().withPrimary(true).withName("primary-nic-cfg").withIpConfigurations(new ArrayList<VirtualMachineScaleSetIPConfigurationInner>());
        primaryNetworkInterfaceConfiguration.ipConfigurations().add(new VirtualMachineScaleSetIPConfigurationInner().withName("primary-nic-ip-cfg"));
        inner.virtualMachineProfile().networkProfile().networkInterfaceConfigurations().add(primaryNetworkInterfaceConfiguration);
        return new VirtualMachineScaleSetImpl(name, inner, (VirtualMachineScaleSetsInner)this.innerCollection, (ComputeManager)this.myManager, this.storageManager, this.networkManager);
    }

    protected VirtualMachineScaleSetImpl wrapModel(VirtualMachineScaleSetInner inner) {
        return new VirtualMachineScaleSetImpl(inner.name(), inner, (VirtualMachineScaleSetsInner)this.innerCollection, (ComputeManager)this.myManager, this.storageManager, this.networkManager);
    }
}

