/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.DataDisk;
import com.microsoft.azure.management.compute.HardwareProfile;
import com.microsoft.azure.management.compute.NetworkProfile;
import com.microsoft.azure.management.compute.OSDisk;
import com.microsoft.azure.management.compute.OSProfile;
import com.microsoft.azure.management.compute.StorageProfile;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineSizes;
import com.microsoft.azure.management.compute.VirtualMachines;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.NetworkInterfaceReferenceInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineCaptureParametersInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineCaptureResultInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizesImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizesInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachinesInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.ArrayList;
import rx.Observable;
import rx.exceptions.Exceptions;

@LangDefinition
class VirtualMachinesImpl
extends GroupableResourcesImpl<VirtualMachine, VirtualMachineImpl, VirtualMachineInner, VirtualMachinesInner, ComputeManager>
implements VirtualMachines {
    private final StorageManager storageManager;
    private final NetworkManager networkManager;
    private final VirtualMachineSizesImpl vmSizes;
    private final VirtualMachineExtensionsInner virtualMachineExtensionsClient;

    VirtualMachinesImpl(VirtualMachinesInner client, VirtualMachineExtensionsInner virtualMachineExtensionsClient, VirtualMachineSizesInner virtualMachineSizesClient, ComputeManager computeManager, StorageManager storageManager, NetworkManager networkManager) {
        super((Object)client, (ManagerBase)computeManager);
        this.virtualMachineExtensionsClient = virtualMachineExtensionsClient;
        this.storageManager = storageManager;
        this.networkManager = networkManager;
        this.vmSizes = new VirtualMachineSizesImpl(virtualMachineSizesClient);
    }

    public PagedList<VirtualMachine> list() {
        return this.wrapList(((VirtualMachinesInner)this.innerCollection).listAll());
    }

    public PagedList<VirtualMachine> listByGroup(String groupName) {
        return this.wrapList(((VirtualMachinesInner)this.innerCollection).list(groupName));
    }

    public VirtualMachine getByGroup(String groupName, String name) {
        return this.wrapModel(((VirtualMachinesInner)this.innerCollection).get(groupName, name));
    }

    public Observable<Void> deleteAsync(String groupName, String name) {
        return ((VirtualMachinesInner)this.innerCollection).deleteAsync(groupName, name);
    }

    public VirtualMachine.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public void deallocate(String groupName, String name) {
        ((VirtualMachinesInner)this.innerCollection).deallocate(groupName, name);
    }

    @Override
    public void generalize(String groupName, String name) {
        ((VirtualMachinesInner)this.innerCollection).generalize(groupName, name);
    }

    @Override
    public void powerOff(String groupName, String name) {
        ((VirtualMachinesInner)this.innerCollection).powerOff(groupName, name);
    }

    @Override
    public void restart(String groupName, String name) {
        ((VirtualMachinesInner)this.innerCollection).restart(groupName, name);
    }

    @Override
    public void start(String groupName, String name) {
        ((VirtualMachinesInner)this.innerCollection).start(groupName, name);
    }

    @Override
    public void redeploy(String groupName, String name) {
        ((VirtualMachinesInner)this.innerCollection).redeploy(groupName, name);
    }

    @Override
    public String capture(String groupName, String name, String containerName, boolean overwriteVhd) {
        VirtualMachineCaptureParametersInner parameters = new VirtualMachineCaptureParametersInner();
        parameters.withDestinationContainerName(containerName);
        parameters.withOverwriteVhds(overwriteVhd);
        VirtualMachineCaptureResultInner captureResult = ((VirtualMachinesInner)this.innerCollection).capture(groupName, name, parameters);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(captureResult.output());
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public VirtualMachineSizes sizes() {
        return this.vmSizes;
    }

    protected VirtualMachineImpl wrapModel(String name) {
        VirtualMachineInner inner = new VirtualMachineInner();
        inner.withStorageProfile(new StorageProfile().withOsDisk(new OSDisk()).withDataDisks(new ArrayList<DataDisk>()));
        inner.withOsProfile(new OSProfile());
        inner.withHardwareProfile(new HardwareProfile());
        inner.withNetworkProfile(new NetworkProfile().withNetworkInterfaces(new ArrayList<NetworkInterfaceReferenceInner>()));
        return new VirtualMachineImpl(name, inner, (VirtualMachinesInner)this.innerCollection, this.virtualMachineExtensionsClient, (ComputeManager)this.myManager, this.storageManager, this.networkManager);
    }

    protected VirtualMachineImpl wrapModel(VirtualMachineInner virtualMachineInner) {
        return new VirtualMachineImpl(virtualMachineInner.name(), virtualMachineInner, (VirtualMachinesInner)this.innerCollection, this.virtualMachineExtensionsClient, (ComputeManager)this.myManager, this.storageManager, this.networkManager);
    }
}

