/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.compute.AvailabilitySet;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.DiagnosticsProfile;
import com.microsoft.azure.management.compute.Disk;
import com.microsoft.azure.management.compute.DiskEncryptionSettings;
import com.microsoft.azure.management.compute.ImageReference;
import com.microsoft.azure.management.compute.KnownLinuxVirtualMachineImage;
import com.microsoft.azure.management.compute.KnownWindowsVirtualMachineImage;
import com.microsoft.azure.management.compute.OSProfile;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.Plan;
import com.microsoft.azure.management.compute.PowerState;
import com.microsoft.azure.management.compute.PurchasePlan;
import com.microsoft.azure.management.compute.ResourceIdentityType;
import com.microsoft.azure.management.compute.RunCommandInput;
import com.microsoft.azure.management.compute.RunCommandInputParameter;
import com.microsoft.azure.management.compute.RunCommandResult;
import com.microsoft.azure.management.compute.StorageAccountTypes;
import com.microsoft.azure.management.compute.StorageProfile;
import com.microsoft.azure.management.compute.VirtualMachineDataDisk;
import com.microsoft.azure.management.compute.VirtualMachineEncryption;
import com.microsoft.azure.management.compute.VirtualMachineExtension;
import com.microsoft.azure.management.compute.VirtualMachineInstanceView;
import com.microsoft.azure.management.compute.VirtualMachineSize;
import com.microsoft.azure.management.compute.VirtualMachineSizeTypes;
import com.microsoft.azure.management.compute.VirtualMachineUnmanagedDataDisk;
import com.microsoft.azure.management.compute.WinRMListener;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.msi.Identity;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.model.HasNetworkInterfaces;
import com.microsoft.azure.management.resources.fluentcore.arm.AvailabilityZoneId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Completable;
import rx.Observable;

@Fluent
public interface VirtualMachine
extends GroupableResource<ComputeManager, VirtualMachineInner>,
Refreshable<VirtualMachine>,
Updatable<Update>,
HasNetworkInterfaces {
    public void deallocate();

    public Completable deallocateAsync();

    public ServiceFuture<Void> deallocateAsync(ServiceCallback<Void> var1);

    public void generalize();

    public Completable generalizeAsync();

    public ServiceFuture<Void> generalizeAsync(ServiceCallback<Void> var1);

    public void powerOff();

    public Completable powerOffAsync();

    public ServiceFuture<Void> powerOffAsync(ServiceCallback<Void> var1);

    public void restart();

    public Completable restartAsync();

    public ServiceFuture<Void> restartAsync(ServiceCallback<Void> var1);

    public void start();

    public Completable startAsync();

    public ServiceFuture<Void> startAsync(ServiceCallback<Void> var1);

    public void redeploy();

    public Completable redeployAsync();

    public ServiceFuture<Void> redeployAsync(ServiceCallback<Void> var1);

    public VirtualMachineEncryption diskEncryption();

    public void convertToManaged();

    public Completable convertToManagedAsync();

    public ServiceFuture<Void> convertToManagedAsync(ServiceCallback<Void> var1);

    @Method
    public PagedList<VirtualMachineSize> availableSizes();

    public String capture(String var1, String var2, boolean var3);

    public Observable<String> captureAsync(String var1, String var2, boolean var3);

    public ServiceFuture<String> captureAsync(String var1, String var2, boolean var3, ServiceCallback<String> var4);

    @Method
    public VirtualMachineInstanceView refreshInstanceView();

    @Method
    public Observable<VirtualMachineInstanceView> refreshInstanceViewAsync();

    @Beta(value=Beta.SinceVersion.V1_14_0)
    public RunCommandResult runPowerShellScript(String var1, String var2, List<String> var3, List<RunCommandInputParameter> var4);

    @Beta(value=Beta.SinceVersion.V1_14_0)
    public Observable<RunCommandResult> runPowerShellScriptAsync(List<String> var1, List<RunCommandInputParameter> var2);

    @Beta(value=Beta.SinceVersion.V1_14_0)
    public RunCommandResult runShellScript(List<String> var1, List<RunCommandInputParameter> var2);

    @Beta(value=Beta.SinceVersion.V1_14_0)
    public Observable<RunCommandResult> runShellScriptAsync(List<String> var1, List<RunCommandInputParameter> var2);

    @Beta(value=Beta.SinceVersion.V1_14_0)
    public RunCommandResult runCommand(RunCommandInput var1);

    @Beta(value=Beta.SinceVersion.V1_14_0)
    public Observable<RunCommandResult> runCommandAsync(RunCommandInput var1);

    public boolean isManagedDiskEnabled();

    public String computerName();

    public VirtualMachineSizeTypes size();

    public OperatingSystemTypes osType();

    public String osUnmanagedDiskVhdUri();

    public CachingTypes osDiskCachingType();

    public int osDiskSize();

    public StorageAccountTypes osDiskStorageAccountType();

    public String osDiskId();

    public Map<Integer, VirtualMachineUnmanagedDataDisk> unmanagedDataDisks();

    public Map<Integer, VirtualMachineDataDisk> dataDisks();

    public PublicIPAddress getPrimaryPublicIPAddress();

    public String getPrimaryPublicIPAddressId();

    public String availabilitySetId();

    public String provisioningState();

    public String licenseType();

    public Observable<VirtualMachineExtension> listExtensionsAsync();

    public Map<String, VirtualMachineExtension> listExtensions();

    public Plan plan();

    public StorageProfile storageProfile();

    public OSProfile osProfile();

    public DiagnosticsProfile diagnosticsProfile();

    public String vmId();

    public PowerState powerState();

    public VirtualMachineInstanceView instanceView();

    @Beta(value=Beta.SinceVersion.V1_3_0)
    public Set<AvailabilityZoneId> availabilityZones();

    public boolean isBootDiagnosticsEnabled();

    public String bootDiagnosticsStorageUri();

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public boolean isManagedServiceIdentityEnabled();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public String systemAssignedManagedServiceIdentityTenantId();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public String systemAssignedManagedServiceIdentityPrincipalId();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public ResourceIdentityType managedServiceIdentityType();

    @Beta(value=Beta.SinceVersion.V1_5_1)
    public Set<String> userAssignedManagedServiceIdentityIds();

    public static interface Update
    extends Appliable<VirtualMachine>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithUnmanagedDataDisk,
    UpdateStages.WithManagedDataDisk,
    UpdateStages.WithSecondaryNetworkInterface,
    UpdateStages.WithExtension,
    UpdateStages.WithBootDiagnostics,
    UpdateStages.WithSystemAssignedManagedServiceIdentity,
    UpdateStages.WithUserAssignedManagedServiceIdentity,
    UpdateStages.WithLicenseType {
        public Update withOSDiskEncryptionSettings(DiskEncryptionSettings var1);

        public Update withDataDiskDefaultCachingType(CachingTypes var1);

        public Update withDataDiskDefaultStorageAccountType(StorageAccountTypes var1);

        public Update withOSDiskCaching(CachingTypes var1);

        @Deprecated
        public Update withOSDiskSizeInGB(Integer var1);

        public Update withOSDiskSizeInGB(int var1);

        public Update withSize(String var1);

        public Update withSize(VirtualMachineSizeTypes var1);
    }

    public static interface UpdateStages {

        @Beta(value=Beta.SinceVersion.V1_14_0)
        public static interface WithLicenseType {
            @Beta(value=Beta.SinceVersion.V1_14_0)
            public Update withLicenseType(String var1);
        }

        @Beta(value=Beta.SinceVersion.V1_5_1)
        public static interface WithUserAssignedManagedServiceIdentity {
            @Beta(value=Beta.SinceVersion.V1_5_1)
            public Update withNewUserAssignedManagedServiceIdentity(Creatable<Identity> var1);

            @Beta(value=Beta.SinceVersion.V1_5_1)
            public Update withExistingUserAssignedManagedServiceIdentity(Identity var1);

            @Beta(value=Beta.SinceVersion.V1_5_1)
            public Update withoutUserAssignedManagedServiceIdentity(String var1);
        }

        @Beta(value=Beta.SinceVersion.V1_5_0)
        public static interface WithSystemAssignedIdentityBasedAccessOrUpdate
        extends Update {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithSystemAssignedIdentityBasedAccessOrUpdate withSystemAssignedIdentityBasedAccessTo(String var1, BuiltInRole var2);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithSystemAssignedIdentityBasedAccessOrUpdate withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithSystemAssignedIdentityBasedAccessOrUpdate withSystemAssignedIdentityBasedAccessTo(String var1, String var2);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithSystemAssignedIdentityBasedAccessOrUpdate withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String var1);
        }

        @Beta(value=Beta.SinceVersion.V1_5_0)
        public static interface WithSystemAssignedManagedServiceIdentity {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithSystemAssignedIdentityBasedAccessOrUpdate withSystemAssignedManagedServiceIdentity();

            @Beta(value=Beta.SinceVersion.V1_14_0)
            public Update withoutSystemAssignedManagedServiceIdentity();
        }

        public static interface WithBootDiagnostics {
            public Update withBootDiagnostics();

            public Update withBootDiagnostics(Creatable<StorageAccount> var1);

            public Update withBootDiagnostics(StorageAccount var1);

            public Update withBootDiagnostics(String var1);

            public Update withoutBootDiagnostics();
        }

        public static interface WithExtension {
            public VirtualMachineExtension.UpdateDefinitionStages.Blank<Update> defineNewExtension(String var1);

            public VirtualMachineExtension.Update updateExtension(String var1);

            public Update withoutExtension(String var1);
        }

        public static interface WithSecondaryNetworkInterface {
            public Update withNewSecondaryNetworkInterface(Creatable<NetworkInterface> var1);

            public Update withExistingSecondaryNetworkInterface(NetworkInterface var1);

            public Update withoutSecondaryNetworkInterface(String var1);
        }

        public static interface WithManagedDataDisk {
            public Update withNewDataDisk(Creatable<Disk> var1);

            public Update withNewDataDisk(Creatable<Disk> var1, int var2, CachingTypes var3);

            public Update withNewDataDisk(int var1);

            public Update withNewDataDisk(int var1, int var2, CachingTypes var3);

            public Update withNewDataDisk(int var1, int var2, CachingTypes var3, StorageAccountTypes var4);

            public Update withExistingDataDisk(Disk var1);

            public Update withExistingDataDisk(Disk var1, int var2, CachingTypes var3);

            public Update withExistingDataDisk(Disk var1, int var2, int var3, CachingTypes var4);

            public Update withoutDataDisk(int var1);
        }

        public static interface WithUnmanagedDataDisk {
            public Update withNewUnmanagedDataDisk(Integer var1);

            public Update withExistingUnmanagedDataDisk(String var1, String var2, String var3);

            public VirtualMachineUnmanagedDataDisk.UpdateDefinitionStages.Blank<Update> defineUnmanagedDataDisk(String var1);

            public VirtualMachineUnmanagedDataDisk.Update updateUnmanagedDataDisk(String var1);

            public Update withoutUnmanagedDataDisk(String var1);

            public Update withoutUnmanagedDataDisk(int var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<VirtualMachine>,
        Resource.DefinitionWithTags<WithCreate>,
        WithOSDiskSettings,
        WithVMSize,
        WithStorageAccount,
        WithAvailabilitySet,
        WithSecondaryNetworkInterface,
        WithExtension,
        WithPlan,
        WithBootDiagnostics,
        WithSystemAssignedManagedServiceIdentity,
        WithUserAssignedManagedServiceIdentity,
        WithLicenseType {
        }

        public static interface WithUnmanagedCreate
        extends WithUnmanagedDataDisk,
        WithCreate {
            public WithUnmanagedCreate withOSDiskVhdLocation(String var1, String var2);
        }

        public static interface WithManagedCreate
        extends WithManagedDataDisk,
        WithAvailabilityZone,
        WithCreate {
            public WithManagedCreate withOSDiskStorageAccountType(StorageAccountTypes var1);

            public WithManagedCreate withDataDiskDefaultCachingType(CachingTypes var1);

            public WithManagedCreate withDataDiskDefaultStorageAccountType(StorageAccountTypes var1);
        }

        @Beta(value=Beta.SinceVersion.V1_3_0)
        public static interface WithAvailabilityZone {
            @Beta(value=Beta.SinceVersion.V1_3_0)
            public WithManagedCreate withAvailabilityZone(AvailabilityZoneId var1);
        }

        @Beta(value=Beta.SinceVersion.V1_14_0)
        public static interface WithLicenseType {
            @Beta(value=Beta.SinceVersion.V1_14_0)
            public WithCreate withLicenseType(String var1);
        }

        @Beta(value=Beta.SinceVersion.V1_5_1)
        public static interface WithUserAssignedManagedServiceIdentity {
            @Beta(value=Beta.SinceVersion.V1_5_1)
            public WithCreate withNewUserAssignedManagedServiceIdentity(Creatable<Identity> var1);

            @Beta(value=Beta.SinceVersion.V1_5_1)
            public WithCreate withExistingUserAssignedManagedServiceIdentity(Identity var1);
        }

        @Beta(value=Beta.SinceVersion.V1_5_0)
        public static interface WithSystemAssignedIdentityBasedAccessOrCreate
        extends WithCreate {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessTo(String var1, BuiltInRole var2);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessTo(String var1, String var2);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String var1);
        }

        @Beta(value=Beta.SinceVersion.V1_5_0)
        public static interface WithSystemAssignedManagedServiceIdentity {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedManagedServiceIdentity();
        }

        public static interface WithBootDiagnostics {
            public WithCreate withBootDiagnostics();

            public WithCreate withBootDiagnostics(Creatable<StorageAccount> var1);

            public WithCreate withBootDiagnostics(StorageAccount var1);

            public WithCreate withBootDiagnostics(String var1);
        }

        public static interface WithPlan {
            public WithCreate withPlan(PurchasePlan var1);

            public WithCreate withPromotionalPlan(PurchasePlan var1, String var2);
        }

        public static interface WithExtension {
            public VirtualMachineExtension.DefinitionStages.Blank<WithCreate> defineNewExtension(String var1);
        }

        public static interface WithSecondaryNetworkInterface {
            public WithCreate withNewSecondaryNetworkInterface(Creatable<NetworkInterface> var1);

            public WithCreate withExistingSecondaryNetworkInterface(NetworkInterface var1);
        }

        public static interface WithStorageAccount {
            public WithCreate withNewStorageAccount(String var1);

            public WithCreate withNewStorageAccount(Creatable<StorageAccount> var1);

            public WithCreate withExistingStorageAccount(StorageAccount var1);
        }

        public static interface WithAvailabilitySet {
            public WithCreate withNewAvailabilitySet(String var1);

            public WithCreate withNewAvailabilitySet(Creatable<AvailabilitySet> var1);

            public WithCreate withExistingAvailabilitySet(AvailabilitySet var1);
        }

        public static interface WithManagedDataDisk {
            public WithManagedCreate withNewDataDisk(Creatable<Disk> var1);

            public WithManagedCreate withNewDataDisk(Creatable<Disk> var1, int var2, CachingTypes var3);

            public WithManagedCreate withNewDataDisk(int var1);

            public WithManagedCreate withNewDataDisk(int var1, int var2, CachingTypes var3);

            public WithManagedCreate withNewDataDisk(int var1, int var2, CachingTypes var3, StorageAccountTypes var4);

            public WithManagedCreate withExistingDataDisk(Disk var1);

            public WithManagedCreate withExistingDataDisk(Disk var1, int var2, CachingTypes var3);

            public WithManagedCreate withExistingDataDisk(Disk var1, int var2, int var3, CachingTypes var4);

            public WithManagedCreate withNewDataDiskFromImage(int var1);

            public WithManagedCreate withNewDataDiskFromImage(int var1, int var2, CachingTypes var3);

            public WithManagedCreate withNewDataDiskFromImage(int var1, int var2, CachingTypes var3, StorageAccountTypes var4);
        }

        public static interface WithUnmanagedDataDisk {
            public WithUnmanagedCreate withNewUnmanagedDataDisk(Integer var1);

            public WithUnmanagedCreate withExistingUnmanagedDataDisk(String var1, String var2, String var3);

            public VirtualMachineUnmanagedDataDisk.DefinitionStages.Blank<WithUnmanagedCreate> defineUnmanagedDataDisk(String var1);
        }

        public static interface WithVMSize {
            public WithCreate withSize(String var1);

            public WithCreate withSize(VirtualMachineSizeTypes var1);
        }

        public static interface WithOSDiskSettings {
            public WithCreate withOSDiskCaching(CachingTypes var1);

            public WithCreate withOSDiskEncryptionSettings(DiskEncryptionSettings var1);

            @Deprecated
            public WithCreate withOSDiskSizeInGB(Integer var1);

            public WithCreate withOSDiskSizeInGB(int var1);

            public WithCreate withOSDiskName(String var1);
        }

        public static interface WithWindowsCreateUnmanaged
        extends WithFromImageCreateOptionsUnmanaged {
            @Method
            public WithWindowsCreateUnmanaged withoutVMAgent();

            @Method
            public WithWindowsCreateUnmanaged withoutAutoUpdate();

            public WithWindowsCreateUnmanaged withTimeZone(String var1);

            public WithWindowsCreateUnmanaged withWinRM(WinRMListener var1);
        }

        public static interface WithWindowsCreateManaged
        extends WithFromImageCreateOptionsManaged {
            @Method
            public WithWindowsCreateManaged withoutVMAgent();

            @Method
            public WithWindowsCreateManaged withoutAutoUpdate();

            public WithWindowsCreateManaged withTimeZone(String var1);

            public WithWindowsCreateManaged withWinRM(WinRMListener var1);
        }

        public static interface WithWindowsCreateManagedOrUnmanaged
        extends WithWindowsCreateManaged {
            public WithWindowsCreateUnmanaged withUnmanagedDisks();
        }

        public static interface WithLinuxCreateUnmanaged
        extends WithFromImageCreateOptionsUnmanaged {
            public WithLinuxCreateUnmanaged withSsh(String var1);
        }

        public static interface WithLinuxCreateManaged
        extends WithFromImageCreateOptionsManaged {
            public WithLinuxCreateManaged withSsh(String var1);
        }

        public static interface WithLinuxCreateManagedOrUnmanaged
        extends WithFromImageCreateOptionsManagedOrUnmanaged {
            public WithLinuxCreateManagedOrUnmanaged withSsh(String var1);
        }

        public static interface WithFromImageCreateOptionsUnmanaged
        extends WithUnmanagedCreate {
            public WithFromImageCreateOptionsUnmanaged withCustomData(String var1);

            public WithFromImageCreateOptionsUnmanaged withComputerName(String var1);
        }

        public static interface WithFromImageCreateOptionsManaged
        extends WithManagedCreate {
            public WithFromImageCreateOptionsManaged withCustomData(String var1);

            public WithFromImageCreateOptionsManaged withComputerName(String var1);
        }

        public static interface WithFromImageCreateOptionsManagedOrUnmanaged
        extends WithFromImageCreateOptionsManaged {
            public WithFromImageCreateOptionsUnmanaged withUnmanagedDisks();
        }

        public static interface WithWindowsAdminPasswordUnmanaged {
            public WithWindowsCreateUnmanaged withAdminPassword(String var1);
        }

        public static interface WithWindowsAdminPasswordManaged {
            public WithWindowsCreateManaged withAdminPassword(String var1);
        }

        public static interface WithWindowsAdminPasswordManagedOrUnmanaged {
            public WithWindowsCreateManagedOrUnmanaged withAdminPassword(String var1);
        }

        public static interface WithWindowsAdminUsernameUnmanaged {
            public WithWindowsAdminPasswordUnmanaged withAdminUsername(String var1);
        }

        public static interface WithWindowsAdminUsernameManaged {
            public WithWindowsAdminPasswordManaged withAdminUsername(String var1);
        }

        public static interface WithWindowsAdminUsernameManagedOrUnmanaged {
            public WithWindowsAdminPasswordManagedOrUnmanaged withAdminUsername(String var1);
        }

        public static interface WithLinuxRootPasswordOrPublicKeyUnmanaged {
            public WithLinuxCreateUnmanaged withRootPassword(String var1);

            public WithLinuxCreateUnmanaged withSsh(String var1);
        }

        public static interface WithLinuxRootPasswordOrPublicKeyManaged {
            public WithLinuxCreateManaged withRootPassword(String var1);

            public WithLinuxCreateManaged withSsh(String var1);
        }

        public static interface WithLinuxRootPasswordOrPublicKeyManagedOrUnmanaged {
            public WithLinuxCreateManagedOrUnmanaged withRootPassword(String var1);

            public WithLinuxCreateManagedOrUnmanaged withSsh(String var1);
        }

        public static interface WithLinuxRootUsernameUnmanaged {
            public WithLinuxRootPasswordOrPublicKeyUnmanaged withRootUsername(String var1);
        }

        public static interface WithLinuxRootUsernameManaged {
            public WithLinuxRootPasswordOrPublicKeyManaged withRootUsername(String var1);
        }

        public static interface WithLinuxRootUsernameManagedOrUnmanaged {
            public WithLinuxRootPasswordOrPublicKeyManagedOrUnmanaged withRootUsername(String var1);
        }

        public static interface WithOS {
            public WithWindowsAdminUsernameManagedOrUnmanaged withPopularWindowsImage(KnownWindowsVirtualMachineImage var1);

            public WithWindowsAdminUsernameManagedOrUnmanaged withLatestWindowsImage(String var1, String var2, String var3);

            public WithWindowsAdminUsernameManagedOrUnmanaged withSpecificWindowsImageVersion(ImageReference var1);

            public WithWindowsAdminUsernameManaged withWindowsCustomImage(String var1);

            public WithWindowsAdminUsernameUnmanaged withStoredWindowsImage(String var1);

            public WithLinuxRootUsernameManagedOrUnmanaged withPopularLinuxImage(KnownLinuxVirtualMachineImage var1);

            public WithLinuxRootUsernameManagedOrUnmanaged withLatestLinuxImage(String var1, String var2, String var3);

            public WithLinuxRootUsernameManagedOrUnmanaged withSpecificLinuxImageVersion(ImageReference var1);

            public WithLinuxRootUsernameManaged withLinuxCustomImage(String var1);

            public WithLinuxRootUsernameUnmanaged withStoredLinuxImage(String var1);

            public WithUnmanagedCreate withSpecializedOSUnmanagedDisk(String var1, OperatingSystemTypes var2);

            public WithManagedCreate withSpecializedOSDisk(Disk var1, OperatingSystemTypes var2);
        }

        public static interface WithPrimaryNetworkInterface {
            public WithOS withNewPrimaryNetworkInterface(Creatable<NetworkInterface> var1);

            public WithOS withExistingPrimaryNetworkInterface(NetworkInterface var1);
        }

        public static interface WithPublicIPAddress {
            public WithOS withNewPrimaryPublicIPAddress(Creatable<PublicIPAddress> var1);

            public WithOS withNewPrimaryPublicIPAddress(String var1);

            public WithOS withExistingPrimaryPublicIPAddress(PublicIPAddress var1);

            public WithOS withoutPrimaryPublicIPAddress();
        }

        public static interface WithPrivateIP {
            public WithPublicIPAddress withPrimaryPrivateIPAddressDynamic();

            public WithPublicIPAddress withPrimaryPrivateIPAddressStatic(String var1);
        }

        public static interface WithSubnet {
            public WithPrivateIP withSubnet(String var1);
        }

        public static interface WithNetwork
        extends WithPrimaryNetworkInterface {
            public WithPrivateIP withNewPrimaryNetwork(Creatable<Network> var1);

            public WithPrivateIP withNewPrimaryNetwork(String var1);

            public WithSubnet withExistingPrimaryNetwork(Network var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithNetwork> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface DefinitionUnmanaged
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithNetwork,
    DefinitionStages.WithSubnet,
    DefinitionStages.WithPrivateIP,
    DefinitionStages.WithPublicIPAddress,
    DefinitionStages.WithPrimaryNetworkInterface,
    DefinitionStages.WithOS,
    DefinitionStages.WithLinuxRootUsernameUnmanaged,
    DefinitionStages.WithLinuxRootPasswordOrPublicKeyUnmanaged,
    DefinitionStages.WithWindowsAdminUsernameUnmanaged,
    DefinitionStages.WithWindowsAdminPasswordUnmanaged,
    DefinitionStages.WithFromImageCreateOptionsUnmanaged,
    DefinitionStages.WithLinuxCreateUnmanaged,
    DefinitionStages.WithWindowsCreateUnmanaged,
    DefinitionStages.WithUnmanagedCreate {
    }

    public static interface DefinitionManaged
    extends DefinitionShared,
    DefinitionStages.WithLinuxRootUsernameManaged,
    DefinitionStages.WithLinuxRootPasswordOrPublicKeyManaged,
    DefinitionStages.WithWindowsAdminUsernameManaged,
    DefinitionStages.WithWindowsAdminPasswordManaged,
    DefinitionStages.WithFromImageCreateOptionsManaged,
    DefinitionStages.WithLinuxCreateManaged,
    DefinitionStages.WithWindowsCreateManaged,
    DefinitionStages.WithManagedCreate {
    }

    public static interface DefinitionManagedOrUnmanaged
    extends DefinitionShared,
    DefinitionStages.WithLinuxRootUsernameManagedOrUnmanaged,
    DefinitionStages.WithLinuxRootPasswordOrPublicKeyManagedOrUnmanaged,
    DefinitionStages.WithWindowsAdminUsernameManagedOrUnmanaged,
    DefinitionStages.WithWindowsAdminPasswordManagedOrUnmanaged,
    DefinitionStages.WithFromImageCreateOptionsManagedOrUnmanaged,
    DefinitionStages.WithLinuxCreateManagedOrUnmanaged,
    DefinitionStages.WithWindowsCreateManagedOrUnmanaged,
    DefinitionStages.WithManagedCreate,
    DefinitionStages.WithUnmanagedCreate {
    }

    public static interface DefinitionShared
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithNetwork,
    DefinitionStages.WithSubnet,
    DefinitionStages.WithPrivateIP,
    DefinitionStages.WithPublicIPAddress,
    DefinitionStages.WithPrimaryNetworkInterface,
    DefinitionStages.WithOS,
    DefinitionStages.WithCreate {
    }
}

