/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * This is the disk image base class.
 */
public class GalleryDiskImage {
    /**
     * It indicates the size of the VHD to create.
     */
    @JsonProperty(value = "sizeInGB", access = JsonProperty.Access.WRITE_ONLY)
    private Integer sizeInGB;

    /**
     * The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     * 'ReadWrite'. Possible values include: 'None', 'ReadOnly', 'ReadWrite'.
     */
    @JsonProperty(value = "hostCaching", access = JsonProperty.Access.WRITE_ONLY)
    private HostCaching hostCaching;

    /**
     * Get it indicates the size of the VHD to create.
     *
     * @return the sizeInGB value
     */
    public Integer sizeInGB() {
        return this.sizeInGB;
    }

    /**
     * Get the host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'. Possible values include: 'None', 'ReadOnly', 'ReadWrite'.
     *
     * @return the hostCaching value
     */
    public HostCaching hostCaching() {
        return this.hostCaching;
    }

}
