/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * This is the gallery image identifier.
 */
public class GalleryImageIdentifier {
    /**
     * The gallery image publisher name.
     */
    @JsonProperty(value = "publisher")
    private String publisher;

    /**
     * The gallery image offer name.
     */
    @JsonProperty(value = "offer")
    private String offer;

    /**
     * The gallery image sku name.
     */
    @JsonProperty(value = "sku")
    private String sku;

    /**
     * Get the gallery image publisher name.
     *
     * @return the publisher value
     */
    public String publisher() {
        return this.publisher;
    }

    /**
     * Set the gallery image publisher name.
     *
     * @param publisher the publisher value to set
     * @return the GalleryImageIdentifier object itself.
     */
    public GalleryImageIdentifier withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    /**
     * Get the gallery image offer name.
     *
     * @return the offer value
     */
    public String offer() {
        return this.offer;
    }

    /**
     * Set the gallery image offer name.
     *
     * @param offer the offer value to set
     * @return the GalleryImageIdentifier object itself.
     */
    public GalleryImageIdentifier withOffer(String offer) {
        this.offer = offer;
        return this;
    }

    /**
     * Get the gallery image sku name.
     *
     * @return the sku value
     */
    public String sku() {
        return this.sku;
    }

    /**
     * Set the gallery image sku name.
     *
     * @param sku the sku value to set
     * @return the GalleryImageIdentifier object itself.
     */
    public GalleryImageIdentifier withSku(String sku) {
        this.sku = sku;
        return this;
    }

}
