/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.ReplicationStatusTypes;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in GalleryImageVersions.
 */
public class GalleryImageVersionsInner {
    /** The Retrofit service to perform REST calls. */
    private GalleryImageVersionsService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of GalleryImageVersionsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public GalleryImageVersionsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(GalleryImageVersionsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for GalleryImageVersions to be
     * used by Retrofit to perform actually REST calls.
     */
    interface GalleryImageVersionsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryImageName") String galleryImageName, @Path("galleryImageVersionName") String galleryImageVersionName, @Query("api-version") String apiVersion, @Body GalleryImageVersionInner galleryImageVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryImageName") String galleryImageName, @Path("galleryImageVersionName") String galleryImageVersionName, @Query("api-version") String apiVersion, @Body GalleryImageVersionInner galleryImageVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryImageName") String galleryImageName, @Path("galleryImageVersionName") String galleryImageVersionName, @Query("$expand") ReplicationStatusTypes expand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryImageName") String galleryImageName, @Path("galleryImageVersionName") String galleryImageVersionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryImageName") String galleryImageName, @Path("galleryImageVersionName") String galleryImageVersionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions listByGalleryImage" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions")
        Observable<Response<ResponseBody>> listByGalleryImage(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryImageName") String galleryImageName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions listByGalleryImageNext" })
        @GET
        Observable<Response<ResponseBody>> listByGalleryImageNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create or update a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryImageVersionInner object if successful.
     */
    public GalleryImageVersionInner createOrUpdate(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).toBlocking().last().body();
    }

    /**
     * Create or update a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryImageVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion, final ServiceCallback<GalleryImageVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion), serviceCallback);
    }

    /**
     * Create or update a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<GalleryImageVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).map(new Func1<ServiceResponse<GalleryImageVersionInner>, GalleryImageVersionInner>() {
            @Override
            public GalleryImageVersionInner call(ServiceResponse<GalleryImageVersionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<GalleryImageVersionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        if (galleryImageVersion == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersion is required and cannot be null.");
        }
        Validator.validate(galleryImageVersion);
        final String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, apiVersion, galleryImageVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryImageVersionInner>() { }.getType());
    }

    /**
     * Create or update a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryImageVersionInner object if successful.
     */
    public GalleryImageVersionInner beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).toBlocking().single().body();
    }

    /**
     * Create or update a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryImageVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion, final ServiceCallback<GalleryImageVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion), serviceCallback);
    }

    /**
     * Create or update a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryImageVersionInner object
     */
    public Observable<GalleryImageVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).map(new Func1<ServiceResponse<GalleryImageVersionInner>, GalleryImageVersionInner>() {
            @Override
            public GalleryImageVersionInner call(ServiceResponse<GalleryImageVersionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryImageVersion Parameters supplied to the create or update gallery image version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryImageVersionInner object
     */
    public Observable<ServiceResponse<GalleryImageVersionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        if (galleryImageVersion == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersion is required and cannot be null.");
        }
        Validator.validate(galleryImageVersion);
        final String apiVersion = "2018-06-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, apiVersion, galleryImageVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryImageVersionInner>>>() {
                @Override
                public Observable<ServiceResponse<GalleryImageVersionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GalleryImageVersionInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GalleryImageVersionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GalleryImageVersionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GalleryImageVersionInner>() { }.getType())
                .register(201, new TypeToken<GalleryImageVersionInner>() { }.getType())
                .register(202, new TypeToken<GalleryImageVersionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves information about a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryImageVersionInner object if successful.
     */
    public GalleryImageVersionInner get(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        return getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).toBlocking().single().body();
    }

    /**
     * Retrieves information about a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryImageVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, final ServiceCallback<GalleryImageVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName), serviceCallback);
    }

    /**
     * Retrieves information about a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryImageVersionInner object
     */
    public Observable<GalleryImageVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        return getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).map(new Func1<ServiceResponse<GalleryImageVersionInner>, GalleryImageVersionInner>() {
            @Override
            public GalleryImageVersionInner call(ServiceResponse<GalleryImageVersionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryImageVersionInner object
     */
    public Observable<ServiceResponse<GalleryImageVersionInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        final ReplicationStatusTypes expand = null;
        return service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryImageVersionInner>>>() {
                @Override
                public Observable<ServiceResponse<GalleryImageVersionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GalleryImageVersionInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves information about a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @param expand The expand expression to apply on the operation. Possible values include: 'ReplicationStatus'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryImageVersionInner object if successful.
     */
    public GalleryImageVersionInner get(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand) {
        return getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand).toBlocking().single().body();
    }

    /**
     * Retrieves information about a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @param expand The expand expression to apply on the operation. Possible values include: 'ReplicationStatus'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryImageVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand, final ServiceCallback<GalleryImageVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand), serviceCallback);
    }

    /**
     * Retrieves information about a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @param expand The expand expression to apply on the operation. Possible values include: 'ReplicationStatus'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryImageVersionInner object
     */
    public Observable<GalleryImageVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand) {
        return getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand).map(new Func1<ServiceResponse<GalleryImageVersionInner>, GalleryImageVersionInner>() {
            @Override
            public GalleryImageVersionInner call(ServiceResponse<GalleryImageVersionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @param expand The expand expression to apply on the operation. Possible values include: 'ReplicationStatus'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryImageVersionInner object
     */
    public Observable<ServiceResponse<GalleryImageVersionInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryImageVersionInner>>>() {
                @Override
                public Observable<ServiceResponse<GalleryImageVersionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GalleryImageVersionInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GalleryImageVersionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GalleryImageVersionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GalleryImageVersionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).toBlocking().last().body();
    }

    /**
     * Delete a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName), serviceCallback);
    }

    /**
     * Delete a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        return deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Delete a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).toBlocking().single().body();
    }

    /**
     * Delete a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName), serviceCallback);
    }

    /**
     * Delete a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a gallery image version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param galleryImageVersionName The name of the gallery image version.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List gallery image versions under a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;GalleryImageVersionInner&gt; object if successful.
     */
    public PagedList<GalleryImageVersionInner> listByGalleryImage(final String resourceGroupName, final String galleryName, final String galleryImageName) {
        ServiceResponse<Page<GalleryImageVersionInner>> response = listByGalleryImageSinglePageAsync(resourceGroupName, galleryName, galleryImageName).toBlocking().single();
        return new PagedList<GalleryImageVersionInner>(response.body()) {
            @Override
            public Page<GalleryImageVersionInner> nextPage(String nextPageLink) {
                return listByGalleryImageNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List gallery image versions under a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GalleryImageVersionInner>> listByGalleryImageAsync(final String resourceGroupName, final String galleryName, final String galleryImageName, final ListOperationCallback<GalleryImageVersionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByGalleryImageSinglePageAsync(resourceGroupName, galleryName, galleryImageName),
            new Func1<String, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(String nextPageLink) {
                    return listByGalleryImageNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List gallery image versions under a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryImageVersionInner&gt; object
     */
    public Observable<Page<GalleryImageVersionInner>> listByGalleryImageAsync(final String resourceGroupName, final String galleryName, final String galleryImageName) {
        return listByGalleryImageWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName)
            .map(new Func1<ServiceResponse<Page<GalleryImageVersionInner>>, Page<GalleryImageVersionInner>>() {
                @Override
                public Page<GalleryImageVersionInner> call(ServiceResponse<Page<GalleryImageVersionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List gallery image versions under a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the gallery.
     * @param galleryImageName The name of the gallery image.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryImageVersionInner&gt; object
     */
    public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> listByGalleryImageWithServiceResponseAsync(final String resourceGroupName, final String galleryName, final String galleryImageName) {
        return listByGalleryImageSinglePageAsync(resourceGroupName, galleryName, galleryImageName)
            .concatMap(new Func1<ServiceResponse<Page<GalleryImageVersionInner>>, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(ServiceResponse<Page<GalleryImageVersionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByGalleryImageNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List gallery image versions under a gallery image.
     *
    ServiceResponse<PageImpl1<GalleryImageVersionInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl1<GalleryImageVersionInner>> * @param galleryName The name of the gallery.
    ServiceResponse<PageImpl1<GalleryImageVersionInner>> * @param galleryImageName The name of the gallery image.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;GalleryImageVersionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> listByGalleryImageSinglePageAsync(final String resourceGroupName, final String galleryName, final String galleryImageName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.listByGalleryImage(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<GalleryImageVersionInner>> result = listByGalleryImageDelegate(response);
                        return Observable.just(new ServiceResponse<Page<GalleryImageVersionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<GalleryImageVersionInner>> listByGalleryImageDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<GalleryImageVersionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<GalleryImageVersionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List gallery image versions under a gallery image.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;GalleryImageVersionInner&gt; object if successful.
     */
    public PagedList<GalleryImageVersionInner> listByGalleryImageNext(final String nextPageLink) {
        ServiceResponse<Page<GalleryImageVersionInner>> response = listByGalleryImageNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GalleryImageVersionInner>(response.body()) {
            @Override
            public Page<GalleryImageVersionInner> nextPage(String nextPageLink) {
                return listByGalleryImageNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List gallery image versions under a gallery image.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GalleryImageVersionInner>> listByGalleryImageNextAsync(final String nextPageLink, final ServiceFuture<List<GalleryImageVersionInner>> serviceFuture, final ListOperationCallback<GalleryImageVersionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByGalleryImageNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(String nextPageLink) {
                    return listByGalleryImageNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List gallery image versions under a gallery image.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryImageVersionInner&gt; object
     */
    public Observable<Page<GalleryImageVersionInner>> listByGalleryImageNextAsync(final String nextPageLink) {
        return listByGalleryImageNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<GalleryImageVersionInner>>, Page<GalleryImageVersionInner>>() {
                @Override
                public Page<GalleryImageVersionInner> call(ServiceResponse<Page<GalleryImageVersionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List gallery image versions under a gallery image.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryImageVersionInner&gt; object
     */
    public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> listByGalleryImageNextWithServiceResponseAsync(final String nextPageLink) {
        return listByGalleryImageNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<GalleryImageVersionInner>>, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(ServiceResponse<Page<GalleryImageVersionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByGalleryImageNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List gallery image versions under a gallery image.
     *
    ServiceResponse<PageImpl1<GalleryImageVersionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;GalleryImageVersionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> listByGalleryImageNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByGalleryImageNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<GalleryImageVersionInner>> result = listByGalleryImageNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<GalleryImageVersionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<GalleryImageVersionInner>> listByGalleryImageNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<GalleryImageVersionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<GalleryImageVersionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
