/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Api request input for LogAnalytics getRequestRateByInterval Api.
 */
public class RequestRateByIntervalInput extends LogAnalyticsInputBase {
    /**
     * Interval value in minutes used to create LogAnalytics call rate logs.
     * Possible values include: 'ThreeMins', 'FiveMins', 'ThirtyMins',
     * 'SixtyMins'.
     */
    @JsonProperty(value = "intervalLength", required = true)
    private IntervalInMins intervalLength;

    /**
     * Get interval value in minutes used to create LogAnalytics call rate logs. Possible values include: 'ThreeMins', 'FiveMins', 'ThirtyMins', 'SixtyMins'.
     *
     * @return the intervalLength value
     */
    public IntervalInMins intervalLength() {
        return this.intervalLength;
    }

    /**
     * Set interval value in minutes used to create LogAnalytics call rate logs. Possible values include: 'ThreeMins', 'FiveMins', 'ThirtyMins', 'SixtyMins'.
     *
     * @param intervalLength the intervalLength value to set
     * @return the RequestRateByIntervalInput object itself.
     */
    public RequestRateByIntervalInput withIntervalLength(IntervalInMins intervalLength) {
        this.intervalLength = intervalLength;
        return this;
    }

}
