/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.compute.implementation.AvailabilitySetsInner;
import com.microsoft.azure.management.compute.implementation.ContainerServicesInner;
import com.microsoft.azure.management.compute.implementation.DisksInner;
import com.microsoft.azure.management.compute.implementation.GalleriesInner;
import com.microsoft.azure.management.compute.implementation.GalleryImageVersionsInner;
import com.microsoft.azure.management.compute.implementation.GalleryImagesInner;
import com.microsoft.azure.management.compute.implementation.ImagesInner;
import com.microsoft.azure.management.compute.implementation.LogAnalyticsInner;
import com.microsoft.azure.management.compute.implementation.OperationsInner;
import com.microsoft.azure.management.compute.implementation.ProximityPlacementGroupsInner;
import com.microsoft.azure.management.compute.implementation.ResourceSkusInner;
import com.microsoft.azure.management.compute.implementation.SnapshotsInner;
import com.microsoft.azure.management.compute.implementation.UsagesInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionImagesInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImagesInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineRunCommandsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetExtensionsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetRollingUpgradesInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetVMsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizesInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachinesInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class ComputeManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private OperationsInner operations;
    private AvailabilitySetsInner availabilitySets;
    private ProximityPlacementGroupsInner proximityPlacementGroups;
    private VirtualMachineExtensionImagesInner virtualMachineExtensionImages;
    private VirtualMachineExtensionsInner virtualMachineExtensions;
    private VirtualMachineImagesInner virtualMachineImages;
    private UsagesInner usages;
    private VirtualMachinesInner virtualMachines;
    private VirtualMachineSizesInner virtualMachineSizes;
    private ImagesInner images;
    private VirtualMachineScaleSetsInner virtualMachineScaleSets;
    private VirtualMachineScaleSetExtensionsInner virtualMachineScaleSetExtensions;
    private VirtualMachineScaleSetRollingUpgradesInner virtualMachineScaleSetRollingUpgrades;
    private VirtualMachineScaleSetVMsInner virtualMachineScaleSetVMs;
    private LogAnalyticsInner logAnalytics;
    private VirtualMachineRunCommandsInner virtualMachineRunCommands;
    private ResourceSkusInner resourceSkus;
    private DisksInner disks;
    private SnapshotsInner snapshots;
    private GalleriesInner galleries;
    private GalleryImagesInner galleryImages;
    private GalleryImageVersionsInner galleryImageVersions;
    private ContainerServicesInner containerServices;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ComputeManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public ComputeManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public ComputeManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public ComputeManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public AvailabilitySetsInner availabilitySets() {
        return this.availabilitySets;
    }

    public ProximityPlacementGroupsInner proximityPlacementGroups() {
        return this.proximityPlacementGroups;
    }

    public VirtualMachineExtensionImagesInner virtualMachineExtensionImages() {
        return this.virtualMachineExtensionImages;
    }

    public VirtualMachineExtensionsInner virtualMachineExtensions() {
        return this.virtualMachineExtensions;
    }

    public VirtualMachineImagesInner virtualMachineImages() {
        return this.virtualMachineImages;
    }

    public UsagesInner usages() {
        return this.usages;
    }

    public VirtualMachinesInner virtualMachines() {
        return this.virtualMachines;
    }

    public VirtualMachineSizesInner virtualMachineSizes() {
        return this.virtualMachineSizes;
    }

    public ImagesInner images() {
        return this.images;
    }

    public VirtualMachineScaleSetsInner virtualMachineScaleSets() {
        return this.virtualMachineScaleSets;
    }

    public VirtualMachineScaleSetExtensionsInner virtualMachineScaleSetExtensions() {
        return this.virtualMachineScaleSetExtensions;
    }

    public VirtualMachineScaleSetRollingUpgradesInner virtualMachineScaleSetRollingUpgrades() {
        return this.virtualMachineScaleSetRollingUpgrades;
    }

    public VirtualMachineScaleSetVMsInner virtualMachineScaleSetVMs() {
        return this.virtualMachineScaleSetVMs;
    }

    public LogAnalyticsInner logAnalytics() {
        return this.logAnalytics;
    }

    public VirtualMachineRunCommandsInner virtualMachineRunCommands() {
        return this.virtualMachineRunCommands;
    }

    public ResourceSkusInner resourceSkus() {
        return this.resourceSkus;
    }

    public DisksInner disks() {
        return this.disks;
    }

    public SnapshotsInner snapshots() {
        return this.snapshots;
    }

    public GalleriesInner galleries() {
        return this.galleries;
    }

    public GalleryImagesInner galleryImages() {
        return this.galleryImages;
    }

    public GalleryImageVersionsInner galleryImageVersions() {
        return this.galleryImageVersions;
    }

    public ContainerServicesInner containerServices() {
        return this.containerServices;
    }

    public ComputeManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public ComputeManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public ComputeManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.availabilitySets = new AvailabilitySetsInner(this.restClient().retrofit(), this);
        this.proximityPlacementGroups = new ProximityPlacementGroupsInner(this.restClient().retrofit(), this);
        this.virtualMachineExtensionImages = new VirtualMachineExtensionImagesInner(this.restClient().retrofit(), this);
        this.virtualMachineExtensions = new VirtualMachineExtensionsInner(this.restClient().retrofit(), this);
        this.virtualMachineImages = new VirtualMachineImagesInner(this.restClient().retrofit(), this);
        this.usages = new UsagesInner(this.restClient().retrofit(), this);
        this.virtualMachines = new VirtualMachinesInner(this.restClient().retrofit(), this);
        this.virtualMachineSizes = new VirtualMachineSizesInner(this.restClient().retrofit(), this);
        this.images = new ImagesInner(this.restClient().retrofit(), this);
        this.virtualMachineScaleSets = new VirtualMachineScaleSetsInner(this.restClient().retrofit(), this);
        this.virtualMachineScaleSetExtensions = new VirtualMachineScaleSetExtensionsInner(this.restClient().retrofit(), this);
        this.virtualMachineScaleSetRollingUpgrades = new VirtualMachineScaleSetRollingUpgradesInner(this.restClient().retrofit(), this);
        this.virtualMachineScaleSetVMs = new VirtualMachineScaleSetVMsInner(this.restClient().retrofit(), this);
        this.logAnalytics = new LogAnalyticsInner(this.restClient().retrofit(), this);
        this.virtualMachineRunCommands = new VirtualMachineRunCommandsInner(this.restClient().retrofit(), this);
        this.resourceSkus = new ResourceSkusInner(this.restClient().retrofit(), this);
        this.disks = new DisksInner(this.restClient().retrofit(), this);
        this.snapshots = new SnapshotsInner(this.restClient().retrofit(), this);
        this.galleries = new GalleriesInner(this.restClient().retrofit(), this);
        this.galleryImages = new GalleryImagesInner(this.restClient().retrofit(), this);
        this.galleryImageVersions = new GalleryImageVersionsInner(this.restClient().retrofit(), this);
        this.containerServices = new ContainerServicesInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "ComputeManagementClient");
    }
}

