/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.DataDisk;
import com.microsoft.azure.management.compute.DiagnosticsProfile;
import com.microsoft.azure.management.compute.ImageReference;
import com.microsoft.azure.management.compute.NetworkInterfaceReference;
import com.microsoft.azure.management.compute.OSProfile;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.PowerState;
import com.microsoft.azure.management.compute.Sku;
import com.microsoft.azure.management.compute.StorageProfile;
import com.microsoft.azure.management.compute.VirtualMachineCustomImage;
import com.microsoft.azure.management.compute.VirtualMachineDataDisk;
import com.microsoft.azure.management.compute.VirtualMachineImage;
import com.microsoft.azure.management.compute.VirtualMachineInstanceView;
import com.microsoft.azure.management.compute.VirtualMachineScaleSet;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetVM;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetVMInstanceExtension;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetVMNetworkProfileConfiguration;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetVMProtectionPolicy;
import com.microsoft.azure.management.compute.VirtualMachineSizeTypes;
import com.microsoft.azure.management.compute.VirtualMachineUnmanagedDataDisk;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.UnmanagedDataDiskImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineDataDiskImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInstanceViewImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInstanceViewInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetVMInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetVMInstanceExtensionImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetVMInstanceViewInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetVMsInner;
import com.microsoft.azure.management.network.VirtualMachineScaleSetNetworkInterface;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class VirtualMachineScaleSetVMImpl
extends ChildResourceImpl<VirtualMachineScaleSetVMInner, VirtualMachineScaleSetImpl, VirtualMachineScaleSet>
implements VirtualMachineScaleSetVM {
    private VirtualMachineInstanceView virtualMachineInstanceView;
    private final VirtualMachineScaleSetVMsInner client;
    private final ComputeManager computeManager;

    VirtualMachineScaleSetVMImpl(VirtualMachineScaleSetVMInner inner, VirtualMachineScaleSetImpl parent, VirtualMachineScaleSetVMsInner client, ComputeManager computeManager) {
        super((Object)inner, (Object)parent);
        this.client = client;
        this.computeManager = computeManager;
        VirtualMachineScaleSetVMInstanceViewInner instanceViewInner = ((VirtualMachineScaleSetVMInner)((Object)this.inner())).instanceView();
        this.virtualMachineInstanceView = instanceViewInner != null ? new VirtualMachineInstanceViewImpl(new VirtualMachineInstanceViewInner().withBootDiagnostics(instanceViewInner.bootDiagnostics()).withDisks(instanceViewInner.disks()).withExtensions(instanceViewInner.extensions()).withPlatformFaultDomain(instanceViewInner.platformFaultDomain()).withPlatformUpdateDomain(instanceViewInner.platformUpdateDomain()).withRdpThumbPrint(instanceViewInner.rdpThumbPrint()).withStatuses(instanceViewInner.statuses()).withVmAgent(instanceViewInner.vmAgent())) : null;
    }

    public String id() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).id();
    }

    public String name() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).name();
    }

    public String regionName() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).location();
    }

    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    public String type() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).type();
    }

    public Map<String, String> tags() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).getTags() == null) {
            return Collections.unmodifiableMap(new LinkedHashMap());
        }
        return Collections.unmodifiableMap(((VirtualMachineScaleSetVMInner)((Object)this.inner())).getTags());
    }

    @Override
    public String instanceId() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).instanceId();
    }

    @Override
    public Sku sku() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).sku();
    }

    @Override
    public VirtualMachineSizeTypes size() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).hardwareProfile() != null && ((VirtualMachineScaleSetVMInner)((Object)this.inner())).hardwareProfile().vmSize() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).hardwareProfile().vmSize();
        }
        if (this.sku() != null && this.sku().name() != null) {
            return VirtualMachineSizeTypes.fromString(this.sku().name());
        }
        return null;
    }

    @Override
    public boolean isLatestScaleSetUpdateApplied() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).latestModelApplied();
    }

    @Override
    public boolean isOSBasedOnPlatformImage() {
        ImageReference imageReference = ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().imageReference();
        return imageReference != null && imageReference.publisher() != null && imageReference.sku() != null && imageReference.offer() != null && imageReference.version() != null;
    }

    @Override
    public boolean isOSBasedOnCustomImage() {
        ImageReference imageReference = ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().imageReference();
        return imageReference != null && imageReference.id() != null;
    }

    @Override
    public boolean isOSBasedOnStoredImage() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk() != null && ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().image() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().image().uri() != null;
        }
        return false;
    }

    @Override
    public ImageReference platformImageReference() {
        if (this.isOSBasedOnPlatformImage()) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().imageReference();
        }
        return null;
    }

    @Override
    public VirtualMachineImage getOSPlatformImage() {
        if (this.isOSBasedOnPlatformImage()) {
            ImageReference imageReference = this.platformImageReference();
            return this.computeManager.virtualMachineImages().getImage(this.region(), imageReference.publisher(), imageReference.offer(), imageReference.sku(), imageReference.version());
        }
        return null;
    }

    @Override
    public VirtualMachineCustomImage getOSCustomImage() {
        if (this.isOSBasedOnCustomImage()) {
            ImageReference imageReference = ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().imageReference();
            return (VirtualMachineCustomImage)this.computeManager.virtualMachineCustomImages().getById(imageReference.id());
        }
        return null;
    }

    @Override
    public String storedImageUnmanagedVhdUri() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().image() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().image().uri();
        }
        return null;
    }

    @Override
    public String osDiskName() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().name();
    }

    @Override
    public String osUnmanagedDiskVhdUri() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().vhd() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().vhd().uri();
        }
        return null;
    }

    @Override
    public String osDiskId() {
        if (this.storageProfile().osDisk().managedDisk() != null) {
            return this.storageProfile().osDisk().managedDisk().id();
        }
        return null;
    }

    @Override
    public Map<Integer, VirtualMachineUnmanagedDataDisk> unmanagedDataDisks() {
        List<DataDisk> innerDataDisks;
        HashMap<Integer, UnmanagedDataDiskImpl> dataDisks = new HashMap<Integer, UnmanagedDataDiskImpl>();
        if (!this.isManagedDiskEnabled() && (innerDataDisks = ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().dataDisks()) != null) {
            for (DataDisk innerDataDisk : innerDataDisks) {
                dataDisks.put(innerDataDisk.lun(), new UnmanagedDataDiskImpl(innerDataDisk, null));
            }
        }
        return Collections.unmodifiableMap(dataDisks);
    }

    @Override
    public Map<Integer, VirtualMachineDataDisk> dataDisks() {
        List<DataDisk> innerDataDisks;
        HashMap<Integer, VirtualMachineDataDiskImpl> dataDisks = new HashMap<Integer, VirtualMachineDataDiskImpl>();
        if (this.isManagedDiskEnabled() && (innerDataDisks = ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().dataDisks()) != null) {
            for (DataDisk innerDataDisk : innerDataDisks) {
                dataDisks.put(innerDataDisk.lun(), new VirtualMachineDataDiskImpl(innerDataDisk));
            }
        }
        return Collections.unmodifiableMap(dataDisks);
    }

    @Override
    public CachingTypes osDiskCachingType() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().caching();
    }

    @Override
    public int osDiskSizeInGB() {
        return Utils.toPrimitiveInt((Integer)((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().diskSizeGB());
    }

    @Override
    public String computerName() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile().computerName();
    }

    @Override
    public String administratorUserName() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile().adminUsername();
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().osType();
    }

    @Override
    public boolean isLinuxPasswordAuthenticationEnabled() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile().linuxConfiguration() != null) {
            return !Utils.toPrimitiveBoolean((Boolean)((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile().linuxConfiguration().disablePasswordAuthentication());
        }
        return false;
    }

    @Override
    public boolean isWindowsVMAgentProvisioned() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile().windowsConfiguration() != null) {
            return Utils.toPrimitiveBoolean((Boolean)((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile().windowsConfiguration().provisionVMAgent());
        }
        return false;
    }

    @Override
    public boolean isWindowsAutoUpdateEnabled() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile().windowsConfiguration() != null) {
            return Utils.toPrimitiveBoolean((Boolean)((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile().windowsConfiguration().enableAutomaticUpdates());
        }
        return false;
    }

    @Override
    public String windowsTimeZone() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile().windowsConfiguration() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile().windowsConfiguration().timeZone();
        }
        return null;
    }

    @Override
    public boolean bootDiagnosticEnabled() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).diagnosticsProfile() != null && ((VirtualMachineScaleSetVMInner)((Object)this.inner())).diagnosticsProfile().bootDiagnostics() != null) {
            return Utils.toPrimitiveBoolean((Boolean)((VirtualMachineScaleSetVMInner)((Object)this.inner())).diagnosticsProfile().bootDiagnostics().enabled());
        }
        return false;
    }

    @Override
    public String bootDiagnosticStorageAccountUri() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).diagnosticsProfile() != null && ((VirtualMachineScaleSetVMInner)((Object)this.inner())).diagnosticsProfile().bootDiagnostics() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).diagnosticsProfile().bootDiagnostics().storageUri();
        }
        return null;
    }

    @Override
    public String availabilitySetId() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).availabilitySet() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).availabilitySet().id();
        }
        return null;
    }

    @Override
    public List<String> networkInterfaceIds() {
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (NetworkInterfaceReference reference : ((VirtualMachineScaleSetVMInner)((Object)this.inner())).networkProfile().networkInterfaces()) {
            resourceIds.add(reference.id());
        }
        return Collections.unmodifiableList(resourceIds);
    }

    @Override
    public String primaryNetworkInterfaceId() {
        for (NetworkInterfaceReference reference : ((VirtualMachineScaleSetVMInner)((Object)this.inner())).networkProfile().networkInterfaces()) {
            if (reference.primary() == null || !reference.primary().booleanValue()) continue;
            return reference.id();
        }
        return null;
    }

    @Override
    public Map<String, VirtualMachineScaleSetVMInstanceExtension> extensions() {
        LinkedHashMap<String, VirtualMachineScaleSetVMInstanceExtensionImpl> extensions = new LinkedHashMap<String, VirtualMachineScaleSetVMInstanceExtensionImpl>();
        if (((VirtualMachineScaleSetVMInner)((Object)this.inner())).resources() != null) {
            for (VirtualMachineExtensionInner extensionInner : ((VirtualMachineScaleSetVMInner)((Object)this.inner())).resources()) {
                extensions.put(extensionInner.name(), new VirtualMachineScaleSetVMInstanceExtensionImpl(extensionInner, this));
            }
        }
        return Collections.unmodifiableMap(extensions);
    }

    @Override
    public StorageProfile storageProfile() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile();
    }

    @Override
    public OSProfile osProfile() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).osProfile();
    }

    @Override
    public DiagnosticsProfile diagnosticsProfile() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).diagnosticsProfile();
    }

    @Override
    public VirtualMachineInstanceView instanceView() {
        if (this.virtualMachineInstanceView == null) {
            this.refreshInstanceView();
        }
        return this.virtualMachineInstanceView;
    }

    @Override
    public VirtualMachineInstanceView refreshInstanceView() {
        return (VirtualMachineInstanceView)this.refreshInstanceViewAsync().toBlocking().last();
    }

    @Override
    public Observable<VirtualMachineInstanceView> refreshInstanceViewAsync() {
        return this.client.getInstanceViewAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId()).map((Func1)new Func1<VirtualMachineScaleSetVMInstanceViewInner, VirtualMachineInstanceView>(){

            public VirtualMachineInstanceView call(VirtualMachineScaleSetVMInstanceViewInner instanceViewInner) {
                if (instanceViewInner != null) {
                    VirtualMachineScaleSetVMImpl.this.virtualMachineInstanceView = new VirtualMachineInstanceViewImpl(new VirtualMachineInstanceViewInner().withBootDiagnostics(instanceViewInner.bootDiagnostics()).withDisks(instanceViewInner.disks()).withExtensions(instanceViewInner.extensions()).withPlatformFaultDomain(instanceViewInner.platformFaultDomain()).withPlatformUpdateDomain(instanceViewInner.platformUpdateDomain()).withRdpThumbPrint(instanceViewInner.rdpThumbPrint()).withStatuses(instanceViewInner.statuses()).withVmAgent(instanceViewInner.vmAgent()));
                }
                return VirtualMachineScaleSetVMImpl.this.virtualMachineInstanceView;
            }
        });
    }

    @Override
    public PowerState powerState() {
        return PowerState.fromInstanceView(this.instanceView());
    }

    @Override
    public void reimage() {
        this.reimageAsync().await();
    }

    @Override
    public Completable reimageAsync() {
        return this.client.reimageAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId()).toCompletable();
    }

    @Override
    public void deallocate() {
        this.deallocateAsync().await();
    }

    @Override
    public Completable deallocateAsync() {
        return this.client.deallocateAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId()).toCompletable();
    }

    @Override
    public void powerOff() {
        this.powerOffAsync().await();
    }

    @Override
    public Completable powerOffAsync() {
        return this.client.powerOffAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId()).toCompletable();
    }

    @Override
    public void start() {
        this.startAsync().await();
    }

    @Override
    public Completable startAsync() {
        return this.client.startAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId()).toCompletable();
    }

    @Override
    public void restart() {
        this.restartAsync().await();
    }

    @Override
    public Completable restartAsync() {
        return this.client.restartAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId()).toCompletable();
    }

    @Override
    public void delete() {
        this.deleteAsync().await();
    }

    @Override
    public Completable deleteAsync() {
        return this.client.deleteAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId()).toCompletable();
    }

    public VirtualMachineScaleSetVM refresh() {
        return (VirtualMachineScaleSetVM)this.refreshAsync().toBlocking().last();
    }

    public Observable<VirtualMachineScaleSetVM> refreshAsync() {
        final VirtualMachineScaleSetVMImpl self = this;
        return this.client.getAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId()).map((Func1)new Func1<VirtualMachineScaleSetVMInner, VirtualMachineScaleSetVM>(){

            public VirtualMachineScaleSetVM call(VirtualMachineScaleSetVMInner virtualMachineScaleSetVMInner) {
                self.setInner((Object)virtualMachineScaleSetVMInner);
                self.clearCachedRelatedResources();
                return self;
            }
        });
    }

    @Override
    public VirtualMachineScaleSetNetworkInterface getNetworkInterface(String name) {
        return ((VirtualMachineScaleSetImpl)this.parent()).getNetworkInterfaceByInstanceId(this.instanceId(), name);
    }

    @Override
    public PagedList<VirtualMachineScaleSetNetworkInterface> listNetworkInterfaces() {
        return ((VirtualMachineScaleSetImpl)this.parent()).listNetworkInterfacesByInstanceId(this.instanceId());
    }

    @Override
    public String modelDefinitionApplied() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).modelDefinitionApplied();
    }

    @Override
    public VirtualMachineScaleSetVMProtectionPolicy protectionPolicy() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).protectionPolicy();
    }

    @Override
    public VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.inner())).networkProfileConfiguration();
    }

    private void clearCachedRelatedResources() {
        this.virtualMachineInstanceView = null;
    }

    @Override
    public boolean isManagedDiskEnabled() {
        if (this.isOSBasedOnCustomImage()) {
            return true;
        }
        if (this.isOSBasedOnStoredImage()) {
            return false;
        }
        return !this.isOSBasedOnPlatformImage() || ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk() == null || ((VirtualMachineScaleSetVMInner)((Object)this.inner())).storageProfile().osDisk().vhd() == null;
    }
}

