/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.compute.DiskEncryptionSettings;
import com.microsoft.azure.management.compute.DiskVolumeEncryptionMonitor;
import com.microsoft.azure.management.compute.DiskVolumeType;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineEncryptionConfiguration;
import com.microsoft.azure.management.compute.VirtualMachineExtension;
import com.microsoft.azure.management.compute.VirtualMachineExtensionInstanceView;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.EncryptionExtensionIdentifier;
import com.microsoft.azure.management.compute.implementation.EncryptionSettings;
import com.microsoft.azure.management.compute.implementation.LinuxDiskVolumeLegacyEncryptionMonitorImpl;
import com.microsoft.azure.management.compute.implementation.LinuxDiskVolumeNoAADEncryptionMonitorImpl;
import com.microsoft.azure.management.compute.implementation.WindowsVolumeLegacyEncryptionMonitorImpl;
import com.microsoft.azure.management.compute.implementation.WindowsVolumeNoAADEncryptionMonitorImpl;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

class VirtualMachineEncryptionHelper {
    private final OperatingSystemTypes osType;
    private final VirtualMachine virtualMachine;
    private static final String ERROR_ENCRYPTION_EXTENSION_NOT_FOUND = "Expected encryption extension not found in the VM";
    private static final String ERROR_NON_SUCCESS_PROVISIONING_STATE = "Extension needed for disk encryption was not provisioned correctly, found ProvisioningState as '%s'";
    private static final String ERROR_EXPECTED_KEY_VAULT_URL_NOT_FOUND = "Could not found URL pointing to the secret for disk encryption";
    private static final String ERROR_EXPECTED_ENCRYPTION_EXTENSION_STATUS_NOT_FOUND = "Encryption extension with successful status not found in the VM";
    private static final String ERROR_ENCRYPTION_EXTENSION_STATUS_IS_EMPTY = "Encryption extension status is empty";
    private static final String ERROR_ON_LINUX_ONLY_DATA_DISK_CAN_BE_DECRYPTED = "Only data disk is supported to disable encryption on Linux VM";
    private static final String ERROR_LEGACY_ENCRYPTION_EXTENSION_FOUND_AAD_PARAMS_REQUIRED = "VM has Legacy Encryption Extension installed, updating it requires aadClientId and aadSecret parameters";
    private static final String ERROR_NOAAD_ENCRYPTION_EXTENSION_FOUND_AAD_PARAMS_NOT_REQUIRED = "VM has NoAAD Encryption Extension installed, aadClientId and aadSecret parameters are not allowed for this extension.";
    private static final String ERROR_NO_DECRYPT_ENCRYPTION_EXTENSION_NOT_FOUND = "Expected encryption extension not found in the VM, no decryption to perform";

    VirtualMachineEncryptionHelper(VirtualMachine virtualMachine) {
        this.virtualMachine = virtualMachine;
        this.osType = this.virtualMachine.osType();
    }

    <T extends VirtualMachineEncryptionConfiguration<T>> Observable<DiskVolumeEncryptionMonitor> enableEncryptionAsync(VirtualMachineEncryptionConfiguration<T> encryptionConfig) {
        final EncryptionSettings.Enable<T> encryptSettings = EncryptionSettings.createEnable(encryptionConfig);
        return this.validateBeforeEncryptAsync(encryptSettings).flatMap((Func1)new Func1<VirtualMachineExtension, Observable<VirtualMachine>>(){

            public Observable<VirtualMachine> call(VirtualMachineExtension virtualMachineExtension) {
                return VirtualMachineEncryptionHelper.this.updateEncryptionExtensionAsync(encryptSettings, virtualMachineExtension);
            }
        }).switchIfEmpty(this.installEncryptionExtensionAsync(encryptSettings)).flatMap((Func1)new Func1<VirtualMachine, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachine virtualMachine) {
                if (encryptSettings.requestedForNoAADEncryptExtension()) {
                    return VirtualMachineEncryptionHelper.this.noAADExtensionEncryptPostProcessingAsync(virtualMachine);
                }
                return VirtualMachineEncryptionHelper.this.legacyExtensionEncryptPostProcessingAsync(encryptSettings);
            }
        });
    }

    Observable<DiskVolumeEncryptionMonitor> disableEncryptionAsync(DiskVolumeType volumeType) {
        final EncryptionSettings.Disable encryptSettings = EncryptionSettings.createDisable(volumeType);
        return this.validateBeforeDecryptAsync(volumeType).flatMap((Func1)new Func1<VirtualMachineExtension, Observable<VMExtTuple>>(){

            public Observable<VMExtTuple> call(final VirtualMachineExtension virtualMachineExtension) {
                return VirtualMachineEncryptionHelper.this.updateEncryptionExtensionAsync(encryptSettings, virtualMachineExtension).map((Func1)new Func1<VirtualMachine, VMExtTuple>(){

                    public VMExtTuple call(VirtualMachine virtualMachine) {
                        return new VMExtTuple(virtualMachine, virtualMachineExtension);
                    }
                });
            }
        }).flatMap((Func1)new Func1<VMExtTuple, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VMExtTuple vmExt) {
                if (EncryptionExtensionIdentifier.isNoAADVersion(VirtualMachineEncryptionHelper.this.osType, vmExt.encryptExtension.versionName())) {
                    return VirtualMachineEncryptionHelper.this.noAADExtensionDecryptPostProcessingAsync(vmExt.virtualMachine);
                }
                return VirtualMachineEncryptionHelper.this.legacyExtensionDecryptPostProcessingAsync(encryptSettings);
            }
        });
    }

    private Observable<DiskVolumeEncryptionMonitor> noAADExtensionEncryptPostProcessingAsync(VirtualMachine virtualMachine) {
        return this.osType == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)((Object)virtualMachine.manager())).refreshAsync() : new WindowsVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)((Object)virtualMachine.manager())).refreshAsync();
    }

    private <T extends VirtualMachineEncryptionConfiguration<T>> Observable<DiskVolumeEncryptionMonitor> legacyExtensionEncryptPostProcessingAsync(final EncryptionSettings.Enable<T> encryptConfig) {
        return this.retrieveEncryptionExtensionStatusStringAsync(ERROR_EXPECTED_KEY_VAULT_URL_NOT_FOUND).flatMap((Func1)new Func1<String, Observable<VirtualMachine>>(){

            public Observable<VirtualMachine> call(String keyVaultSecretUrl) {
                return VirtualMachineEncryptionHelper.this.updateVMStorageProfileAsync(encryptConfig, keyVaultSecretUrl);
            }
        }).flatMap((Func1)new Func1<VirtualMachine, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachine virtualMachine) {
                return VirtualMachineEncryptionHelper.this.osType == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)((Object)virtualMachine.manager())).refreshAsync() : new WindowsVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)((Object)virtualMachine.manager())).refreshAsync();
            }
        });
    }

    private Observable<DiskVolumeEncryptionMonitor> noAADExtensionDecryptPostProcessingAsync(VirtualMachine virtualMachine) {
        return this.osType == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)((Object)virtualMachine.manager())).refreshAsync() : new WindowsVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)((Object)virtualMachine.manager())).refreshAsync();
    }

    private Observable<DiskVolumeEncryptionMonitor> legacyExtensionDecryptPostProcessingAsync(final EncryptionSettings.Disable encryptConfig) {
        return this.retrieveEncryptionExtensionStatusStringAsync(ERROR_ENCRYPTION_EXTENSION_STATUS_IS_EMPTY).flatMap((Func1)new Func1<String, Observable<VirtualMachine>>(){

            public Observable<VirtualMachine> call(String status) {
                return VirtualMachineEncryptionHelper.this.updateVMStorageProfileAsync(encryptConfig);
            }
        }).flatMap((Func1)new Func1<VirtualMachine, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachine virtualMachine) {
                return VirtualMachineEncryptionHelper.this.osType == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)((Object)virtualMachine.manager())).refreshAsync() : new WindowsVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)((Object)virtualMachine.manager())).refreshAsync();
            }
        });
    }

    private <T extends VirtualMachineEncryptionConfiguration<T>> Observable<VirtualMachineExtension> validateBeforeEncryptAsync(final EncryptionSettings.Enable<T> encryptSettings) {
        if (this.virtualMachine.storageProfile().osDisk().encryptionSettings() != null && encryptSettings.requestedForNoAADEncryptExtension()) {
            return Observable.error((Throwable)new RuntimeException(ERROR_LEGACY_ENCRYPTION_EXTENSION_FOUND_AAD_PARAMS_REQUIRED));
        }
        return this.getEncryptionExtensionInstalledInVMAsync().flatMap((Func1)new Func1<VirtualMachineExtension, Observable<VirtualMachineExtension>>(){

            public Observable<VirtualMachineExtension> call(VirtualMachineExtension extension) {
                if (EncryptionExtensionIdentifier.isNoAADVersion(VirtualMachineEncryptionHelper.this.osType, extension.versionName())) {
                    return encryptSettings.requestedForNoAADEncryptExtension() ? Observable.just((Object)extension) : Observable.error((Throwable)new RuntimeException(VirtualMachineEncryptionHelper.ERROR_NOAAD_ENCRYPTION_EXTENSION_FOUND_AAD_PARAMS_NOT_REQUIRED));
                }
                return encryptSettings.requestedForNoAADEncryptExtension() ? Observable.error((Throwable)new RuntimeException(VirtualMachineEncryptionHelper.ERROR_LEGACY_ENCRYPTION_EXTENSION_FOUND_AAD_PARAMS_REQUIRED)) : Observable.just((Object)extension);
            }
        });
    }

    private Observable<VirtualMachineExtension> validateBeforeDecryptAsync(DiskVolumeType volumeType) {
        if (this.osType == OperatingSystemTypes.LINUX && volumeType != DiskVolumeType.DATA) {
            return this.toErrorObservable(ERROR_ON_LINUX_ONLY_DATA_DISK_CAN_BE_DECRYPTED);
        }
        return this.getEncryptionExtensionInstalledInVMAsync().switchIfEmpty(this.toErrorObservable(ERROR_NO_DECRYPT_ENCRYPTION_EXTENSION_NOT_FOUND));
    }

    private Observable<VirtualMachineExtension> getEncryptionExtensionInstalledInVMAsync() {
        return this.virtualMachine.listExtensionsAsync().firstOrDefault(null, (Func1)new Func1<VirtualMachineExtension, Boolean>(){

            public Boolean call(VirtualMachineExtension extension) {
                return EncryptionExtensionIdentifier.isEncryptionPublisherName(extension.publisherName()) && EncryptionExtensionIdentifier.isEncryptionTypeName(extension.typeName(), VirtualMachineEncryptionHelper.this.osType);
            }
        }).flatMap((Func1)new Func1<VirtualMachineExtension, Observable<VirtualMachineExtension>>(){

            public Observable<VirtualMachineExtension> call(VirtualMachineExtension extension) {
                if (extension == null) {
                    return Observable.empty();
                }
                return Observable.just((Object)extension);
            }
        });
    }

    private Observable<VirtualMachine> updateEncryptionExtensionAsync(EncryptionSettings encryptSettings, VirtualMachineExtension encryptionExtension) {
        return ((VirtualMachine.Update)((VirtualMachine.Update)this.virtualMachine.update()).updateExtension(encryptionExtension.name()).withPublicSettings(encryptSettings.extensionPublicSettings()).withProtectedSettings(encryptSettings.extensionProtectedSettings()).parent()).applyAsync();
    }

    private <T extends VirtualMachineEncryptionConfiguration<T>> Observable<VirtualMachine> installEncryptionExtensionAsync(final EncryptionSettings.Enable<T> encryptSettings) {
        return Observable.defer((Func0)new Func0<Observable<VirtualMachine>>(){

            public Observable<VirtualMachine> call() {
                String typeName = EncryptionExtensionIdentifier.typeName(VirtualMachineEncryptionHelper.this.osType);
                return ((VirtualMachine.Update)((VirtualMachine.Update)VirtualMachineEncryptionHelper.this.virtualMachine.update()).defineNewExtension(typeName).withPublisher(EncryptionExtensionIdentifier.publisherName()).withType(typeName).withVersion(encryptSettings.encryptionExtensionVersion()).withPublicSettings(encryptSettings.extensionPublicSettings()).withProtectedSettings(encryptSettings.extensionProtectedSettings()).withMinorVersionAutoUpgrade().attach()).applyAsync();
            }
        });
    }

    private Observable<String> retrieveEncryptionExtensionStatusStringAsync(final String statusEmptyErrorMessage) {
        final VirtualMachineEncryptionHelper self = this;
        return this.getEncryptionExtensionInstalledInVMAsync().switchIfEmpty(self.toErrorObservable(ERROR_ENCRYPTION_EXTENSION_NOT_FOUND)).flatMap((Func1)new Func1<VirtualMachineExtension, Observable<VirtualMachineExtensionInstanceView>>(){

            public Observable<VirtualMachineExtensionInstanceView> call(VirtualMachineExtension extension) {
                if (!extension.provisioningState().equalsIgnoreCase("Succeeded")) {
                    return self.toErrorObservable(String.format(VirtualMachineEncryptionHelper.ERROR_NON_SUCCESS_PROVISIONING_STATE, extension.provisioningState()));
                }
                return extension.getInstanceViewAsync();
            }
        }).flatMap((Func1)new Func1<VirtualMachineExtensionInstanceView, Observable<String>>(){

            public Observable<String> call(VirtualMachineExtensionInstanceView instanceView) {
                if (instanceView == null || instanceView.statuses() == null || instanceView.statuses().size() == 0) {
                    return self.toErrorObservable(VirtualMachineEncryptionHelper.ERROR_EXPECTED_ENCRYPTION_EXTENSION_STATUS_NOT_FOUND);
                }
                String extensionStatus = instanceView.statuses().get(0).message();
                if (extensionStatus == null) {
                    return self.toErrorObservable(statusEmptyErrorMessage);
                }
                return Observable.just((Object)extensionStatus);
            }
        });
    }

    private Observable<VirtualMachine> updateVMStorageProfileAsync(EncryptionSettings encryptSettings, String encryptionSecretKeyVaultUrl) {
        DiskEncryptionSettings diskEncryptionSettings = encryptSettings.storageProfileEncryptionSettings();
        diskEncryptionSettings.diskEncryptionKey().withSecretUrl(encryptionSecretKeyVaultUrl);
        return ((VirtualMachine.Update)this.virtualMachine.update()).withOSDiskEncryptionSettings(diskEncryptionSettings).applyAsync();
    }

    private Observable<VirtualMachine> updateVMStorageProfileAsync(EncryptionSettings encryptSettings) {
        DiskEncryptionSettings diskEncryptionSettings = encryptSettings.storageProfileEncryptionSettings();
        return ((VirtualMachine.Update)this.virtualMachine.update()).withOSDiskEncryptionSettings(diskEncryptionSettings).applyAsync();
    }

    private <ResultT> Observable<ResultT> toErrorObservable(String message) {
        return Observable.error((Throwable)new Exception(message));
    }

    private class VMExtTuple {
        private final VirtualMachine virtualMachine;
        private final VirtualMachineExtension encryptExtension;

        VMExtTuple(VirtualMachine vm, VirtualMachineExtension ext) {
            this.virtualMachine = vm;
            this.encryptExtension = ext;
        }
    }
}

