/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.ContainerService;
import com.microsoft.azure.management.compute.ContainerServiceAgentPool;
import com.microsoft.azure.management.compute.ContainerServiceAgentPoolProfile;
import com.microsoft.azure.management.compute.ContainerServiceVMSizeTypes;
import com.microsoft.azure.management.compute.implementation.ContainerServiceImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

@LangDefinition
class ContainerServiceAgentPoolImpl
extends ChildResourceImpl<ContainerServiceAgentPoolProfile, ContainerServiceImpl, ContainerService>
implements ContainerServiceAgentPool,
ContainerServiceAgentPool.Definition {
    ContainerServiceAgentPoolImpl(ContainerServiceAgentPoolProfile inner, ContainerServiceImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).name();
    }

    @Override
    public int count() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).count();
    }

    @Override
    public ContainerServiceVMSizeTypes vmSize() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).vmSize();
    }

    @Override
    public String dnsLabel() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).dnsPrefix();
    }

    @Override
    public String fqdn() {
        return ((ContainerServiceAgentPoolProfile)this.inner()).fqdn();
    }

    public ContainerServiceAgentPoolImpl withVMCount(int agentPoolCount) {
        if (agentPoolCount < 0 || agentPoolCount > 100) {
            throw new RuntimeException("Agent pool count  must be in the range of 1 to 100 (inclusive)");
        }
        ((ContainerServiceAgentPoolProfile)this.inner()).withCount(agentPoolCount);
        return this;
    }

    public ContainerServiceAgentPoolImpl withVMSize(ContainerServiceVMSizeTypes param0) {
        ((ContainerServiceAgentPoolProfile)this.inner()).withVmSize(param0);
        return this;
    }

    public ContainerServiceAgentPoolImpl withLeafDomainLabel(String param0) {
        ((ContainerServiceAgentPoolProfile)this.inner()).withDnsPrefix(param0);
        return this;
    }

    public ContainerService.Definition attach() {
        ((ContainerServiceImpl)this.parent()).attachAgentPoolProfile(this);
        return (ContainerService.Definition)this.parent();
    }
}

