/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.implementation.AccessUriInner;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.DiskInner;
import com.microsoft.azure.management.compute.implementation.DiskUpdateInner;
import com.microsoft.azure.management.compute.implementation.GrantAccessDataInner;
import com.microsoft.azure.management.compute.implementation.OperationStatusResponseInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DisksInner
implements InnerSupportsGet<DiskInner>,
InnerSupportsDelete<OperationStatusResponseInner>,
InnerSupportsListing<DiskInner> {
    private DisksService service;
    private ComputeManagementClientImpl client;

    public DisksInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (DisksService)retrofit.create(DisksService.class);
        this.client = client;
    }

    public DiskInner createOrUpdate(String resourceGroupName, String diskName, DiskInner disk) {
        return (DiskInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).toBlocking().last()).body());
    }

    public ServiceFuture<DiskInner> createOrUpdateAsync(String resourceGroupName, String diskName, DiskInner disk, ServiceCallback<DiskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk), serviceCallback);
    }

    public Observable<DiskInner> createOrUpdateAsync(String resourceGroupName, String diskName, DiskInner disk) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).map((Func1)new Func1<ServiceResponse<DiskInner>, DiskInner>(){

            public DiskInner call(ServiceResponse<DiskInner> response) {
                return (DiskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskName, DiskInner disk) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Parameter disk is required and cannot be null.");
        }
        Validator.validate((Object)((Object)disk));
        String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", disk, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskInner>(){}.getType());
    }

    public DiskInner beginCreateOrUpdate(String resourceGroupName, String diskName, DiskInner disk) {
        return (DiskInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).toBlocking().single()).body());
    }

    public ServiceFuture<DiskInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskName, DiskInner disk, ServiceCallback<DiskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk), serviceCallback);
    }

    public Observable<DiskInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskName, DiskInner disk) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).map((Func1)new Func1<ServiceResponse<DiskInner>, DiskInner>(){

            public DiskInner call(ServiceResponse<DiskInner> response) {
                return (DiskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskName, DiskInner disk) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Parameter disk is required and cannot be null.");
        }
        Validator.validate((Object)((Object)disk));
        String apiVersion = "2017-03-30";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", disk, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskInner>>>(){

            public Observable<ServiceResponse<DiskInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisksInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiskInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiskInner>(){}.getType()).register(202, new TypeToken<DiskInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiskInner update(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        return (DiskInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, diskName, disk).toBlocking().last()).body());
    }

    public ServiceFuture<DiskInner> updateAsync(String resourceGroupName, String diskName, DiskUpdateInner disk, ServiceCallback<DiskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, diskName, disk), serviceCallback);
    }

    public Observable<DiskInner> updateAsync(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        return this.updateWithServiceResponseAsync(resourceGroupName, diskName, disk).map((Func1)new Func1<ServiceResponse<DiskInner>, DiskInner>(){

            public DiskInner call(ServiceResponse<DiskInner> response) {
                return (DiskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskInner>> updateWithServiceResponseAsync(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Parameter disk is required and cannot be null.");
        }
        Validator.validate((Object)disk);
        String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", disk, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskInner>(){}.getType());
    }

    public DiskInner beginUpdate(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        return (DiskInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).toBlocking().single()).body());
    }

    public ServiceFuture<DiskInner> beginUpdateAsync(String resourceGroupName, String diskName, DiskUpdateInner disk, ServiceCallback<DiskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk), serviceCallback);
    }

    public Observable<DiskInner> beginUpdateAsync(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).map((Func1)new Func1<ServiceResponse<DiskInner>, DiskInner>(){

            public DiskInner call(ServiceResponse<DiskInner> response) {
                return (DiskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Parameter disk is required and cannot be null.");
        }
        Validator.validate((Object)disk);
        String apiVersion = "2017-03-30";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", disk, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskInner>>>(){

            public Observable<ServiceResponse<DiskInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisksInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiskInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiskInner>(){}.getType()).register(202, new TypeToken<DiskInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiskInner getByResourceGroup(String resourceGroupName, String diskName) {
        return (DiskInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskName).toBlocking().single()).body());
    }

    public ServiceFuture<DiskInner> getByResourceGroupAsync(String resourceGroupName, String diskName, ServiceCallback<DiskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskName), serviceCallback);
    }

    public Observable<DiskInner> getByResourceGroupAsync(String resourceGroupName, String diskName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskName).map((Func1)new Func1<ServiceResponse<DiskInner>, DiskInner>(){

            public DiskInner call(ServiceResponse<DiskInner> response) {
                return (DiskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String diskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskInner>>>(){

            public Observable<ServiceResponse<DiskInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisksInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiskInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiskInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner delete(String resourceGroupName, String diskName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, diskName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> deleteAsync(String resourceGroupName, String diskName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, diskName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> deleteAsync(String resourceGroupName, String diskName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, diskName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> deleteWithServiceResponseAsync(String resourceGroupName, String diskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginDelete(String resourceGroupName, String diskName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, diskName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginDeleteAsync(String resourceGroupName, String diskName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, diskName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginDeleteAsync(String resourceGroupName, String diskName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, diskName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String diskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisksInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DiskInner>((Page)response.body()){

            public Page<DiskInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DisksInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<DiskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(String nextPageLink) {
                return DisksInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<DiskInner>>, Page<DiskInner>>(){

            public Page<DiskInner> call(ServiceResponse<Page<DiskInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<DiskInner>>, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(ServiceResponse<Page<DiskInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DisksInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DisksInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<DiskInner>((Page)response.body()){

            public Page<DiskInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DisksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskInner>> listAsync(ListOperationCallback<DiskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(String nextPageLink) {
                return DisksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<DiskInner>>, Page<DiskInner>>(){

            public Page<DiskInner> call(ServiceResponse<Page<DiskInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<DiskInner>>, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(ServiceResponse<Page<DiskInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DisksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.list(this.client.subscriptionId(), "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DisksInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AccessUriInner grantAccess(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        return (AccessUriInner)((ServiceResponse)this.grantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData).toBlocking().last()).body();
    }

    public ServiceFuture<AccessUriInner> grantAccessAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData, ServiceCallback<AccessUriInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.grantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData), serviceCallback);
    }

    public Observable<AccessUriInner> grantAccessAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        return this.grantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData).map((Func1)new Func1<ServiceResponse<AccessUriInner>, AccessUriInner>(){

            public AccessUriInner call(ServiceResponse<AccessUriInner> response) {
                return (AccessUriInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AccessUriInner>> grantAccessWithServiceResponseAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (grantAccessData == null) {
            throw new IllegalArgumentException("Parameter grantAccessData is required and cannot be null.");
        }
        Validator.validate((Object)grantAccessData);
        String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = this.service.grantAccess(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", grantAccessData, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<AccessUriInner>(){}.getType());
    }

    public AccessUriInner beginGrantAccess(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        return (AccessUriInner)((ServiceResponse)this.beginGrantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData).toBlocking().single()).body();
    }

    public ServiceFuture<AccessUriInner> beginGrantAccessAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData, ServiceCallback<AccessUriInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGrantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData), serviceCallback);
    }

    public Observable<AccessUriInner> beginGrantAccessAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        return this.beginGrantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData).map((Func1)new Func1<ServiceResponse<AccessUriInner>, AccessUriInner>(){

            public AccessUriInner call(ServiceResponse<AccessUriInner> response) {
                return (AccessUriInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AccessUriInner>> beginGrantAccessWithServiceResponseAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (grantAccessData == null) {
            throw new IllegalArgumentException("Parameter grantAccessData is required and cannot be null.");
        }
        Validator.validate((Object)grantAccessData);
        String apiVersion = "2017-03-30";
        return this.service.beginGrantAccess(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", grantAccessData, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AccessUriInner>>>(){

            public Observable<ServiceResponse<AccessUriInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisksInner.this.beginGrantAccessDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AccessUriInner> beginGrantAccessDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AccessUriInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner revokeAccess(String resourceGroupName, String diskName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.revokeAccessWithServiceResponseAsync(resourceGroupName, diskName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> revokeAccessAsync(String resourceGroupName, String diskName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.revokeAccessWithServiceResponseAsync(resourceGroupName, diskName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> revokeAccessAsync(String resourceGroupName, String diskName) {
        return this.revokeAccessWithServiceResponseAsync(resourceGroupName, diskName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> revokeAccessWithServiceResponseAsync(String resourceGroupName, String diskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = this.service.revokeAccess(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginRevokeAccess(String resourceGroupName, String diskName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginRevokeAccessWithServiceResponseAsync(resourceGroupName, diskName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginRevokeAccessAsync(String resourceGroupName, String diskName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRevokeAccessWithServiceResponseAsync(resourceGroupName, diskName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginRevokeAccessAsync(String resourceGroupName, String diskName) {
        return this.beginRevokeAccessWithServiceResponseAsync(resourceGroupName, diskName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginRevokeAccessWithServiceResponseAsync(String resourceGroupName, String diskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.beginRevokeAccess(this.client.subscriptionId(), resourceGroupName, diskName, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisksInner.this.beginRevokeAccessDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginRevokeAccessDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskInner>((Page)response.body()){

            public Page<DiskInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DisksInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<DiskInner>> serviceFuture, ListOperationCallback<DiskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(String nextPageLink) {
                return DisksInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DiskInner>>, Page<DiskInner>>(){

            public Page<DiskInner> call(ServiceResponse<Page<DiskInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DiskInner>>, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(ServiceResponse<Page<DiskInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DisksInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DisksInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskInner>((Page)response.body()){

            public Page<DiskInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DisksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskInner>> listNextAsync(String nextPageLink, ServiceFuture<List<DiskInner>> serviceFuture, ListOperationCallback<DiskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(String nextPageLink) {
                return DisksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DiskInner>>, Page<DiskInner>>(){

            public Page<DiskInner> call(ServiceResponse<Page<DiskInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DiskInner>>, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(ServiceResponse<Page<DiskInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DisksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskInner>>>>(){

            public Observable<ServiceResponse<Page<DiskInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DisksInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DisksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Body DiskInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Body DiskInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Body DiskUpdateInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Body DiskUpdateInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/disks")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks grantAccess"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}/beginGetAccess")
        public Observable<Response<ResponseBody>> grantAccess(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Body GrantAccessDataInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks beginGrantAccess"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}/beginGetAccess")
        public Observable<Response<ResponseBody>> beginGrantAccess(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Body GrantAccessDataInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks revokeAccess"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}/endGetAccess")
        public Observable<Response<ResponseBody>> revokeAccess(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks beginRevokeAccess"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}/endGetAccess")
        public Observable<Response<ResponseBody>> beginRevokeAccess(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

