/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ImageInner;
import com.microsoft.azure.management.compute.implementation.OperationStatusResponseInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ImagesInner
implements InnerSupportsGet<ImageInner>,
InnerSupportsDelete<OperationStatusResponseInner>,
InnerSupportsListing<ImageInner> {
    private ImagesService service;
    private ComputeManagementClientImpl client;

    public ImagesInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (ImagesService)retrofit.create(ImagesService.class);
        this.client = client;
    }

    public ImageInner createOrUpdate(String resourceGroupName, String imageName, ImageInner parameters) {
        return (ImageInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, imageName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ImageInner> createOrUpdateAsync(String resourceGroupName, String imageName, ImageInner parameters, ServiceCallback<ImageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, imageName, parameters), serviceCallback);
    }

    public Observable<ImageInner> createOrUpdateAsync(String resourceGroupName, String imageName, ImageInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, imageName, parameters).map((Func1)new Func1<ServiceResponse<ImageInner>, ImageInner>(){

            public ImageInner call(ServiceResponse<ImageInner> response) {
                return (ImageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ImageInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String imageName, ImageInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (imageName == null) {
            throw new IllegalArgumentException("Parameter imageName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, imageName, this.client.subscriptionId(), parameters, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ImageInner>(){}.getType());
    }

    public ImageInner beginCreateOrUpdate(String resourceGroupName, String imageName, ImageInner parameters) {
        return (ImageInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, imageName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ImageInner> beginCreateOrUpdateAsync(String resourceGroupName, String imageName, ImageInner parameters, ServiceCallback<ImageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, imageName, parameters), serviceCallback);
    }

    public Observable<ImageInner> beginCreateOrUpdateAsync(String resourceGroupName, String imageName, ImageInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, imageName, parameters).map((Func1)new Func1<ServiceResponse<ImageInner>, ImageInner>(){

            public ImageInner call(ServiceResponse<ImageInner> response) {
                return (ImageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ImageInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String imageName, ImageInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (imageName == null) {
            throw new IllegalArgumentException("Parameter imageName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-03-30";
        return this.service.beginCreateOrUpdate(resourceGroupName, imageName, this.client.subscriptionId(), parameters, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImageInner>>>(){

            public Observable<ServiceResponse<ImageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ImagesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImageInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImageInner>(){}.getType()).register(201, new TypeToken<ImageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner delete(String resourceGroupName, String imageName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, imageName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> deleteAsync(String resourceGroupName, String imageName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, imageName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> deleteAsync(String resourceGroupName, String imageName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, imageName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> deleteWithServiceResponseAsync(String resourceGroupName, String imageName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (imageName == null) {
            throw new IllegalArgumentException("Parameter imageName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, imageName, this.client.subscriptionId(), "2017-03-30", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginDelete(String resourceGroupName, String imageName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, imageName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginDeleteAsync(String resourceGroupName, String imageName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, imageName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginDeleteAsync(String resourceGroupName, String imageName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, imageName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String imageName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (imageName == null) {
            throw new IllegalArgumentException("Parameter imageName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.beginDelete(resourceGroupName, imageName, this.client.subscriptionId(), "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ImagesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ImageInner getByResourceGroup(String resourceGroupName, String imageName) {
        return (ImageInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, imageName).toBlocking().single()).body());
    }

    public ServiceFuture<ImageInner> getByResourceGroupAsync(String resourceGroupName, String imageName, ServiceCallback<ImageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, imageName), serviceCallback);
    }

    public Observable<ImageInner> getByResourceGroupAsync(String resourceGroupName, String imageName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, imageName).map((Func1)new Func1<ServiceResponse<ImageInner>, ImageInner>(){

            public ImageInner call(ServiceResponse<ImageInner> response) {
                return (ImageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ImageInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String imageName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (imageName == null) {
            throw new IllegalArgumentException("Parameter imageName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, imageName, this.client.subscriptionId(), expand, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImageInner>>>(){

            public Observable<ServiceResponse<ImageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ImagesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ImageInner getByResourceGroup(String resourceGroupName, String imageName, String expand) {
        return (ImageInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, imageName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<ImageInner> getByResourceGroupAsync(String resourceGroupName, String imageName, String expand, ServiceCallback<ImageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, imageName, expand), serviceCallback);
    }

    public Observable<ImageInner> getByResourceGroupAsync(String resourceGroupName, String imageName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, imageName, expand).map((Func1)new Func1<ServiceResponse<ImageInner>, ImageInner>(){

            public ImageInner call(ServiceResponse<ImageInner> response) {
                return (ImageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ImageInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String imageName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (imageName == null) {
            throw new IllegalArgumentException("Parameter imageName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.getByResourceGroup(resourceGroupName, imageName, this.client.subscriptionId(), expand, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImageInner>>>(){

            public Observable<ServiceResponse<ImageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ImagesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImageInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ImageInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ImageInner>((Page)response.body()){

            public Page<ImageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ImagesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ImageInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ImageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(String nextPageLink) {
                return ImagesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ImageInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ImageInner>>, Page<ImageInner>>(){

            public Page<ImageInner> call(ServiceResponse<Page<ImageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ImageInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ImageInner>>, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(ServiceResponse<Page<ImageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ImagesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ImageInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ImagesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ImageInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ImageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ImageInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ImageInner>((Page)response.body()){

            public Page<ImageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ImagesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ImageInner>> listAsync(ListOperationCallback<ImageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(String nextPageLink) {
                return ImagesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ImageInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ImageInner>>, Page<ImageInner>>(){

            public Page<ImageInner> call(ServiceResponse<Page<ImageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ImageInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ImageInner>>, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(ServiceResponse<Page<ImageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ImagesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ImageInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.list(this.client.subscriptionId(), "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ImagesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ImageInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ImageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ImageInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ImageInner>((Page)response.body()){

            public Page<ImageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ImagesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ImageInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ImageInner>> serviceFuture, ListOperationCallback<ImageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(String nextPageLink) {
                return ImagesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ImageInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ImageInner>>, Page<ImageInner>>(){

            public Page<ImageInner> call(ServiceResponse<Page<ImageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ImageInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ImageInner>>, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(ServiceResponse<Page<ImageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ImagesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ImageInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ImagesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ImageInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ImageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ImageInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ImageInner>((Page)response.body()){

            public Page<ImageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ImagesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ImageInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ImageInner>> serviceFuture, ListOperationCallback<ImageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(String nextPageLink) {
                return ImagesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ImageInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ImageInner>>, Page<ImageInner>>(){

            public Page<ImageInner> call(ServiceResponse<Page<ImageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ImageInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ImageInner>>, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(ServiceResponse<Page<ImageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ImagesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ImageInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ImageInner>>>>(){

            public Observable<ServiceResponse<Page<ImageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ImagesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ImageInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ImageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ImagesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Images createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="imageName") String var2, @Path(value="subscriptionId") String var3, @Body ImageInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Images beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="imageName") String var2, @Path(value="subscriptionId") String var3, @Body ImageInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Images delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="imageName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Images beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="imageName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Images getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="imageName") String var2, @Path(value="subscriptionId") String var3, @Query(value="$expand") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Images listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Images list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/images")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Images listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Images listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

