/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageResourceInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class VirtualMachineImagesInner {
    private VirtualMachineImagesService service;
    private ComputeManagementClientImpl client;

    public VirtualMachineImagesInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (VirtualMachineImagesService)retrofit.create(VirtualMachineImagesService.class);
        this.client = client;
    }

    public VirtualMachineImageInner get(String location, String publisherName, String offer, String skus, String version) {
        return (VirtualMachineImageInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(location, publisherName, offer, skus, version).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineImageInner> getAsync(String location, String publisherName, String offer, String skus, String version, ServiceCallback<VirtualMachineImageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(location, publisherName, offer, skus, version), serviceCallback);
    }

    public Observable<VirtualMachineImageInner> getAsync(String location, String publisherName, String offer, String skus, String version) {
        return this.getWithServiceResponseAsync(location, publisherName, offer, skus, version).map((Func1)new Func1<ServiceResponse<VirtualMachineImageInner>, VirtualMachineImageInner>(){

            public VirtualMachineImageInner call(ServiceResponse<VirtualMachineImageInner> response) {
                return (VirtualMachineImageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineImageInner>> getWithServiceResponseAsync(String location, String publisherName, String offer, String skus, String version) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (offer == null) {
            throw new IllegalArgumentException("Parameter offer is required and cannot be null.");
        }
        if (skus == null) {
            throw new IllegalArgumentException("Parameter skus is required and cannot be null.");
        }
        if (version == null) {
            throw new IllegalArgumentException("Parameter version is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.get(location, publisherName, offer, skus, version, this.client.subscriptionId(), "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineImageInner>>>(){

            public Observable<ServiceResponse<VirtualMachineImageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineImageInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineImageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineImageResourceInner> list(String location, String publisherName, String offer, String skus) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(location, publisherName, offer, skus).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineImageResourceInner>> listAsync(String location, String publisherName, String offer, String skus, ServiceCallback<List<VirtualMachineImageResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(location, publisherName, offer, skus), serviceCallback);
    }

    public Observable<List<VirtualMachineImageResourceInner>> listAsync(String location, String publisherName, String offer, String skus) {
        return this.listWithServiceResponseAsync(location, publisherName, offer, skus).map((Func1)new Func1<ServiceResponse<List<VirtualMachineImageResourceInner>>, List<VirtualMachineImageResourceInner>>(){

            public List<VirtualMachineImageResourceInner> call(ServiceResponse<List<VirtualMachineImageResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> listWithServiceResponseAsync(String location, String publisherName, String offer, String skus) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (offer == null) {
            throw new IllegalArgumentException("Parameter offer is required and cannot be null.");
        }
        if (skus == null) {
            throw new IllegalArgumentException("Parameter skus is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        String filter = null;
        Integer top = null;
        String orderby = null;
        return this.service.list(location, publisherName, offer, skus, this.client.subscriptionId(), filter, top, orderby, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<VirtualMachineImageResourceInner> list(String location, String publisherName, String offer, String skus, String filter, Integer top, String orderby) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(location, publisherName, offer, skus, filter, top, orderby).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineImageResourceInner>> listAsync(String location, String publisherName, String offer, String skus, String filter, Integer top, String orderby, ServiceCallback<List<VirtualMachineImageResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(location, publisherName, offer, skus, filter, top, orderby), serviceCallback);
    }

    public Observable<List<VirtualMachineImageResourceInner>> listAsync(String location, String publisherName, String offer, String skus, String filter, Integer top, String orderby) {
        return this.listWithServiceResponseAsync(location, publisherName, offer, skus, filter, top, orderby).map((Func1)new Func1<ServiceResponse<List<VirtualMachineImageResourceInner>>, List<VirtualMachineImageResourceInner>>(){

            public List<VirtualMachineImageResourceInner> call(ServiceResponse<List<VirtualMachineImageResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> listWithServiceResponseAsync(String location, String publisherName, String offer, String skus, String filter, Integer top, String orderby) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (offer == null) {
            throw new IllegalArgumentException("Parameter offer is required and cannot be null.");
        }
        if (skus == null) {
            throw new IllegalArgumentException("Parameter skus is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.list(location, publisherName, offer, skus, this.client.subscriptionId(), filter, top, orderby, "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<VirtualMachineImageResourceInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<VirtualMachineImageResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineImageResourceInner> listOffers(String location, String publisherName) {
        return (List)((ServiceResponse)this.listOffersWithServiceResponseAsync(location, publisherName).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineImageResourceInner>> listOffersAsync(String location, String publisherName, ServiceCallback<List<VirtualMachineImageResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listOffersWithServiceResponseAsync(location, publisherName), serviceCallback);
    }

    public Observable<List<VirtualMachineImageResourceInner>> listOffersAsync(String location, String publisherName) {
        return this.listOffersWithServiceResponseAsync(location, publisherName).map((Func1)new Func1<ServiceResponse<List<VirtualMachineImageResourceInner>>, List<VirtualMachineImageResourceInner>>(){

            public List<VirtualMachineImageResourceInner> call(ServiceResponse<List<VirtualMachineImageResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> listOffersWithServiceResponseAsync(String location, String publisherName) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.listOffers(location, publisherName, this.client.subscriptionId(), "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesInner.this.listOffersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<VirtualMachineImageResourceInner>> listOffersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<VirtualMachineImageResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineImageResourceInner> listPublishers(String location) {
        return (List)((ServiceResponse)this.listPublishersWithServiceResponseAsync(location).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineImageResourceInner>> listPublishersAsync(String location, ServiceCallback<List<VirtualMachineImageResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listPublishersWithServiceResponseAsync(location), serviceCallback);
    }

    public Observable<List<VirtualMachineImageResourceInner>> listPublishersAsync(String location) {
        return this.listPublishersWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<List<VirtualMachineImageResourceInner>>, List<VirtualMachineImageResourceInner>>(){

            public List<VirtualMachineImageResourceInner> call(ServiceResponse<List<VirtualMachineImageResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> listPublishersWithServiceResponseAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.listPublishers(location, this.client.subscriptionId(), "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesInner.this.listPublishersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<VirtualMachineImageResourceInner>> listPublishersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<VirtualMachineImageResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineImageResourceInner> listSkus(String location, String publisherName, String offer) {
        return (List)((ServiceResponse)this.listSkusWithServiceResponseAsync(location, publisherName, offer).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineImageResourceInner>> listSkusAsync(String location, String publisherName, String offer, ServiceCallback<List<VirtualMachineImageResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSkusWithServiceResponseAsync(location, publisherName, offer), serviceCallback);
    }

    public Observable<List<VirtualMachineImageResourceInner>> listSkusAsync(String location, String publisherName, String offer) {
        return this.listSkusWithServiceResponseAsync(location, publisherName, offer).map((Func1)new Func1<ServiceResponse<List<VirtualMachineImageResourceInner>>, List<VirtualMachineImageResourceInner>>(){

            public List<VirtualMachineImageResourceInner> call(ServiceResponse<List<VirtualMachineImageResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> listSkusWithServiceResponseAsync(String location, String publisherName, String offer) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (offer == null) {
            throw new IllegalArgumentException("Parameter offer is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-30";
        return this.service.listSkus(location, publisherName, offer, this.client.subscriptionId(), "2017-03-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineImageResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineImagesInner.this.listSkusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<VirtualMachineImageResourceInner>> listSkusDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<VirtualMachineImageResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualMachineImagesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineImages get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions/{version}")
        public Observable<Response<ResponseBody>> get(@Path(value="location") String var1, @Path(value="publisherName") String var2, @Path(value="offer") String var3, @Path(value="skus") String var4, @Path(value="version") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineImages list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions")
        public Observable<Response<ResponseBody>> list(@Path(value="location") String var1, @Path(value="publisherName") String var2, @Path(value="offer") String var3, @Path(value="skus") String var4, @Path(value="subscriptionId") String var5, @Query(value="$filter") String var6, @Query(value="$top") Integer var7, @Query(value="$orderby") String var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineImages listOffers"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers")
        public Observable<Response<ResponseBody>> listOffers(@Path(value="location") String var1, @Path(value="publisherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineImages listPublishers"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers")
        public Observable<Response<ResponseBody>> listPublishers(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineImages listSkus"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus")
        public Observable<Response<ResponseBody>> listSkus(@Path(value="location") String var1, @Path(value="publisherName") String var2, @Path(value="offer") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

