/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.AdditionalCapabilities;
import com.microsoft.azure.management.compute.ApiEntityReference;
import com.microsoft.azure.management.compute.BillingProfile;
import com.microsoft.azure.management.compute.BootDiagnostics;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.DiagnosticsProfile;
import com.microsoft.azure.management.compute.DiskCreateOptionTypes;
import com.microsoft.azure.management.compute.ImageReference;
import com.microsoft.azure.management.compute.KnownLinuxVirtualMachineImage;
import com.microsoft.azure.management.compute.KnownWindowsVirtualMachineImage;
import com.microsoft.azure.management.compute.LinuxConfiguration;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.ProximityPlacementGroup;
import com.microsoft.azure.management.compute.ProximityPlacementGroupType;
import com.microsoft.azure.management.compute.ResourceIdentityType;
import com.microsoft.azure.management.compute.RunCommandInput;
import com.microsoft.azure.management.compute.RunCommandInputParameter;
import com.microsoft.azure.management.compute.RunCommandResult;
import com.microsoft.azure.management.compute.SshConfiguration;
import com.microsoft.azure.management.compute.SshPublicKey;
import com.microsoft.azure.management.compute.StorageAccountTypes;
import com.microsoft.azure.management.compute.UpgradeMode;
import com.microsoft.azure.management.compute.UpgradePolicy;
import com.microsoft.azure.management.compute.VaultSecretGroup;
import com.microsoft.azure.management.compute.VirtualHardDisk;
import com.microsoft.azure.management.compute.VirtualMachineEvictionPolicyTypes;
import com.microsoft.azure.management.compute.VirtualMachinePriorityTypes;
import com.microsoft.azure.management.compute.VirtualMachineScaleSet;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetDataDisk;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetExtension;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetExtensionProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetIPConfiguration;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetManagedDiskParameters;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetNetworkConfiguration;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetNetworkProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetOSDisk;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetOSProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetPublicIPAddressConfiguration;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetSku;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetSkuTypes;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetStorageProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetUpdate;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetVMs;
import com.microsoft.azure.management.compute.WinRMConfiguration;
import com.microsoft.azure.management.compute.WinRMListener;
import com.microsoft.azure.management.compute.WindowsConfiguration;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.ProximityPlacementGroupImpl;
import com.microsoft.azure.management.compute.implementation.ProximityPlacementGroupInner;
import com.microsoft.azure.management.compute.implementation.VMSSPatchPayload;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetExtensionImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetMsiHandler;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetSkuImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetSkuInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetUnmanagedDataDiskImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetVMsImpl;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentHelper;
import com.microsoft.azure.management.msi.Identity;
import com.microsoft.azure.management.network.ApplicationSecurityGroup;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancerInboundNatPool;
import com.microsoft.azure.management.network.LoadBalancerPrivateFrontend;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.VirtualMachineScaleSetNetworkInterface;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.AvailabilityZoneId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceNamer;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Completable;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
public class VirtualMachineScaleSetImpl
extends GroupableParentResourceImpl<VirtualMachineScaleSet, VirtualMachineScaleSetInner, VirtualMachineScaleSetImpl, ComputeManager>
implements VirtualMachineScaleSet,
VirtualMachineScaleSet.DefinitionManagedOrUnmanaged,
VirtualMachineScaleSet.DefinitionManaged,
VirtualMachineScaleSet.DefinitionUnmanaged,
VirtualMachineScaleSet.Update,
VirtualMachineScaleSet.DefinitionStages.WithSystemAssignedIdentityBasedAccessOrCreate,
VirtualMachineScaleSet.DefinitionStages.WithUserAssignedManagedServiceIdentity,
VirtualMachineScaleSet.UpdateStages.WithSystemAssignedIdentityBasedAccessOrApply,
VirtualMachineScaleSet.UpdateStages.WithUserAssignedManagedServiceIdentity {
    private final StorageManager storageManager;
    private final NetworkManager networkManager;
    private final ResourceNamer namer;
    private boolean isMarketplaceLinuxImage = false;
    private String existingPrimaryNetworkSubnetNameToAssociate;
    private List<String> creatableStorageAccountKeys = new ArrayList<String>();
    private List<StorageAccount> existingStorageAccountsToAssociate = new ArrayList<StorageAccount>();
    private Map<String, VirtualMachineScaleSetExtension> extensions;
    private LoadBalancer primaryInternetFacingLoadBalancer;
    private LoadBalancer primaryInternalLoadBalancer;
    private boolean removePrimaryInternetFacingLoadBalancerOnUpdate;
    private boolean removePrimaryInternalLoadBalancerOnUpdate;
    private LoadBalancer primaryInternetFacingLoadBalancerToAttachOnUpdate;
    private LoadBalancer primaryInternalLoadBalancerToAttachOnUpdate;
    private List<String> primaryInternetFacingLBBackendsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBBackendsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBInboundNatPoolsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternetFacingLBBackendsToAddOnUpdate = new ArrayList<String>();
    private List<String> primaryInternetFacingLBInboundNatPoolsToAddOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBBackendsToAddOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBInboundNatPoolsToAddOnUpdate = new ArrayList<String>();
    private PagedListConverter<VirtualMachineScaleSetSkuInner, VirtualMachineScaleSetSku> skuConverter;
    private boolean isUnmanagedDiskSelected;
    private final ManagedDataDiskCollection managedDataDisks;
    VirtualMachineScaleSetMsiHandler virtualMachineScaleSetMsiHandler;
    private final BootDiagnosticsHandler bootDiagnosticsHandler;
    private String newProximityPlacementGroupName;
    private ProximityPlacementGroupType newProximityPlacementGroupType;

    VirtualMachineScaleSetImpl(String name, VirtualMachineScaleSetInner innerModel, ComputeManager computeManager, StorageManager storageManager, NetworkManager networkManager, GraphRbacManager rbacManager) {
        super(name, (Resource)innerModel, (ManagerBase)computeManager);
        this.storageManager = storageManager;
        this.networkManager = networkManager;
        this.namer = SdkContext.getResourceNamerFactory().createResourceNamer(this.name());
        this.skuConverter = new PagedListConverter<VirtualMachineScaleSetSkuInner, VirtualMachineScaleSetSku>(){

            public Observable<VirtualMachineScaleSetSku> typeConvertAsync(VirtualMachineScaleSetSkuInner inner) {
                return Observable.just((Object)new VirtualMachineScaleSetSkuImpl(inner));
            }
        };
        this.managedDataDisks = new ManagedDataDiskCollection(this);
        this.virtualMachineScaleSetMsiHandler = new VirtualMachineScaleSetMsiHandler(rbacManager, this);
        this.bootDiagnosticsHandler = new BootDiagnosticsHandler(this);
        this.newProximityPlacementGroupName = null;
        this.newProximityPlacementGroupType = null;
    }

    protected void initializeChildrenFromInner() {
        this.extensions = new HashMap<String, VirtualMachineScaleSetExtension>();
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().extensionProfile() != null && ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().extensionProfile().extensions() != null) {
            for (VirtualMachineScaleSetExtensionInner inner : ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().extensionProfile().extensions()) {
                this.extensions.put(inner.name(), new VirtualMachineScaleSetExtensionImpl(inner, this));
            }
        }
    }

    @Override
    public VirtualMachineScaleSetVMs virtualMachines() {
        return new VirtualMachineScaleSetVMsImpl(this, ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachineScaleSetVMs(), (ComputeManager)this.myManager);
    }

    @Override
    public PagedList<VirtualMachineScaleSetSku> listAvailableSkus() {
        return this.skuConverter.convert(((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachineScaleSets().listSkus(this.resourceGroupName(), this.name()));
    }

    @Override
    public void deallocate() {
        this.deallocateAsync().await();
    }

    @Override
    public Completable deallocateAsync() {
        Observable<Void> d = ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachineScaleSets().deallocateAsync(this.resourceGroupName(), this.name());
        Observable<VirtualMachineScaleSet> r = this.refreshAsync();
        return Observable.concat(d, r).toCompletable();
    }

    @Override
    public ServiceFuture<Void> deallocateAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.deallocateAsync(), callback);
    }

    @Override
    public void powerOff() {
        this.powerOffAsync().await();
    }

    @Override
    public Completable powerOffAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachineScaleSets().powerOffAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> powerOffAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.powerOffAsync(), callback);
    }

    @Override
    public void restart() {
        this.restartAsync().await();
    }

    @Override
    public Completable restartAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachineScaleSets().restartAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> restartAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.restartAsync(), callback);
    }

    @Override
    public void start() {
        this.startAsync().await();
    }

    @Override
    public Completable startAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachineScaleSets().startAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> startAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.startAsync(), callback);
    }

    @Override
    public void reimage() {
        this.reimageAsync().await();
    }

    @Override
    public Completable reimageAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachineScaleSets().reimageAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> reimageAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.reimageAsync(), callback);
    }

    @Override
    public RunCommandResult runPowerShellScriptInVMInstance(String vmId, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runPowerShellScriptInVMInstance(this.resourceGroupName(), this.name(), vmId, scriptLines, scriptParameters);
    }

    @Override
    public Observable<RunCommandResult> runPowerShellScriptInVMInstanceAsync(String vmId, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runPowerShellScriptInVMInstanceAsync(this.resourceGroupName(), this.name(), vmId, scriptLines, scriptParameters);
    }

    @Override
    public RunCommandResult runShellScriptInVMInstance(String vmId, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runShellScriptInVMInstance(this.resourceGroupName(), this.name(), vmId, scriptLines, scriptParameters);
    }

    @Override
    public Observable<RunCommandResult> runShellScriptInVMInstanceAsync(String vmId, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runShellScriptInVMInstanceAsync(this.resourceGroupName(), this.name(), vmId, scriptLines, scriptParameters);
    }

    @Override
    public RunCommandResult runCommandInVMInstance(String vmId, RunCommandInput inputCommand) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runCommandInVMInstance(this.resourceGroupName(), this.name(), vmId, inputCommand);
    }

    @Override
    public Observable<RunCommandResult> runCommandVMInstanceAsync(String vmId, RunCommandInput inputCommand) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runCommandVMInstanceAsync(this.resourceGroupName(), this.name(), vmId, inputCommand);
    }

    @Override
    public String computerNamePrefix() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().computerNamePrefix();
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().osType();
    }

    @Override
    public CachingTypes osDiskCachingType() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().caching();
    }

    @Override
    public String osDiskName() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().name();
    }

    @Override
    public UpgradeMode upgradeModel() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).upgradePolicy().mode();
    }

    @Override
    public boolean overProvisionEnabled() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).overprovision();
    }

    @Override
    public VirtualMachineScaleSetSkuTypes sku() {
        return VirtualMachineScaleSetSkuTypes.fromSku(((VirtualMachineScaleSetInner)((Object)this.inner())).sku());
    }

    @Override
    public int capacity() {
        return Utils.toPrimitiveInt((Long)((VirtualMachineScaleSetInner)((Object)this.inner())).sku().capacity());
    }

    @Override
    public Network getPrimaryNetwork() throws IOException {
        String subnetId = this.primaryNicDefaultIPConfiguration().subnet().id();
        String virtualNetworkId = ResourceUtils.parentResourceIdFromResourceId((String)subnetId);
        return (Network)this.networkManager.networks().getById(virtualNetworkId);
    }

    @Override
    public LoadBalancer getPrimaryInternetFacingLoadBalancer() throws IOException {
        if (this.primaryInternetFacingLoadBalancer == null) {
            this.loadCurrentPrimaryLoadBalancersIfAvailable();
        }
        return this.primaryInternetFacingLoadBalancer;
    }

    @Override
    public Map<String, LoadBalancerBackend> listPrimaryInternetFacingLoadBalancerBackends() throws IOException {
        if (this.getPrimaryInternetFacingLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getBackendsAssociatedWithIpConfiguration(this.primaryInternetFacingLoadBalancer, this.primaryNicDefaultIPConfiguration());
        }
        return new HashMap<String, LoadBalancerBackend>();
    }

    @Override
    public Map<String, LoadBalancerInboundNatPool> listPrimaryInternetFacingLoadBalancerInboundNatPools() throws IOException {
        if (this.getPrimaryInternetFacingLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getInboundNatPoolsAssociatedWithIpConfiguration(this.primaryInternetFacingLoadBalancer, this.primaryNicDefaultIPConfiguration());
        }
        return new HashMap<String, LoadBalancerInboundNatPool>();
    }

    @Override
    public LoadBalancer getPrimaryInternalLoadBalancer() throws IOException {
        if (this.primaryInternalLoadBalancer == null) {
            this.loadCurrentPrimaryLoadBalancersIfAvailable();
        }
        return this.primaryInternalLoadBalancer;
    }

    @Override
    public Map<String, LoadBalancerBackend> listPrimaryInternalLoadBalancerBackends() throws IOException {
        if (this.getPrimaryInternalLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getBackendsAssociatedWithIpConfiguration(this.primaryInternalLoadBalancer, this.primaryNicDefaultIPConfiguration());
        }
        return new HashMap<String, LoadBalancerBackend>();
    }

    @Override
    public Map<String, LoadBalancerInboundNatPool> listPrimaryInternalLoadBalancerInboundNatPools() throws IOException {
        if (this.getPrimaryInternalLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getInboundNatPoolsAssociatedWithIpConfiguration(this.primaryInternalLoadBalancer, this.primaryNicDefaultIPConfiguration());
        }
        return new HashMap<String, LoadBalancerInboundNatPool>();
    }

    @Override
    public List<String> primaryPublicIPAddressIds() throws IOException {
        LoadBalancer loadBalancer = this.getPrimaryInternetFacingLoadBalancer();
        if (loadBalancer != null) {
            return loadBalancer.publicIPAddressIds();
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> vhdContainers() {
        if (this.storageProfile() != null && this.storageProfile().osDisk() != null && this.storageProfile().osDisk().vhdContainers() != null) {
            return this.storageProfile().osDisk().vhdContainers();
        }
        return new ArrayList<String>();
    }

    @Override
    public VirtualMachineScaleSetStorageProfile storageProfile() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile();
    }

    @Override
    public VirtualMachineScaleSetNetworkProfile networkProfile() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().networkProfile();
    }

    @Override
    public Map<String, VirtualMachineScaleSetExtension> extensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    @Override
    public VirtualMachinePriorityTypes virtualMachinePriority() {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().priority();
        }
        return null;
    }

    @Override
    public BillingProfile billingProfile() {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().billingProfile();
        }
        return null;
    }

    @Override
    public VirtualMachineScaleSetPublicIPAddressConfiguration virtualMachinePublicIpConfig() {
        VirtualMachineScaleSetIPConfiguration nicConfig = this.primaryNicDefaultIPConfiguration();
        if (nicConfig != null) {
            return nicConfig.publicIPAddressConfiguration();
        }
        return null;
    }

    @Override
    public VirtualMachineEvictionPolicyTypes virtualMachineEvictionPolicy() {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().evictionPolicy();
        }
        return null;
    }

    @Override
    public boolean isIpForwardingEnabled() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        if (nicConfig.enableIPForwarding() != null) {
            return nicConfig.enableIPForwarding();
        }
        return false;
    }

    @Override
    public boolean isAcceleratedNetworkingEnabled() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        if (nicConfig.enableAcceleratedNetworking() != null) {
            return nicConfig.enableAcceleratedNetworking();
        }
        return false;
    }

    @Override
    public String networkSecurityGroupId() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        if (nicConfig.networkSecurityGroup() != null) {
            return nicConfig.networkSecurityGroup().id();
        }
        return null;
    }

    @Override
    public boolean isSinglePlacementGroupEnabled() {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).singlePlacementGroup() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.inner())).singlePlacementGroup();
        }
        return false;
    }

    @Override
    public List<String> applicationGatewayBackendAddressPoolsIds() {
        VirtualMachineScaleSetIPConfiguration nicIpConfig = this.primaryNicDefaultIPConfiguration();
        List<SubResource> backendPools = nicIpConfig.applicationGatewayBackendAddressPools();
        ArrayList<String> result = new ArrayList<String>();
        if (backendPools != null) {
            for (SubResource backendPool : backendPools) {
                result.add(backendPool.id());
            }
        }
        return result;
    }

    @Override
    public List<String> applicationSecurityGroupIds() {
        VirtualMachineScaleSetIPConfiguration nicIpConfig = this.primaryNicDefaultIPConfiguration();
        ArrayList<String> asgIds = new ArrayList<String>();
        if (nicIpConfig.applicationSecurityGroups() != null) {
            for (SubResource asg : nicIpConfig.applicationSecurityGroups()) {
                asgIds.add(asg.id());
            }
        }
        return asgIds;
    }

    @Override
    public Boolean doNotRunExtensionsOnOverprovisionedVMs() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).doNotRunExtensionsOnOverprovisionedVMs();
    }

    @Override
    public ProximityPlacementGroup proximityPlacementGroup() {
        ResourceId id = ResourceId.fromString((String)((VirtualMachineScaleSetInner)((Object)this.inner())).proximityPlacementGroup().id());
        ProximityPlacementGroupInner plgInner = ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).proximityPlacementGroups().getByResourceGroup(id.resourceGroupName(), id.name());
        if (plgInner == null) {
            return null;
        }
        return new ProximityPlacementGroupImpl(plgInner);
    }

    @Override
    public AdditionalCapabilities additionalCapabilities() {
        return ((VirtualMachineScaleSetInner)((Object)this.inner())).additionalCapabilities();
    }

    @Override
    public VirtualMachineScaleSetNetworkInterface getNetworkInterfaceByInstanceId(String instanceId, String name) {
        return this.networkManager.networkInterfaces().getByVirtualMachineScaleSetInstanceId(this.resourceGroupName(), this.name(), instanceId, name);
    }

    @Override
    public PagedList<VirtualMachineScaleSetNetworkInterface> listNetworkInterfaces() {
        return this.networkManager.networkInterfaces().listByVirtualMachineScaleSet(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedList<VirtualMachineScaleSetNetworkInterface> listNetworkInterfacesByInstanceId(String virtualMachineInstanceId) {
        return this.networkManager.networkInterfaces().listByVirtualMachineScaleSetInstanceId(this.resourceGroupName(), this.name(), virtualMachineInstanceId);
    }

    @Override
    public VirtualMachineScaleSetImpl withSku(VirtualMachineScaleSetSkuTypes skuType) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).withSku(skuType.sku());
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSku(VirtualMachineScaleSetSku sku) {
        return this.withSku(sku.skuType());
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingPrimaryNetworkSubnet(Network network, String subnetName) {
        this.existingPrimaryNetworkSubnetNameToAssociate = VirtualMachineScaleSetImpl.mergePath(network.id(), "subnets", subnetName);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingPrimaryInternetFacingLoadBalancer(LoadBalancer loadBalancer) {
        if (loadBalancer.publicIPAddressIds().isEmpty()) {
            throw new IllegalArgumentException("Parameter loadBalancer must be an Internet facing load balancer");
        }
        if (this.isInCreateMode()) {
            this.primaryInternetFacingLoadBalancer = loadBalancer;
            VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternetFacingLoadBalancer, this.primaryNicDefaultIPConfiguration());
        } else {
            this.primaryInternetFacingLoadBalancerToAttachOnUpdate = loadBalancer;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternetFacingLoadBalancerBackends(String ... backendNames) {
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIPConfiguration defaultPrimaryIpConfig = this.primaryNicDefaultIPConfiguration();
            VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), defaultPrimaryIpConfig, backendNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBBackendsToAddOnUpdate, backendNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternetFacingLoadBalancerInboundNatPools(String ... natPoolNames) {
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIPConfiguration defaultPrimaryIpConfig = this.primaryNicDefaultIPConfiguration();
            VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), defaultPrimaryIpConfig, natPoolNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate, natPoolNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingPrimaryInternalLoadBalancer(LoadBalancer loadBalancer) {
        if (!loadBalancer.publicIPAddressIds().isEmpty()) {
            throw new IllegalArgumentException("Parameter loadBalancer must be an internal load balancer");
        }
        String lbNetworkId = null;
        for (LoadBalancerPrivateFrontend frontEnd : loadBalancer.privateFrontends().values()) {
            if (frontEnd.networkId() == null) continue;
            lbNetworkId = frontEnd.networkId();
        }
        if (this.isInCreateMode()) {
            String vmNICNetworkId = ResourceUtils.parentResourceIdFromResourceId((String)this.existingPrimaryNetworkSubnetNameToAssociate);
            if (!vmNICNetworkId.equalsIgnoreCase(lbNetworkId)) {
                throw new IllegalArgumentException("Virtual network associated with scale set virtual machines and internal load balancer must be same. '" + vmNICNetworkId + "''" + lbNetworkId);
            }
            this.primaryInternalLoadBalancer = loadBalancer;
            VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternalLoadBalancer, this.primaryNicDefaultIPConfiguration());
        } else {
            String vmNicVnetId = ResourceUtils.parentResourceIdFromResourceId((String)this.primaryNicDefaultIPConfiguration().subnet().id());
            if (!vmNicVnetId.equalsIgnoreCase(lbNetworkId)) {
                throw new IllegalArgumentException("Virtual network associated with scale set virtual machines and internal load balancer must be same. '" + vmNicVnetId + "''" + lbNetworkId);
            }
            this.primaryInternalLoadBalancerToAttachOnUpdate = loadBalancer;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternalLoadBalancerBackends(String ... backendNames) {
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIPConfiguration defaultPrimaryIpConfig = this.primaryNicDefaultIPConfiguration();
            VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternalLoadBalancer.id(), defaultPrimaryIpConfig, backendNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBBackendsToAddOnUpdate, backendNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternalLoadBalancerInboundNatPools(String ... natPoolNames) {
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIPConfiguration defaultPrimaryIpConfig = this.primaryNicDefaultIPConfiguration();
            VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternalLoadBalancer.id(), defaultPrimaryIpConfig, natPoolNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBInboundNatPoolsToAddOnUpdate, natPoolNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternalLoadBalancer() {
        if (this.isInUpdateMode()) {
            this.removePrimaryInternalLoadBalancerOnUpdate = true;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternetFacingLoadBalancer() {
        if (this.isInUpdateMode()) {
            this.removePrimaryInternetFacingLoadBalancerOnUpdate = true;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternetFacingLoadBalancerBackends(String ... backendNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBBackendsToRemoveOnUpdate, backendNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternalLoadBalancerBackends(String ... backendNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBBackendsToRemoveOnUpdate, backendNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternetFacingLoadBalancerNatPools(String ... natPoolNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate, natPoolNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternalLoadBalancerNatPools(String ... natPoolNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBInboundNatPoolsToRemoveOnUpdate, natPoolNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPopularWindowsImage(KnownWindowsVirtualMachineImage knownImage) {
        return this.withSpecificWindowsImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineScaleSetImpl withLatestWindowsImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference().withPublisher(publisher).withOffer(offer).withSku(sku).withVersion("latest");
        return this.withSpecificWindowsImageVersion(imageReference);
    }

    @Override
    public VirtualMachineScaleSetImpl withSpecificWindowsImageVersion(ImageReference imageReference) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().withImageReference(imageReference);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withWindowsCustomImage(String customImageId) {
        ImageReference imageReferenceInner = new ImageReference();
        imageReferenceInner.withId(customImageId);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().withImageReference(imageReferenceInner);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withStoredWindowsImage(String imageUrl) {
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withOsType(OperatingSystemTypes.WINDOWS);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPopularLinuxImage(KnownLinuxVirtualMachineImage knownImage) {
        return this.withSpecificLinuxImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineScaleSetImpl withLatestLinuxImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference().withPublisher(publisher).withOffer(offer).withSku(sku).withVersion("latest");
        return this.withSpecificLinuxImageVersion(imageReference);
    }

    @Override
    public VirtualMachineScaleSetImpl withSpecificLinuxImageVersion(ImageReference imageReference) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().withImageReference(imageReference);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withLinuxConfiguration(new LinuxConfiguration());
        this.isMarketplaceLinuxImage = true;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withLinuxCustomImage(String customImageId) {
        ImageReference imageReferenceInner = new ImageReference();
        imageReferenceInner.withId(customImageId);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().withImageReference(imageReferenceInner);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withLinuxConfiguration(new LinuxConfiguration());
        this.isMarketplaceLinuxImage = true;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withStoredLinuxImage(String imageUrl) {
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withOsType(OperatingSystemTypes.LINUX);
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withLinuxConfiguration(new LinuxConfiguration());
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAdminUsername(String adminUserName) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withAdminUsername(adminUserName);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withRootUsername(String adminUserName) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withAdminUsername(adminUserName);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAdminPassword(String password) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withAdminPassword(password);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withRootPassword(String password) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withAdminPassword(password);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSsh(String publicKeyData) {
        VirtualMachineScaleSetOSProfile osProfile = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile();
        if (osProfile.linuxConfiguration().ssh() == null) {
            SshConfiguration sshConfiguration = new SshConfiguration();
            sshConfiguration.withPublicKeys(new ArrayList<SshPublicKey>());
            osProfile.linuxConfiguration().withSsh(sshConfiguration);
        }
        SshPublicKey sshPublicKey = new SshPublicKey();
        sshPublicKey.withKeyData(publicKeyData);
        sshPublicKey.withPath("/home/" + osProfile.adminUsername() + "/.ssh/authorized_keys");
        osProfile.linuxConfiguration().ssh().publicKeys().add(sshPublicKey);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVMAgent() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutVMAgent() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAutoUpdate() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutAutoUpdate() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withTimeZone(String timeZone) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withTimeZone(timeZone);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withWinRM(WinRMListener listener) {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().winRM() == null) {
            WinRMConfiguration winRMConfiguration = new WinRMConfiguration();
            ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().withWinRM(winRMConfiguration);
        }
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().windowsConfiguration().winRM().listeners().add(listener);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOSDiskCaching(CachingTypes cachingType) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withCaching(cachingType);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOSDiskName(String name) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withName(name);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withComputerNamePrefix(String namePrefix) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withComputerNamePrefix(namePrefix);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withUpgradeMode(UpgradeMode upgradeMode) {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).upgradePolicy() == null) {
            ((VirtualMachineScaleSetInner)((Object)this.inner())).withUpgradePolicy(new UpgradePolicy());
        }
        ((VirtualMachineScaleSetInner)((Object)this.inner())).upgradePolicy().withMode(upgradeMode);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOverProvision(boolean enabled) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).withOverprovision(enabled);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOverProvisioning() {
        return this.withOverProvision(true);
    }

    @Override
    public VirtualMachineScaleSetImpl withoutOverProvisioning() {
        return this.withOverProvision(false);
    }

    @Override
    public VirtualMachineScaleSetImpl withCapacity(int capacity) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).sku().withCapacity(new Long(capacity));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewStorageAccount(String name) {
        StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(name)).withRegion(this.regionName());
        Creatable definitionAfterGroup = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return this.withNewStorageAccount(definitionAfterGroup);
    }

    @Override
    public VirtualMachineScaleSetImpl withNewStorageAccount(Creatable<StorageAccount> creatable) {
        this.creatableStorageAccountKeys.add(this.addDependency(creatable));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.existingStorageAccountsToAssociate.add(storageAccount);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withCustomData(String base64EncodedCustomData) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withCustomData(base64EncodedCustomData);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSecrets(List<VaultSecretGroup> secrets) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withSecrets(secrets);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutSecrets() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile().withSecrets(new ArrayList<VaultSecretGroup>());
        return this;
    }

    public VirtualMachineScaleSetExtensionImpl defineNewExtension(String name) {
        return new VirtualMachineScaleSetExtensionImpl(new VirtualMachineScaleSetExtensionInner().withName(name), this);
    }

    protected VirtualMachineScaleSetImpl withExtension(VirtualMachineScaleSetExtensionImpl extension) {
        this.extensions.put(extension.name(), extension);
        return this;
    }

    @Override
    public VirtualMachineScaleSetExtensionImpl updateExtension(String name) {
        return (VirtualMachineScaleSetExtensionImpl)this.extensions.get(name);
    }

    @Override
    public VirtualMachineScaleSetImpl withoutExtension(String name) {
        if (this.extensions.containsKey(name)) {
            this.extensions.remove(name);
        }
        return this;
    }

    @Override
    public boolean isManagedDiskEnabled() {
        VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile();
        if (this.isOsDiskFromCustomImage(storageProfile)) {
            return true;
        }
        if (this.isOSDiskFromStoredImage(storageProfile)) {
            return false;
        }
        if (this.isOSDiskFromPlatformImage(storageProfile) && this.isUnmanagedDiskSelected) {
            return false;
        }
        if (this.isInCreateMode()) {
            return true;
        }
        List<String> vhdContainers = storageProfile.osDisk().vhdContainers();
        return vhdContainers == null || vhdContainers.size() == 0;
    }

    @Override
    public boolean isManagedServiceIdentityEnabled() {
        ResourceIdentityType type = this.managedServiceIdentityType();
        return type != null && !type.equals((Object)ResourceIdentityType.NONE);
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).identity() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.inner())).identity().tenantId();
        }
        return null;
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).identity() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.inner())).identity().principalId();
        }
        return null;
    }

    @Override
    public ResourceIdentityType managedServiceIdentityType() {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).identity() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.inner())).identity().type();
        }
        return null;
    }

    @Override
    public Set<String> userAssignedManagedServiceIdentityIds() {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).identity() != null && ((VirtualMachineScaleSetInner)((Object)this.inner())).identity().userAssignedIdentities() != null) {
            return Collections.unmodifiableSet(new HashSet<String>(((VirtualMachineScaleSetInner)((Object)this.inner())).identity().userAssignedIdentities().keySet()));
        }
        return Collections.unmodifiableSet(new HashSet());
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).zones() != null) {
            for (String zone : ((VirtualMachineScaleSetInner)((Object)this.inner())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public boolean isBootDiagnosticsEnabled() {
        return this.bootDiagnosticsHandler.isBootDiagnosticsEnabled();
    }

    @Override
    public String bootDiagnosticsStorageUri() {
        return this.bootDiagnosticsHandler.bootDiagnosticsStorageUri();
    }

    @Override
    public StorageAccountTypes managedOSDiskStorageAccountType() {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile() != null && ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile() != null && ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk() != null && ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().managedDisk() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().managedDisk().storageAccountType();
        }
        return null;
    }

    @Override
    public VirtualMachineScaleSetImpl withUnmanagedDisks() {
        this.isUnmanagedDiskSelected = true;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDisk(int sizeInGB) {
        this.throwIfManagedDiskDisabled("This virtual machine scale set is based on un-managed disk(s), both un-managed and managed cannot exists together in a virtual machine scale set");
        this.managedDataDisks.implicitDisksToAssociate.add(new VirtualMachineScaleSetDataDisk().withLun(-1).withDiskSizeGB(sizeInGB));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDisk(int sizeInGB, int lun, CachingTypes cachingType) {
        this.throwIfManagedDiskDisabled("This virtual machine scale set is based on un-managed disk(s), both un-managed and managed cannot exists together in a virtual machine scale set");
        this.managedDataDisks.implicitDisksToAssociate.add(new VirtualMachineScaleSetDataDisk().withLun(lun).withDiskSizeGB(sizeInGB).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDisk(int sizeInGB, int lun, CachingTypes cachingType, StorageAccountTypes storageAccountType) {
        this.throwIfManagedDiskDisabled("This virtual machine scale set is based on un-managed disk(s), both un-managed and managed cannot exists together in a virtual machine scale set");
        VirtualMachineScaleSetManagedDiskParameters managedDiskParameters = new VirtualMachineScaleSetManagedDiskParameters();
        managedDiskParameters.withStorageAccountType(storageAccountType);
        this.managedDataDisks.implicitDisksToAssociate.add(new VirtualMachineScaleSetDataDisk().withLun(lun).withDiskSizeGB(sizeInGB).withCaching(cachingType).withManagedDisk(managedDiskParameters));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutDataDisk(int lun) {
        if (!this.isManagedDiskEnabled()) {
            return this;
        }
        this.managedDataDisks.diskLunsToRemove.add(lun);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDiskFromImage(int imageLun) {
        this.managedDataDisks.newDisksFromImage.add(new VirtualMachineScaleSetDataDisk().withLun(imageLun));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDiskFromImage(int imageLun, int newSizeInGB, CachingTypes cachingType) {
        this.managedDataDisks.newDisksFromImage.add(new VirtualMachineScaleSetDataDisk().withLun(imageLun).withDiskSizeGB(newSizeInGB).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDiskFromImage(int imageLun, int newSizeInGB, CachingTypes cachingType, StorageAccountTypes storageAccountType) {
        VirtualMachineScaleSetManagedDiskParameters managedDiskParameters = new VirtualMachineScaleSetManagedDiskParameters();
        managedDiskParameters.withStorageAccountType(storageAccountType);
        this.managedDataDisks.newDisksFromImage.add(new VirtualMachineScaleSetDataDisk().withLun(imageLun).withDiskSizeGB(newSizeInGB).withManagedDisk(managedDiskParameters).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOSDiskStorageAccountType(StorageAccountTypes accountType) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk().withManagedDisk(new VirtualMachineScaleSetManagedDiskParameters().withStorageAccountType(accountType));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withDataDiskDefaultCachingType(CachingTypes cachingType) {
        this.managedDataDisks.setDefaultCachingType(cachingType);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withDataDiskDefaultStorageAccountType(StorageAccountTypes storageAccountType) {
        this.managedDataDisks.setDefaultStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSystemAssignedManagedServiceIdentity() {
        this.virtualMachineScaleSetMsiHandler.withLocalManagedServiceIdentity();
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutSystemAssignedManagedServiceIdentity() {
        this.virtualMachineScaleSetMsiHandler.withoutLocalManagedServiceIdentity();
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSystemAssignedIdentityBasedAccessTo(String resourceId, BuiltInRole role) {
        this.virtualMachineScaleSetMsiHandler.withAccessTo(resourceId, role);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole asRole) {
        this.virtualMachineScaleSetMsiHandler.withAccessToCurrentResourceGroup(asRole);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSystemAssignedIdentityBasedAccessTo(String scope, String roleDefinitionId) {
        this.virtualMachineScaleSetMsiHandler.withAccessTo(scope, roleDefinitionId);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String roleDefinitionId) {
        this.virtualMachineScaleSetMsiHandler.withAccessToCurrentResourceGroup(roleDefinitionId);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewUserAssignedManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.virtualMachineScaleSetMsiHandler.withNewExternalManagedServiceIdentity(creatableIdentity);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingUserAssignedManagedServiceIdentity(Identity identity) {
        this.virtualMachineScaleSetMsiHandler.withExistingExternalManagedServiceIdentity(identity);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutUserAssignedManagedServiceIdentity(String identityId) {
        this.virtualMachineScaleSetMsiHandler.withoutExternalManagedServiceIdentity(identityId);
        return this;
    }

    protected void beforeCreating() {
        if (this.extensions.size() > 0) {
            ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().withExtensionProfile(new VirtualMachineScaleSetExtensionProfile()).extensionProfile().withExtensions(this.innersFromWrappers(this.extensions.values()));
        }
    }

    protected Observable<VirtualMachineScaleSetInner> createInner() {
        if (this.isInCreateMode()) {
            this.setOSProfileDefaults();
            this.setOSDiskDefault();
        }
        this.setPrimaryIpConfigurationSubnet();
        this.setPrimaryIpConfigurationBackendsAndInboundNatPools();
        if (this.isManagedDiskEnabled()) {
            this.managedDataDisks.setDataDisksDefaults();
        } else {
            List<VirtualMachineScaleSetDataDisk> dataDisks = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().dataDisks();
            VirtualMachineScaleSetUnmanagedDataDiskImpl.setDataDisksDefaults(dataDisks, this.name());
        }
        this.handleUnManagedOSDiskContainers();
        this.bootDiagnosticsHandler.handleDiagnosticsSettings();
        this.virtualMachineScaleSetMsiHandler.processCreatedExternalIdentities();
        this.virtualMachineScaleSetMsiHandler.handleExternalIdentities();
        this.createNewProximityPlacementGroup();
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachineScaleSets().createOrUpdateAsync(this.resourceGroupName(), this.name(), (VirtualMachineScaleSetInner)((Object)this.inner()));
    }

    protected void afterCreating() {
        this.clearCachedProperties();
        this.initializeChildrenFromInner();
        this.virtualMachineScaleSetMsiHandler.clear();
    }

    public Observable<VirtualMachineScaleSet> updateResourceAsync() {
        if (this.extensions.size() > 0) {
            ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().withExtensionProfile(new VirtualMachineScaleSetExtensionProfile()).extensionProfile().withExtensions(this.innersFromWrappers(this.extensions.values()));
        }
        this.setPrimaryIpConfigurationSubnet();
        this.setPrimaryIpConfigurationBackendsAndInboundNatPools();
        if (this.isManagedDiskEnabled()) {
            this.managedDataDisks.setDataDisksDefaults();
        } else {
            List<VirtualMachineScaleSetDataDisk> dataDisks = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().dataDisks();
            VirtualMachineScaleSetUnmanagedDataDiskImpl.setDataDisksDefaults(dataDisks, this.name());
        }
        this.handleUnManagedOSDiskContainers();
        this.bootDiagnosticsHandler.handleDiagnosticsSettings();
        this.virtualMachineScaleSetMsiHandler.processCreatedExternalIdentities();
        VirtualMachineScaleSetUpdate updateParameter = VMSSPatchPayload.preparePatchPayload(this);
        this.virtualMachineScaleSetMsiHandler.handleExternalIdentities(updateParameter);
        final VirtualMachineScaleSetImpl self = this;
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachineScaleSets().updateAsync(this.resourceGroupName(), this.name(), updateParameter).map((Func1)new Func1<VirtualMachineScaleSetInner, VirtualMachineScaleSet>(){

            public VirtualMachineScaleSet call(VirtualMachineScaleSetInner vmssInner) {
                VirtualMachineScaleSetImpl.this.setInner((Object)vmssInner);
                self.clearCachedProperties();
                self.initializeChildrenFromInner();
                self.virtualMachineScaleSetMsiHandler.clear();
                return self;
            }
        });
    }

    public Observable<VirtualMachineScaleSet> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<VirtualMachineScaleSet, VirtualMachineScaleSet>(){

            public VirtualMachineScaleSet call(VirtualMachineScaleSet virtualMachineScaleSet) {
                VirtualMachineScaleSetImpl impl = (VirtualMachineScaleSetImpl)virtualMachineScaleSet;
                impl.clearCachedProperties();
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    protected Observable<VirtualMachineScaleSetInner> getInnerAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachineScaleSets().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private boolean isInUpdateMode() {
        return !this.isInCreateMode();
    }

    private void setOSProfileDefaults() {
        if (this.isInUpdateMode()) {
            return;
        }
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).sku().capacity() == null) {
            this.withCapacity(2);
        }
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).upgradePolicy() == null || ((VirtualMachineScaleSetInner)((Object)this.inner())).upgradePolicy().mode() == null) {
            ((VirtualMachineScaleSetInner)((Object)this.inner())).withUpgradePolicy(new UpgradePolicy().withMode(UpgradeMode.AUTOMATIC));
        }
        VirtualMachineScaleSetOSProfile osProfile = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().osProfile();
        VirtualMachineScaleSetOSDisk osDisk = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().osDisk();
        if (this.isOSDiskFromImage(osDisk)) {
            if (this.osType() == OperatingSystemTypes.LINUX || this.isMarketplaceLinuxImage) {
                if (osProfile.linuxConfiguration() == null) {
                    osProfile.withLinuxConfiguration(new LinuxConfiguration());
                }
                osProfile.linuxConfiguration().withDisablePasswordAuthentication(osProfile.adminPassword() == null);
            }
            if (this.computerNamePrefix() == null) {
                if (this.name().matches("[0-9]+")) {
                    this.withComputerNamePrefix(this.namer.randomName("vmss-vm", 12));
                } else if (this.name().length() <= 12) {
                    this.withComputerNamePrefix(this.name() + "-vm");
                } else {
                    this.withComputerNamePrefix(this.namer.randomName("vmss-vm", 12));
                }
            }
        } else {
            ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().withOsProfile(null);
        }
    }

    private void setOSDiskDefault() {
        if (this.isInUpdateMode()) {
            return;
        }
        VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile();
        VirtualMachineScaleSetOSDisk osDisk = storageProfile.osDisk();
        if (this.isOSDiskFromImage(osDisk)) {
            if (this.isManagedDiskEnabled()) {
                if (osDisk.managedDisk() == null) {
                    osDisk.withManagedDisk(new VirtualMachineScaleSetManagedDiskParameters());
                }
                if (osDisk.managedDisk().storageAccountType() == null) {
                    osDisk.managedDisk().withStorageAccountType(StorageAccountTypes.STANDARD_LRS);
                }
                osDisk.withVhdContainers(null);
            } else {
                osDisk.withManagedDisk(null);
                if (osDisk.name() == null) {
                    this.withOSDiskName(this.name() + "-os-disk");
                }
            }
        }
        if (this.osDiskCachingType() == null) {
            this.withOSDiskCaching(CachingTypes.READ_WRITE);
        }
    }

    public void beforeGroupCreateOrUpdate() {
        this.prepareOSDiskContainers();
        this.bootDiagnosticsHandler.prepare();
    }

    protected void prepareOSDiskContainers() {
        if (this.isManagedDiskEnabled()) {
            return;
        }
        VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile();
        if (this.isOSDiskFromStoredImage(storageProfile)) {
            return;
        }
        if (this.isInCreateMode() && this.creatableStorageAccountKeys.isEmpty() && this.existingStorageAccountsToAssociate.isEmpty()) {
            String accountName = this.namer.randomName("stg", 24).replace("-", "");
            Creatable storageAccountCreatable = this.creatableGroup != null ? (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(accountName)).withRegion(this.regionName())).withNewResourceGroup(this.creatableGroup) : (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(accountName)).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
            this.creatableStorageAccountKeys.add(this.addDependency(storageAccountCreatable));
        }
    }

    private void handleUnManagedOSDiskContainers() {
        VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile();
        if (this.isManagedDiskEnabled()) {
            storageProfile.osDisk().withVhdContainers(null);
            return;
        }
        if (this.isOSDiskFromStoredImage(storageProfile)) {
            storageProfile.osDisk().vhdContainers().clear();
            return;
        }
        String containerName = null;
        Iterator<String> iterator = storageProfile.osDisk().vhdContainers().iterator();
        if (iterator.hasNext()) {
            String containerUrl = iterator.next();
            containerName = containerUrl.substring(containerUrl.lastIndexOf("/") + 1);
        }
        if (containerName == null) {
            containerName = "vhds";
        }
        if (this.isInCreateMode() && this.creatableStorageAccountKeys.isEmpty() && this.existingStorageAccountsToAssociate.isEmpty()) {
            throw new IllegalStateException("Expected storage account(s) for VMSS OS disk containers not found");
        }
        for (String storageAccountKey : this.creatableStorageAccountKeys) {
            StorageAccount storageAccount = (StorageAccount)this.taskResult(storageAccountKey);
            storageProfile.osDisk().vhdContainers().add(VirtualMachineScaleSetImpl.mergePath(storageAccount.endPoints().primary().blob(), containerName));
        }
        for (StorageAccount storageAccount : this.existingStorageAccountsToAssociate) {
            storageProfile.osDisk().vhdContainers().add(VirtualMachineScaleSetImpl.mergePath(storageAccount.endPoints().primary().blob(), containerName));
        }
        this.creatableStorageAccountKeys.clear();
        this.existingStorageAccountsToAssociate.clear();
    }

    private void setPrimaryIpConfigurationSubnet() {
        if (this.isInUpdateMode()) {
            return;
        }
        VirtualMachineScaleSetIPConfiguration ipConfig = this.primaryNicDefaultIPConfiguration();
        ipConfig.withSubnet(new ApiEntityReference().withId(this.existingPrimaryNetworkSubnetNameToAssociate));
        this.existingPrimaryNetworkSubnetNameToAssociate = null;
    }

    private void setPrimaryIpConfigurationBackendsAndInboundNatPools() {
        if (this.isInCreateMode()) {
            return;
        }
        try {
            this.loadCurrentPrimaryLoadBalancersIfAvailable();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        VirtualMachineScaleSetIPConfiguration primaryIpConfig = this.primaryNicDefaultIPConfiguration();
        if (this.primaryInternetFacingLoadBalancer != null) {
            VirtualMachineScaleSetImpl.removeBackendsFromIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBBackendsToRemoveOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBBackendsToAddOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.removeInboundNatPoolsFromIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
        }
        if (this.primaryInternalLoadBalancer != null) {
            VirtualMachineScaleSetImpl.removeBackendsFromIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBBackendsToRemoveOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBBackendsToAddOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.removeInboundNatPoolsFromIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBInboundNatPoolsToRemoveOnUpdate.toArray(new String[0]));
            VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
        }
        if (this.removePrimaryInternetFacingLoadBalancerOnUpdate && this.primaryInternetFacingLoadBalancer != null) {
            VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, primaryIpConfig);
        }
        if (this.removePrimaryInternalLoadBalancerOnUpdate && this.primaryInternalLoadBalancer != null) {
            VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, primaryIpConfig);
        }
        if (this.primaryInternetFacingLoadBalancerToAttachOnUpdate != null) {
            if (this.primaryInternetFacingLoadBalancer != null) {
                VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, primaryIpConfig);
            }
            VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate, primaryIpConfig);
            if (!this.primaryInternetFacingLBBackendsToAddOnUpdate.isEmpty()) {
                VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate, primaryIpConfig);
                VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternetFacingLBBackendsToAddOnUpdate.toArray(new String[0]));
            }
            if (!this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.isEmpty()) {
                VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate, primaryIpConfig);
                VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
            }
        }
        if (this.primaryInternalLoadBalancerToAttachOnUpdate != null) {
            if (this.primaryInternalLoadBalancer != null) {
                VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, primaryIpConfig);
            }
            VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate, primaryIpConfig);
            if (!this.primaryInternalLBBackendsToAddOnUpdate.isEmpty()) {
                VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate, primaryIpConfig);
                VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternalLBBackendsToAddOnUpdate.toArray(new String[0]));
            }
            if (!this.primaryInternalLBInboundNatPoolsToAddOnUpdate.isEmpty()) {
                VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate, primaryIpConfig);
                VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternalLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
            }
        }
        this.removePrimaryInternetFacingLoadBalancerOnUpdate = false;
        this.removePrimaryInternalLoadBalancerOnUpdate = false;
        this.primaryInternetFacingLoadBalancerToAttachOnUpdate = null;
        this.primaryInternalLoadBalancerToAttachOnUpdate = null;
        this.primaryInternetFacingLBBackendsToRemoveOnUpdate.clear();
        this.primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate.clear();
        this.primaryInternalLBBackendsToRemoveOnUpdate.clear();
        this.primaryInternalLBInboundNatPoolsToRemoveOnUpdate.clear();
        this.primaryInternetFacingLBBackendsToAddOnUpdate.clear();
        this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.clear();
        this.primaryInternalLBBackendsToAddOnUpdate.clear();
        this.primaryInternalLBInboundNatPoolsToAddOnUpdate.clear();
    }

    private void clearCachedProperties() {
        this.primaryInternetFacingLoadBalancer = null;
        this.primaryInternalLoadBalancer = null;
    }

    private void loadCurrentPrimaryLoadBalancersIfAvailable() throws IOException {
        if (this.primaryInternetFacingLoadBalancer != null && this.primaryInternalLoadBalancer != null) {
            return;
        }
        String firstLoadBalancerId = null;
        VirtualMachineScaleSetIPConfiguration ipConfig = this.primaryNicDefaultIPConfiguration();
        if (!ipConfig.loadBalancerBackendAddressPools().isEmpty()) {
            firstLoadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)ipConfig.loadBalancerBackendAddressPools().get(0).id());
        }
        if (firstLoadBalancerId == null && !ipConfig.loadBalancerInboundNatPools().isEmpty()) {
            firstLoadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)ipConfig.loadBalancerInboundNatPools().get(0).id());
        }
        if (firstLoadBalancerId == null) {
            return;
        }
        LoadBalancer loadBalancer1 = (LoadBalancer)this.networkManager.loadBalancers().getById(firstLoadBalancerId);
        if (loadBalancer1.publicIPAddressIds() != null && loadBalancer1.publicIPAddressIds().size() > 0) {
            this.primaryInternetFacingLoadBalancer = loadBalancer1;
        } else {
            this.primaryInternalLoadBalancer = loadBalancer1;
        }
        String secondLoadBalancerId = null;
        for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
            if (subResource.id().toLowerCase().startsWith(firstLoadBalancerId.toLowerCase())) continue;
            secondLoadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)subResource.id());
            break;
        }
        if (secondLoadBalancerId == null) {
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (subResource.id().toLowerCase().startsWith(firstLoadBalancerId.toLowerCase())) continue;
                secondLoadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)subResource.id());
                break;
            }
        }
        if (secondLoadBalancerId == null) {
            return;
        }
        LoadBalancer loadBalancer2 = (LoadBalancer)this.networkManager.loadBalancers().getById(secondLoadBalancerId);
        if (loadBalancer2.publicIPAddressIds() != null && loadBalancer2.publicIPAddressIds().size() > 0) {
            this.primaryInternetFacingLoadBalancer = loadBalancer2;
        } else {
            this.primaryInternalLoadBalancer = loadBalancer2;
        }
    }

    private VirtualMachineScaleSetIPConfiguration primaryNicDefaultIPConfiguration() {
        List<VirtualMachineScaleSetNetworkConfiguration> nicConfigurations = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().networkProfile().networkInterfaceConfigurations();
        for (VirtualMachineScaleSetNetworkConfiguration nicConfiguration : nicConfigurations) {
            if (!nicConfiguration.primary().booleanValue() || nicConfiguration.ipConfigurations().size() <= 0) continue;
            VirtualMachineScaleSetIPConfiguration ipConfig = nicConfiguration.ipConfigurations().get(0);
            if (ipConfig.loadBalancerBackendAddressPools() == null) {
                ipConfig.withLoadBalancerBackendAddressPools(new ArrayList<SubResource>());
            }
            if (ipConfig.loadBalancerInboundNatPools() == null) {
                ipConfig.withLoadBalancerInboundNatPools(new ArrayList<SubResource>());
            }
            return ipConfig;
        }
        throw new RuntimeException("Could not find the primary nic configuration or an IP configuration in it");
    }

    private VirtualMachineScaleSetNetworkConfiguration primaryNicConfiguration() {
        List<VirtualMachineScaleSetNetworkConfiguration> nicConfigurations = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().networkProfile().networkInterfaceConfigurations();
        for (VirtualMachineScaleSetNetworkConfiguration nicConfiguration : nicConfigurations) {
            if (!nicConfiguration.primary().booleanValue()) continue;
            return nicConfiguration;
        }
        throw new RuntimeException("Could not find the primary nic configuration");
    }

    private static void associateBackEndsToIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIPConfiguration ipConfig, String ... backendNames) {
        ArrayList<SubResource> backendSubResourcesToAssociate = new ArrayList<SubResource>();
        for (String backendName : backendNames) {
            String backendPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "backendAddressPools", backendName);
            boolean found = false;
            for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
                if (!subResource.id().equalsIgnoreCase(backendPoolId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            backendSubResourcesToAssociate.add(new SubResource().withId(backendPoolId));
        }
        for (SubResource backendSubResource : backendSubResourcesToAssociate) {
            ipConfig.loadBalancerBackendAddressPools().add(backendSubResource);
        }
    }

    private static void associateInboundNATPoolsToIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIPConfiguration ipConfig, String ... inboundNatPools) {
        ArrayList<SubResource> inboundNatPoolSubResourcesToAssociate = new ArrayList<SubResource>();
        for (String inboundNatPool : inboundNatPools) {
            String inboundNatPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "inboundNatPools", inboundNatPool);
            boolean found = false;
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (!subResource.id().equalsIgnoreCase(inboundNatPoolId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            inboundNatPoolSubResourcesToAssociate.add(new SubResource().withId(inboundNatPoolId));
        }
        for (SubResource backendSubResource : inboundNatPoolSubResourcesToAssociate) {
            ipConfig.loadBalancerInboundNatPools().add(backendSubResource);
        }
    }

    private static Map<String, LoadBalancerBackend> getBackendsAssociatedWithIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfiguration ipConfig) {
        String loadBalancerId = loadBalancer.id();
        HashMap<String, LoadBalancerBackend> attachedBackends = new HashMap<String, LoadBalancerBackend>();
        Map lbBackends = loadBalancer.backends();
        for (LoadBalancerBackend lbBackend : lbBackends.values()) {
            String backendId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "backendAddressPools", lbBackend.name());
            for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
                if (!subResource.id().equalsIgnoreCase(backendId)) continue;
                attachedBackends.put(lbBackend.name(), lbBackend);
            }
        }
        return attachedBackends;
    }

    private static Map<String, LoadBalancerInboundNatPool> getInboundNatPoolsAssociatedWithIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfiguration ipConfig) {
        String loadBalancerId = loadBalancer.id();
        HashMap<String, LoadBalancerInboundNatPool> attachedInboundNatPools = new HashMap<String, LoadBalancerInboundNatPool>();
        Map lbInboundNatPools = loadBalancer.inboundNatPools();
        for (LoadBalancerInboundNatPool lbInboundNatPool : lbInboundNatPools.values()) {
            String inboundNatPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "inboundNatPools", lbInboundNatPool.name());
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (!subResource.id().equalsIgnoreCase(inboundNatPoolId)) continue;
                attachedInboundNatPools.put(lbInboundNatPool.name(), lbInboundNatPool);
            }
        }
        return attachedInboundNatPools;
    }

    private static void associateLoadBalancerToIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfiguration ipConfig) {
        Collection backends = loadBalancer.backends().values();
        String[] backendNames = new String[backends.size()];
        int i = 0;
        for (LoadBalancerBackend backend : backends) {
            backendNames[i] = backend.name();
            ++i;
        }
        VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(loadBalancer.id(), ipConfig, backendNames);
        Collection inboundNatPools = loadBalancer.inboundNatPools().values();
        String[] natPoolNames = new String[inboundNatPools.size()];
        i = 0;
        for (LoadBalancerInboundNatPool inboundNatPool : inboundNatPools) {
            natPoolNames[i] = inboundNatPool.name();
            ++i;
        }
        VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(loadBalancer.id(), ipConfig, natPoolNames);
    }

    private static void removeLoadBalancerAssociationFromIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfiguration ipConfig) {
        VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(loadBalancer, ipConfig);
        VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(loadBalancer, ipConfig);
    }

    private static void removeAllBackendAssociationFromIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfiguration ipConfig) {
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
            if (!subResource.id().toLowerCase().startsWith(loadBalancer.id().toLowerCase() + "/")) continue;
            toRemove.add(subResource);
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerBackendAddressPools().remove(subResource);
        }
    }

    private static void removeAllInboundNatPoolAssociationFromIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIPConfiguration ipConfig) {
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
            if (!subResource.id().toLowerCase().startsWith(loadBalancer.id().toLowerCase() + "/")) continue;
            toRemove.add(subResource);
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerInboundNatPools().remove(subResource);
        }
    }

    private static void removeBackendsFromIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIPConfiguration ipConfig, String ... backendNames) {
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        block0: for (String backendName : backendNames) {
            String backendPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "backendAddressPools", backendName);
            for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
                if (!subResource.id().equalsIgnoreCase(backendPoolId)) continue;
                toRemove.add(subResource);
                continue block0;
            }
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerBackendAddressPools().remove(subResource);
        }
    }

    private static void removeInboundNatPoolsFromIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIPConfiguration ipConfig, String ... inboundNatPoolNames) {
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        block0: for (String natPoolName : inboundNatPoolNames) {
            String inboundNatPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "inboundNatPools", natPoolName);
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (!subResource.id().equalsIgnoreCase(inboundNatPoolId)) continue;
                toRemove.add(subResource);
                continue block0;
            }
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerInboundNatPools().remove(subResource);
        }
    }

    private static <T> void addToList(List<T> list, T ... items) {
        for (T item : items) {
            list.add(item);
        }
    }

    private static String mergePath(String ... segments) {
        StringBuilder builder = new StringBuilder();
        for (String segment : segments) {
            while (segment.length() > 1 && segment.endsWith("/")) {
                segment = segment.substring(0, segment.length() - 1);
            }
            if (segment.length() <= 0) continue;
            builder.append(segment);
            builder.append("/");
        }
        String merged = builder.toString();
        if (merged.endsWith("/")) {
            merged = merged.substring(0, merged.length() - 1);
        }
        return merged;
    }

    RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            public String principalId() {
                if (VirtualMachineScaleSetImpl.this.inner() != null && ((VirtualMachineScaleSetInner)((Object)VirtualMachineScaleSetImpl.this.inner())).identity() != null) {
                    return ((VirtualMachineScaleSetInner)((Object)VirtualMachineScaleSetImpl.this.inner())).identity().principalId();
                }
                return null;
            }

            public String resourceId() {
                if (VirtualMachineScaleSetImpl.this.inner() != null) {
                    return ((VirtualMachineScaleSetInner)((Object)VirtualMachineScaleSetImpl.this.inner())).id();
                }
                return null;
            }
        };
    }

    protected VirtualMachineScaleSetImpl withUnmanagedDataDisk(VirtualMachineScaleSetUnmanagedDataDiskImpl unmanagedDisk) {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().dataDisks() == null) {
            ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().withDataDisks(new ArrayList<VirtualMachineScaleSetDataDisk>());
        }
        List<VirtualMachineScaleSetDataDisk> dataDisks = ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().storageProfile().dataDisks();
        dataDisks.add((VirtualMachineScaleSetDataDisk)unmanagedDisk.inner());
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((VirtualMachineScaleSetInner)((Object)this.inner())).zones() == null) {
            ((VirtualMachineScaleSetInner)((Object)this.inner())).withZones(new ArrayList<String>());
        }
        ((VirtualMachineScaleSetInner)((Object)this.inner())).zones().add(zoneId.toString());
        return this;
    }

    private boolean isOSDiskFromImage(VirtualMachineScaleSetOSDisk osDisk) {
        return osDisk.createOption() == DiskCreateOptionTypes.FROM_IMAGE;
    }

    private boolean isOsDiskFromCustomImage(VirtualMachineScaleSetStorageProfile storageProfile) {
        ImageReference imageReference = storageProfile.imageReference();
        return this.isOSDiskFromImage(storageProfile.osDisk()) && imageReference != null && imageReference.id() != null;
    }

    private boolean isOSDiskFromPlatformImage(VirtualMachineScaleSetStorageProfile storageProfile) {
        ImageReference imageReference = storageProfile.imageReference();
        return this.isOSDiskFromImage(storageProfile.osDisk()) && imageReference != null && imageReference.publisher() != null && imageReference.offer() != null && imageReference.sku() != null && imageReference.version() != null;
    }

    private boolean isOSDiskFromStoredImage(VirtualMachineScaleSetStorageProfile storageProfile) {
        VirtualMachineScaleSetOSDisk osDisk = storageProfile.osDisk();
        return this.isOSDiskFromImage(osDisk) && osDisk.image() != null && osDisk.image().uri() != null;
    }

    private void throwIfManagedDiskDisabled(String message) {
        if (!this.isManagedDiskEnabled()) {
            throw new UnsupportedOperationException(message);
        }
    }

    @Override
    public VirtualMachineScaleSetImpl withBootDiagnostics() {
        this.bootDiagnosticsHandler.withBootDiagnostics();
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withBootDiagnostics(Creatable<StorageAccount> creatable) {
        this.bootDiagnosticsHandler.withBootDiagnostics(creatable);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withBootDiagnostics(StorageAccount storageAccount) {
        this.bootDiagnosticsHandler.withBootDiagnostics(storageAccount);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withBootDiagnostics(String storageAccountBlobEndpointUri) {
        this.bootDiagnosticsHandler.withBootDiagnostics(storageAccountBlobEndpointUri);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutBootDiagnostics() {
        this.bootDiagnosticsHandler.withoutBootDiagnostics();
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withMaxPrice(Double maxPrice) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().withBillingProfile(new BillingProfile().withMaxPrice(maxPrice));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVirtualMachinePriority(VirtualMachinePriorityTypes priority) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().withPriority(priority);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withLowPriorityVirtualMachine() {
        this.withVirtualMachinePriority(VirtualMachinePriorityTypes.LOW);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withLowPriorityVirtualMachine(VirtualMachineEvictionPolicyTypes policy) {
        this.withLowPriorityVirtualMachine();
        ((VirtualMachineScaleSetInner)((Object)this.inner())).virtualMachineProfile().withEvictionPolicy(policy);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVirtualMachinePublicIp() {
        VirtualMachineScaleSetIPConfiguration nicIpConfig = this.primaryNicDefaultIPConfiguration();
        if (nicIpConfig.publicIPAddressConfiguration() != null) {
            return this;
        }
        VirtualMachineScaleSetPublicIPAddressConfiguration pipConfig = new VirtualMachineScaleSetPublicIPAddressConfiguration();
        pipConfig.withName("pip1");
        pipConfig.withIdleTimeoutInMinutes(15);
        nicIpConfig.withPublicIPAddressConfiguration(pipConfig);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVirtualMachinePublicIp(String leafDomainLabel) {
        VirtualMachineScaleSetIPConfiguration nicIpConfig = this.primaryNicDefaultIPConfiguration();
        if (nicIpConfig.publicIPAddressConfiguration() != null) {
            if (nicIpConfig.publicIPAddressConfiguration().dnsSettings() != null) {
                nicIpConfig.publicIPAddressConfiguration().dnsSettings().withDomainNameLabel(leafDomainLabel);
            } else {
                nicIpConfig.publicIPAddressConfiguration().withDnsSettings(new VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings());
                nicIpConfig.publicIPAddressConfiguration().dnsSettings().withDomainNameLabel(leafDomainLabel);
            }
        } else {
            VirtualMachineScaleSetPublicIPAddressConfiguration pipConfig = new VirtualMachineScaleSetPublicIPAddressConfiguration();
            pipConfig.withName("pip1");
            pipConfig.withIdleTimeoutInMinutes(15);
            pipConfig.withDnsSettings(new VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings());
            pipConfig.dnsSettings().withDomainNameLabel(leafDomainLabel);
            nicIpConfig.withPublicIPAddressConfiguration(pipConfig);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVirtualMachinePublicIp(VirtualMachineScaleSetPublicIPAddressConfiguration pipConfig) {
        VirtualMachineScaleSetIPConfiguration nicIpConfig = this.primaryNicDefaultIPConfiguration();
        nicIpConfig.withPublicIPAddressConfiguration(pipConfig);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAcceleratedNetworking() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withEnableAcceleratedNetworking(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutAcceleratedNetworking() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withEnableAcceleratedNetworking(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withIpForwarding() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withEnableIPForwarding(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutIpForwarding() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withEnableIPForwarding(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingNetworkSecurityGroup(NetworkSecurityGroup networkSecurityGroup) {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withNetworkSecurityGroup(new SubResource().withId(networkSecurityGroup.id()));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingNetworkSecurityGroupId(String networkSecurityGroupId) {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withNetworkSecurityGroup(new SubResource().withId(networkSecurityGroupId));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutNetworkSecurityGroup() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withNetworkSecurityGroup(null);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSinglePlacementGroup() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).withSinglePlacementGroup(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutSinglePlacementGroup() {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).withSinglePlacementGroup(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingApplicationGatewayBackendPool(String backendPoolId) {
        VirtualMachineScaleSetIPConfiguration nicIpConfig = this.primaryNicDefaultIPConfiguration();
        if (nicIpConfig.applicationGatewayBackendAddressPools() == null) {
            nicIpConfig.withApplicationGatewayBackendAddressPools(new ArrayList<SubResource>());
        }
        boolean found = false;
        for (SubResource backendPool : nicIpConfig.applicationGatewayBackendAddressPools()) {
            if (!backendPool.id().equalsIgnoreCase(backendPoolId)) continue;
            found = true;
            break;
        }
        if (!found) {
            nicIpConfig.applicationGatewayBackendAddressPools().add(new SubResource().withId(backendPoolId));
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutApplicationGatewayBackendPool(String backendPoolId) {
        VirtualMachineScaleSetIPConfiguration nicIpConfig = this.primaryNicDefaultIPConfiguration();
        if (nicIpConfig.applicationGatewayBackendAddressPools() == null) {
            return this;
        }
        int foundIndex = -1;
        int index = -1;
        for (SubResource backendPool : nicIpConfig.applicationGatewayBackendAddressPools()) {
            ++index;
            if (!backendPool.id().equalsIgnoreCase(backendPoolId)) continue;
            foundIndex = index;
            break;
        }
        if (foundIndex != -1) {
            nicIpConfig.applicationGatewayBackendAddressPools().remove(foundIndex);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingApplicationSecurityGroup(ApplicationSecurityGroup applicationSecurityGroup) {
        return this.withExistingApplicationSecurityGroupId(applicationSecurityGroup.id());
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingApplicationSecurityGroupId(String applicationSecurityGroupId) {
        VirtualMachineScaleSetIPConfiguration nicIpConfig = this.primaryNicDefaultIPConfiguration();
        if (nicIpConfig.applicationSecurityGroups() == null) {
            nicIpConfig.withApplicationSecurityGroups(new ArrayList<SubResource>());
        }
        boolean found = false;
        for (SubResource asg : nicIpConfig.applicationSecurityGroups()) {
            if (!asg.id().equalsIgnoreCase(applicationSecurityGroupId)) continue;
            found = true;
            break;
        }
        if (!found) {
            nicIpConfig.applicationSecurityGroups().add(new SubResource().withId(applicationSecurityGroupId));
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutApplicationSecurityGroup(String applicationSecurityGroupId) {
        VirtualMachineScaleSetIPConfiguration nicIpConfig = this.primaryNicDefaultIPConfiguration();
        if (nicIpConfig.applicationSecurityGroups() == null) {
            return this;
        }
        int foundIndex = -1;
        int index = -1;
        for (SubResource asg : nicIpConfig.applicationSecurityGroups()) {
            ++index;
            if (!asg.id().equalsIgnoreCase(applicationSecurityGroupId)) continue;
            foundIndex = index;
            break;
        }
        if (foundIndex != -1) {
            nicIpConfig.applicationSecurityGroups().remove(foundIndex);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withProximityPlacementGroup(String proximityPlacementGroupId) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).withProximityPlacementGroup(new SubResource().withId(proximityPlacementGroupId));
        this.newProximityPlacementGroupName = null;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewProximityPlacementGroup(String proximityPlacementGroupName, ProximityPlacementGroupType type) {
        this.newProximityPlacementGroupName = proximityPlacementGroupName;
        this.newProximityPlacementGroupType = type;
        ((VirtualMachineScaleSetInner)((Object)this.inner())).withProximityPlacementGroup(null);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withDoNotRunExtensionsOnOverprovisionedVMs(Boolean doNotRunExtensionsOnOverprovisionedVMs) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).withDoNotRunExtensionsOnOverprovisionedVMs(doNotRunExtensionsOnOverprovisionedVMs);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        ((VirtualMachineScaleSetInner)((Object)this.inner())).withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    private void createNewProximityPlacementGroup() {
        if (this.isInCreateMode() && this.newProximityPlacementGroupName != null && !this.newProximityPlacementGroupName.isEmpty()) {
            ProximityPlacementGroupInner plgInner = new ProximityPlacementGroupInner();
            plgInner.withProximityPlacementGroupType(this.newProximityPlacementGroupType);
            plgInner.withLocation(((VirtualMachineScaleSetInner)((Object)this.inner())).location());
            plgInner = ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).proximityPlacementGroups().createOrUpdate(this.resourceGroupName(), this.newProximityPlacementGroupName, plgInner);
            ((VirtualMachineScaleSetInner)((Object)this.inner())).withProximityPlacementGroup(new SubResource().withId(plgInner.id()));
        }
    }

    private class BootDiagnosticsHandler {
        private final VirtualMachineScaleSetImpl vmssImpl;
        private String creatableDiagnosticsStorageAccountKey;
        private String creatableStorageAccountKey;
        private StorageAccount existingStorageAccountToAssociate;

        BootDiagnosticsHandler(VirtualMachineScaleSetImpl vmssImpl) {
            this.vmssImpl = vmssImpl;
        }

        public boolean isBootDiagnosticsEnabled() {
            DiagnosticsProfile diagnosticsProfile = this.vmssInner().virtualMachineProfile().diagnosticsProfile();
            if (diagnosticsProfile != null && diagnosticsProfile.bootDiagnostics() != null && diagnosticsProfile.bootDiagnostics().enabled() != null) {
                return diagnosticsProfile.bootDiagnostics().enabled();
            }
            return false;
        }

        public String bootDiagnosticsStorageUri() {
            DiagnosticsProfile diagnosticsProfile = this.vmssInner().virtualMachineProfile().diagnosticsProfile();
            if (diagnosticsProfile != null && diagnosticsProfile.bootDiagnostics() != null) {
                return diagnosticsProfile.bootDiagnostics().storageUri();
            }
            return null;
        }

        BootDiagnosticsHandler withBootDiagnostics() {
            this.enableDisable(true);
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(Creatable<StorageAccount> creatable) {
            this.enableDisable(true);
            this.creatableDiagnosticsStorageAccountKey = this.vmssImpl.addDependency(creatable);
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(String storageAccountBlobEndpointUri) {
            this.enableDisable(true);
            this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().withStorageUri(storageAccountBlobEndpointUri);
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(StorageAccount storageAccount) {
            return this.withBootDiagnostics(storageAccount.endPoints().primary().blob());
        }

        BootDiagnosticsHandler withoutBootDiagnostics() {
            this.enableDisable(false);
            return this;
        }

        void prepare() {
            this.creatableStorageAccountKey = null;
            this.existingStorageAccountToAssociate = null;
            DiagnosticsProfile diagnosticsProfile = this.vmssInner().virtualMachineProfile().diagnosticsProfile();
            if (diagnosticsProfile == null || diagnosticsProfile.bootDiagnostics() == null || diagnosticsProfile.bootDiagnostics().storageUri() != null) {
                return;
            }
            boolean enableBD = Utils.toPrimitiveBoolean((Boolean)diagnosticsProfile.bootDiagnostics().enabled());
            if (!enableBD) {
                return;
            }
            if (this.creatableDiagnosticsStorageAccountKey != null) {
                return;
            }
            if (!this.vmssImpl.creatableStorageAccountKeys.isEmpty()) {
                this.creatableStorageAccountKey = (String)this.vmssImpl.creatableStorageAccountKeys.get(0);
                return;
            }
            if (!this.vmssImpl.existingStorageAccountsToAssociate.isEmpty()) {
                this.existingStorageAccountToAssociate = (StorageAccount)this.vmssImpl.existingStorageAccountsToAssociate.get(0);
                return;
            }
            String accountName = this.vmssImpl.namer.randomName("stg", 24).replace("-", "");
            Creatable storageAccountCreatable = this.vmssImpl.creatableGroup != null ? (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.vmssImpl.storageManager.storageAccounts().define(accountName)).withRegion(this.vmssImpl.regionName())).withNewResourceGroup(this.vmssImpl.creatableGroup) : (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.vmssImpl.storageManager.storageAccounts().define(accountName)).withRegion(this.vmssImpl.regionName())).withExistingResourceGroup(this.vmssImpl.resourceGroupName());
            this.creatableDiagnosticsStorageAccountKey = this.vmssImpl.addDependency(storageAccountCreatable);
        }

        void handleDiagnosticsSettings() {
            DiagnosticsProfile diagnosticsProfile = this.vmssInner().virtualMachineProfile().diagnosticsProfile();
            if (diagnosticsProfile == null || diagnosticsProfile.bootDiagnostics() == null || diagnosticsProfile.bootDiagnostics().storageUri() != null) {
                return;
            }
            boolean enableBD = Utils.toPrimitiveBoolean((Boolean)diagnosticsProfile.bootDiagnostics().enabled());
            if (!enableBD) {
                return;
            }
            StorageAccount storageAccount = null;
            if (this.creatableDiagnosticsStorageAccountKey != null) {
                storageAccount = (StorageAccount)this.vmssImpl.taskResult(this.creatableDiagnosticsStorageAccountKey);
            } else if (this.creatableStorageAccountKey != null) {
                storageAccount = (StorageAccount)this.vmssImpl.taskResult(this.creatableStorageAccountKey);
            } else if (this.existingStorageAccountToAssociate != null) {
                storageAccount = this.existingStorageAccountToAssociate;
            }
            if (storageAccount == null) {
                throw new IllegalStateException("Unable to retrieve expected storageAccount instance for BootDiagnostics");
            }
            this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().withStorageUri(storageAccount.endPoints().primary().blob());
        }

        private VirtualMachineScaleSetInner vmssInner() {
            return (VirtualMachineScaleSetInner)((Object)this.vmssImpl.inner());
        }

        private void enableDisable(boolean enable) {
            if (this.vmssInner().virtualMachineProfile().diagnosticsProfile() == null) {
                this.vmssInner().virtualMachineProfile().withDiagnosticsProfile(new DiagnosticsProfile());
            }
            if (this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics() == null) {
                this.vmssInner().virtualMachineProfile().diagnosticsProfile().withBootDiagnostics(new BootDiagnostics());
            }
            if (enable) {
                this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().withEnabled(true);
            } else {
                this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().withEnabled(false);
                this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().withStorageUri(null);
            }
        }
    }

    private class ManagedDataDiskCollection {
        private final List<VirtualMachineScaleSetDataDisk> implicitDisksToAssociate = new ArrayList<VirtualMachineScaleSetDataDisk>();
        private final List<Integer> diskLunsToRemove = new ArrayList<Integer>();
        private final List<VirtualMachineScaleSetDataDisk> newDisksFromImage = new ArrayList<VirtualMachineScaleSetDataDisk>();
        private final VirtualMachineScaleSetImpl vmss;
        private CachingTypes defaultCachingType;
        private StorageAccountTypes defaultStorageAccountType;

        ManagedDataDiskCollection(VirtualMachineScaleSetImpl vmss) {
            this.vmss = vmss;
        }

        void setDefaultCachingType(CachingTypes cachingType) {
            this.defaultCachingType = cachingType;
        }

        void setDefaultStorageAccountType(StorageAccountTypes defaultStorageAccountType) {
            this.defaultStorageAccountType = defaultStorageAccountType;
        }

        void setDataDisksDefaults() {
            VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.vmss.inner())).virtualMachineProfile().storageProfile();
            if (this.isPending()) {
                if (storageProfile.dataDisks() == null) {
                    storageProfile.withDataDisks(new ArrayList<VirtualMachineScaleSetDataDisk>());
                }
                List<VirtualMachineScaleSetDataDisk> dataDisks = storageProfile.dataDisks();
                final ArrayList<Integer> usedLuns = new ArrayList<Integer>();
                for (VirtualMachineScaleSetDataDisk dataDisk : dataDisks) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (VirtualMachineScaleSetDataDisk dataDisk : this.implicitDisksToAssociate) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (VirtualMachineScaleSetDataDisk dataDisk : this.newDisksFromImage) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                Func0<Integer> nextLun = new Func0<Integer>(){

                    public Integer call() {
                        Integer lun = 0;
                        while (usedLuns.contains(lun)) {
                            Integer n = lun;
                            Integer n2 = lun = Integer.valueOf(lun + 1);
                        }
                        usedLuns.add(lun);
                        return lun;
                    }
                };
                this.setImplicitDataDisks(nextLun);
                this.setImageBasedDataDisks();
                this.removeDataDisks();
            }
            if (storageProfile.dataDisks() != null && storageProfile.dataDisks().size() == 0 && this.vmss.isInCreateMode()) {
                storageProfile.withDataDisks(null);
            }
            this.clear();
        }

        private void clear() {
            this.implicitDisksToAssociate.clear();
            this.diskLunsToRemove.clear();
            this.newDisksFromImage.clear();
        }

        private boolean isPending() {
            return this.implicitDisksToAssociate.size() > 0 || this.diskLunsToRemove.size() > 0 || this.newDisksFromImage.size() > 0;
        }

        private void setImplicitDataDisks(Func0<Integer> nextLun) {
            VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.vmss.inner())).virtualMachineProfile().storageProfile();
            List<VirtualMachineScaleSetDataDisk> dataDisks = storageProfile.dataDisks();
            for (VirtualMachineScaleSetDataDisk dataDisk : this.implicitDisksToAssociate) {
                dataDisk.withCreateOption(DiskCreateOptionTypes.EMPTY);
                if (dataDisk.lun() == -1) {
                    dataDisk.withLun((Integer)nextLun.call());
                }
                if (dataDisk.managedDisk() == null) {
                    dataDisk.withManagedDisk(new VirtualMachineScaleSetManagedDiskParameters());
                }
                if (dataDisk.caching() == null) {
                    dataDisk.withCaching(this.getDefaultCachingType());
                }
                if (dataDisk.managedDisk().storageAccountType() == null) {
                    dataDisk.managedDisk().withStorageAccountType(this.getDefaultStorageAccountType());
                }
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void setImageBasedDataDisks() {
            VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.vmss.inner())).virtualMachineProfile().storageProfile();
            List<VirtualMachineScaleSetDataDisk> dataDisks = storageProfile.dataDisks();
            for (VirtualMachineScaleSetDataDisk dataDisk : this.newDisksFromImage) {
                dataDisk.withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void removeDataDisks() {
            VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.vmss.inner())).virtualMachineProfile().storageProfile();
            List<VirtualMachineScaleSetDataDisk> dataDisks = storageProfile.dataDisks();
            block0: for (Integer lun : this.diskLunsToRemove) {
                int indexToRemove = 0;
                for (VirtualMachineScaleSetDataDisk dataDisk : dataDisks) {
                    if (dataDisk.lun() == lun.intValue()) {
                        dataDisks.remove(indexToRemove);
                        continue block0;
                    }
                    ++indexToRemove;
                }
            }
        }

        private CachingTypes getDefaultCachingType() {
            if (this.defaultCachingType == null) {
                return CachingTypes.READ_WRITE;
            }
            return this.defaultCachingType;
        }

        private StorageAccountTypes getDefaultStorageAccountType() {
            if (this.defaultStorageAccountType == null) {
                return StorageAccountTypes.STANDARD_LRS;
            }
            return this.defaultStorageAccountType;
        }
    }
}

