/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.GalleryApplicationUpdate;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.GalleryApplicationInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class GalleryApplicationsInner {
    private GalleryApplicationsService service;
    private ComputeManagementClientImpl client;

    public GalleryApplicationsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (GalleryApplicationsService)retrofit.create(GalleryApplicationsService.class);
        this.client = client;
    }

    public GalleryApplicationInner createOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        return (GalleryApplicationInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).toBlocking().last()).body());
    }

    public ServiceFuture<GalleryApplicationInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication, ServiceCallback<GalleryApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication), serviceCallback);
    }

    public Observable<GalleryApplicationInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).map((Func1)new Func1<ServiceResponse<GalleryApplicationInner>, GalleryApplicationInner>(){

            public GalleryApplicationInner call(ServiceResponse<GalleryApplicationInner> response) {
                return (GalleryApplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplication == null) {
            throw new IllegalArgumentException("Parameter galleryApplication is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryApplication));
        String apiVersion = "2019-07-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, "2019-07-01", galleryApplication, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryApplicationInner>(){}.getType());
    }

    public GalleryApplicationInner beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        return (GalleryApplicationInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryApplicationInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication, ServiceCallback<GalleryApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication), serviceCallback);
    }

    public Observable<GalleryApplicationInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).map((Func1)new Func1<ServiceResponse<GalleryApplicationInner>, GalleryApplicationInner>(){

            public GalleryApplicationInner call(ServiceResponse<GalleryApplicationInner> response) {
                return (GalleryApplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplication == null) {
            throw new IllegalArgumentException("Parameter galleryApplication is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryApplication));
        String apiVersion = "2019-07-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, "2019-07-01", galleryApplication, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationInner>>>(){

            public Observable<ServiceResponse<GalleryApplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryApplicationsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryApplicationInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryApplicationInner>(){}.getType()).register(201, new TypeToken<GalleryApplicationInner>(){}.getType()).register(202, new TypeToken<GalleryApplicationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GalleryApplicationInner update(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        return (GalleryApplicationInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).toBlocking().last()).body());
    }

    public ServiceFuture<GalleryApplicationInner> updateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication, ServiceCallback<GalleryApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication), serviceCallback);
    }

    public Observable<GalleryApplicationInner> updateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        return this.updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).map((Func1)new Func1<ServiceResponse<GalleryApplicationInner>, GalleryApplicationInner>(){

            public GalleryApplicationInner call(ServiceResponse<GalleryApplicationInner> response) {
                return (GalleryApplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationInner>> updateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplication == null) {
            throw new IllegalArgumentException("Parameter galleryApplication is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryApplication));
        String apiVersion = "2019-07-01";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, "2019-07-01", galleryApplication, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryApplicationInner>(){}.getType());
    }

    public GalleryApplicationInner beginUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        return (GalleryApplicationInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryApplicationInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication, ServiceCallback<GalleryApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication), serviceCallback);
    }

    public Observable<GalleryApplicationInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).map((Func1)new Func1<ServiceResponse<GalleryApplicationInner>, GalleryApplicationInner>(){

            public GalleryApplicationInner call(ServiceResponse<GalleryApplicationInner> response) {
                return (GalleryApplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplication == null) {
            throw new IllegalArgumentException("Parameter galleryApplication is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryApplication));
        String apiVersion = "2019-07-01";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, "2019-07-01", galleryApplication, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationInner>>>(){

            public Observable<ServiceResponse<GalleryApplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryApplicationsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryApplicationInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryApplicationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GalleryApplicationInner get(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return (GalleryApplicationInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryApplicationInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, ServiceCallback<GalleryApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName), serviceCallback);
    }

    public Observable<GalleryApplicationInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).map((Func1)new Func1<ServiceResponse<GalleryApplicationInner>, GalleryApplicationInner>(){

            public GalleryApplicationInner call(ServiceResponse<GalleryApplicationInner> response) {
                return (GalleryApplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        String apiVersion = "2019-07-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, "2019-07-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationInner>>>(){

            public Observable<ServiceResponse<GalleryApplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryApplicationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryApplicationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryApplicationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String galleryName, String galleryApplicationName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        String apiVersion = "2019-07-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, "2019-07-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String galleryName, String galleryApplicationName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        String apiVersion = "2019-07-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, "2019-07-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryApplicationsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GalleryApplicationInner> listByGallery(String resourceGroupName, String galleryName) {
        ServiceResponse response = (ServiceResponse)this.listByGallerySinglePageAsync(resourceGroupName, galleryName).toBlocking().single();
        return new PagedList<GalleryApplicationInner>((Page)response.body()){

            public Page<GalleryApplicationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)GalleryApplicationsInner.this.listByGalleryNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GalleryApplicationInner>> listByGalleryAsync(String resourceGroupName, String galleryName, ListOperationCallback<GalleryApplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByGallerySinglePageAsync(resourceGroupName, galleryName), (Func1)new Func1<String, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(String nextPageLink) {
                return GalleryApplicationsInner.this.listByGalleryNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GalleryApplicationInner>> listByGalleryAsync(String resourceGroupName, String galleryName) {
        return this.listByGalleryWithServiceResponseAsync(resourceGroupName, galleryName).map((Func1)new Func1<ServiceResponse<Page<GalleryApplicationInner>>, Page<GalleryApplicationInner>>(){

            public Page<GalleryApplicationInner> call(ServiceResponse<Page<GalleryApplicationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryApplicationInner>>> listByGalleryWithServiceResponseAsync(String resourceGroupName, String galleryName) {
        return this.listByGallerySinglePageAsync(resourceGroupName, galleryName).concatMap((Func1)new Func1<ServiceResponse<Page<GalleryApplicationInner>>, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(ServiceResponse<Page<GalleryApplicationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GalleryApplicationsInner.this.listByGalleryNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryApplicationInner>>> listByGallerySinglePageAsync(String resourceGroupName, String galleryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        String apiVersion = "2019-07-01";
        return this.service.listByGallery(this.client.subscriptionId(), resourceGroupName, galleryName, "2019-07-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GalleryApplicationsInner.this.listByGalleryDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<GalleryApplicationInner>> listByGalleryDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<GalleryApplicationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GalleryApplicationInner> listByGalleryNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByGalleryNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GalleryApplicationInner>((Page)response.body()){

            public Page<GalleryApplicationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)GalleryApplicationsInner.this.listByGalleryNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GalleryApplicationInner>> listByGalleryNextAsync(String nextPageLink, ServiceFuture<List<GalleryApplicationInner>> serviceFuture, ListOperationCallback<GalleryApplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByGalleryNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(String nextPageLink) {
                return GalleryApplicationsInner.this.listByGalleryNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GalleryApplicationInner>> listByGalleryNextAsync(String nextPageLink) {
        return this.listByGalleryNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<GalleryApplicationInner>>, Page<GalleryApplicationInner>>(){

            public Page<GalleryApplicationInner> call(ServiceResponse<Page<GalleryApplicationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryApplicationInner>>> listByGalleryNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByGalleryNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<GalleryApplicationInner>>, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(ServiceResponse<Page<GalleryApplicationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GalleryApplicationsInner.this.listByGalleryNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryApplicationInner>>> listByGalleryNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByGalleryNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GalleryApplicationsInner.this.listByGalleryNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<GalleryApplicationInner>> listByGalleryNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<GalleryApplicationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface GalleryApplicationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Query(value="api-version") String var5, @Body GalleryApplicationInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Query(value="api-version") String var5, @Body GalleryApplicationInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Query(value="api-version") String var5, @Body GalleryApplicationUpdate var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Query(value="api-version") String var5, @Body GalleryApplicationUpdate var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications listByGallery"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications")
        public Observable<Response<ResponseBody>> listByGallery(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications listByGalleryNext"})
        @GET
        public Observable<Response<ResponseBody>> listByGalleryNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

