/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.DiskEncryptionSetUpdate;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.DiskEncryptionSetInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DiskEncryptionSetsInner
implements InnerSupportsGet<DiskEncryptionSetInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<DiskEncryptionSetInner> {
    private DiskEncryptionSetsService service;
    private ComputeManagementClientImpl client;

    public DiskEncryptionSetsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (DiskEncryptionSetsService)retrofit.create(DiskEncryptionSetsService.class);
        this.client = client;
    }

    public DiskEncryptionSetInner createOrUpdate(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return (DiskEncryptionSetInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).toBlocking().last()).body());
    }

    public ServiceFuture<DiskEncryptionSetInner> createOrUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet, ServiceCallback<DiskEncryptionSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet), serviceCallback);
    }

    public Observable<DiskEncryptionSetInner> createOrUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).map((Func1)new Func1<ServiceResponse<DiskEncryptionSetInner>, DiskEncryptionSetInner>(){

            public DiskEncryptionSetInner call(ServiceResponse<DiskEncryptionSetInner> response) {
                return (DiskEncryptionSetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskEncryptionSetInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        if (diskEncryptionSet == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null.");
        }
        Validator.validate((Object)((Object)diskEncryptionSet));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, "2019-11-01", diskEncryptionSet, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskEncryptionSetInner>(){}.getType());
    }

    public DiskEncryptionSetInner beginCreateOrUpdate(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return (DiskEncryptionSetInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).toBlocking().single()).body());
    }

    public ServiceFuture<DiskEncryptionSetInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet, ServiceCallback<DiskEncryptionSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet), serviceCallback);
    }

    public Observable<DiskEncryptionSetInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).map((Func1)new Func1<ServiceResponse<DiskEncryptionSetInner>, DiskEncryptionSetInner>(){

            public DiskEncryptionSetInner call(ServiceResponse<DiskEncryptionSetInner> response) {
                return (DiskEncryptionSetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskEncryptionSetInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        if (diskEncryptionSet == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null.");
        }
        Validator.validate((Object)((Object)diskEncryptionSet));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, "2019-11-01", diskEncryptionSet, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskEncryptionSetInner>>>(){

            public Observable<ServiceResponse<DiskEncryptionSetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskEncryptionSetsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiskEncryptionSetInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiskEncryptionSetInner>(){}.getType()).register(201, new TypeToken<DiskEncryptionSetInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiskEncryptionSetInner update(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return (DiskEncryptionSetInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).toBlocking().last()).body());
    }

    public ServiceFuture<DiskEncryptionSetInner> updateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet, ServiceCallback<DiskEncryptionSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet), serviceCallback);
    }

    public Observable<DiskEncryptionSetInner> updateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return this.updateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).map((Func1)new Func1<ServiceResponse<DiskEncryptionSetInner>, DiskEncryptionSetInner>(){

            public DiskEncryptionSetInner call(ServiceResponse<DiskEncryptionSetInner> response) {
                return (DiskEncryptionSetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskEncryptionSetInner>> updateWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        if (diskEncryptionSet == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null.");
        }
        Validator.validate((Object)diskEncryptionSet);
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, "2019-11-01", diskEncryptionSet, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskEncryptionSetInner>(){}.getType());
    }

    public DiskEncryptionSetInner beginUpdate(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return (DiskEncryptionSetInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).toBlocking().single()).body());
    }

    public ServiceFuture<DiskEncryptionSetInner> beginUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet, ServiceCallback<DiskEncryptionSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet), serviceCallback);
    }

    public Observable<DiskEncryptionSetInner> beginUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).map((Func1)new Func1<ServiceResponse<DiskEncryptionSetInner>, DiskEncryptionSetInner>(){

            public DiskEncryptionSetInner call(ServiceResponse<DiskEncryptionSetInner> response) {
                return (DiskEncryptionSetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskEncryptionSetInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        if (diskEncryptionSet == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null.");
        }
        Validator.validate((Object)diskEncryptionSet);
        String apiVersion = "2019-11-01";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, "2019-11-01", diskEncryptionSet, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskEncryptionSetInner>>>(){

            public Observable<ServiceResponse<DiskEncryptionSetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskEncryptionSetsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiskEncryptionSetInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiskEncryptionSetInner>(){}.getType()).register(202, new TypeToken<DiskEncryptionSetInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiskEncryptionSetInner getByResourceGroup(String resourceGroupName, String diskEncryptionSetName) {
        return (DiskEncryptionSetInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).toBlocking().single()).body());
    }

    public ServiceFuture<DiskEncryptionSetInner> getByResourceGroupAsync(String resourceGroupName, String diskEncryptionSetName, ServiceCallback<DiskEncryptionSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName), serviceCallback);
    }

    public Observable<DiskEncryptionSetInner> getByResourceGroupAsync(String resourceGroupName, String diskEncryptionSetName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).map((Func1)new Func1<ServiceResponse<DiskEncryptionSetInner>, DiskEncryptionSetInner>(){

            public DiskEncryptionSetInner call(ServiceResponse<DiskEncryptionSetInner> response) {
                return (DiskEncryptionSetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskEncryptionSetInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskEncryptionSetInner>>>(){

            public Observable<ServiceResponse<DiskEncryptionSetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskEncryptionSetsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiskEncryptionSetInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiskEncryptionSetInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String diskEncryptionSetName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String diskEncryptionSetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String diskEncryptionSetName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String diskEncryptionSetName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String diskEncryptionSetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String diskEncryptionSetName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskEncryptionSetsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskEncryptionSetInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DiskEncryptionSetInner>((Page)response.body()){

            public Page<DiskEncryptionSetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskEncryptionSetsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskEncryptionSetInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<DiskEncryptionSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(String nextPageLink) {
                return DiskEncryptionSetsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskEncryptionSetInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Page<DiskEncryptionSetInner>>(){

            public Page<DiskEncryptionSetInner> call(ServiceResponse<Page<DiskEncryptionSetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(ServiceResponse<Page<DiskEncryptionSetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskEncryptionSetsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskEncryptionSetsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskEncryptionSetInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskEncryptionSetInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskEncryptionSetInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<DiskEncryptionSetInner>((Page)response.body()){

            public Page<DiskEncryptionSetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskEncryptionSetsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskEncryptionSetInner>> listAsync(ListOperationCallback<DiskEncryptionSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(String nextPageLink) {
                return DiskEncryptionSetsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskEncryptionSetInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Page<DiskEncryptionSetInner>>(){

            public Page<DiskEncryptionSetInner> call(ServiceResponse<Page<DiskEncryptionSetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(ServiceResponse<Page<DiskEncryptionSetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskEncryptionSetsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskEncryptionSetsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskEncryptionSetInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskEncryptionSetInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskEncryptionSetInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskEncryptionSetInner>((Page)response.body()){

            public Page<DiskEncryptionSetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskEncryptionSetsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskEncryptionSetInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<DiskEncryptionSetInner>> serviceFuture, ListOperationCallback<DiskEncryptionSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(String nextPageLink) {
                return DiskEncryptionSetsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskEncryptionSetInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Page<DiskEncryptionSetInner>>(){

            public Page<DiskEncryptionSetInner> call(ServiceResponse<Page<DiskEncryptionSetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(ServiceResponse<Page<DiskEncryptionSetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskEncryptionSetsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskEncryptionSetsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskEncryptionSetInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskEncryptionSetInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskEncryptionSetInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskEncryptionSetInner>((Page)response.body()){

            public Page<DiskEncryptionSetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskEncryptionSetsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskEncryptionSetInner>> listNextAsync(String nextPageLink, ServiceFuture<List<DiskEncryptionSetInner>> serviceFuture, ListOperationCallback<DiskEncryptionSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(String nextPageLink) {
                return DiskEncryptionSetsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskEncryptionSetInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Page<DiskEncryptionSetInner>>(){

            public Page<DiskEncryptionSetInner> call(ServiceResponse<Page<DiskEncryptionSetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(ServiceResponse<Page<DiskEncryptionSetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskEncryptionSetsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>(){

            public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskEncryptionSetsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskEncryptionSetInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskEncryptionSetInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DiskEncryptionSetsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskEncryptionSetName") String var3, @Query(value="api-version") String var4, @Body DiskEncryptionSetInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskEncryptionSetName") String var3, @Query(value="api-version") String var4, @Body DiskEncryptionSetInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskEncryptionSetName") String var3, @Query(value="api-version") String var4, @Body DiskEncryptionSetUpdate var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskEncryptionSetName") String var3, @Query(value="api-version") String var4, @Body DiskEncryptionSetUpdate var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskEncryptionSetName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskEncryptionSetName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskEncryptionSetName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/diskEncryptionSets")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

