/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.management.compute.RequestRateByIntervalInput;
import com.microsoft.azure.management.compute.ThrottledRequestsInput;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.LogAnalyticsOperationResultInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class LogAnalyticsInner {
    private LogAnalyticsService service;
    private ComputeManagementClientImpl client;

    public LogAnalyticsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (LogAnalyticsService)retrofit.create(LogAnalyticsService.class);
        this.client = client;
    }

    public LogAnalyticsOperationResultInner exportRequestRateByInterval(String location, RequestRateByIntervalInput parameters) {
        return (LogAnalyticsOperationResultInner)((ServiceResponse)this.exportRequestRateByIntervalWithServiceResponseAsync(location, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<LogAnalyticsOperationResultInner> exportRequestRateByIntervalAsync(String location, RequestRateByIntervalInput parameters, ServiceCallback<LogAnalyticsOperationResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportRequestRateByIntervalWithServiceResponseAsync(location, parameters), serviceCallback);
    }

    public Observable<LogAnalyticsOperationResultInner> exportRequestRateByIntervalAsync(String location, RequestRateByIntervalInput parameters) {
        return this.exportRequestRateByIntervalWithServiceResponseAsync(location, parameters).map((Func1)new Func1<ServiceResponse<LogAnalyticsOperationResultInner>, LogAnalyticsOperationResultInner>(){

            public LogAnalyticsOperationResultInner call(ServiceResponse<LogAnalyticsOperationResultInner> response) {
                return (LogAnalyticsOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<LogAnalyticsOperationResultInner>> exportRequestRateByIntervalWithServiceResponseAsync(String location, RequestRateByIntervalInput parameters) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = this.service.exportRequestRateByInterval(location, this.client.subscriptionId(), parameters, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.AZURE_ASYNC_OPERATION), new TypeToken<LogAnalyticsOperationResultInner>(){}.getType());
    }

    public LogAnalyticsOperationResultInner beginExportRequestRateByInterval(String location, RequestRateByIntervalInput parameters) {
        return (LogAnalyticsOperationResultInner)((ServiceResponse)this.beginExportRequestRateByIntervalWithServiceResponseAsync(location, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<LogAnalyticsOperationResultInner> beginExportRequestRateByIntervalAsync(String location, RequestRateByIntervalInput parameters, ServiceCallback<LogAnalyticsOperationResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginExportRequestRateByIntervalWithServiceResponseAsync(location, parameters), serviceCallback);
    }

    public Observable<LogAnalyticsOperationResultInner> beginExportRequestRateByIntervalAsync(String location, RequestRateByIntervalInput parameters) {
        return this.beginExportRequestRateByIntervalWithServiceResponseAsync(location, parameters).map((Func1)new Func1<ServiceResponse<LogAnalyticsOperationResultInner>, LogAnalyticsOperationResultInner>(){

            public LogAnalyticsOperationResultInner call(ServiceResponse<LogAnalyticsOperationResultInner> response) {
                return (LogAnalyticsOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<LogAnalyticsOperationResultInner>> beginExportRequestRateByIntervalWithServiceResponseAsync(String location, RequestRateByIntervalInput parameters) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-12-01";
        return this.service.beginExportRequestRateByInterval(location, this.client.subscriptionId(), parameters, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogAnalyticsOperationResultInner>>>(){

            public Observable<ServiceResponse<LogAnalyticsOperationResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.beginExportRequestRateByIntervalDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LogAnalyticsOperationResultInner> beginExportRequestRateByIntervalDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LogAnalyticsOperationResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LogAnalyticsOperationResultInner exportThrottledRequests(String location, ThrottledRequestsInput parameters) {
        return (LogAnalyticsOperationResultInner)((ServiceResponse)this.exportThrottledRequestsWithServiceResponseAsync(location, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<LogAnalyticsOperationResultInner> exportThrottledRequestsAsync(String location, ThrottledRequestsInput parameters, ServiceCallback<LogAnalyticsOperationResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportThrottledRequestsWithServiceResponseAsync(location, parameters), serviceCallback);
    }

    public Observable<LogAnalyticsOperationResultInner> exportThrottledRequestsAsync(String location, ThrottledRequestsInput parameters) {
        return this.exportThrottledRequestsWithServiceResponseAsync(location, parameters).map((Func1)new Func1<ServiceResponse<LogAnalyticsOperationResultInner>, LogAnalyticsOperationResultInner>(){

            public LogAnalyticsOperationResultInner call(ServiceResponse<LogAnalyticsOperationResultInner> response) {
                return (LogAnalyticsOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<LogAnalyticsOperationResultInner>> exportThrottledRequestsWithServiceResponseAsync(String location, ThrottledRequestsInput parameters) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = this.service.exportThrottledRequests(location, this.client.subscriptionId(), parameters, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.AZURE_ASYNC_OPERATION), new TypeToken<LogAnalyticsOperationResultInner>(){}.getType());
    }

    public LogAnalyticsOperationResultInner beginExportThrottledRequests(String location, ThrottledRequestsInput parameters) {
        return (LogAnalyticsOperationResultInner)((ServiceResponse)this.beginExportThrottledRequestsWithServiceResponseAsync(location, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<LogAnalyticsOperationResultInner> beginExportThrottledRequestsAsync(String location, ThrottledRequestsInput parameters, ServiceCallback<LogAnalyticsOperationResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginExportThrottledRequestsWithServiceResponseAsync(location, parameters), serviceCallback);
    }

    public Observable<LogAnalyticsOperationResultInner> beginExportThrottledRequestsAsync(String location, ThrottledRequestsInput parameters) {
        return this.beginExportThrottledRequestsWithServiceResponseAsync(location, parameters).map((Func1)new Func1<ServiceResponse<LogAnalyticsOperationResultInner>, LogAnalyticsOperationResultInner>(){

            public LogAnalyticsOperationResultInner call(ServiceResponse<LogAnalyticsOperationResultInner> response) {
                return (LogAnalyticsOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<LogAnalyticsOperationResultInner>> beginExportThrottledRequestsWithServiceResponseAsync(String location, ThrottledRequestsInput parameters) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-12-01";
        return this.service.beginExportThrottledRequests(location, this.client.subscriptionId(), parameters, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogAnalyticsOperationResultInner>>>(){

            public Observable<ServiceResponse<LogAnalyticsOperationResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.beginExportThrottledRequestsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LogAnalyticsOperationResultInner> beginExportThrottledRequestsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LogAnalyticsOperationResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LogAnalyticsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.LogAnalytics exportRequestRateByInterval"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/logAnalytics/apiAccess/getRequestRateByInterval")
        public Observable<Response<ResponseBody>> exportRequestRateByInterval(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Body RequestRateByIntervalInput var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.LogAnalytics beginExportRequestRateByInterval"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/logAnalytics/apiAccess/getRequestRateByInterval")
        public Observable<Response<ResponseBody>> beginExportRequestRateByInterval(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Body RequestRateByIntervalInput var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.LogAnalytics exportThrottledRequests"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/logAnalytics/apiAccess/getThrottledRequests")
        public Observable<Response<ResponseBody>> exportThrottledRequests(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Body ThrottledRequestsInput var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.LogAnalytics beginExportThrottledRequests"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/logAnalytics/apiAccess/getThrottledRequests")
        public Observable<Response<ResponseBody>> beginExportThrottledRequests(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Body ThrottledRequestsInput var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

