/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.compute.implementation.RunCommandDocumentBaseInner;
import com.microsoft.azure.management.compute.implementation.RunCommandDocumentInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualMachineRunCommandsInner {
    private VirtualMachineRunCommandsService service;
    private ComputeManagementClientImpl client;

    public VirtualMachineRunCommandsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (VirtualMachineRunCommandsService)retrofit.create(VirtualMachineRunCommandsService.class);
        this.client = client;
    }

    public PagedList<RunCommandDocumentBaseInner> list(String location) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(location).toBlocking().single();
        return new PagedList<RunCommandDocumentBaseInner>((Page)response.body()){

            public Page<RunCommandDocumentBaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachineRunCommandsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RunCommandDocumentBaseInner>> listAsync(String location, ListOperationCallback<RunCommandDocumentBaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(location), (Func1)new Func1<String, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(String nextPageLink) {
                return VirtualMachineRunCommandsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RunCommandDocumentBaseInner>> listAsync(String location) {
        return this.listWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Page<RunCommandDocumentBaseInner>>(){

            public Page<RunCommandDocumentBaseInner> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listWithServiceResponseAsync(String location) {
        return this.listSinglePageAsync(location).concatMap((Func1)new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachineRunCommandsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listSinglePageAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.list(location, this.client.subscriptionId(), "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachineRunCommandsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<RunCommandDocumentBaseInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<RunCommandDocumentBaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RunCommandDocumentInner get(String location, String commandId) {
        return (RunCommandDocumentInner)((ServiceResponse)this.getWithServiceResponseAsync(location, commandId).toBlocking().single()).body();
    }

    public ServiceFuture<RunCommandDocumentInner> getAsync(String location, String commandId, ServiceCallback<RunCommandDocumentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(location, commandId), serviceCallback);
    }

    public Observable<RunCommandDocumentInner> getAsync(String location, String commandId) {
        return this.getWithServiceResponseAsync(location, commandId).map((Func1)new Func1<ServiceResponse<RunCommandDocumentInner>, RunCommandDocumentInner>(){

            public RunCommandDocumentInner call(ServiceResponse<RunCommandDocumentInner> response) {
                return (RunCommandDocumentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RunCommandDocumentInner>> getWithServiceResponseAsync(String location, String commandId) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (commandId == null) {
            throw new IllegalArgumentException("Parameter commandId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.get(location, commandId, this.client.subscriptionId(), "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RunCommandDocumentInner>>>(){

            public Observable<ServiceResponse<RunCommandDocumentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineRunCommandsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RunCommandDocumentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RunCommandDocumentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RunCommandDocumentBaseInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RunCommandDocumentBaseInner>((Page)response.body()){

            public Page<RunCommandDocumentBaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachineRunCommandsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RunCommandDocumentBaseInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RunCommandDocumentBaseInner>> serviceFuture, ListOperationCallback<RunCommandDocumentBaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(String nextPageLink) {
                return VirtualMachineRunCommandsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RunCommandDocumentBaseInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Page<RunCommandDocumentBaseInner>>(){

            public Page<RunCommandDocumentBaseInner> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachineRunCommandsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachineRunCommandsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<RunCommandDocumentBaseInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<RunCommandDocumentBaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualMachineRunCommandsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands")
        public Observable<Response<ResponseBody>> list(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands/{commandId}")
        public Observable<Response<ResponseBody>> get(@Path(value="location") String var1, @Path(value="commandId") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

