/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.GalleryApplicationVersionUpdate;
import com.microsoft.azure.management.compute.ReplicationStatusTypes;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.GalleryApplicationVersionInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class GalleryApplicationVersionsInner {
    private GalleryApplicationVersionsService service;
    private ComputeManagementClientImpl client;

    public GalleryApplicationVersionsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (GalleryApplicationVersionsService)retrofit.create(GalleryApplicationVersionsService.class);
        this.client = client;
    }

    public GalleryApplicationVersionInner createOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return (GalleryApplicationVersionInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).toBlocking().last()).body());
    }

    public ServiceFuture<GalleryApplicationVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion, ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion), serviceCallback);
    }

    public Observable<GalleryApplicationVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).map((Func1)new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>(){

            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return (GalleryApplicationVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationVersionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        if (galleryApplicationVersion == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryApplicationVersion));
        String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", galleryApplicationVersion, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryApplicationVersionInner>(){}.getType());
    }

    public GalleryApplicationVersionInner beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return (GalleryApplicationVersionInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryApplicationVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion, ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion), serviceCallback);
    }

    public Observable<GalleryApplicationVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).map((Func1)new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>(){

            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return (GalleryApplicationVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationVersionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        if (galleryApplicationVersion == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryApplicationVersion));
        String apiVersion = "2019-12-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", galleryApplicationVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationVersionInner>>>(){

            public Observable<ServiceResponse<GalleryApplicationVersionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryApplicationVersionsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryApplicationVersionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryApplicationVersionInner>(){}.getType()).register(201, new TypeToken<GalleryApplicationVersionInner>(){}.getType()).register(202, new TypeToken<GalleryApplicationVersionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GalleryApplicationVersionInner update(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return (GalleryApplicationVersionInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).toBlocking().last()).body());
    }

    public ServiceFuture<GalleryApplicationVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion, ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion), serviceCallback);
    }

    public Observable<GalleryApplicationVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return this.updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).map((Func1)new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>(){

            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return (GalleryApplicationVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationVersionInner>> updateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        if (galleryApplicationVersion == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryApplicationVersion));
        String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", galleryApplicationVersion, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryApplicationVersionInner>(){}.getType());
    }

    public GalleryApplicationVersionInner beginUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return (GalleryApplicationVersionInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryApplicationVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion, ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion), serviceCallback);
    }

    public Observable<GalleryApplicationVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).map((Func1)new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>(){

            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return (GalleryApplicationVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationVersionInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        if (galleryApplicationVersion == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryApplicationVersion));
        String apiVersion = "2019-12-01";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", galleryApplicationVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationVersionInner>>>(){

            public Observable<ServiceResponse<GalleryApplicationVersionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryApplicationVersionsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryApplicationVersionInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryApplicationVersionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GalleryApplicationVersionInner get(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        return (GalleryApplicationVersionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryApplicationVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName), serviceCallback);
    }

    public Observable<GalleryApplicationVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).map((Func1)new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>(){

            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return (GalleryApplicationVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationVersionInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        ReplicationStatusTypes expand = null;
        return this.service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationVersionInner>>>(){

            public Observable<ServiceResponse<GalleryApplicationVersionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryApplicationVersionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public GalleryApplicationVersionInner get(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand) {
        return (GalleryApplicationVersionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryApplicationVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand, ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand), serviceCallback);
    }

    public Observable<GalleryApplicationVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand).map((Func1)new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>(){

            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return (GalleryApplicationVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryApplicationVersionInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationVersionInner>>>(){

            public Observable<ServiceResponse<GalleryApplicationVersionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryApplicationVersionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryApplicationVersionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryApplicationVersionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryApplicationVersionsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GalleryApplicationVersionInner> listByGalleryApplication(String resourceGroupName, String galleryName, String galleryApplicationName) {
        ServiceResponse response = (ServiceResponse)this.listByGalleryApplicationSinglePageAsync(resourceGroupName, galleryName, galleryApplicationName).toBlocking().single();
        return new PagedList<GalleryApplicationVersionInner>((Page)response.body()){

            public Page<GalleryApplicationVersionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)GalleryApplicationVersionsInner.this.listByGalleryApplicationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GalleryApplicationVersionInner>> listByGalleryApplicationAsync(String resourceGroupName, String galleryName, String galleryApplicationName, ListOperationCallback<GalleryApplicationVersionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByGalleryApplicationSinglePageAsync(resourceGroupName, galleryName, galleryApplicationName), (Func1)new Func1<String, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(String nextPageLink) {
                return GalleryApplicationVersionsInner.this.listByGalleryApplicationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GalleryApplicationVersionInner>> listByGalleryApplicationAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return this.listByGalleryApplicationWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).map((Func1)new Func1<ServiceResponse<Page<GalleryApplicationVersionInner>>, Page<GalleryApplicationVersionInner>>(){

            public Page<GalleryApplicationVersionInner> call(ServiceResponse<Page<GalleryApplicationVersionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> listByGalleryApplicationWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return this.listByGalleryApplicationSinglePageAsync(resourceGroupName, galleryName, galleryApplicationName).concatMap((Func1)new Func1<ServiceResponse<Page<GalleryApplicationVersionInner>>, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(ServiceResponse<Page<GalleryApplicationVersionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GalleryApplicationVersionsInner.this.listByGalleryApplicationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> listByGalleryApplicationSinglePageAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.listByGalleryApplication(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GalleryApplicationVersionsInner.this.listByGalleryApplicationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<GalleryApplicationVersionInner>> listByGalleryApplicationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<GalleryApplicationVersionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GalleryApplicationVersionInner> listByGalleryApplicationNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByGalleryApplicationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GalleryApplicationVersionInner>((Page)response.body()){

            public Page<GalleryApplicationVersionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)GalleryApplicationVersionsInner.this.listByGalleryApplicationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GalleryApplicationVersionInner>> listByGalleryApplicationNextAsync(String nextPageLink, ServiceFuture<List<GalleryApplicationVersionInner>> serviceFuture, ListOperationCallback<GalleryApplicationVersionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByGalleryApplicationNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(String nextPageLink) {
                return GalleryApplicationVersionsInner.this.listByGalleryApplicationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GalleryApplicationVersionInner>> listByGalleryApplicationNextAsync(String nextPageLink) {
        return this.listByGalleryApplicationNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<GalleryApplicationVersionInner>>, Page<GalleryApplicationVersionInner>>(){

            public Page<GalleryApplicationVersionInner> call(ServiceResponse<Page<GalleryApplicationVersionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> listByGalleryApplicationNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByGalleryApplicationNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<GalleryApplicationVersionInner>>, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(ServiceResponse<Page<GalleryApplicationVersionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GalleryApplicationVersionsInner.this.listByGalleryApplicationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> listByGalleryApplicationNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByGalleryApplicationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GalleryApplicationVersionsInner.this.listByGalleryApplicationNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<GalleryApplicationVersionInner>> listByGalleryApplicationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<GalleryApplicationVersionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface GalleryApplicationVersionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Path(value="galleryApplicationVersionName") String var5, @Query(value="api-version") String var6, @Body GalleryApplicationVersionInner var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Path(value="galleryApplicationVersionName") String var5, @Query(value="api-version") String var6, @Body GalleryApplicationVersionInner var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Path(value="galleryApplicationVersionName") String var5, @Query(value="api-version") String var6, @Body GalleryApplicationVersionUpdate var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Path(value="galleryApplicationVersionName") String var5, @Query(value="api-version") String var6, @Body GalleryApplicationVersionUpdate var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Path(value="galleryApplicationVersionName") String var5, @Query(value="$expand") ReplicationStatusTypes var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Path(value="galleryApplicationVersionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Path(value="galleryApplicationVersionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions listByGalleryApplication"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions")
        public Observable<Response<ResponseBody>> listByGalleryApplication(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryApplicationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions listByGalleryApplicationNext"})
        @GET
        public Observable<Response<ResponseBody>> listByGalleryApplicationNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

