/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.ProximityPlacementGroupUpdate;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.compute.implementation.ProximityPlacementGroupInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ProximityPlacementGroupsInner
implements InnerSupportsGet<ProximityPlacementGroupInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ProximityPlacementGroupInner> {
    private ProximityPlacementGroupsService service;
    private ComputeManagementClientImpl client;

    public ProximityPlacementGroupsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (ProximityPlacementGroupsService)retrofit.create(ProximityPlacementGroupsService.class);
        this.client = client;
    }

    public ProximityPlacementGroupInner createOrUpdate(String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters) {
        return (ProximityPlacementGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ProximityPlacementGroupInner> createOrUpdateAsync(String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters, ServiceCallback<ProximityPlacementGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, parameters), serviceCallback);
    }

    public Observable<ProximityPlacementGroupInner> createOrUpdateAsync(String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, parameters).map((Func1)new Func1<ServiceResponse<ProximityPlacementGroupInner>, ProximityPlacementGroupInner>(){

            public ProximityPlacementGroupInner call(ServiceResponse<ProximityPlacementGroupInner> response) {
                return (ProximityPlacementGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProximityPlacementGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2020-06-01";
        return this.service.createOrUpdate(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), parameters, "2020-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProximityPlacementGroupInner>>>(){

            public Observable<ServiceResponse<ProximityPlacementGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProximityPlacementGroupsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProximityPlacementGroupInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProximityPlacementGroupInner>(){}.getType()).register(201, new TypeToken<ProximityPlacementGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ProximityPlacementGroupInner update(String resourceGroupName, String proximityPlacementGroupName) {
        return (ProximityPlacementGroupInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<ProximityPlacementGroupInner> updateAsync(String resourceGroupName, String proximityPlacementGroupName, ServiceCallback<ProximityPlacementGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName), serviceCallback);
    }

    public Observable<ProximityPlacementGroupInner> updateAsync(String resourceGroupName, String proximityPlacementGroupName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).map((Func1)new Func1<ServiceResponse<ProximityPlacementGroupInner>, ProximityPlacementGroupInner>(){

            public ProximityPlacementGroupInner call(ServiceResponse<ProximityPlacementGroupInner> response) {
                return (ProximityPlacementGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProximityPlacementGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-06-01";
        Object tags = null;
        ProximityPlacementGroupUpdate parameters = new ProximityPlacementGroupUpdate();
        parameters.withTags(null);
        return this.service.update(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), "2020-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProximityPlacementGroupInner>>>(){

            public Observable<ServiceResponse<ProximityPlacementGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProximityPlacementGroupsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ProximityPlacementGroupInner update(String resourceGroupName, String proximityPlacementGroupName, Map<String, String> tags) {
        return (ProximityPlacementGroupInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ProximityPlacementGroupInner> updateAsync(String resourceGroupName, String proximityPlacementGroupName, Map<String, String> tags, ServiceCallback<ProximityPlacementGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, tags), serviceCallback);
    }

    public Observable<ProximityPlacementGroupInner> updateAsync(String resourceGroupName, String proximityPlacementGroupName, Map<String, String> tags) {
        return this.updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, tags).map((Func1)new Func1<ServiceResponse<ProximityPlacementGroupInner>, ProximityPlacementGroupInner>(){

            public ProximityPlacementGroupInner call(ServiceResponse<ProximityPlacementGroupInner> response) {
                return (ProximityPlacementGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProximityPlacementGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2020-06-01";
        ProximityPlacementGroupUpdate parameters = new ProximityPlacementGroupUpdate();
        parameters.withTags(tags);
        return this.service.update(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), "2020-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProximityPlacementGroupInner>>>(){

            public Observable<ServiceResponse<ProximityPlacementGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProximityPlacementGroupsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProximityPlacementGroupInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProximityPlacementGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String proximityPlacementGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String proximityPlacementGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String proximityPlacementGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-06-01";
        return this.service.delete(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), "2020-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProximityPlacementGroupsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ProximityPlacementGroupInner getByResourceGroup(String resourceGroupName, String proximityPlacementGroupName) {
        return (ProximityPlacementGroupInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<ProximityPlacementGroupInner> getByResourceGroupAsync(String resourceGroupName, String proximityPlacementGroupName, ServiceCallback<ProximityPlacementGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName), serviceCallback);
    }

    public Observable<ProximityPlacementGroupInner> getByResourceGroupAsync(String resourceGroupName, String proximityPlacementGroupName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).map((Func1)new Func1<ServiceResponse<ProximityPlacementGroupInner>, ProximityPlacementGroupInner>(){

            public ProximityPlacementGroupInner call(ServiceResponse<ProximityPlacementGroupInner> response) {
                return (ProximityPlacementGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProximityPlacementGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-06-01";
        String includeColocationStatus = null;
        return this.service.getByResourceGroup(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), includeColocationStatus, "2020-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProximityPlacementGroupInner>>>(){

            public Observable<ServiceResponse<ProximityPlacementGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProximityPlacementGroupsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ProximityPlacementGroupInner getByResourceGroup(String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus) {
        return (ProximityPlacementGroupInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, includeColocationStatus).toBlocking().single()).body());
    }

    public ServiceFuture<ProximityPlacementGroupInner> getByResourceGroupAsync(String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus, ServiceCallback<ProximityPlacementGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, includeColocationStatus), serviceCallback);
    }

    public Observable<ProximityPlacementGroupInner> getByResourceGroupAsync(String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, includeColocationStatus).map((Func1)new Func1<ServiceResponse<ProximityPlacementGroupInner>, ProximityPlacementGroupInner>(){

            public ProximityPlacementGroupInner call(ServiceResponse<ProximityPlacementGroupInner> response) {
                return (ProximityPlacementGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProximityPlacementGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-06-01";
        return this.service.getByResourceGroup(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), includeColocationStatus, "2020-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProximityPlacementGroupInner>>>(){

            public Observable<ServiceResponse<ProximityPlacementGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProximityPlacementGroupsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProximityPlacementGroupInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProximityPlacementGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProximityPlacementGroupInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ProximityPlacementGroupInner>((Page)response.body()){

            public Page<ProximityPlacementGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProximityPlacementGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProximityPlacementGroupInner>> listAsync(ListOperationCallback<ProximityPlacementGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(String nextPageLink) {
                return ProximityPlacementGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProximityPlacementGroupInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Page<ProximityPlacementGroupInner>>(){

            public Page<ProximityPlacementGroupInner> call(ServiceResponse<Page<ProximityPlacementGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(ServiceResponse<Page<ProximityPlacementGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProximityPlacementGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-06-01";
        return this.service.list(this.client.subscriptionId(), "2020-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProximityPlacementGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ProximityPlacementGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProximityPlacementGroupInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ProximityPlacementGroupInner>((Page)response.body()){

            public Page<ProximityPlacementGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProximityPlacementGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProximityPlacementGroupInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ProximityPlacementGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(String nextPageLink) {
                return ProximityPlacementGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProximityPlacementGroupInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Page<ProximityPlacementGroupInner>>(){

            public Page<ProximityPlacementGroupInner> call(ServiceResponse<Page<ProximityPlacementGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(ServiceResponse<Page<ProximityPlacementGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProximityPlacementGroupsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-06-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2020-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProximityPlacementGroupsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ProximityPlacementGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProximityPlacementGroupInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProximityPlacementGroupInner>((Page)response.body()){

            public Page<ProximityPlacementGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProximityPlacementGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProximityPlacementGroupInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ProximityPlacementGroupInner>> serviceFuture, ListOperationCallback<ProximityPlacementGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(String nextPageLink) {
                return ProximityPlacementGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProximityPlacementGroupInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Page<ProximityPlacementGroupInner>>(){

            public Page<ProximityPlacementGroupInner> call(ServiceResponse<Page<ProximityPlacementGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(ServiceResponse<Page<ProximityPlacementGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProximityPlacementGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProximityPlacementGroupsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ProximityPlacementGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProximityPlacementGroupInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProximityPlacementGroupInner>((Page)response.body()){

            public Page<ProximityPlacementGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProximityPlacementGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProximityPlacementGroupInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ProximityPlacementGroupInner>> serviceFuture, ListOperationCallback<ProximityPlacementGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(String nextPageLink) {
                return ProximityPlacementGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProximityPlacementGroupInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Page<ProximityPlacementGroupInner>>(){

            public Page<ProximityPlacementGroupInner> call(ServiceResponse<Page<ProximityPlacementGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(ServiceResponse<Page<ProximityPlacementGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProximityPlacementGroupsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProximityPlacementGroupsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ProximityPlacementGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ProximityPlacementGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups/{proximityPlacementGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="proximityPlacementGroupName") String var2, @Path(value="subscriptionId") String var3, @Body ProximityPlacementGroupInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups/{proximityPlacementGroupName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="proximityPlacementGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body ProximityPlacementGroupUpdate var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups/{proximityPlacementGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="proximityPlacementGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups/{proximityPlacementGroupName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="proximityPlacementGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="includeColocationStatus") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/proximityPlacementGroups")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

