/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for LinuxVMGuestPatchMode.
 */
public final class LinuxVMGuestPatchMode extends ExpandableStringEnum<LinuxVMGuestPatchMode> {
    /** Static value ImageDefault for LinuxVMGuestPatchMode. */
    public static final LinuxVMGuestPatchMode IMAGE_DEFAULT = fromString("ImageDefault");

    /** Static value AutomaticByPlatform for LinuxVMGuestPatchMode. */
    public static final LinuxVMGuestPatchMode AUTOMATIC_BY_PLATFORM = fromString("AutomaticByPlatform");

    /**
     * Creates or finds a LinuxVMGuestPatchMode from its string representation.
     * @param name a name to look for
     * @return the corresponding LinuxVMGuestPatchMode
     */
    @JsonCreator
    public static LinuxVMGuestPatchMode fromString(String name) {
        return fromString(name, LinuxVMGuestPatchMode.class);
    }

    /**
     * @return known LinuxVMGuestPatchMode values
     */
    public static Collection<LinuxVMGuestPatchMode> values() {
        return values(LinuxVMGuestPatchMode.class);
    }
}
