/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import java.util.List;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes the properties of a Virtual Machine software patch.
 */
public class VirtualMachineSoftwarePatchProperties {
    /**
     * A unique identifier for the patch.
     */
    @JsonProperty(value = "patchId", access = JsonProperty.Access.WRITE_ONLY)
    private String patchId;

    /**
     * The friendly name of the patch.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /**
     * The version number of the patch. This property applies only to Linux
     * patches.
     */
    @JsonProperty(value = "version", access = JsonProperty.Access.WRITE_ONLY)
    private String version;

    /**
     * The KBID of the patch. Only applies to Windows patches.
     */
    @JsonProperty(value = "kbId", access = JsonProperty.Access.WRITE_ONLY)
    private String kbId;

    /**
     * The classification(s) of the patch as provided by the patch publisher.
     */
    @JsonProperty(value = "classifications", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> classifications;

    /**
     * Describes the reboot requirements of the patch. Possible values include:
     * 'Unknown', 'NeverReboots', 'AlwaysRequiresReboot', 'CanRequestReboot'.
     */
    @JsonProperty(value = "rebootBehavior", access = JsonProperty.Access.WRITE_ONLY)
    private VMGuestPatchRebootBehavior rebootBehavior;

    /**
     * The activity ID of the operation that produced this result. It is used
     * to correlate across CRP and extension logs.
     */
    @JsonProperty(value = "activityId", access = JsonProperty.Access.WRITE_ONLY)
    private String activityId;

    /**
     * The UTC timestamp when the repository published this patch.
     */
    @JsonProperty(value = "publishedDate", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime publishedDate;

    /**
     * The UTC timestamp of the last update to this patch record.
     */
    @JsonProperty(value = "lastModifiedDateTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime lastModifiedDateTime;

    /**
     * Describes the availability of a given patch. Possible values include:
     * 'Unknown', 'Available'.
     */
    @JsonProperty(value = "assessmentState", access = JsonProperty.Access.WRITE_ONLY)
    private PatchAssessmentState assessmentState;

    /**
     * Get a unique identifier for the patch.
     *
     * @return the patchId value
     */
    public String patchId() {
        return this.patchId;
    }

    /**
     * Get the friendly name of the patch.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the version number of the patch. This property applies only to Linux patches.
     *
     * @return the version value
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the KBID of the patch. Only applies to Windows patches.
     *
     * @return the kbId value
     */
    public String kbId() {
        return this.kbId;
    }

    /**
     * Get the classification(s) of the patch as provided by the patch publisher.
     *
     * @return the classifications value
     */
    public List<String> classifications() {
        return this.classifications;
    }

    /**
     * Get describes the reboot requirements of the patch. Possible values include: 'Unknown', 'NeverReboots', 'AlwaysRequiresReboot', 'CanRequestReboot'.
     *
     * @return the rebootBehavior value
     */
    public VMGuestPatchRebootBehavior rebootBehavior() {
        return this.rebootBehavior;
    }

    /**
     * Get the activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
     *
     * @return the activityId value
     */
    public String activityId() {
        return this.activityId;
    }

    /**
     * Get the UTC timestamp when the repository published this patch.
     *
     * @return the publishedDate value
     */
    public DateTime publishedDate() {
        return this.publishedDate;
    }

    /**
     * Get the UTC timestamp of the last update to this patch record.
     *
     * @return the lastModifiedDateTime value
     */
    public DateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Get describes the availability of a given patch. Possible values include: 'Unknown', 'Available'.
     *
     * @return the assessmentState value
     */
    public PatchAssessmentState assessmentState() {
        return this.assessmentState;
    }

}
