/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Summary for an orchestration service of a virtual machine scale set.
 */
public class OrchestrationServiceSummary {
    /**
     * The name of the service. Possible values include: 'AutomaticRepairs'.
     */
    @JsonProperty(value = "serviceName", access = JsonProperty.Access.WRITE_ONLY)
    private OrchestrationServiceNames serviceName;

    /**
     * The current state of the service. Possible values include: 'NotRunning',
     * 'Running', 'Suspended'.
     */
    @JsonProperty(value = "serviceState", access = JsonProperty.Access.WRITE_ONLY)
    private OrchestrationServiceState serviceState;

    /**
     * Get the name of the service. Possible values include: 'AutomaticRepairs'.
     *
     * @return the serviceName value
     */
    public OrchestrationServiceNames serviceName() {
        return this.serviceName;
    }

    /**
     * Get the current state of the service. Possible values include: 'NotRunning', 'Running', 'Suspended'.
     *
     * @return the serviceState value
     */
    public OrchestrationServiceState serviceState() {
        return this.serviceState;
    }

}
