/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies settings related to VM Guest Patching on Windows.
 */
public class PatchSettings {
    /**
     * Specifies the mode of VM Guest Patching to IaaS virtual machine.&lt;br
     * /&gt;&lt;br /&gt; Possible values are:&lt;br /&gt;&lt;br /&gt;
     * **Manual** - You  control the application of patches to a virtual
     * machine. You do this by applying patches manually inside the VM. In this
     * mode, automatic updates are disabled; the property
     * WindowsConfiguration.enableAutomaticUpdates must be false&lt;br
     * /&gt;&lt;br /&gt; **AutomaticByOS** - The virtual machine will
     * automatically be updated by the OS. The property
     * WindowsConfiguration.enableAutomaticUpdates must be true. &lt;br
     * /&gt;&lt;br /&gt; **AutomaticByPlatform** - the virtual machine will
     * automatically updated by the platform. The properties provisionVMAgent
     * and WindowsConfiguration.enableAutomaticUpdates must be true. Possible
     * values include: 'Manual', 'AutomaticByOS', 'AutomaticByPlatform'.
     */
    @JsonProperty(value = "patchMode")
    private WindowsVMGuestPatchMode patchMode;

    /**
     * Enables customers to patch their Azure VMs without requiring a reboot.
     * For enableHotpatching, the 'provisionVMAgent' must be set to true and
     * 'patchMode' must be set to 'AutomaticByPlatform'.
     */
    @JsonProperty(value = "enableHotpatching")
    private Boolean enableHotpatching;

    /**
     * Get specifies the mode of VM Guest Patching to IaaS virtual machine.&lt;br /&gt;&lt;br /&gt; Possible values are:&lt;br /&gt;&lt;br /&gt; **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false&lt;br /&gt;&lt;br /&gt; **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. &lt;br /&gt;&lt;br /&gt; **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true. Possible values include: 'Manual', 'AutomaticByOS', 'AutomaticByPlatform'.
     *
     * @return the patchMode value
     */
    public WindowsVMGuestPatchMode patchMode() {
        return this.patchMode;
    }

    /**
     * Set specifies the mode of VM Guest Patching to IaaS virtual machine.&lt;br /&gt;&lt;br /&gt; Possible values are:&lt;br /&gt;&lt;br /&gt; **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false&lt;br /&gt;&lt;br /&gt; **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. &lt;br /&gt;&lt;br /&gt; **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true. Possible values include: 'Manual', 'AutomaticByOS', 'AutomaticByPlatform'.
     *
     * @param patchMode the patchMode value to set
     * @return the PatchSettings object itself.
     */
    public PatchSettings withPatchMode(WindowsVMGuestPatchMode patchMode) {
        this.patchMode = patchMode;
        return this;
    }

    /**
     * Get enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.
     *
     * @return the enableHotpatching value
     */
    public Boolean enableHotpatching() {
        return this.enableHotpatching;
    }

    /**
     * Set enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.
     *
     * @param enableHotpatching the enableHotpatching value to set
     * @return the PatchSettings object itself.
     */
    public PatchSettings withEnableHotpatching(Boolean enableHotpatching) {
        this.enableHotpatching = enableHotpatching;
        return this;
    }

}
