/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.DiskAccessUpdate;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in DiskAccesses.
 */
public class DiskAccessesInner implements InnerSupportsGet<DiskAccessInner>, InnerSupportsDelete<Void>, InnerSupportsListing<DiskAccessInner> {
    /** The Retrofit service to perform REST calls. */
    private DiskAccessesService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of DiskAccessesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DiskAccessesInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(DiskAccessesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for DiskAccesses to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DiskAccessesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Query("api-version") String apiVersion, @Body DiskAccessInner diskAccess, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Query("api-version") String apiVersion, @Body DiskAccessInner diskAccess, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body DiskAccessUpdate diskAccess, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body DiskAccessUpdate diskAccess, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Compute/diskAccesses")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses getPrivateLinkResources" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateLinkResources")
        Observable<Response<ResponseBody>> getPrivateLinkResources(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses updateAPrivateEndpointConnection" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}")
        Observable<Response<ResponseBody>> updateAPrivateEndpointConnection(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Path("privateEndpointConnectionName") String privateEndpointConnectionName, @Query("api-version") String apiVersion, @Body PrivateEndpointConnectionInner privateEndpointConnection, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses beginUpdateAPrivateEndpointConnection" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}")
        Observable<Response<ResponseBody>> beginUpdateAPrivateEndpointConnection(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Path("privateEndpointConnectionName") String privateEndpointConnectionName, @Query("api-version") String apiVersion, @Body PrivateEndpointConnectionInner privateEndpointConnection, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses getAPrivateEndpointConnection" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}")
        Observable<Response<ResponseBody>> getAPrivateEndpointConnection(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Path("privateEndpointConnectionName") String privateEndpointConnectionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses deleteAPrivateEndpointConnection" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAPrivateEndpointConnection(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Path("privateEndpointConnectionName") String privateEndpointConnectionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses beginDeleteAPrivateEndpointConnection" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteAPrivateEndpointConnection(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Path("privateEndpointConnectionName") String privateEndpointConnectionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses listPrivateEndpointConnections" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections")
        Observable<Response<ResponseBody>> listPrivateEndpointConnections(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskAccessName") String diskAccessName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses listPrivateEndpointConnectionsNext" })
        @GET
        Observable<Response<ResponseBody>> listPrivateEndpointConnectionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates or updates a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskAccessInner object if successful.
     */
    public DiskAccessInner createOrUpdate(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess).toBlocking().last().body();
    }

    /**
     * Creates or updates a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskAccessInner> createOrUpdateAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess, final ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess), serviceCallback);
    }

    /**
     * Creates or updates a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DiskAccessInner> createOrUpdateAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess).map(new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>() {
            @Override
            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DiskAccessInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (diskAccess == null) {
            throw new IllegalArgumentException("Parameter diskAccess is required and cannot be null.");
        }
        Validator.validate(diskAccess);
        final String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, diskAccess, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskAccessInner>() { }.getType());
    }

    /**
     * Creates or updates a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskAccessInner object if successful.
     */
    public DiskAccessInner beginCreateOrUpdate(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess).toBlocking().single().body();
    }

    /**
     * Creates or updates a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskAccessInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess, final ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess), serviceCallback);
    }

    /**
     * Creates or updates a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskAccessInner object
     */
    public Observable<DiskAccessInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess).map(new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>() {
            @Override
            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskAccessInner object
     */
    public Observable<ServiceResponse<DiskAccessInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (diskAccess == null) {
            throw new IllegalArgumentException("Parameter diskAccess is required and cannot be null.");
        }
        Validator.validate(diskAccess);
        final String apiVersion = "2020-09-30";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, diskAccess, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskAccessInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskAccessInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskAccessInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiskAccessInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiskAccessInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiskAccessInner>() { }.getType())
                .register(202, new TypeToken<DiskAccessInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskAccessInner object if successful.
     */
    public DiskAccessInner update(String resourceGroupName, String diskAccessName) {
        return updateWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().last().body();
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskAccessInner> updateAsync(String resourceGroupName, String diskAccessName, final ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DiskAccessInner> updateAsync(String resourceGroupName, String diskAccessName) {
        return updateWithServiceResponseAsync(resourceGroupName, diskAccessName).map(new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>() {
            @Override
            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DiskAccessInner>> updateWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        final Map<String, String> tags = null;
        DiskAccessUpdate diskAccess = new DiskAccessUpdate();
        diskAccess.withTags(null);
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, this.client.acceptLanguage(), diskAccess, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskAccessInner>() { }.getType());
    }
    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param tags Resource tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskAccessInner object if successful.
     */
    public DiskAccessInner update(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags).toBlocking().last().body();
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param tags Resource tags
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskAccessInner> updateAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags, final ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags), serviceCallback);
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param tags Resource tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DiskAccessInner> updateAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags).map(new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>() {
            @Override
            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param tags Resource tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DiskAccessInner>> updateWithServiceResponseAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2020-09-30";
        DiskAccessUpdate diskAccess = new DiskAccessUpdate();
        diskAccess.withTags(tags);
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, this.client.acceptLanguage(), diskAccess, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskAccessInner>() { }.getType());
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskAccessInner object if successful.
     */
    public DiskAccessInner beginUpdate(String resourceGroupName, String diskAccessName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().single().body();
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskAccessInner> beginUpdateAsync(String resourceGroupName, String diskAccessName, final ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskAccessInner object
     */
    public Observable<DiskAccessInner> beginUpdateAsync(String resourceGroupName, String diskAccessName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName).map(new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>() {
            @Override
            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskAccessInner object
     */
    public Observable<ServiceResponse<DiskAccessInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        final Map<String, String> tags = null;
        DiskAccessUpdate diskAccess = new DiskAccessUpdate();
        diskAccess.withTags(null);
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, this.client.acceptLanguage(), diskAccess, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskAccessInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskAccessInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskAccessInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param tags Resource tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskAccessInner object if successful.
     */
    public DiskAccessInner beginUpdate(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags).toBlocking().single().body();
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param tags Resource tags
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskAccessInner> beginUpdateAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags, final ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags), serviceCallback);
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param tags Resource tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskAccessInner object
     */
    public Observable<DiskAccessInner> beginUpdateAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags).map(new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>() {
            @Override
            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates (patches) a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param tags Resource tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskAccessInner object
     */
    public Observable<ServiceResponse<DiskAccessInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2020-09-30";
        DiskAccessUpdate diskAccess = new DiskAccessUpdate();
        diskAccess.withTags(tags);
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, this.client.acceptLanguage(), diskAccess, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskAccessInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskAccessInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskAccessInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiskAccessInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiskAccessInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiskAccessInner>() { }.getType())
                .register(202, new TypeToken<DiskAccessInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskAccessInner object if successful.
     */
    public DiskAccessInner getByResourceGroup(String resourceGroupName, String diskAccessName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().single().body();
    }

    /**
     * Gets information about a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskAccessInner> getByResourceGroupAsync(String resourceGroupName, String diskAccessName, final ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    /**
     * Gets information about a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskAccessInner object
     */
    public Observable<DiskAccessInner> getByResourceGroupAsync(String resourceGroupName, String diskAccessName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskAccessName).map(new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>() {
            @Override
            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskAccessInner object
     */
    public Observable<ServiceResponse<DiskAccessInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskAccessInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskAccessInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskAccessInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiskAccessInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiskAccessInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiskAccessInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String diskAccessName) {
        deleteWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().last().body();
    }

    /**
     * Deletes a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String diskAccessName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    /**
     * Deletes a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String diskAccessName) {
        return deleteWithServiceResponseAsync(resourceGroupName, diskAccessName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String diskAccessName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().single().body();
    }

    /**
     * Deletes a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String diskAccessName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    /**
     * Deletes a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String diskAccessName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, diskAccessName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disk access resources under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskAccessInner&gt; object if successful.
     */
    public PagedList<DiskAccessInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<DiskAccessInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DiskAccessInner>(response.body()) {
            @Override
            public Page<DiskAccessInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disk access resources under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskAccessInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<DiskAccessInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disk access resources under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskAccessInner&gt; object
     */
    public Observable<Page<DiskAccessInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<DiskAccessInner>>, Page<DiskAccessInner>>() {
                @Override
                public Page<DiskAccessInner> call(ServiceResponse<Page<DiskAccessInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disk access resources under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskAccessInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskAccessInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<DiskAccessInner>>, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(ServiceResponse<Page<DiskAccessInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disk access resources under a resource group.
     *
    ServiceResponse<PageImpl1<DiskAccessInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskAccessInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskAccessInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskAccessInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskAccessInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskAccessInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskAccessInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskAccessInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disk access resources under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskAccessInner&gt; object if successful.
     */
    public PagedList<DiskAccessInner> list() {
        ServiceResponse<Page<DiskAccessInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<DiskAccessInner>(response.body()) {
            @Override
            public Page<DiskAccessInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disk access resources under a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskAccessInner>> listAsync(final ListOperationCallback<DiskAccessInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disk access resources under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskAccessInner&gt; object
     */
    public Observable<Page<DiskAccessInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<DiskAccessInner>>, Page<DiskAccessInner>>() {
                @Override
                public Page<DiskAccessInner> call(ServiceResponse<Page<DiskAccessInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disk access resources under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskAccessInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskAccessInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<DiskAccessInner>>, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(ServiceResponse<Page<DiskAccessInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disk access resources under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskAccessInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskAccessInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskAccessInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskAccessInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskAccessInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskAccessInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskAccessInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the private link resources possible under disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateLinkResourceListResultInner object if successful.
     */
    public PrivateLinkResourceListResultInner getPrivateLinkResources(String resourceGroupName, String diskAccessName) {
        return getPrivateLinkResourcesWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().single().body();
    }

    /**
     * Gets the private link resources possible under disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateLinkResourceListResultInner> getPrivateLinkResourcesAsync(String resourceGroupName, String diskAccessName, final ServiceCallback<PrivateLinkResourceListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(getPrivateLinkResourcesWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    /**
     * Gets the private link resources possible under disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkResourceListResultInner object
     */
    public Observable<PrivateLinkResourceListResultInner> getPrivateLinkResourcesAsync(String resourceGroupName, String diskAccessName) {
        return getPrivateLinkResourcesWithServiceResponseAsync(resourceGroupName, diskAccessName).map(new Func1<ServiceResponse<PrivateLinkResourceListResultInner>, PrivateLinkResourceListResultInner>() {
            @Override
            public PrivateLinkResourceListResultInner call(ServiceResponse<PrivateLinkResourceListResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the private link resources possible under disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkResourceListResultInner object
     */
    public Observable<ServiceResponse<PrivateLinkResourceListResultInner>> getPrivateLinkResourcesWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.getPrivateLinkResources(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkResourceListResultInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateLinkResourceListResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateLinkResourceListResultInner> clientResponse = getPrivateLinkResourcesDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateLinkResourceListResultInner> getPrivateLinkResourcesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateLinkResourceListResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateLinkResourceListResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner updateAPrivateEndpointConnection(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return updateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection).toBlocking().last().body();
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private endpoint connection operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> updateAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection), serviceCallback);
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<PrivateEndpointConnectionInner> updateAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return updateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection).map(new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> updateAPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (privateEndpointConnection == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnection is required and cannot be null.");
        }
        Validator.validate(privateEndpointConnection);
        final String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = service.updateAPrivateEndpointConnection(this.client.subscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName, apiVersion, privateEndpointConnection, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PrivateEndpointConnectionInner>() { }.getType());
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner beginUpdateAPrivateEndpointConnection(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return beginUpdateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection).toBlocking().single().body();
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private endpoint connection operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> beginUpdateAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection), serviceCallback);
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<PrivateEndpointConnectionInner> beginUpdateAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return beginUpdateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection).map(new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> beginUpdateAPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (privateEndpointConnection == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnection is required and cannot be null.");
        }
        Validator.validate(privateEndpointConnection);
        final String apiVersion = "2020-09-30";
        return service.beginUpdateAPrivateEndpointConnection(this.client.subscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName, apiVersion, privateEndpointConnection, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateEndpointConnectionInner> clientResponse = beginUpdateAPrivateEndpointConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> beginUpdateAPrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateEndpointConnectionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateEndpointConnectionInner>() { }.getType())
                .register(202, new TypeToken<PrivateEndpointConnectionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner getAPrivateEndpointConnection(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        return getAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).toBlocking().single().body();
    }

    /**
     * Gets information about a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> getAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName), serviceCallback);
    }

    /**
     * Gets information about a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<PrivateEndpointConnectionInner> getAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        return getAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).map(new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> getAPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.getAPrivateEndpointConnection(this.client.subscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateEndpointConnectionInner> clientResponse = getAPrivateEndpointConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> getAPrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateEndpointConnectionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateEndpointConnectionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAPrivateEndpointConnection(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        deleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).toBlocking().last().body();
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName), serviceCallback);
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        return deleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteAPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = service.deleteAPrivateEndpointConnection(this.client.subscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteAPrivateEndpointConnection(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        beginDeleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).toBlocking().single().body();
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName), serviceCallback);
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        return beginDeleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteAPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.beginDeleteAPrivateEndpointConnection(this.client.subscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteAPrivateEndpointConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteAPrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object if successful.
     */
    public PagedList<PrivateEndpointConnectionInner> listPrivateEndpointConnections(final String resourceGroupName, final String diskAccessName) {
        ServiceResponse<Page<PrivateEndpointConnectionInner>> response = listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, diskAccessName).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>(response.body()) {
            @Override
            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsAsync(final String resourceGroupName, final String diskAccessName, final ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, diskAccessName),
            new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                    return listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<Page<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsAsync(final String resourceGroupName, final String diskAccessName) {
        return listPrivateEndpointConnectionsWithServiceResponseAsync(resourceGroupName, diskAccessName)
            .map(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>() {
                @Override
                public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsWithServiceResponseAsync(final String resourceGroupName, final String diskAccessName) {
        return listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, diskAccessName)
            .concatMap(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     *
    ServiceResponse<PageImpl1<PrivateEndpointConnectionInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl1<PrivateEndpointConnectionInner>> * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsSinglePageAsync(final String resourceGroupName, final String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.listPrivateEndpointConnections(this.client.subscriptionId(), resourceGroupName, diskAccessName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<PrivateEndpointConnectionInner>> result = listPrivateEndpointConnectionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateEndpointConnectionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<PrivateEndpointConnectionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<PrivateEndpointConnectionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disk access resources under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskAccessInner&gt; object if successful.
     */
    public PagedList<DiskAccessInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<DiskAccessInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskAccessInner>(response.body()) {
            @Override
            public Page<DiskAccessInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disk access resources under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskAccessInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<DiskAccessInner>> serviceFuture, final ListOperationCallback<DiskAccessInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disk access resources under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskAccessInner&gt; object
     */
    public Observable<Page<DiskAccessInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DiskAccessInner>>, Page<DiskAccessInner>>() {
                @Override
                public Page<DiskAccessInner> call(ServiceResponse<Page<DiskAccessInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disk access resources under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskAccessInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskAccessInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DiskAccessInner>>, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(ServiceResponse<Page<DiskAccessInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disk access resources under a resource group.
     *
    ServiceResponse<PageImpl1<DiskAccessInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskAccessInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskAccessInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskAccessInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskAccessInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskAccessInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskAccessInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskAccessInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disk access resources under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskAccessInner&gt; object if successful.
     */
    public PagedList<DiskAccessInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<DiskAccessInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskAccessInner>(response.body()) {
            @Override
            public Page<DiskAccessInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disk access resources under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskAccessInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<DiskAccessInner>> serviceFuture, final ListOperationCallback<DiskAccessInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disk access resources under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskAccessInner&gt; object
     */
    public Observable<Page<DiskAccessInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DiskAccessInner>>, Page<DiskAccessInner>>() {
                @Override
                public Page<DiskAccessInner> call(ServiceResponse<Page<DiskAccessInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disk access resources under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskAccessInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskAccessInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DiskAccessInner>>, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(ServiceResponse<Page<DiskAccessInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disk access resources under a subscription.
     *
    ServiceResponse<PageImpl1<DiskAccessInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskAccessInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskAccessInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskAccessInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskAccessInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskAccessInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskAccessInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskAccessInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskAccessInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskAccessInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object if successful.
     */
    public PagedList<PrivateEndpointConnectionInner> listPrivateEndpointConnectionsNext(final String nextPageLink) {
        ServiceResponse<Page<PrivateEndpointConnectionInner>> response = listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>(response.body()) {
            @Override
            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextAsync(final String nextPageLink, final ServiceFuture<List<PrivateEndpointConnectionInner>> serviceFuture, final ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                    return listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<Page<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextAsync(final String nextPageLink) {
        return listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>() {
                @Override
                public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsNextWithServiceResponseAsync(final String nextPageLink) {
        return listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     *
    ServiceResponse<PageImpl1<PrivateEndpointConnectionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listPrivateEndpointConnectionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<PrivateEndpointConnectionInner>> result = listPrivateEndpointConnectionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateEndpointConnectionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<PrivateEndpointConnectionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<PrivateEndpointConnectionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
