/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import org.joda.time.DateTime;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.HyperVGeneration;
import com.microsoft.azure.management.compute.PurchasePlan;
import com.microsoft.azure.management.compute.Encryption;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.compute.ProxyOnlyResource;

/**
 * Properties of disk restore point.
 */
@JsonFlatten
public class DiskRestorePointInner extends ProxyOnlyResource {
    /**
     * The timestamp of restorePoint creation.
     */
    @JsonProperty(value = "properties.timeCreated", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime timeCreated;

    /**
     * arm id of source disk.
     */
    @JsonProperty(value = "properties.sourceResourceId", access = JsonProperty.Access.WRITE_ONLY)
    private String sourceResourceId;

    /**
     * The Operating System type. Possible values include: 'Windows', 'Linux'.
     */
    @JsonProperty(value = "properties.osType", access = JsonProperty.Access.WRITE_ONLY)
    private OperatingSystemTypes osType;

    /**
     * The hypervisor generation of the Virtual Machine. Applicable to OS disks
     * only. Possible values include: 'V1', 'V2'.
     */
    @JsonProperty(value = "properties.hyperVGeneration")
    private HyperVGeneration hyperVGeneration;

    /**
     * Purchase plan information for the the image from which the OS disk was
     * created.
     */
    @JsonProperty(value = "properties.purchasePlan")
    private PurchasePlan purchasePlan;

    /**
     * id of the backing snapshot's MIS family.
     */
    @JsonProperty(value = "properties.familyId", access = JsonProperty.Access.WRITE_ONLY)
    private String familyId;

    /**
     * unique incarnation id of the source disk.
     */
    @JsonProperty(value = "properties.sourceUniqueId", access = JsonProperty.Access.WRITE_ONLY)
    private String sourceUniqueId;

    /**
     * Encryption property can be used to encrypt data at rest with customer
     * managed keys or platform managed keys.
     */
    @JsonProperty(value = "properties.encryption", access = JsonProperty.Access.WRITE_ONLY)
    private Encryption encryption;

    /**
     * Get the timestamp of restorePoint creation.
     *
     * @return the timeCreated value
     */
    public DateTime timeCreated() {
        return this.timeCreated;
    }

    /**
     * Get arm id of source disk.
     *
     * @return the sourceResourceId value
     */
    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    /**
     * Get the Operating System type. Possible values include: 'Windows', 'Linux'.
     *
     * @return the osType value
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Get the hypervisor generation of the Virtual Machine. Applicable to OS disks only. Possible values include: 'V1', 'V2'.
     *
     * @return the hyperVGeneration value
     */
    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    /**
     * Set the hypervisor generation of the Virtual Machine. Applicable to OS disks only. Possible values include: 'V1', 'V2'.
     *
     * @param hyperVGeneration the hyperVGeneration value to set
     * @return the DiskRestorePointInner object itself.
     */
    public DiskRestorePointInner withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    /**
     * Get purchase plan information for the the image from which the OS disk was created.
     *
     * @return the purchasePlan value
     */
    public PurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    /**
     * Set purchase plan information for the the image from which the OS disk was created.
     *
     * @param purchasePlan the purchasePlan value to set
     * @return the DiskRestorePointInner object itself.
     */
    public DiskRestorePointInner withPurchasePlan(PurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    /**
     * Get id of the backing snapshot's MIS family.
     *
     * @return the familyId value
     */
    public String familyId() {
        return this.familyId;
    }

    /**
     * Get unique incarnation id of the source disk.
     *
     * @return the sourceUniqueId value
     */
    public String sourceUniqueId() {
        return this.sourceUniqueId;
    }

    /**
     * Get encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     *
     * @return the encryption value
     */
    public Encryption encryption() {
        return this.encryption;
    }

}
