/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.compute.CreationSource;
import com.microsoft.azure.management.compute.Disk;
import com.microsoft.azure.management.compute.DiskCreateOption;
import com.microsoft.azure.management.compute.DiskSkuTypes;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.SnapshotSkuType;
import com.microsoft.azure.management.compute.VirtualMachineCustomImage;
import com.microsoft.azure.management.compute.VirtualMachineImage;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.SnapshotInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;

@Fluent
public interface Snapshot
extends GroupableResource<ComputeManager, SnapshotInner>,
Refreshable<Snapshot>,
Updatable<Update> {
    @Deprecated
    public DiskSkuTypes sku();

    public SnapshotSkuType skuType();

    public boolean incremental();

    public DiskCreateOption creationMethod();

    public int sizeInGB();

    public OperatingSystemTypes osType();

    public CreationSource source();

    public String grantAccess(int var1);

    public Observable<String> grantAccessAsync(int var1);

    public ServiceFuture<String> grantAccessAsync(int var1, ServiceCallback<String> var2);

    public void revokeAccess();

    public Completable revokeAccessAsync();

    public ServiceFuture<Void> revokeAccessAsync(ServiceCallback<Void> var1);

    public static interface Update
    extends Appliable<Snapshot>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithOSSettings {
    }

    public static interface UpdateStages {

        public static interface WithOSSettings {
            public Update withOSType(OperatingSystemTypes var1);
        }

        public static interface WithSku {
            @Deprecated
            public Update withSku(DiskSkuTypes var1);

            public Update withSku(SnapshotSkuType var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Snapshot>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSize,
        WithSku,
        WithIncremental {
        }

        public static interface WithSku {
            @Deprecated
            public WithCreate withSku(DiskSkuTypes var1);

            public WithCreate withSku(SnapshotSkuType var1);
        }

        public static interface WithIncremental {
            public WithCreate withIncremental(boolean var1);
        }

        public static interface WithSize {
            public WithCreate withSizeInGB(int var1);
        }

        public static interface WithDataSnapshotFromImage {
            public WithCreate fromImage(String var1, int var2);

            public WithCreate fromImage(VirtualMachineImage var1, int var2);

            public WithCreate fromImage(VirtualMachineCustomImage var1, int var2);
        }

        public static interface WithOSSnapshotFromImage {
            public WithCreate fromImage(String var1, OperatingSystemTypes var2);

            public WithCreate fromImage(VirtualMachineImage var1);

            public WithCreate fromImage(VirtualMachineCustomImage var1);
        }

        public static interface WithDataSnapshotFromSnapshot {
            public WithCreate withDataFromSnapshot(String var1);

            public WithCreate withDataFromSnapshot(Snapshot var1);
        }

        public static interface WithDataSnapshotFromDisk {
            public WithCreate withDataFromDisk(String var1);

            public WithCreate withDataFromDisk(Disk var1);
        }

        public static interface WithDataSnapshotFromVhd {
            public WithCreate withDataFromVhd(String var1);

            public WithCreate withDataFromVhd(String var1, String var2);
        }

        public static interface WithDataSnapshotSource
        extends WithDataSnapshotFromVhd,
        WithDataSnapshotFromDisk,
        WithDataSnapshotFromSnapshot {
        }

        public static interface WithLinuxSnapshotSource {
            public WithCreate withLinuxFromDisk(String var1);

            public WithCreate withLinuxFromDisk(Disk var1);

            public WithCreate withLinuxFromSnapshot(String var1);

            public WithCreate withLinuxFromSnapshot(Snapshot var1);

            public WithCreate withLinuxFromVhd(String var1);

            public WithCreate withLinuxFromVhd(String var1, String var2);
        }

        public static interface WithWindowsSnapshotSource {
            public WithCreate withWindowsFromDisk(String var1);

            public WithCreate withWindowsFromDisk(Disk var1);

            public WithCreate withWindowsFromSnapshot(String var1);

            public WithCreate withWindowsFromSnapshot(Snapshot var1);

            public WithCreate withWindowsFromVhd(String var1);

            public WithCreate withWindowsFromVhd(String var1, String var2);
        }

        public static interface WithSnapshotSource
        extends WithWindowsSnapshotSource,
        WithLinuxSnapshotSource,
        WithDataSnapshotSource {
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSnapshotSource> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSnapshotSource,
    DefinitionStages.WithWindowsSnapshotSource,
    DefinitionStages.WithLinuxSnapshotSource,
    DefinitionStages.WithDataSnapshotSource,
    DefinitionStages.WithDataSnapshotFromVhd,
    DefinitionStages.WithDataSnapshotFromDisk,
    DefinitionStages.WithDataSnapshotFromSnapshot,
    DefinitionStages.WithCreate {
    }
}

