/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.DiskAccessUpdate;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.DiskAccessInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.compute.implementation.PrivateEndpointConnectionInner;
import com.microsoft.azure.management.compute.implementation.PrivateLinkResourceListResultInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DiskAccessesInner
implements InnerSupportsGet<DiskAccessInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<DiskAccessInner> {
    private DiskAccessesService service;
    private ComputeManagementClientImpl client;

    public DiskAccessesInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (DiskAccessesService)retrofit.create(DiskAccessesService.class);
        this.client = client;
    }

    public DiskAccessInner createOrUpdate(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        return (DiskAccessInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess).toBlocking().last()).body());
    }

    public ServiceFuture<DiskAccessInner> createOrUpdateAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess, ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess), serviceCallback);
    }

    public Observable<DiskAccessInner> createOrUpdateAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess).map((Func1)new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>(){

            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return (DiskAccessInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskAccessInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (diskAccess == null) {
            throw new IllegalArgumentException("Parameter diskAccess is required and cannot be null.");
        }
        Validator.validate((Object)((Object)diskAccess));
        String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", diskAccess, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskAccessInner>(){}.getType());
    }

    public DiskAccessInner beginCreateOrUpdate(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        return (DiskAccessInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess).toBlocking().single()).body());
    }

    public ServiceFuture<DiskAccessInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess, ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess), serviceCallback);
    }

    public Observable<DiskAccessInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, diskAccess).map((Func1)new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>(){

            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return (DiskAccessInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskAccessInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (diskAccess == null) {
            throw new IllegalArgumentException("Parameter diskAccess is required and cannot be null.");
        }
        Validator.validate((Object)((Object)diskAccess));
        String apiVersion = "2020-09-30";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", diskAccess, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskAccessInner>>>(){

            public Observable<ServiceResponse<DiskAccessInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskAccessesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiskAccessInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiskAccessInner>(){}.getType()).register(202, new TypeToken<DiskAccessInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiskAccessInner update(String resourceGroupName, String diskAccessName) {
        return (DiskAccessInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().last()).body());
    }

    public ServiceFuture<DiskAccessInner> updateAsync(String resourceGroupName, String diskAccessName, ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    public Observable<DiskAccessInner> updateAsync(String resourceGroupName, String diskAccessName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, diskAccessName).map((Func1)new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>(){

            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return (DiskAccessInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskAccessInner>> updateWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        Object tags = null;
        DiskAccessUpdate diskAccess = new DiskAccessUpdate();
        diskAccess.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", this.client.acceptLanguage(), diskAccess, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskAccessInner>(){}.getType());
    }

    public DiskAccessInner update(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        return (DiskAccessInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<DiskAccessInner> updateAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags, ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags), serviceCallback);
    }

    public Observable<DiskAccessInner> updateAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        return this.updateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags).map((Func1)new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>(){

            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return (DiskAccessInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskAccessInner>> updateWithServiceResponseAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2020-09-30";
        DiskAccessUpdate diskAccess = new DiskAccessUpdate();
        diskAccess.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", this.client.acceptLanguage(), diskAccess, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskAccessInner>(){}.getType());
    }

    public DiskAccessInner beginUpdate(String resourceGroupName, String diskAccessName) {
        return (DiskAccessInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().single()).body());
    }

    public ServiceFuture<DiskAccessInner> beginUpdateAsync(String resourceGroupName, String diskAccessName, ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    public Observable<DiskAccessInner> beginUpdateAsync(String resourceGroupName, String diskAccessName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName).map((Func1)new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>(){

            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return (DiskAccessInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskAccessInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        Object tags = null;
        DiskAccessUpdate diskAccess = new DiskAccessUpdate();
        diskAccess.withTags(null);
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", this.client.acceptLanguage(), diskAccess, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskAccessInner>>>(){

            public Observable<ServiceResponse<DiskAccessInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskAccessesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DiskAccessInner beginUpdate(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        return (DiskAccessInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<DiskAccessInner> beginUpdateAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags, ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags), serviceCallback);
    }

    public Observable<DiskAccessInner> beginUpdateAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, diskAccessName, tags).map((Func1)new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>(){

            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return (DiskAccessInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskAccessInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String diskAccessName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2020-09-30";
        DiskAccessUpdate diskAccess = new DiskAccessUpdate();
        diskAccess.withTags(tags);
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", this.client.acceptLanguage(), diskAccess, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskAccessInner>>>(){

            public Observable<ServiceResponse<DiskAccessInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskAccessesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiskAccessInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiskAccessInner>(){}.getType()).register(202, new TypeToken<DiskAccessInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiskAccessInner getByResourceGroup(String resourceGroupName, String diskAccessName) {
        return (DiskAccessInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().single()).body());
    }

    public ServiceFuture<DiskAccessInner> getByResourceGroupAsync(String resourceGroupName, String diskAccessName, ServiceCallback<DiskAccessInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    public Observable<DiskAccessInner> getByResourceGroupAsync(String resourceGroupName, String diskAccessName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskAccessName).map((Func1)new Func1<ServiceResponse<DiskAccessInner>, DiskAccessInner>(){

            public DiskAccessInner call(ServiceResponse<DiskAccessInner> response) {
                return (DiskAccessInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DiskAccessInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskAccessInner>>>(){

            public Observable<ServiceResponse<DiskAccessInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskAccessesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiskAccessInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiskAccessInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String diskAccessName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String diskAccessName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String diskAccessName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, diskAccessName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String diskAccessName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String diskAccessName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String diskAccessName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, diskAccessName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskAccessesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskAccessInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DiskAccessInner>((Page)response.body()){

            public Page<DiskAccessInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskAccessesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskAccessInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<DiskAccessInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(String nextPageLink) {
                return DiskAccessesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskAccessInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<DiskAccessInner>>, Page<DiskAccessInner>>(){

            public Page<DiskAccessInner> call(ServiceResponse<Page<DiskAccessInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskAccessInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<DiskAccessInner>>, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(ServiceResponse<Page<DiskAccessInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskAccessesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskAccessInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskAccessesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskAccessInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskAccessInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskAccessInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<DiskAccessInner>((Page)response.body()){

            public Page<DiskAccessInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskAccessesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskAccessInner>> listAsync(ListOperationCallback<DiskAccessInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(String nextPageLink) {
                return DiskAccessesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskAccessInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<DiskAccessInner>>, Page<DiskAccessInner>>(){

            public Page<DiskAccessInner> call(ServiceResponse<Page<DiskAccessInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskAccessInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<DiskAccessInner>>, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(ServiceResponse<Page<DiskAccessInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskAccessesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskAccessInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.list(this.client.subscriptionId(), "2020-09-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskAccessesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskAccessInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskAccessInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PrivateLinkResourceListResultInner getPrivateLinkResources(String resourceGroupName, String diskAccessName) {
        return (PrivateLinkResourceListResultInner)((ServiceResponse)this.getPrivateLinkResourcesWithServiceResponseAsync(resourceGroupName, diskAccessName).toBlocking().single()).body();
    }

    public ServiceFuture<PrivateLinkResourceListResultInner> getPrivateLinkResourcesAsync(String resourceGroupName, String diskAccessName, ServiceCallback<PrivateLinkResourceListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getPrivateLinkResourcesWithServiceResponseAsync(resourceGroupName, diskAccessName), serviceCallback);
    }

    public Observable<PrivateLinkResourceListResultInner> getPrivateLinkResourcesAsync(String resourceGroupName, String diskAccessName) {
        return this.getPrivateLinkResourcesWithServiceResponseAsync(resourceGroupName, diskAccessName).map((Func1)new Func1<ServiceResponse<PrivateLinkResourceListResultInner>, PrivateLinkResourceListResultInner>(){

            public PrivateLinkResourceListResultInner call(ServiceResponse<PrivateLinkResourceListResultInner> response) {
                return (PrivateLinkResourceListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkResourceListResultInner>> getPrivateLinkResourcesWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.getPrivateLinkResources(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkResourceListResultInner>>>(){

            public Observable<ServiceResponse<PrivateLinkResourceListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskAccessesInner.this.getPrivateLinkResourcesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateLinkResourceListResultInner> getPrivateLinkResourcesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateLinkResourceListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PrivateEndpointConnectionInner updateAPrivateEndpointConnection(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponse)this.updateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection).toBlocking().last()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> updateAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> updateAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return this.updateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection).map((Func1)new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> updateAPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (privateEndpointConnection == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnection is required and cannot be null.");
        }
        Validator.validate((Object)((Object)privateEndpointConnection));
        String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = this.service.updateAPrivateEndpointConnection(this.client.subscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName, "2020-09-30", privateEndpointConnection, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PrivateEndpointConnectionInner>(){}.getType());
    }

    public PrivateEndpointConnectionInner beginUpdateAPrivateEndpointConnection(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponse)this.beginUpdateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> beginUpdateAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> beginUpdateAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return this.beginUpdateAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, privateEndpointConnection).map((Func1)new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> beginUpdateAPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (privateEndpointConnection == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnection is required and cannot be null.");
        }
        Validator.validate((Object)((Object)privateEndpointConnection));
        String apiVersion = "2020-09-30";
        return this.service.beginUpdateAPrivateEndpointConnection(this.client.subscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName, "2020-09-30", privateEndpointConnection, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskAccessesInner.this.beginUpdateAPrivateEndpointConnectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> beginUpdateAPrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointConnectionInner>(){}.getType()).register(202, new TypeToken<PrivateEndpointConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PrivateEndpointConnectionInner getAPrivateEndpointConnection(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponse)this.getAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> getAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> getAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        return this.getAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).map((Func1)new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> getAPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.getAPrivateEndpointConnection(this.client.subscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskAccessesInner.this.getAPrivateEndpointConnectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> getAPrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteAPrivateEndpointConnection(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        ((ServiceResponse)this.deleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName), serviceCallback);
    }

    public Observable<Void> deleteAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        return this.deleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = this.service.deleteAPrivateEndpointConnection(this.client.subscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteAPrivateEndpointConnection(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        ((ServiceResponse)this.beginDeleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName), serviceCallback);
    }

    public Observable<Void> beginDeleteAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        return this.beginDeleteAPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteAPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.beginDeleteAPrivateEndpointConnection(this.client.subscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiskAccessesInner.this.beginDeleteAPrivateEndpointConnectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteAPrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PrivateEndpointConnectionInner> listPrivateEndpointConnections(String resourceGroupName, String diskAccessName) {
        ServiceResponse response = (ServiceResponse)this.listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, diskAccessName).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>((Page)response.body()){

            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskAccessesInner.this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsAsync(String resourceGroupName, String diskAccessName, ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, diskAccessName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                return DiskAccessesInner.this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsAsync(String resourceGroupName, String diskAccessName) {
        return this.listPrivateEndpointConnectionsWithServiceResponseAsync(resourceGroupName, diskAccessName).map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>(){

            public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsWithServiceResponseAsync(String resourceGroupName, String diskAccessName) {
        return this.listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, diskAccessName).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskAccessesInner.this.listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsSinglePageAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskAccessName == null) {
            throw new IllegalArgumentException("Parameter diskAccessName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.listPrivateEndpointConnections(this.client.subscriptionId(), resourceGroupName, diskAccessName, "2020-09-30", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskAccessesInner.this.listPrivateEndpointConnectionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<PrivateEndpointConnectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskAccessInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskAccessInner>((Page)response.body()){

            public Page<DiskAccessInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskAccessesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskAccessInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<DiskAccessInner>> serviceFuture, ListOperationCallback<DiskAccessInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(String nextPageLink) {
                return DiskAccessesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskAccessInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DiskAccessInner>>, Page<DiskAccessInner>>(){

            public Page<DiskAccessInner> call(ServiceResponse<Page<DiskAccessInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskAccessInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DiskAccessInner>>, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(ServiceResponse<Page<DiskAccessInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskAccessesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskAccessInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskAccessesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskAccessInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskAccessInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiskAccessInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskAccessInner>((Page)response.body()){

            public Page<DiskAccessInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskAccessesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiskAccessInner>> listNextAsync(String nextPageLink, ServiceFuture<List<DiskAccessInner>> serviceFuture, ListOperationCallback<DiskAccessInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(String nextPageLink) {
                return DiskAccessesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiskAccessInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DiskAccessInner>>, Page<DiskAccessInner>>(){

            public Page<DiskAccessInner> call(ServiceResponse<Page<DiskAccessInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskAccessInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DiskAccessInner>>, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(ServiceResponse<Page<DiskAccessInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskAccessesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiskAccessInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskAccessInner>>>>(){

            public Observable<ServiceResponse<Page<DiskAccessInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskAccessesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DiskAccessInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DiskAccessInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PrivateEndpointConnectionInner> listPrivateEndpointConnectionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>((Page)response.body()){

            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiskAccessesInner.this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextAsync(String nextPageLink, ServiceFuture<List<PrivateEndpointConnectionInner>> serviceFuture, ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                return DiskAccessesInner.this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextAsync(String nextPageLink) {
        return this.listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>(){

            public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiskAccessesInner.this.listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listPrivateEndpointConnectionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiskAccessesInner.this.listPrivateEndpointConnectionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<PrivateEndpointConnectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DiskAccessesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Query(value="api-version") String var4, @Body DiskAccessInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Query(value="api-version") String var4, @Body DiskAccessInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DiskAccessUpdate var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DiskAccessUpdate var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/diskAccesses")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses getPrivateLinkResources"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateLinkResources")
        public Observable<Response<ResponseBody>> getPrivateLinkResources(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses updateAPrivateEndpointConnection"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}")
        public Observable<Response<ResponseBody>> updateAPrivateEndpointConnection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Body PrivateEndpointConnectionInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses beginUpdateAPrivateEndpointConnection"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}")
        public Observable<Response<ResponseBody>> beginUpdateAPrivateEndpointConnection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Body PrivateEndpointConnectionInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses getAPrivateEndpointConnection"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}")
        public Observable<Response<ResponseBody>> getAPrivateEndpointConnection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses deleteAPrivateEndpointConnection"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAPrivateEndpointConnection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses beginDeleteAPrivateEndpointConnection"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteAPrivateEndpointConnection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses listPrivateEndpointConnections"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections")
        public Observable<Response<ResponseBody>> listPrivateEndpointConnections(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="diskAccessName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskAccesses listPrivateEndpointConnectionsNext"})
        @GET
        public Observable<Response<ResponseBody>> listPrivateEndpointConnectionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

