/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.GalleryImage;
import com.microsoft.azure.management.compute.GalleryImages;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.GalleryImageImpl;
import com.microsoft.azure.management.compute.implementation.GalleryImageInner;
import com.microsoft.azure.management.compute.implementation.GalleryImagesInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.WrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class GalleryImagesImpl
extends WrapperImpl<GalleryImagesInner>
implements GalleryImages {
    private final ComputeManager manager;

    GalleryImagesImpl(ComputeManager manager) {
        super((Object)((ComputeManagementClientImpl)((Object)manager.inner())).galleryImages());
        this.manager = manager;
    }

    public ComputeManager manager() {
        return this.manager;
    }

    public GalleryImageImpl define(String name) {
        return this.wrapModel(name);
    }

    private GalleryImageImpl wrapModel(GalleryImageInner inner) {
        if (inner == null) {
            return null;
        }
        return new GalleryImageImpl(inner, this.manager());
    }

    private GalleryImageImpl wrapModel(String name) {
        return new GalleryImageImpl(name, this.manager());
    }

    @Override
    public Observable<GalleryImage> listByGalleryAsync(String resourceGroupName, String galleryName) {
        GalleryImagesInner client = (GalleryImagesInner)this.inner();
        return client.listByGalleryAsync(resourceGroupName, galleryName).flatMapIterable((Func1)new Func1<Page<GalleryImageInner>, Iterable<GalleryImageInner>>(){

            public Iterable<GalleryImageInner> call(Page<GalleryImageInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<GalleryImageInner, GalleryImage>(){

            public GalleryImage call(GalleryImageInner inner) {
                return GalleryImagesImpl.this.wrapModel(inner);
            }
        });
    }

    @Override
    public PagedList<GalleryImage> listByGallery(String resourceGroupName, String galleryName) {
        return new PagedListConverter<GalleryImageInner, GalleryImage>(){

            public Observable<GalleryImage> typeConvertAsync(GalleryImageInner inner) {
                return Observable.just((Object)GalleryImagesImpl.this.wrapModel(inner));
            }
        }.convert(((GalleryImagesInner)this.inner()).listByGallery(resourceGroupName, galleryName));
    }

    @Override
    public Observable<GalleryImage> getByGalleryAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        GalleryImagesInner client = (GalleryImagesInner)this.inner();
        return client.getAsync(resourceGroupName, galleryName, galleryImageName).map((Func1)new Func1<GalleryImageInner, GalleryImage>(){

            public GalleryImage call(GalleryImageInner inner) {
                return GalleryImagesImpl.this.wrapModel(inner);
            }
        });
    }

    @Override
    public GalleryImage getByGallery(String resourceGroupName, String galleryName, String galleryImageName) {
        return (GalleryImage)this.getByGalleryAsync(resourceGroupName, galleryName, galleryImageName).toBlocking().last();
    }

    @Override
    public Completable deleteByGalleryAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        GalleryImagesInner client = (GalleryImagesInner)this.inner();
        return client.deleteAsync(resourceGroupName, galleryName, galleryImageName).toCompletable();
    }

    @Override
    public void deleteByGallery(String resourceGroupName, String galleryName, String galleryImageName) {
        this.deleteByGalleryAsync(resourceGroupName, galleryName, galleryImageName).await();
    }
}

