/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.VirtualMachineRunCommandUpdate;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.compute.implementation.VirtualMachineRunCommandInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualMachineScaleSetVMRunCommandsInner {
    private VirtualMachineScaleSetVMRunCommandsService service;
    private ComputeManagementClientImpl client;

    public VirtualMachineScaleSetVMRunCommandsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (VirtualMachineScaleSetVMRunCommandsService)retrofit.create(VirtualMachineScaleSetVMRunCommandsService.class);
        this.client = client;
    }

    public VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate((Object)((Object)runCommand));
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), runCommand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineRunCommandInner>(){}.getType());
    }

    public VirtualMachineRunCommandInner beginCreateOrUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate((Object)((Object)runCommand));
        String apiVersion = "2020-12-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), runCommand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>(){

            public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMRunCommandsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineRunCommandInner>(){}.getType()).register(201, new TypeToken<VirtualMachineRunCommandInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualMachineRunCommandInner update(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return this.updateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> updateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate((Object)runCommand);
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), runCommand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineRunCommandInner>(){}.getType());
    }

    public VirtualMachineRunCommandInner beginUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate((Object)runCommand);
        String apiVersion = "2020-12-01";
        return this.service.beginUpdate(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), runCommand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>(){

            public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMRunCommandsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineRunCommandInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.beginDelete(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMRunCommandsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualMachineRunCommandInner get(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        return this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> getWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        String expand = null;
        return this.service.get(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>(){

            public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMRunCommandsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualMachineRunCommandInner get(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, String expand) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, String expand, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, expand), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, String expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, expand).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> getWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.get(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>(){

            public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMRunCommandsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineRunCommandInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualMachineRunCommandInner> list(String resourceGroupName, String vmScaleSetName, String instanceId) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>((Page)response.body()){

            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachineScaleSetVMRunCommandsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualMachineRunCommandInner>> listAsync(String resourceGroupName, String vmScaleSetName, String instanceId, ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                return VirtualMachineScaleSetVMRunCommandsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualMachineRunCommandInner>> listAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.listWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId).map((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>(){

            public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachineScaleSetVMRunCommandsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listSinglePageAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        String expand = null;
        return this.service.list(resourceGroupName, vmScaleSetName, instanceId, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachineScaleSetVMRunCommandsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<VirtualMachineRunCommandInner> list(String resourceGroupName, String vmScaleSetName, String instanceId, String expand) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId, expand).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>((Page)response.body()){

            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachineScaleSetVMRunCommandsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualMachineRunCommandInner>> listAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String expand, ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId, expand), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                return VirtualMachineScaleSetVMRunCommandsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualMachineRunCommandInner>> listAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String expand) {
        return this.listWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand).map((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>(){

            public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String expand) {
        return this.listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId, expand).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachineScaleSetVMRunCommandsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listSinglePageAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.list(resourceGroupName, vmScaleSetName, instanceId, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachineScaleSetVMRunCommandsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualMachineRunCommandInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualMachineRunCommandInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>((Page)response.body()){

            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachineScaleSetVMRunCommandsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualMachineRunCommandInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VirtualMachineRunCommandInner>> serviceFuture, ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                return VirtualMachineScaleSetVMRunCommandsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualMachineRunCommandInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>(){

            public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachineScaleSetVMRunCommandsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachineScaleSetVMRunCommandsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualMachineRunCommandInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualMachineScaleSetVMRunCommandsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="runCommandName") String var4, @Path(value="subscriptionId") String var5, @Body VirtualMachineRunCommandInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="runCommandName") String var4, @Path(value="subscriptionId") String var5, @Body VirtualMachineRunCommandInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="runCommandName") String var4, @Path(value="subscriptionId") String var5, @Body VirtualMachineRunCommandUpdate var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="runCommandName") String var4, @Path(value="subscriptionId") String var5, @Body VirtualMachineRunCommandUpdate var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="runCommandName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="runCommandName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="runCommandName") String var4, @Path(value="subscriptionId") String var5, @Query(value="$expand") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="subscriptionId") String var4, @Query(value="$expand") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

