/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The status of virtual machine patch operations.
 */
public class VirtualMachinePatchStatus {
    /**
     * The available patch summary of the latest assessment operation for the
     * virtual machine.
     */
    @JsonProperty(value = "availablePatchSummary")
    private AvailablePatchSummary availablePatchSummary;

    /**
     * The installation summary of the latest installation operation for the
     * virtual machine.
     */
    @JsonProperty(value = "lastPatchInstallationSummary")
    private LastPatchInstallationSummary lastPatchInstallationSummary;

    /**
     * The enablement status of the specified patchMode.
     */
    @JsonProperty(value = "configurationStatuses", access = JsonProperty.Access.WRITE_ONLY)
    private List<InstanceViewStatus> configurationStatuses;

    /**
     * Get the available patch summary of the latest assessment operation for the virtual machine.
     *
     * @return the availablePatchSummary value
     */
    public AvailablePatchSummary availablePatchSummary() {
        return this.availablePatchSummary;
    }

    /**
     * Set the available patch summary of the latest assessment operation for the virtual machine.
     *
     * @param availablePatchSummary the availablePatchSummary value to set
     * @return the VirtualMachinePatchStatus object itself.
     */
    public VirtualMachinePatchStatus withAvailablePatchSummary(AvailablePatchSummary availablePatchSummary) {
        this.availablePatchSummary = availablePatchSummary;
        return this;
    }

    /**
     * Get the installation summary of the latest installation operation for the virtual machine.
     *
     * @return the lastPatchInstallationSummary value
     */
    public LastPatchInstallationSummary lastPatchInstallationSummary() {
        return this.lastPatchInstallationSummary;
    }

    /**
     * Set the installation summary of the latest installation operation for the virtual machine.
     *
     * @param lastPatchInstallationSummary the lastPatchInstallationSummary value to set
     * @return the VirtualMachinePatchStatus object itself.
     */
    public VirtualMachinePatchStatus withLastPatchInstallationSummary(LastPatchInstallationSummary lastPatchInstallationSummary) {
        this.lastPatchInstallationSummary = lastPatchInstallationSummary;
        return this;
    }

    /**
     * Get the enablement status of the specified patchMode.
     *
     * @return the configurationStatuses value
     */
    public List<InstanceViewStatus> configurationStatuses() {
        return this.configurationStatuses;
    }

}
