/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.DiskEncryptionSetUpdate;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in DiskEncryptionSets.
 */
public class DiskEncryptionSetsInner implements InnerSupportsGet<DiskEncryptionSetInner>, InnerSupportsDelete<Void>, InnerSupportsListing<DiskEncryptionSetInner> {
    /** The Retrofit service to perform REST calls. */
    private DiskEncryptionSetsService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of DiskEncryptionSetsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DiskEncryptionSetsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(DiskEncryptionSetsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for DiskEncryptionSets to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DiskEncryptionSetsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskEncryptionSetName") String diskEncryptionSetName, @Query("api-version") String apiVersion, @Body DiskEncryptionSetInner diskEncryptionSet, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskEncryptionSetName") String diskEncryptionSetName, @Query("api-version") String apiVersion, @Body DiskEncryptionSetInner diskEncryptionSet, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskEncryptionSetName") String diskEncryptionSetName, @Query("api-version") String apiVersion, @Body DiskEncryptionSetUpdate diskEncryptionSet, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskEncryptionSetName") String diskEncryptionSetName, @Query("api-version") String apiVersion, @Body DiskEncryptionSetUpdate diskEncryptionSet, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskEncryptionSetName") String diskEncryptionSetName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskEncryptionSetName") String diskEncryptionSetName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskEncryptionSetName") String diskEncryptionSetName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Compute/diskEncryptionSets")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets listAssociatedResources" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}/associatedResources")
        Observable<Response<ResponseBody>> listAssociatedResources(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskEncryptionSetName") String diskEncryptionSetName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskEncryptionSets listAssociatedResourcesNext" })
        @GET
        Observable<Response<ResponseBody>> listAssociatedResourcesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskEncryptionSetInner object if successful.
     */
    public DiskEncryptionSetInner createOrUpdate(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).toBlocking().last().body();
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskEncryptionSetInner> createOrUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet, final ServiceCallback<DiskEncryptionSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet), serviceCallback);
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DiskEncryptionSetInner> createOrUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).map(new Func1<ServiceResponse<DiskEncryptionSetInner>, DiskEncryptionSetInner>() {
            @Override
            public DiskEncryptionSetInner call(ServiceResponse<DiskEncryptionSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DiskEncryptionSetInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        if (diskEncryptionSet == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null.");
        }
        Validator.validate(diskEncryptionSet);
        final String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, apiVersion, diskEncryptionSet, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskEncryptionSetInner>() { }.getType());
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskEncryptionSetInner object if successful.
     */
    public DiskEncryptionSetInner beginCreateOrUpdate(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).toBlocking().single().body();
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskEncryptionSetInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet, final ServiceCallback<DiskEncryptionSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet), serviceCallback);
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskEncryptionSetInner object
     */
    public Observable<DiskEncryptionSetInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).map(new Func1<ServiceResponse<DiskEncryptionSetInner>, DiskEncryptionSetInner>() {
            @Override
            public DiskEncryptionSetInner call(ServiceResponse<DiskEncryptionSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskEncryptionSetInner object
     */
    public Observable<ServiceResponse<DiskEncryptionSetInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        if (diskEncryptionSet == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null.");
        }
        Validator.validate(diskEncryptionSet);
        final String apiVersion = "2020-09-30";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, apiVersion, diskEncryptionSet, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskEncryptionSetInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskEncryptionSetInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskEncryptionSetInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiskEncryptionSetInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiskEncryptionSetInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiskEncryptionSetInner>() { }.getType())
                .register(202, new TypeToken<DiskEncryptionSetInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskEncryptionSetInner object if successful.
     */
    public DiskEncryptionSetInner update(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return updateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).toBlocking().last().body();
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskEncryptionSetInner> updateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet, final ServiceCallback<DiskEncryptionSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet), serviceCallback);
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DiskEncryptionSetInner> updateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return updateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).map(new Func1<ServiceResponse<DiskEncryptionSetInner>, DiskEncryptionSetInner>() {
            @Override
            public DiskEncryptionSetInner call(ServiceResponse<DiskEncryptionSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DiskEncryptionSetInner>> updateWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        if (diskEncryptionSet == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null.");
        }
        Validator.validate(diskEncryptionSet);
        final String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, apiVersion, diskEncryptionSet, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskEncryptionSetInner>() { }.getType());
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskEncryptionSetInner object if successful.
     */
    public DiskEncryptionSetInner beginUpdate(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).toBlocking().single().body();
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskEncryptionSetInner> beginUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet, final ServiceCallback<DiskEncryptionSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet), serviceCallback);
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskEncryptionSetInner object
     */
    public Observable<DiskEncryptionSetInner> beginUpdateAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).map(new Func1<ServiceResponse<DiskEncryptionSetInner>, DiskEncryptionSetInner>() {
            @Override
            public DiskEncryptionSetInner call(ServiceResponse<DiskEncryptionSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskEncryptionSetInner object
     */
    public Observable<ServiceResponse<DiskEncryptionSetInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        if (diskEncryptionSet == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null.");
        }
        Validator.validate(diskEncryptionSet);
        final String apiVersion = "2020-09-30";
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, apiVersion, diskEncryptionSet, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskEncryptionSetInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskEncryptionSetInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskEncryptionSetInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiskEncryptionSetInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiskEncryptionSetInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiskEncryptionSetInner>() { }.getType())
                .register(202, new TypeToken<DiskEncryptionSetInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskEncryptionSetInner object if successful.
     */
    public DiskEncryptionSetInner getByResourceGroup(String resourceGroupName, String diskEncryptionSetName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).toBlocking().single().body();
    }

    /**
     * Gets information about a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskEncryptionSetInner> getByResourceGroupAsync(String resourceGroupName, String diskEncryptionSetName, final ServiceCallback<DiskEncryptionSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName), serviceCallback);
    }

    /**
     * Gets information about a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskEncryptionSetInner object
     */
    public Observable<DiskEncryptionSetInner> getByResourceGroupAsync(String resourceGroupName, String diskEncryptionSetName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).map(new Func1<ServiceResponse<DiskEncryptionSetInner>, DiskEncryptionSetInner>() {
            @Override
            public DiskEncryptionSetInner call(ServiceResponse<DiskEncryptionSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskEncryptionSetInner object
     */
    public Observable<ServiceResponse<DiskEncryptionSetInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskEncryptionSetInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskEncryptionSetInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskEncryptionSetInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiskEncryptionSetInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiskEncryptionSetInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiskEncryptionSetInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String diskEncryptionSetName) {
        deleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).toBlocking().last().body();
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String diskEncryptionSetName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName), serviceCallback);
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String diskEncryptionSetName) {
        return deleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String diskEncryptionSetName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).toBlocking().single().body();
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String diskEncryptionSetName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName), serviceCallback);
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String diskEncryptionSetName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String diskEncryptionSetName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskEncryptionSetInner&gt; object if successful.
     */
    public PagedList<DiskEncryptionSetInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<DiskEncryptionSetInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DiskEncryptionSetInner>(response.body()) {
            @Override
            public Page<DiskEncryptionSetInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskEncryptionSetInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<DiskEncryptionSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskEncryptionSetInner&gt; object
     */
    public Observable<Page<DiskEncryptionSetInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Page<DiskEncryptionSetInner>>() {
                @Override
                public Page<DiskEncryptionSetInner> call(ServiceResponse<Page<DiskEncryptionSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskEncryptionSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(ServiceResponse<Page<DiskEncryptionSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
    ServiceResponse<PageImpl1<DiskEncryptionSetInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskEncryptionSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskEncryptionSetInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskEncryptionSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskEncryptionSetInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskEncryptionSetInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskEncryptionSetInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskEncryptionSetInner&gt; object if successful.
     */
    public PagedList<DiskEncryptionSetInner> list() {
        ServiceResponse<Page<DiskEncryptionSetInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<DiskEncryptionSetInner>(response.body()) {
            @Override
            public Page<DiskEncryptionSetInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskEncryptionSetInner>> listAsync(final ListOperationCallback<DiskEncryptionSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskEncryptionSetInner&gt; object
     */
    public Observable<Page<DiskEncryptionSetInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Page<DiskEncryptionSetInner>>() {
                @Override
                public Page<DiskEncryptionSetInner> call(ServiceResponse<Page<DiskEncryptionSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskEncryptionSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(ServiceResponse<Page<DiskEncryptionSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskEncryptionSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskEncryptionSetInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskEncryptionSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskEncryptionSetInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskEncryptionSetInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskEncryptionSetInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;String&gt; object if successful.
     */
    public PagedList<String> listAssociatedResources(final String resourceGroupName, final String diskEncryptionSetName) {
        ServiceResponse<Page<String>> response = listAssociatedResourcesSinglePageAsync(resourceGroupName, diskEncryptionSetName).toBlocking().single();
        return new PagedList<String>(response.body()) {
            @Override
            public Page<String> nextPage(String nextPageLink) {
                return listAssociatedResourcesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<String>> listAssociatedResourcesAsync(final String resourceGroupName, final String diskEncryptionSetName, final ListOperationCallback<String> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAssociatedResourcesSinglePageAsync(resourceGroupName, diskEncryptionSetName),
            new Func1<String, Observable<ServiceResponse<Page<String>>>>() {
                @Override
                public Observable<ServiceResponse<Page<String>>> call(String nextPageLink) {
                    return listAssociatedResourcesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;String&gt; object
     */
    public Observable<Page<String>> listAssociatedResourcesAsync(final String resourceGroupName, final String diskEncryptionSetName) {
        return listAssociatedResourcesWithServiceResponseAsync(resourceGroupName, diskEncryptionSetName)
            .map(new Func1<ServiceResponse<Page<String>>, Page<String>>() {
                @Override
                public Page<String> call(ServiceResponse<Page<String>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;String&gt; object
     */
    public Observable<ServiceResponse<Page<String>>> listAssociatedResourcesWithServiceResponseAsync(final String resourceGroupName, final String diskEncryptionSetName) {
        return listAssociatedResourcesSinglePageAsync(resourceGroupName, diskEncryptionSetName)
            .concatMap(new Func1<ServiceResponse<Page<String>>, Observable<ServiceResponse<Page<String>>>>() {
                @Override
                public Observable<ServiceResponse<Page<String>>> call(ServiceResponse<Page<String>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAssociatedResourcesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
    ServiceResponse<PageImpl1<String>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl1<String>> * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;String&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<String>>> listAssociatedResourcesSinglePageAsync(final String resourceGroupName, final String diskEncryptionSetName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskEncryptionSetName == null) {
            throw new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.listAssociatedResources(this.client.subscriptionId(), resourceGroupName, diskEncryptionSetName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<String>>>>() {
                @Override
                public Observable<ServiceResponse<Page<String>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<String>> result = listAssociatedResourcesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<String>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<String>> listAssociatedResourcesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<String>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<String>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskEncryptionSetInner&gt; object if successful.
     */
    public PagedList<DiskEncryptionSetInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<DiskEncryptionSetInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskEncryptionSetInner>(response.body()) {
            @Override
            public Page<DiskEncryptionSetInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskEncryptionSetInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<DiskEncryptionSetInner>> serviceFuture, final ListOperationCallback<DiskEncryptionSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskEncryptionSetInner&gt; object
     */
    public Observable<Page<DiskEncryptionSetInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Page<DiskEncryptionSetInner>>() {
                @Override
                public Page<DiskEncryptionSetInner> call(ServiceResponse<Page<DiskEncryptionSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskEncryptionSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(ServiceResponse<Page<DiskEncryptionSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
    ServiceResponse<PageImpl1<DiskEncryptionSetInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskEncryptionSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskEncryptionSetInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskEncryptionSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskEncryptionSetInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskEncryptionSetInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskEncryptionSetInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskEncryptionSetInner&gt; object if successful.
     */
    public PagedList<DiskEncryptionSetInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<DiskEncryptionSetInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskEncryptionSetInner>(response.body()) {
            @Override
            public Page<DiskEncryptionSetInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskEncryptionSetInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<DiskEncryptionSetInner>> serviceFuture, final ListOperationCallback<DiskEncryptionSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskEncryptionSetInner&gt; object
     */
    public Observable<Page<DiskEncryptionSetInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Page<DiskEncryptionSetInner>>() {
                @Override
                public Page<DiskEncryptionSetInner> call(ServiceResponse<Page<DiskEncryptionSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskEncryptionSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DiskEncryptionSetInner>>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(ServiceResponse<Page<DiskEncryptionSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
    ServiceResponse<PageImpl1<DiskEncryptionSetInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskEncryptionSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskEncryptionSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskEncryptionSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskEncryptionSetInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskEncryptionSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskEncryptionSetInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskEncryptionSetInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskEncryptionSetInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;String&gt; object if successful.
     */
    public PagedList<String> listAssociatedResourcesNext(final String nextPageLink) {
        ServiceResponse<Page<String>> response = listAssociatedResourcesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<String>(response.body()) {
            @Override
            public Page<String> nextPage(String nextPageLink) {
                return listAssociatedResourcesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<String>> listAssociatedResourcesNextAsync(final String nextPageLink, final ServiceFuture<List<String>> serviceFuture, final ListOperationCallback<String> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAssociatedResourcesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<String>>>>() {
                @Override
                public Observable<ServiceResponse<Page<String>>> call(String nextPageLink) {
                    return listAssociatedResourcesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;String&gt; object
     */
    public Observable<Page<String>> listAssociatedResourcesNextAsync(final String nextPageLink) {
        return listAssociatedResourcesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<String>>, Page<String>>() {
                @Override
                public Page<String> call(ServiceResponse<Page<String>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;String&gt; object
     */
    public Observable<ServiceResponse<Page<String>>> listAssociatedResourcesNextWithServiceResponseAsync(final String nextPageLink) {
        return listAssociatedResourcesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<String>>, Observable<ServiceResponse<Page<String>>>>() {
                @Override
                public Observable<ServiceResponse<Page<String>>> call(ServiceResponse<Page<String>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAssociatedResourcesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
    ServiceResponse<PageImpl1<String>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;String&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<String>>> listAssociatedResourcesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAssociatedResourcesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<String>>>>() {
                @Override
                public Observable<ServiceResponse<Page<String>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<String>> result = listAssociatedResourcesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<String>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<String>> listAssociatedResourcesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<String>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<String>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
