/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.GalleryApplicationUpdate;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in GalleryApplications.
 */
public class GalleryApplicationsInner {
    /** The Retrofit service to perform REST calls. */
    private GalleryApplicationsService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of GalleryApplicationsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public GalleryApplicationsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(GalleryApplicationsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for GalleryApplications to be
     * used by Retrofit to perform actually REST calls.
     */
    interface GalleryApplicationsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Query("api-version") String apiVersion, @Body GalleryApplicationInner galleryApplication, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Query("api-version") String apiVersion, @Body GalleryApplicationInner galleryApplication, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Query("api-version") String apiVersion, @Body GalleryApplicationUpdate galleryApplication, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Query("api-version") String apiVersion, @Body GalleryApplicationUpdate galleryApplication, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications listByGallery" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications")
        Observable<Response<ResponseBody>> listByGallery(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplications listByGalleryNext" })
        @GET
        Observable<Response<ResponseBody>> listByGalleryNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationInner object if successful.
     */
    public GalleryApplicationInner createOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).toBlocking().last().body();
    }

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication, final ServiceCallback<GalleryApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication), serviceCallback);
    }

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<GalleryApplicationInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).map(new Func1<ServiceResponse<GalleryApplicationInner>, GalleryApplicationInner>() {
            @Override
            public GalleryApplicationInner call(ServiceResponse<GalleryApplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<GalleryApplicationInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplication == null) {
            throw new IllegalArgumentException("Parameter galleryApplication is required and cannot be null.");
        }
        Validator.validate(galleryApplication);
        final String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, apiVersion, galleryApplication, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryApplicationInner>() { }.getType());
    }

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationInner object if successful.
     */
    public GalleryApplicationInner beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).toBlocking().single().body();
    }

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication, final ServiceCallback<GalleryApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication), serviceCallback);
    }

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationInner object
     */
    public Observable<GalleryApplicationInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).map(new Func1<ServiceResponse<GalleryApplicationInner>, GalleryApplicationInner>() {
            @Override
            public GalleryApplicationInner call(ServiceResponse<GalleryApplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationInner object
     */
    public Observable<ServiceResponse<GalleryApplicationInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationInner galleryApplication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplication == null) {
            throw new IllegalArgumentException("Parameter galleryApplication is required and cannot be null.");
        }
        Validator.validate(galleryApplication);
        final String apiVersion = "2019-12-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, apiVersion, galleryApplication, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<GalleryApplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GalleryApplicationInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GalleryApplicationInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GalleryApplicationInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GalleryApplicationInner>() { }.getType())
                .register(201, new TypeToken<GalleryApplicationInner>() { }.getType())
                .register(202, new TypeToken<GalleryApplicationInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationInner object if successful.
     */
    public GalleryApplicationInner update(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        return updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).toBlocking().last().body();
    }

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationInner> updateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication, final ServiceCallback<GalleryApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication), serviceCallback);
    }

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<GalleryApplicationInner> updateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        return updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).map(new Func1<ServiceResponse<GalleryApplicationInner>, GalleryApplicationInner>() {
            @Override
            public GalleryApplicationInner call(ServiceResponse<GalleryApplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<GalleryApplicationInner>> updateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplication == null) {
            throw new IllegalArgumentException("Parameter galleryApplication is required and cannot be null.");
        }
        Validator.validate(galleryApplication);
        final String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, apiVersion, galleryApplication, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryApplicationInner>() { }.getType());
    }

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationInner object if successful.
     */
    public GalleryApplicationInner beginUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).toBlocking().single().body();
    }

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication, final ServiceCallback<GalleryApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication), serviceCallback);
    }

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationInner object
     */
    public Observable<GalleryApplicationInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplication).map(new Func1<ServiceResponse<GalleryApplicationInner>, GalleryApplicationInner>() {
            @Override
            public GalleryApplicationInner call(ServiceResponse<GalleryApplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationInner object
     */
    public Observable<ServiceResponse<GalleryApplicationInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, GalleryApplicationUpdate galleryApplication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplication == null) {
            throw new IllegalArgumentException("Parameter galleryApplication is required and cannot be null.");
        }
        Validator.validate(galleryApplication);
        final String apiVersion = "2019-12-01";
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, apiVersion, galleryApplication, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<GalleryApplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GalleryApplicationInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GalleryApplicationInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GalleryApplicationInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GalleryApplicationInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves information about a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which the Application Definitions are to be retrieved.
     * @param galleryApplicationName The name of the gallery Application Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationInner object if successful.
     */
    public GalleryApplicationInner get(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).toBlocking().single().body();
    }

    /**
     * Retrieves information about a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which the Application Definitions are to be retrieved.
     * @param galleryApplicationName The name of the gallery Application Definition to be retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, final ServiceCallback<GalleryApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName), serviceCallback);
    }

    /**
     * Retrieves information about a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which the Application Definitions are to be retrieved.
     * @param galleryApplicationName The name of the gallery Application Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationInner object
     */
    public Observable<GalleryApplicationInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).map(new Func1<ServiceResponse<GalleryApplicationInner>, GalleryApplicationInner>() {
            @Override
            public GalleryApplicationInner call(ServiceResponse<GalleryApplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which the Application Definitions are to be retrieved.
     * @param galleryApplicationName The name of the gallery Application Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationInner object
     */
    public Observable<ServiceResponse<GalleryApplicationInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        final String apiVersion = "2019-12-01";
        return service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<GalleryApplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GalleryApplicationInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GalleryApplicationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GalleryApplicationInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GalleryApplicationInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String galleryName, String galleryApplicationName) {
        deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).toBlocking().last().body();
    }

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName), serviceCallback);
    }

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        final String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String galleryName, String galleryApplicationName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).toBlocking().single().body();
    }

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName), serviceCallback);
    }

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        final String apiVersion = "2019-12-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which Application Definitions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;GalleryApplicationInner&gt; object if successful.
     */
    public PagedList<GalleryApplicationInner> listByGallery(final String resourceGroupName, final String galleryName) {
        ServiceResponse<Page<GalleryApplicationInner>> response = listByGallerySinglePageAsync(resourceGroupName, galleryName).toBlocking().single();
        return new PagedList<GalleryApplicationInner>(response.body()) {
            @Override
            public Page<GalleryApplicationInner> nextPage(String nextPageLink) {
                return listByGalleryNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which Application Definitions are to be listed.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GalleryApplicationInner>> listByGalleryAsync(final String resourceGroupName, final String galleryName, final ListOperationCallback<GalleryApplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByGallerySinglePageAsync(resourceGroupName, galleryName),
            new Func1<String, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(String nextPageLink) {
                    return listByGalleryNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which Application Definitions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryApplicationInner&gt; object
     */
    public Observable<Page<GalleryApplicationInner>> listByGalleryAsync(final String resourceGroupName, final String galleryName) {
        return listByGalleryWithServiceResponseAsync(resourceGroupName, galleryName)
            .map(new Func1<ServiceResponse<Page<GalleryApplicationInner>>, Page<GalleryApplicationInner>>() {
                @Override
                public Page<GalleryApplicationInner> call(ServiceResponse<Page<GalleryApplicationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which Application Definitions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryApplicationInner&gt; object
     */
    public Observable<ServiceResponse<Page<GalleryApplicationInner>>> listByGalleryWithServiceResponseAsync(final String resourceGroupName, final String galleryName) {
        return listByGallerySinglePageAsync(resourceGroupName, galleryName)
            .concatMap(new Func1<ServiceResponse<Page<GalleryApplicationInner>>, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(ServiceResponse<Page<GalleryApplicationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByGalleryNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List gallery Application Definitions in a gallery.
     *
    ServiceResponse<PageImpl1<GalleryApplicationInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl1<GalleryApplicationInner>> * @param galleryName The name of the Shared Application Gallery from which Application Definitions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;GalleryApplicationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<GalleryApplicationInner>>> listByGallerySinglePageAsync(final String resourceGroupName, final String galleryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        final String apiVersion = "2019-12-01";
        return service.listByGallery(this.client.subscriptionId(), resourceGroupName, galleryName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<GalleryApplicationInner>> result = listByGalleryDelegate(response);
                        return Observable.just(new ServiceResponse<Page<GalleryApplicationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<GalleryApplicationInner>> listByGalleryDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<GalleryApplicationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<GalleryApplicationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;GalleryApplicationInner&gt; object if successful.
     */
    public PagedList<GalleryApplicationInner> listByGalleryNext(final String nextPageLink) {
        ServiceResponse<Page<GalleryApplicationInner>> response = listByGalleryNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GalleryApplicationInner>(response.body()) {
            @Override
            public Page<GalleryApplicationInner> nextPage(String nextPageLink) {
                return listByGalleryNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GalleryApplicationInner>> listByGalleryNextAsync(final String nextPageLink, final ServiceFuture<List<GalleryApplicationInner>> serviceFuture, final ListOperationCallback<GalleryApplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByGalleryNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(String nextPageLink) {
                    return listByGalleryNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryApplicationInner&gt; object
     */
    public Observable<Page<GalleryApplicationInner>> listByGalleryNextAsync(final String nextPageLink) {
        return listByGalleryNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<GalleryApplicationInner>>, Page<GalleryApplicationInner>>() {
                @Override
                public Page<GalleryApplicationInner> call(ServiceResponse<Page<GalleryApplicationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryApplicationInner&gt; object
     */
    public Observable<ServiceResponse<Page<GalleryApplicationInner>>> listByGalleryNextWithServiceResponseAsync(final String nextPageLink) {
        return listByGalleryNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<GalleryApplicationInner>>, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(ServiceResponse<Page<GalleryApplicationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByGalleryNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List gallery Application Definitions in a gallery.
     *
    ServiceResponse<PageImpl1<GalleryApplicationInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;GalleryApplicationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<GalleryApplicationInner>>> listByGalleryNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByGalleryNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<GalleryApplicationInner>> result = listByGalleryNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<GalleryApplicationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<GalleryApplicationInner>> listByGalleryNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<GalleryApplicationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<GalleryApplicationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
