/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.ProximityPlacementGroupUpdate;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ProximityPlacementGroups.
 */
public class ProximityPlacementGroupsInner implements InnerSupportsGet<ProximityPlacementGroupInner>, InnerSupportsDelete<Void>, InnerSupportsListing<ProximityPlacementGroupInner> {
    /** The Retrofit service to perform REST calls. */
    private ProximityPlacementGroupsService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of ProximityPlacementGroupsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ProximityPlacementGroupsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(ProximityPlacementGroupsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ProximityPlacementGroups to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ProximityPlacementGroupsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups/{proximityPlacementGroupName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("proximityPlacementGroupName") String proximityPlacementGroupName, @Path("subscriptionId") String subscriptionId, @Body ProximityPlacementGroupInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups/{proximityPlacementGroupName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("proximityPlacementGroupName") String proximityPlacementGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ProximityPlacementGroupUpdate parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups/{proximityPlacementGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("proximityPlacementGroupName") String proximityPlacementGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups/{proximityPlacementGroupName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("proximityPlacementGroupName") String proximityPlacementGroupName, @Path("subscriptionId") String subscriptionId, @Query("includeColocationStatus") String includeColocationStatus, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Compute/proximityPlacementGroups")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ProximityPlacementGroups listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create or update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Create Proximity Placement Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ProximityPlacementGroupInner object if successful.
     */
    public ProximityPlacementGroupInner createOrUpdate(String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, parameters).toBlocking().single().body();
    }

    /**
     * Create or update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Create Proximity Placement Group operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ProximityPlacementGroupInner> createOrUpdateAsync(String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters, final ServiceCallback<ProximityPlacementGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, parameters), serviceCallback);
    }

    /**
     * Create or update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Create Proximity Placement Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProximityPlacementGroupInner object
     */
    public Observable<ProximityPlacementGroupInner> createOrUpdateAsync(String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, parameters).map(new Func1<ServiceResponse<ProximityPlacementGroupInner>, ProximityPlacementGroupInner>() {
            @Override
            public ProximityPlacementGroupInner call(ServiceResponse<ProximityPlacementGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Create Proximity Placement Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProximityPlacementGroupInner object
     */
    public Observable<ServiceResponse<ProximityPlacementGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2020-12-01";
        return service.createOrUpdate(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProximityPlacementGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<ProximityPlacementGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ProximityPlacementGroupInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ProximityPlacementGroupInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ProximityPlacementGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ProximityPlacementGroupInner>() { }.getType())
                .register(201, new TypeToken<ProximityPlacementGroupInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ProximityPlacementGroupInner object if successful.
     */
    public ProximityPlacementGroupInner update(String resourceGroupName, String proximityPlacementGroupName) {
        return updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).toBlocking().single().body();
    }

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ProximityPlacementGroupInner> updateAsync(String resourceGroupName, String proximityPlacementGroupName, final ServiceCallback<ProximityPlacementGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName), serviceCallback);
    }

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProximityPlacementGroupInner object
     */
    public Observable<ProximityPlacementGroupInner> updateAsync(String resourceGroupName, String proximityPlacementGroupName) {
        return updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).map(new Func1<ServiceResponse<ProximityPlacementGroupInner>, ProximityPlacementGroupInner>() {
            @Override
            public ProximityPlacementGroupInner call(ServiceResponse<ProximityPlacementGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProximityPlacementGroupInner object
     */
    public Observable<ServiceResponse<ProximityPlacementGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        final Map<String, String> tags = null;
        ProximityPlacementGroupUpdate parameters = new ProximityPlacementGroupUpdate();
        parameters.withTags(null);
        return service.update(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProximityPlacementGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<ProximityPlacementGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ProximityPlacementGroupInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param tags Resource tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ProximityPlacementGroupInner object if successful.
     */
    public ProximityPlacementGroupInner update(String resourceGroupName, String proximityPlacementGroupName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, tags).toBlocking().single().body();
    }

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param tags Resource tags
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ProximityPlacementGroupInner> updateAsync(String resourceGroupName, String proximityPlacementGroupName, Map<String, String> tags, final ServiceCallback<ProximityPlacementGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, tags), serviceCallback);
    }

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param tags Resource tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProximityPlacementGroupInner object
     */
    public Observable<ProximityPlacementGroupInner> updateAsync(String resourceGroupName, String proximityPlacementGroupName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, tags).map(new Func1<ServiceResponse<ProximityPlacementGroupInner>, ProximityPlacementGroupInner>() {
            @Override
            public ProximityPlacementGroupInner call(ServiceResponse<ProximityPlacementGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param tags Resource tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProximityPlacementGroupInner object
     */
    public Observable<ServiceResponse<ProximityPlacementGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2020-12-01";
        ProximityPlacementGroupUpdate parameters = new ProximityPlacementGroupUpdate();
        parameters.withTags(tags);
        return service.update(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProximityPlacementGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<ProximityPlacementGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ProximityPlacementGroupInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ProximityPlacementGroupInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ProximityPlacementGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ProximityPlacementGroupInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String proximityPlacementGroupName) {
        deleteWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).toBlocking().single().body();
    }

    /**
     * Delete a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String proximityPlacementGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName), serviceCallback);
    }

    /**
     * Delete a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String proximityPlacementGroupName) {
        return deleteWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.delete(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ProximityPlacementGroupInner object if successful.
     */
    public ProximityPlacementGroupInner getByResourceGroup(String resourceGroupName, String proximityPlacementGroupName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).toBlocking().single().body();
    }

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ProximityPlacementGroupInner> getByResourceGroupAsync(String resourceGroupName, String proximityPlacementGroupName, final ServiceCallback<ProximityPlacementGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName), serviceCallback);
    }

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProximityPlacementGroupInner object
     */
    public Observable<ProximityPlacementGroupInner> getByResourceGroupAsync(String resourceGroupName, String proximityPlacementGroupName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName).map(new Func1<ServiceResponse<ProximityPlacementGroupInner>, ProximityPlacementGroupInner>() {
            @Override
            public ProximityPlacementGroupInner call(ServiceResponse<ProximityPlacementGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProximityPlacementGroupInner object
     */
    public Observable<ServiceResponse<ProximityPlacementGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        final String includeColocationStatus = null;
        return service.getByResourceGroup(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), includeColocationStatus, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProximityPlacementGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<ProximityPlacementGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ProximityPlacementGroupInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param includeColocationStatus includeColocationStatus=true enables fetching the colocation status of all the resources in the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ProximityPlacementGroupInner object if successful.
     */
    public ProximityPlacementGroupInner getByResourceGroup(String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, includeColocationStatus).toBlocking().single().body();
    }

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param includeColocationStatus includeColocationStatus=true enables fetching the colocation status of all the resources in the proximity placement group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ProximityPlacementGroupInner> getByResourceGroupAsync(String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus, final ServiceCallback<ProximityPlacementGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, includeColocationStatus), serviceCallback);
    }

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param includeColocationStatus includeColocationStatus=true enables fetching the colocation status of all the resources in the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProximityPlacementGroupInner object
     */
    public Observable<ProximityPlacementGroupInner> getByResourceGroupAsync(String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, proximityPlacementGroupName, includeColocationStatus).map(new Func1<ServiceResponse<ProximityPlacementGroupInner>, ProximityPlacementGroupInner>() {
            @Override
            public ProximityPlacementGroupInner call(ServiceResponse<ProximityPlacementGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param includeColocationStatus includeColocationStatus=true enables fetching the colocation status of all the resources in the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProximityPlacementGroupInner object
     */
    public Observable<ServiceResponse<ProximityPlacementGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (proximityPlacementGroupName == null) {
            throw new IllegalArgumentException("Parameter proximityPlacementGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.getByResourceGroup(resourceGroupName, proximityPlacementGroupName, this.client.subscriptionId(), includeColocationStatus, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProximityPlacementGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<ProximityPlacementGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ProximityPlacementGroupInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ProximityPlacementGroupInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ProximityPlacementGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ProximityPlacementGroupInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ProximityPlacementGroupInner&gt; object if successful.
     */
    public PagedList<ProximityPlacementGroupInner> list() {
        ServiceResponse<Page<ProximityPlacementGroupInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<ProximityPlacementGroupInner>(response.body()) {
            @Override
            public Page<ProximityPlacementGroupInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ProximityPlacementGroupInner>> listAsync(final ListOperationCallback<ProximityPlacementGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProximityPlacementGroupInner&gt; object
     */
    public Observable<Page<ProximityPlacementGroupInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Page<ProximityPlacementGroupInner>>() {
                @Override
                public Page<ProximityPlacementGroupInner> call(ServiceResponse<Page<ProximityPlacementGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProximityPlacementGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(ServiceResponse<Page<ProximityPlacementGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ProximityPlacementGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ProximityPlacementGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ProximityPlacementGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ProximityPlacementGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ProximityPlacementGroupInner&gt; object if successful.
     */
    public PagedList<ProximityPlacementGroupInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<ProximityPlacementGroupInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ProximityPlacementGroupInner>(response.body()) {
            @Override
            public Page<ProximityPlacementGroupInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ProximityPlacementGroupInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<ProximityPlacementGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProximityPlacementGroupInner&gt; object
     */
    public Observable<Page<ProximityPlacementGroupInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Page<ProximityPlacementGroupInner>>() {
                @Override
                public Page<ProximityPlacementGroupInner> call(ServiceResponse<Page<ProximityPlacementGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProximityPlacementGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(ServiceResponse<Page<ProximityPlacementGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all proximity placement groups in a resource group.
     *
    ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ProximityPlacementGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ProximityPlacementGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ProximityPlacementGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ProximityPlacementGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ProximityPlacementGroupInner&gt; object if successful.
     */
    public PagedList<ProximityPlacementGroupInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<ProximityPlacementGroupInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProximityPlacementGroupInner>(response.body()) {
            @Override
            public Page<ProximityPlacementGroupInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ProximityPlacementGroupInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<ProximityPlacementGroupInner>> serviceFuture, final ListOperationCallback<ProximityPlacementGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProximityPlacementGroupInner&gt; object
     */
    public Observable<Page<ProximityPlacementGroupInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Page<ProximityPlacementGroupInner>>() {
                @Override
                public Page<ProximityPlacementGroupInner> call(ServiceResponse<Page<ProximityPlacementGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProximityPlacementGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(ServiceResponse<Page<ProximityPlacementGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all proximity placement groups in a subscription.
     *
    ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ProximityPlacementGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ProximityPlacementGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ProximityPlacementGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ProximityPlacementGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ProximityPlacementGroupInner&gt; object if successful.
     */
    public PagedList<ProximityPlacementGroupInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<ProximityPlacementGroupInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProximityPlacementGroupInner>(response.body()) {
            @Override
            public Page<ProximityPlacementGroupInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ProximityPlacementGroupInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<ProximityPlacementGroupInner>> serviceFuture, final ListOperationCallback<ProximityPlacementGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProximityPlacementGroupInner&gt; object
     */
    public Observable<Page<ProximityPlacementGroupInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Page<ProximityPlacementGroupInner>>() {
                @Override
                public Page<ProximityPlacementGroupInner> call(ServiceResponse<Page<ProximityPlacementGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProximityPlacementGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ProximityPlacementGroupInner>>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(ServiceResponse<Page<ProximityPlacementGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all proximity placement groups in a resource group.
     *
    ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ProximityPlacementGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProximityPlacementGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ProximityPlacementGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ProximityPlacementGroupInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ProximityPlacementGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ProximityPlacementGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
