/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.VirtualMachineRunCommandUpdate;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VirtualMachineRunCommands.
 */
public class VirtualMachineRunCommandsInner {
    /** The Retrofit service to perform REST calls. */
    private VirtualMachineRunCommandsService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of VirtualMachineRunCommandsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VirtualMachineRunCommandsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(VirtualMachineRunCommandsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VirtualMachineRunCommands to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VirtualMachineRunCommandsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands")
        Observable<Response<ResponseBody>> list(@Path("location") String location, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands get" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands/{commandId}")
        Observable<Response<ResponseBody>> get(@Path("location") String location, @Path("commandId") String commandId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("vmName") String vmName, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Body VirtualMachineRunCommandInner runCommand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("vmName") String vmName, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Body VirtualMachineRunCommandInner runCommand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("vmName") String vmName, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Body VirtualMachineRunCommandUpdate runCommand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("vmName") String vmName, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Body VirtualMachineRunCommandUpdate runCommand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("vmName") String vmName, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("vmName") String vmName, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands getByVirtualMachine" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        Observable<Response<ResponseBody>> getByVirtualMachine(@Path("resourceGroupName") String resourceGroupName, @Path("vmName") String vmName, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Query("$expand") String expand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands listByVirtualMachine" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands")
        Observable<Response<ResponseBody>> listByVirtualMachine(@Path("resourceGroupName") String resourceGroupName, @Path("vmName") String vmName, @Path("subscriptionId") String subscriptionId, @Query("$expand") String expand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands listByVirtualMachineNext" })
        @GET
        Observable<Response<ResponseBody>> listByVirtualMachineNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all available run commands for a subscription in a location.
     *
     * @param location The location upon which run commands is queried.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RunCommandDocumentBaseInner&gt; object if successful.
     */
    public PagedList<RunCommandDocumentBaseInner> list(final String location) {
        ServiceResponse<Page<RunCommandDocumentBaseInner>> response = listSinglePageAsync(location).toBlocking().single();
        return new PagedList<RunCommandDocumentBaseInner>(response.body()) {
            @Override
            public Page<RunCommandDocumentBaseInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all available run commands for a subscription in a location.
     *
     * @param location The location upon which run commands is queried.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RunCommandDocumentBaseInner>> listAsync(final String location, final ListOperationCallback<RunCommandDocumentBaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(location),
            new Func1<String, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all available run commands for a subscription in a location.
     *
     * @param location The location upon which run commands is queried.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RunCommandDocumentBaseInner&gt; object
     */
    public Observable<Page<RunCommandDocumentBaseInner>> listAsync(final String location) {
        return listWithServiceResponseAsync(location)
            .map(new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Page<RunCommandDocumentBaseInner>>() {
                @Override
                public Page<RunCommandDocumentBaseInner> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all available run commands for a subscription in a location.
     *
     * @param location The location upon which run commands is queried.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RunCommandDocumentBaseInner&gt; object
     */
    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listWithServiceResponseAsync(final String location) {
        return listSinglePageAsync(location)
            .concatMap(new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all available run commands for a subscription in a location.
     *
    ServiceResponse<PageImpl1<RunCommandDocumentBaseInner>> * @param location The location upon which run commands is queried.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RunCommandDocumentBaseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listSinglePageAsync(final String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.list(location, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<RunCommandDocumentBaseInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RunCommandDocumentBaseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<RunCommandDocumentBaseInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<RunCommandDocumentBaseInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<RunCommandDocumentBaseInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets specific run command for a subscription in a location.
     *
     * @param location The location upon which run commands is queried.
     * @param commandId The command id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RunCommandDocumentInner object if successful.
     */
    public RunCommandDocumentInner get(String location, String commandId) {
        return getWithServiceResponseAsync(location, commandId).toBlocking().single().body();
    }

    /**
     * Gets specific run command for a subscription in a location.
     *
     * @param location The location upon which run commands is queried.
     * @param commandId The command id.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RunCommandDocumentInner> getAsync(String location, String commandId, final ServiceCallback<RunCommandDocumentInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(location, commandId), serviceCallback);
    }

    /**
     * Gets specific run command for a subscription in a location.
     *
     * @param location The location upon which run commands is queried.
     * @param commandId The command id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RunCommandDocumentInner object
     */
    public Observable<RunCommandDocumentInner> getAsync(String location, String commandId) {
        return getWithServiceResponseAsync(location, commandId).map(new Func1<ServiceResponse<RunCommandDocumentInner>, RunCommandDocumentInner>() {
            @Override
            public RunCommandDocumentInner call(ServiceResponse<RunCommandDocumentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets specific run command for a subscription in a location.
     *
     * @param location The location upon which run commands is queried.
     * @param commandId The command id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RunCommandDocumentInner object
     */
    public Observable<ServiceResponse<RunCommandDocumentInner>> getWithServiceResponseAsync(String location, String commandId) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (commandId == null) {
            throw new IllegalArgumentException("Parameter commandId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.get(location, commandId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RunCommandDocumentInner>>>() {
                @Override
                public Observable<ServiceResponse<RunCommandDocumentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RunCommandDocumentInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RunCommandDocumentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RunCommandDocumentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RunCommandDocumentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to create or update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).toBlocking().last().body();
    }

    /**
     * The operation to create or update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand), serviceCallback);
    }

    /**
     * The operation to create or update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to create or update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate(runCommand);
        final String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), runCommand, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineRunCommandInner>() { }.getType());
    }

    /**
     * The operation to create or update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner beginCreateOrUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).toBlocking().single().body();
    }

    /**
     * The operation to create or update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand), serviceCallback);
    }

    /**
     * The operation to create or update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to create or update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate(runCommand);
        final String apiVersion = "2020-12-01";
        return service.beginCreateOrUpdate(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), runCommand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualMachineRunCommandInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualMachineRunCommandInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualMachineRunCommandInner>() { }.getType())
                .register(201, new TypeToken<VirtualMachineRunCommandInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner update(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return updateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).toBlocking().last().body();
    }

    /**
     * The operation to update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand), serviceCallback);
    }

    /**
     * The operation to update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return updateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> updateWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate(runCommand);
        final String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), runCommand, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineRunCommandInner>() { }.getType());
    }

    /**
     * The operation to update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner beginUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).toBlocking().single().body();
    }

    /**
     * The operation to update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> beginUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand), serviceCallback);
    }

    /**
     * The operation to update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<VirtualMachineRunCommandInner> beginUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to update the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate(runCommand);
        final String apiVersion = "2020-12-01";
        return service.beginUpdate(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), runCommand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualMachineRunCommandInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualMachineRunCommandInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualMachineRunCommandInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to delete the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String vmName, String runCommandName) {
        deleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).toBlocking().last().body();
    }

    /**
     * The operation to delete the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vmName, String runCommandName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName), serviceCallback);
    }

    /**
     * The operation to delete the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String vmName, String runCommandName) {
        return deleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to delete the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * The operation to delete the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String vmName, String runCommandName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).toBlocking().single().body();
    }

    /**
     * The operation to delete the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String vmName, String runCommandName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName), serviceCallback);
    }

    /**
     * The operation to delete the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String vmName, String runCommandName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to delete the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.beginDelete(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to get the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner getByVirtualMachine(String resourceGroupName, String vmName, String runCommandName) {
        return getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).toBlocking().single().body();
    }

    /**
     * The operation to get the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName, String runCommandName, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName), serviceCallback);
    }

    /**
     * The operation to get the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName, String runCommandName) {
        return getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to get the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> getByVirtualMachineWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        final String expand = null;
        return service.getByVirtualMachine(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualMachineRunCommandInner> clientResponse = getByVirtualMachineDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * The operation to get the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner getByVirtualMachine(String resourceGroupName, String vmName, String runCommandName, String expand) {
        return getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, expand).toBlocking().single().body();
    }

    /**
     * The operation to get the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName, String runCommandName, String expand, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, expand), serviceCallback);
    }

    /**
     * The operation to get the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName, String runCommandName, String expand) {
        return getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, expand).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to get the run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> getByVirtualMachineWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.getByVirtualMachine(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualMachineRunCommandInner> clientResponse = getByVirtualMachineDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> getByVirtualMachineDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualMachineRunCommandInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualMachineRunCommandInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object if successful.
     */
    public PagedList<VirtualMachineRunCommandInner> listByVirtualMachine(final String resourceGroupName, final String vmName) {
        ServiceResponse<Page<VirtualMachineRunCommandInner>> response = listByVirtualMachineSinglePageAsync(resourceGroupName, vmName).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>(response.body()) {
            @Override
            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return listByVirtualMachineNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualMachineRunCommandInner>> listByVirtualMachineAsync(final String resourceGroupName, final String vmName, final ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByVirtualMachineSinglePageAsync(resourceGroupName, vmName),
            new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                    return listByVirtualMachineNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<Page<VirtualMachineRunCommandInner>> listByVirtualMachineAsync(final String resourceGroupName, final String vmName) {
        return listByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName)
            .map(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>() {
                @Override
                public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineWithServiceResponseAsync(final String resourceGroupName, final String vmName) {
        return listByVirtualMachineSinglePageAsync(resourceGroupName, vmName)
            .concatMap(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByVirtualMachineNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineSinglePageAsync(final String resourceGroupName, final String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        final String expand = null;
        return service.listByVirtualMachine(resourceGroupName, vmName, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> result = listByVirtualMachineDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualMachineRunCommandInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object if successful.
     */
    public PagedList<VirtualMachineRunCommandInner> listByVirtualMachine(final String resourceGroupName, final String vmName, final String expand) {
        ServiceResponse<Page<VirtualMachineRunCommandInner>> response = listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>(response.body()) {
            @Override
            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return listByVirtualMachineNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param expand The expand expression to apply on the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualMachineRunCommandInner>> listByVirtualMachineAsync(final String resourceGroupName, final String vmName, final String expand, final ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand),
            new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                    return listByVirtualMachineNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<Page<VirtualMachineRunCommandInner>> listByVirtualMachineAsync(final String resourceGroupName, final String vmName, final String expand) {
        return listByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, expand)
            .map(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>() {
                @Override
                public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineWithServiceResponseAsync(final String resourceGroupName, final String vmName, final String expand) {
        return listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand)
            .concatMap(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByVirtualMachineNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
    ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> * @param vmName The name of the virtual machine containing the run command.
    ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineSinglePageAsync(final String resourceGroupName, final String vmName, final String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.listByVirtualMachine(resourceGroupName, vmName, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> result = listByVirtualMachineDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualMachineRunCommandInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> listByVirtualMachineDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<VirtualMachineRunCommandInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<VirtualMachineRunCommandInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all available run commands for a subscription in a location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RunCommandDocumentBaseInner&gt; object if successful.
     */
    public PagedList<RunCommandDocumentBaseInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<RunCommandDocumentBaseInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RunCommandDocumentBaseInner>(response.body()) {
            @Override
            public Page<RunCommandDocumentBaseInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all available run commands for a subscription in a location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RunCommandDocumentBaseInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<RunCommandDocumentBaseInner>> serviceFuture, final ListOperationCallback<RunCommandDocumentBaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all available run commands for a subscription in a location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RunCommandDocumentBaseInner&gt; object
     */
    public Observable<Page<RunCommandDocumentBaseInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Page<RunCommandDocumentBaseInner>>() {
                @Override
                public Page<RunCommandDocumentBaseInner> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all available run commands for a subscription in a location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RunCommandDocumentBaseInner&gt; object
     */
    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all available run commands for a subscription in a location.
     *
    ServiceResponse<PageImpl1<RunCommandDocumentBaseInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RunCommandDocumentBaseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<RunCommandDocumentBaseInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RunCommandDocumentBaseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<RunCommandDocumentBaseInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<RunCommandDocumentBaseInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<RunCommandDocumentBaseInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object if successful.
     */
    public PagedList<VirtualMachineRunCommandInner> listByVirtualMachineNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualMachineRunCommandInner>> response = listByVirtualMachineNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>(response.body()) {
            @Override
            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return listByVirtualMachineNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualMachineRunCommandInner>> listByVirtualMachineNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualMachineRunCommandInner>> serviceFuture, final ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByVirtualMachineNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                    return listByVirtualMachineNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<Page<VirtualMachineRunCommandInner>> listByVirtualMachineNextAsync(final String nextPageLink) {
        return listByVirtualMachineNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>() {
                @Override
                public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineNextWithServiceResponseAsync(final String nextPageLink) {
        return listByVirtualMachineNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByVirtualMachineNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     *
    ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByVirtualMachineNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> result = listByVirtualMachineNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualMachineRunCommandInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> listByVirtualMachineNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<VirtualMachineRunCommandInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<VirtualMachineRunCommandInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
